/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.AttrValueBO;
import com.tydic.commodity.base.bo.CommodityPropDefIdBo;
import com.tydic.commodity.base.bo.PropertyBo;
import com.tydic.commodity.base.bo.UccTemplateExportBaseBO;
import com.tydic.commodity.base.bo.UccTemplateExportSheetActiveColumnBaseBO;
import com.tydic.commodity.base.bo.UccTemplateExportSheetBaseBO;
import com.tydic.commodity.base.bo.UccTemplateExportSheetRuleInfoBaseBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.busi.api.UccQueryPropertyBusiService;
import com.tydic.commodity.busibase.busi.bo.UccQryPropReqBo;
import com.tydic.commodity.busibase.busi.bo.UccQryPropRspBo;
import com.tydic.commodity.common.ability.api.UccAgrImportCreateTemplateExportAbilityService;
import com.tydic.commodity.common.ability.bo.UccAgrImportCreateTemplateExportAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccAgrImportCreateTemplateExportAbilityRspBo;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccCommodityPoolPO;
import com.tydic.commodity.po.UccMallBrandDetailInfoGroupListAbilityPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAgrImportCreateTemplateExportAbilityService"})
public class UccAgrImportCreateTemplateExportAbilityServiceImpl
implements UccAgrImportCreateTemplateExportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrImportCreateTemplateExportAbilityServiceImpl.class);
    @Value(value="${uccImportCreate.agrDefaultTableName:defaultName}")
    private String defaultName;
    @Autowired
    private UccQueryPropertyBusiService uccQueryPropertyBusiService;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;
    public static final Integer COMMODITY_PROP_GRP = 1;
    public static final Integer SKU_PROP_GRP = 2;

    @PostMapping(value={"exportTemplate"})
    public UccAgrImportCreateTemplateExportAbilityRspBo exportTemplate(@RequestBody UccAgrImportCreateTemplateExportAbilityReqBo reqBo) {
        this.var(reqBo);
        UccAgrImportCreateTemplateExportAbilityRspBo uccTemplateExportBaseBO = this.prepareTemplateData();
        List<CommodityPropDefIdBo> commodityPropDefIdBos = this.populateCommoditySheet(reqBo, (UccTemplateExportBaseBO)uccTemplateExportBaseBO);
        List<CommodityPropDefIdBo> skuPropDefIdBos = this.populateSkuSheetData(reqBo, (UccTemplateExportBaseBO)uccTemplateExportBaseBO);
        this.populateDataSheetData((UccTemplateExportBaseBO)uccTemplateExportBaseBO, Stream.concat(skuPropDefIdBos.stream(), commodityPropDefIdBos.stream()).collect(Collectors.toList()));
        return uccTemplateExportBaseBO;
    }

    private void populateDataSheetData(UccTemplateExportBaseBO uccTemplateExportBaseBO, List<CommodityPropDefIdBo> dataSheetActiveDataList) {
        UccTemplateExportSheetBaseBO dataSheet = (UccTemplateExportSheetBaseBO)uccTemplateExportBaseBO.getSheetInfos().get(2);
        List addColumnInfos = dataSheet.getAddColumnInfos();
        HashMap<String, List<String>> tableDataMap = new HashMap<String, List<String>>();
        for (CommodityPropDefIdBo commodityPropDefIdBo : dataSheetActiveDataList) {
            if (CollectionUtils.isEmpty((Collection)commodityPropDefIdBo.getAttrValues())) continue;
            UccTemplateExportSheetActiveColumnBaseBO dataAddColumnInfo = new UccTemplateExportSheetActiveColumnBaseBO();
            dataAddColumnInfo.setFieldName(Convert.toStr((Object)commodityPropDefIdBo.getCommodityPropDefId()) + "row");
            dataAddColumnInfo.setHeaderName(commodityPropDefIdBo.getPropName());
            addColumnInfos.add(dataAddColumnInfo);
            tableDataMap.put(Convert.toStr((Object)commodityPropDefIdBo.getCommodityPropDefId()) + "row", commodityPropDefIdBo.getAttrValues().stream().map(AttrValueBO::getPropValue).collect(Collectors.toList()));
        }
        this.getStableData(tableDataMap);
        dataSheet.getRuleInfos().addAll(this.wrapDataTableData(tableDataMap));
    }

    private List<UccTemplateExportSheetRuleInfoBaseBO> wrapDataTableData(Map<String, List<String>> tableDataMap) {
        return tableDataMap.entrySet().stream().map(e -> {
            UccTemplateExportSheetRuleInfoBaseBO uccTemplateExportSheetRuleInfoBaseBO = new UccTemplateExportSheetRuleInfoBaseBO();
            uccTemplateExportSheetRuleInfoBaseBO.setRuleValues((List)e.getValue());
            uccTemplateExportSheetRuleInfoBaseBO.setFiledCode((String)e.getKey());
            return uccTemplateExportSheetRuleInfoBaseBO;
        }).collect(Collectors.toList());
    }

    private void getStableData(Map<String, List<String>> tableDataMap) {
        List commodityClassList;
        List skuOnShelveWayList;
        Page page = new Page(-1, -1);
        List getMallBrandDetailGroupList = this.uccBrandExtMapper.getMallBrandDetailGroupList(page, null, null, null, null);
        if (!CollectionUtils.isEmpty((Collection)getMallBrandDetailGroupList)) {
            tableDataMap.put("brand", getMallBrandDetailGroupList.stream().map(UccMallBrandDetailInfoGroupListAbilityPO::getMallBrandName).distinct().collect(Collectors.toList()));
        }
        UccCommodityPoolPO uccCommodityPoolPO = new UccCommodityPoolPO();
        uccCommodityPoolPO.setPoolState(Integer.valueOf(1));
        uccCommodityPoolPO.setPoolType(Integer.valueOf(1));
        List uccCommodityPoolPOS = this.uccCommodityPoolMapper.getList(uccCommodityPoolPO);
        if (!CollectionUtils.isEmpty((Collection)uccCommodityPoolPOS)) {
            tableDataMap.put("pool", uccCommodityPoolPOS.stream().map(UccCommodityPoolPO::getPoolName).distinct().collect(Collectors.toList()));
        }
        UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
        uccCommodityMeasurePo.setStatus(Integer.valueOf(1));
        uccCommodityMeasurePo.setMeasureType(Integer.valueOf(0));
        List uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByPO(uccCommodityMeasurePo);
        if (!CollectionUtils.isEmpty((Collection)uccCommodityMeasurePos)) {
            tableDataMap.put("measure", uccCommodityMeasurePos.stream().map(UccCommodityMeasurePo::getMeasureName).distinct().collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(skuOnShelveWayList = this.uccBaseDictionaryAtomService.queryBypCodeBackPo("SKU_ON_SHELVE_WAY")))) {
            tableDataMap.put("shelfWay", skuOnShelveWayList.stream().map(DicDictionaryPo::getTitle).distinct().collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(commodityClassList = this.uccBaseDictionaryAtomService.queryBypCodeBackPo("COMMODITY_CLASS")))) {
            tableDataMap.put("commodityClass", commodityClassList.stream().map(DicDictionaryPo::getTitle).distinct().collect(Collectors.toList()));
        }
    }

    private List<CommodityPropDefIdBo> populateSkuSheetData(UccAgrImportCreateTemplateExportAbilityReqBo reqBo, UccTemplateExportBaseBO uccTemplateExportBaseBO) {
        UccQryPropRspBo uccQryPropRspBo = this.getProp(reqBo, SKU_PROP_GRP);
        if (!CollectionUtils.isEmpty((Collection)uccQryPropRspBo.getProperty())) {
            List skuProperty = uccQryPropRspBo.getProperty();
            List addColumnInfos = ((UccTemplateExportSheetBaseBO)uccTemplateExportBaseBO.getSheetInfos().get(1)).getAddColumnInfos();
            Map skuPropDefIdBoMap = skuProperty.stream().map(PropertyBo::getCommodityPropDefIds).filter(commodityPropDefIds -> !CollectionUtils.isEmpty((Collection)commodityPropDefIds)).flatMap(Collection::stream).collect(Collectors.toMap(CommodityPropDefIdBo::getCommodityPropDefId, Function.identity(), (old, cur) -> cur));
            for (CommodityPropDefIdBo commodityPropDefIdBo : skuPropDefIdBoMap.values()) {
                UccTemplateExportSheetActiveColumnBaseBO skuAddColumnInfo = new UccTemplateExportSheetActiveColumnBaseBO();
                skuAddColumnInfo.setDataRuleField(Convert.toStr((Object)commodityPropDefIdBo.getCommodityPropDefId()) + "row");
                skuAddColumnInfo.setHeaderName(commodityPropDefIdBo.getPropName());
                skuAddColumnInfo.setFieldName(Convert.toStr((Object)commodityPropDefIdBo.getCommodityPropDefId()) + "row");
                addColumnInfos.add(skuAddColumnInfo);
            }
            return new ArrayList<CommodityPropDefIdBo>(skuPropDefIdBoMap.values());
        }
        return new ArrayList<CommodityPropDefIdBo>();
    }

    private List<CommodityPropDefIdBo> populateCommoditySheet(UccAgrImportCreateTemplateExportAbilityReqBo reqBo, UccTemplateExportBaseBO uccTemplateExportBaseBO) {
        UccQryPropRspBo uccQryPropRspBo = this.getProp(reqBo, COMMODITY_PROP_GRP);
        UccTemplateExportSheetBaseBO commoditySheet = (UccTemplateExportSheetBaseBO)uccTemplateExportBaseBO.getSheetInfos().get(0);
        JSONArray tableData = commoditySheet.getTableData();
        tableData.add((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo)));
        List addColumnInfos = commoditySheet.getAddColumnInfos();
        if (!CollectionUtils.isEmpty((Collection)uccQryPropRspBo.getProperty())) {
            List commodityProperty = uccQryPropRspBo.getProperty();
            Map spuPropDefIdBoMap = commodityProperty.stream().map(PropertyBo::getCommodityPropDefIds).filter(commodityPropDefIds -> !CollectionUtils.isEmpty((Collection)commodityPropDefIds)).flatMap(Collection::stream).collect(Collectors.toMap(CommodityPropDefIdBo::getCommodityPropDefId, Function.identity(), (old, cur) -> cur));
            for (PropertyBo propertyBo : commodityProperty) {
                List commodityPropDefIds2 = propertyBo.getCommodityPropDefIds();
                if (!CollectionUtils.isEmpty((Collection)commodityPropDefIds2)) {
                    for (CommodityPropDefIdBo commodityPropDefId : commodityPropDefIds2) {
                        UccTemplateExportSheetActiveColumnBaseBO addColumnInfo = new UccTemplateExportSheetActiveColumnBaseBO();
                        if (!CollectionUtils.isEmpty((Collection)commodityPropDefId.getAttrValues())) {
                            addColumnInfo.setDataRuleField(Convert.toStr((Object)commodityPropDefId.getCommodityPropDefId()) + "row");
                        }
                        addColumnInfo.setHeaderName(commodityPropDefId.getPropName());
                        addColumnInfo.setFieldName(Convert.toStr((Object)commodityPropDefId.getCommodityPropDefId()) + "row");
                        addColumnInfos.add(addColumnInfo);
                    }
                    continue;
                }
                log.error(reqBo.getCommodityTypeId() + "\u8be5\u5546\u54c1\u7c7b\u578b\u4e0b\u6ca1\u6709\u53ef\u7528\u7684\u5c5e\u6027");
            }
            return new ArrayList<CommodityPropDefIdBo>(spuPropDefIdBoMap.values());
        }
        return new ArrayList<CommodityPropDefIdBo>();
    }

    private UccQryPropRspBo getProp(UccAgrImportCreateTemplateExportAbilityReqBo reqBo, Integer commodityPropGrp) {
        UccQryPropReqBo uccQryPropReqBo = new UccQryPropReqBo();
        uccQryPropReqBo.setCommodityTypeId(reqBo.getCommodityTypeId());
        uccQryPropReqBo.setCommodityPropGrpType(commodityPropGrp);
        uccQryPropReqBo.setUserId(reqBo.getUserId());
        UccQryPropRspBo uccQryPropRspBo = this.uccQueryPropertyBusiService.queryProp(uccQryPropReqBo);
        if (!"0000".equals(uccQryPropRspBo.getRespCode())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5c5e\u6027\u5f02\u5e38");
        }
        return uccQryPropRspBo;
    }

    private void var(UccAgrImportCreateTemplateExportAbilityReqBo reqBo) {
        if (null == reqBo.getAgrId()) {
            throw new BusinessException("0002", "\u534f\u8baeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getCommodityTypeId()) {
            throw new BusinessException("0002", "\u5546\u54c1\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSupplierId()) {
            throw new BusinessException("0002", "\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getCommodityTypeName())) {
            throw new BusinessException("0002", "\u5546\u54c1\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getSupplierName())) {
            throw new BusinessException("0002", "\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getAgrCode())) {
            throw new BusinessException("0002", "\u534f\u8bae\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UccAgrImportCreateTemplateExportAbilityRspBo prepareTemplateData() {
        UccAgrImportCreateTemplateExportAbilityRspBo uccTemplateExportBaseBO = new UccAgrImportCreateTemplateExportAbilityRspBo();
        uccTemplateExportBaseBO.setTableName(this.defaultName);
        ArrayList<UccTemplateExportSheetBaseBO> sheetInfos = new ArrayList<UccTemplateExportSheetBaseBO>();
        UccTemplateExportSheetBaseBO commoditySheet = new UccTemplateExportSheetBaseBO();
        commoditySheet.setSheetName("\u5546\u54c1\u4fe1\u606f");
        commoditySheet.setHeadRowNo(Integer.valueOf(1));
        commoditySheet.setTableData(new JSONArray());
        commoditySheet.setRuleFlag("0");
        commoditySheet.setAddColumnInfos((List)Lists.newArrayList());
        sheetInfos.add(commoditySheet);
        UccTemplateExportSheetBaseBO skuSheet = new UccTemplateExportSheetBaseBO();
        skuSheet.setSheetName("\u5355\u54c1\u4fe1\u606f");
        skuSheet.setHeadRowNo(Integer.valueOf(1));
        skuSheet.setTableData(new JSONArray());
        skuSheet.setRuleFlag("0");
        skuSheet.setAddColumnInfos((List)Lists.newArrayList());
        sheetInfos.add(skuSheet);
        UccTemplateExportSheetBaseBO dataSheet = new UccTemplateExportSheetBaseBO();
        dataSheet.setSheetName("\u6570\u636e\uff08\u52ff\u5220\uff09");
        dataSheet.setHeadRowNo(Integer.valueOf(0));
        dataSheet.setTableData(new JSONArray());
        dataSheet.setRuleFlag("1");
        dataSheet.setAddColumnInfos((List)Lists.newArrayList());
        dataSheet.setRuleInfos((List)Lists.newArrayList());
        sheetInfos.add(dataSheet);
        uccTemplateExportBaseBO.setSheetInfos(sheetInfos);
        uccTemplateExportBaseBO.setRespCode("0000");
        uccTemplateExportBaseBO.setRespDesc("\u6210\u529f");
        return uccTemplateExportBaseBO;
    }
}

