/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UccTemplateExportBaseBO;
import com.tydic.commodity.base.bo.UccTemplateExportSheetBaseBO;
import com.tydic.commodity.base.bo.UccTemplateExportSheetRuleInfoBaseBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccAgrSkuImportUpdateTemplateExportAbilityService;
import com.tydic.commodity.common.ability.bo.UccAgrSkuImportUpdateTemplateExportAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccAgrSkuImportUpdateTemplateExportAbilityRspBo;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAgrSkuImportUpdateTemplateExportAbilityService"})
public class UccAgrSkuImportUpdateTemplateExportAbilityServiceImpl
implements UccAgrSkuImportUpdateTemplateExportAbilityService {
    @Value(value="${uccSkuImportUpdate.agrDefaultTableName:defaultName}")
    private String defaultName;
    @Value(value="#{'${uccSkuImportUpdate.defaultSkuStatus:0}'.split(',')}")
    private List<Integer> defaultSkuStatus;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;

    @PostMapping(value={"exportSkuTemplate"})
    public UccAgrSkuImportUpdateTemplateExportAbilityRspBo exportSkuTemplate(@RequestBody UccAgrSkuImportUpdateTemplateExportAbilityReqBo reqBo) {
        this.var(reqBo);
        UccAgrSkuImportUpdateTemplateExportAbilityRspBo uccTemplateExportBaseBO = this.prepareTemplateData();
        this.populateSkuSheetData(reqBo, (UccTemplateExportBaseBO)uccTemplateExportBaseBO);
        this.populateDataSheetData((UccTemplateExportBaseBO)uccTemplateExportBaseBO);
        return uccTemplateExportBaseBO;
    }

    private void populateDataSheetData(UccTemplateExportBaseBO uccTemplateExportBaseBO) {
        UccTemplateExportSheetBaseBO dataSheet = (UccTemplateExportSheetBaseBO)uccTemplateExportBaseBO.getSheetInfos().get(1);
        HashMap<String, List<String>> tableDataMap = new HashMap<String, List<String>>();
        this.getStableData(tableDataMap);
        dataSheet.getRuleInfos().addAll(this.wrapDataTableData(tableDataMap));
    }

    private List<UccTemplateExportSheetRuleInfoBaseBO> wrapDataTableData(Map<String, List<String>> tableDataMap) {
        return tableDataMap.entrySet().stream().map(e -> {
            UccTemplateExportSheetRuleInfoBaseBO uccTemplateExportSheetRuleInfoBaseBO = new UccTemplateExportSheetRuleInfoBaseBO();
            uccTemplateExportSheetRuleInfoBaseBO.setRuleValues((List)e.getValue());
            uccTemplateExportSheetRuleInfoBaseBO.setFiledCode((String)e.getKey());
            return uccTemplateExportSheetRuleInfoBaseBO;
        }).collect(Collectors.toList());
    }

    private void getStableData(Map<String, List<String>> tableDataMap) {
        UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
        uccCommodityMeasurePo.setStatus(Integer.valueOf(1));
        uccCommodityMeasurePo.setMeasureType(Integer.valueOf(0));
        List uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByPO(uccCommodityMeasurePo);
        if (!CollectionUtils.isEmpty((Collection)uccCommodityMeasurePos)) {
            tableDataMap.put("measure", uccCommodityMeasurePos.stream().map(UccCommodityMeasurePo::getMeasureName).distinct().collect(Collectors.toList()));
        }
    }

    private void populateSkuSheetData(UccAgrSkuImportUpdateTemplateExportAbilityReqBo reqBo, UccTemplateExportBaseBO uccTemplateExportBaseBO) {
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuIdList(reqBo.getSkuIdList());
        uccSkuPo.setSkuStatusList(this.defaultSkuStatus);
        uccSkuPo.setCommodityTypeId(reqBo.getCommodityTypeId());
        List uccSkuPos = this.uccSkuMapper.getList(uccSkuPo);
        if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5355\u54c1\u6570\u636e\u4e3a\u7a7a");
        }
        List commodityIds = uccSkuPos.stream().map(UccSkuPo::getCommodityId).distinct().collect(Collectors.toList());
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityIds(commodityIds);
        uccCommodityPo.setCommodityTypeId(reqBo.getCommodityTypeId());
        List uccCommodityPos = this.uccCommodityMapper.qryCommodity(uccCommodityPo);
        if (CollectionUtils.isEmpty((Collection)uccCommodityPos)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5546\u54c1\u6570\u636e\u4e3a\u7a7a");
        }
        Map commodityPoMap = uccCommodityPos.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, Function.identity()));
        List skuIds = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List uccSkuPricePos = this.uccSkuPriceMapper.qryPriceBySkuIds(skuIds);
        Map skuPricePoMap = uccSkuPricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, Function.identity()));
        UccTemplateExportSheetBaseBO skuSheet = (UccTemplateExportSheetBaseBO)uccTemplateExportBaseBO.getSheetInfos().get(0);
        JSONArray tableData = skuSheet.getTableData();
        for (int i = 0; i < uccSkuPos.size(); ++i) {
            UccSkuPricePo uccSkuPricePo;
            UccSkuPo uccSku = (UccSkuPo)uccSkuPos.get(i);
            JSONObject rowData = JSON.parseObject((String)JSON.toJSONString((Object)uccSku));
            rowData.put("rowSkuSerial", (Object)(i + 1));
            if (null != commodityPoMap.get(uccSku.getCommodityId())) {
                rowData.putAll((Map)JSON.parseObject((String)JSON.toJSONString(commodityPoMap.get(uccSku.getCommodityId()))));
            }
            if (null != (uccSkuPricePo = (UccSkuPricePo)skuPricePoMap.get(uccSku.getSkuId()))) {
                rowData.putAll((Map)JSON.parseObject((String)JSON.toJSONString((Object)uccSkuPricePo)));
            }
            tableData.add((Object)rowData);
        }
    }

    private UccAgrSkuImportUpdateTemplateExportAbilityRspBo prepareTemplateData() {
        UccAgrSkuImportUpdateTemplateExportAbilityRspBo uccTemplateExportBaseBO = new UccAgrSkuImportUpdateTemplateExportAbilityRspBo();
        uccTemplateExportBaseBO.setTableName(this.defaultName);
        ArrayList<UccTemplateExportSheetBaseBO> sheetInfos = new ArrayList<UccTemplateExportSheetBaseBO>();
        UccTemplateExportSheetBaseBO skuSheet = new UccTemplateExportSheetBaseBO();
        skuSheet.setSheetName("\u5355\u54c1\u4fe1\u606f");
        skuSheet.setHeadRowNo(Integer.valueOf(1));
        skuSheet.setTableData(new JSONArray());
        skuSheet.setRuleFlag("0");
        skuSheet.setAddColumnInfos((List)Lists.newArrayList());
        sheetInfos.add(skuSheet);
        UccTemplateExportSheetBaseBO dataSheet = new UccTemplateExportSheetBaseBO();
        dataSheet.setSheetName("\u6570\u636e\uff08\u52ff\u5220\uff09");
        dataSheet.setHeadRowNo(Integer.valueOf(0));
        dataSheet.setTableData(new JSONArray());
        dataSheet.setRuleFlag("1");
        dataSheet.setAddColumnInfos((List)Lists.newArrayList());
        dataSheet.setRuleInfos((List)Lists.newArrayList());
        sheetInfos.add(dataSheet);
        uccTemplateExportBaseBO.setSheetInfos(sheetInfos);
        uccTemplateExportBaseBO.setRespCode("0000");
        uccTemplateExportBaseBO.setRespDesc("\u6210\u529f");
        return uccTemplateExportBaseBO;
    }

    private void var(UccAgrSkuImportUpdateTemplateExportAbilityReqBo reqBo) {
        if (null == reqBo.getCommodityTypeId()) {
            throw new BusinessException("0002", "\u5546\u54c1\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuIdList())) {
            throw new BusinessException("0002", "\u5355\u54c1id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

