/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.base.constant.CommodityStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.common.ability.api.UccSpuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccEsCommodityBo;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccQrySkuBatchDealRecordByPageBusiService;
import com.tydic.commodity.common.innserbo.UccSpuListQryAbilityInnerCommodityTypeIdBo;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.config.UccIdGenerator;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.po.ComBatchDealRecordPO;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccCommodityPo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSpuListQryAbilityService"})
public class UccSpuListQryAbilityServiceImpl
implements UccSpuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuListQryAbilityServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private UccQrySkuBatchDealRecordByPageBusiService uccQrySkuBatchDealRecordByPageBusiService;
    @Autowired
    private UccIdGenerator uccIdGenerator;
    @Autowired
    private CacheClient cacheClient;
    private static final String SPU_LIST_QUERY_COMMODITY_ID_CACHE_KEY = "spu_list_query_commodity_id_cache_key:";
    @Value(value="${ucc.commodityIdCacheExpireTime:3600}")
    private int commodityIdCacheExpireTime;
    @Value(value="${ucc.queryStatus:0,2,3,5}")
    private List<Integer> queryStatus;

    @PostMapping(value={"getSpuListQry"})
    public UccSpuListQryAbilityRspBO getSpuListQry(@RequestBody UccSpuListQryAbilityReqBO reqBO) {
        UccSpuListQryAbilityRspBO rspBo = new UccSpuListQryAbilityRspBO();
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO);
        String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        if (StringUtils.isEmpty((Object)result)) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        if (UccConstants.IsBatchDealQry.YES.equals(reqBO.getIsBatchDealQry())) {
            return this.qryBatchDealCommodityId(reqBO, result);
        }
        if (UccConstants.IsQryNoPicSku.CODE.equals(reqBO.getIsQryNoPicSku()) || UccConstants.IsQryNoPicSku.NO_PIC.equals(reqBO.getIsQryNoPicSku())) {
            return this.qryCodeExport(reqBO, result);
        }
        if (reqBO.getQueryCommodityIdOnly().booleanValue()) {
            return this.qryCommodityIdList(rspBo, result);
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            Map<String, String> commodityStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS_NEW.toString());
            Map<String, String> commodityClassMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_CLASS.toString());
            rspBo.getRows().forEach(uccSpuManagementListQryBO -> {
                if (uccSpuManagementListQryBO.getCommodityStatus() != null) {
                    uccSpuManagementListQryBO.setCommodityStatusDesc((String)commodityStatusMap.get(uccSpuManagementListQryBO.getCommodityStatus().toString()));
                }
                if (uccSpuManagementListQryBO.getCommodityClass() != null) {
                    uccSpuManagementListQryBO.setCommodityClassStr((String)commodityClassMap.get(uccSpuManagementListQryBO.getCommodityClass().toString()));
                }
            });
        }
        this.newResetStatus(rspBo.getRows());
        this.qrySkuCount(rspBo);
        return rspBo;
    }

    private UccSpuListQryAbilityRspBO qryBatchDealCommodityId(UccSpuListQryAbilityReqBO reqBO, String result) {
        Integer records;
        UccSpuListQryAbilityRspBO rspBo = new UccSpuListQryAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = resultObj.getJSONObject("hits");
        try {
            records = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = hitsObj.getJSONObject("total");
            records = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject.size() > 0) {
            ArrayList<UccSpuListQryBO> uccSkuListCombQryBOList = new ArrayList<UccSpuListQryBO>();
            for (int i = 0; i < listObject.size(); ++i) {
                Object objCommodityId;
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = hitObj.getJSONObject("_source");
                if (null == data || null == (objCommodityId = data.get((Object)"commodity_id"))) continue;
                UccSpuListQryBO uccSpuListQryBO = new UccSpuListQryBO();
                uccSpuListQryBO.setCommodityId(Convert.toLong((Object)objCommodityId));
                uccSkuListCombQryBOList.add(uccSpuListQryBO);
            }
            rspBo.setRows(uccSkuListCombQryBOList);
        }
        if (null != records) {
            int totalPage = records / reqBO.getPageSize();
            int add = records % reqBO.getPageSize() == 0 ? 0 : 1;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(records.intValue());
            rspBo.setPageNo(reqBO.getPageNo());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccSpuListQryAbilityRspBO qryCodeExport(UccSpuListQryAbilityReqBO reqBO, String result) {
        Integer records;
        UccSpuListQryAbilityRspBO rspBo = new UccSpuListQryAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = resultObj.getJSONObject("hits");
        try {
            records = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = hitsObj.getJSONObject("total");
            records = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject.size() > 0) {
            ArrayList<UccSpuListQryBO> uccSkuListCombQryBOList = new ArrayList<UccSpuListQryBO>();
            for (int i = 0; i < listObject.size(); ++i) {
                Object commodityName;
                Object skuCode;
                Object vendorName;
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = hitObj.getJSONObject("_source");
                if (null == data) continue;
                UccSpuListQryBO uccSpuListQryBO = new UccSpuListQryBO();
                Object objCommodityCode = data.get((Object)"commodity_code");
                if (null != objCommodityCode) {
                    uccSpuListQryBO.setCommodityCode(objCommodityCode.toString());
                }
                if (null != (vendorName = data.get((Object)"vendor_name"))) {
                    uccSpuListQryBO.setVendorName(vendorName.toString());
                }
                if (null != (skuCode = data.get((Object)"sku_code"))) {
                    uccSpuListQryBO.setSkuCode(skuCode.toString());
                }
                if (null != (commodityName = data.get((Object)"commodity_name"))) {
                    uccSpuListQryBO.setCommodityName(commodityName.toString());
                }
                uccSkuListCombQryBOList.add(uccSpuListQryBO);
            }
            rspBo.setRows(uccSkuListCombQryBOList);
        }
        if (null != records) {
            int totalPage = records / reqBO.getPageSize();
            int add = records % reqBO.getPageSize() == 0 ? 0 : 1;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(records.intValue());
            rspBo.setPageNo(reqBO.getPageNo());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @NotNull
    private UccSpuListQryAbilityRspBO qryCommodityIdList(UccSpuListQryAbilityRspBO rspBo, String result) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = resultObj.getJSONObject("hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = hitsObj.getJSONObject("total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        ArrayList<Object> commodityModels = new ArrayList<Object>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = hitObj.getJSONObject("_source");
                try {
                    commodityModels.add(JSON.toJavaObject((JSON)data, UccEsCommodityBo.class));
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                }
            }
        }
        String redisCacheKey = SPU_LIST_QUERY_COMMODITY_ID_CACHE_KEY + this.uccIdGenerator.nextId();
        List commodityIds = commodityModels.stream().map(UccEsCommodityBo::getCommodity_id).collect(Collectors.toList());
        List uccCommodityPoList = this.uccCommodityMapper.queryCommodityTypeByCommodityId(commodityIds, this.queryStatus);
        ArrayList<UccSpuListQryAbilityInnerCommodityTypeIdBo> idBoList = new ArrayList<UccSpuListQryAbilityInnerCommodityTypeIdBo>();
        for (UccCommodityPo uccCommodityPo : uccCommodityPoList) {
            UccSpuListQryAbilityInnerCommodityTypeIdBo tmpIdBo = new UccSpuListQryAbilityInnerCommodityTypeIdBo();
            BeanUtils.copyProperties((Object)uccCommodityPo, (Object)tmpIdBo);
            idBoList.add(tmpIdBo);
        }
        this.cacheClient.set(redisCacheKey, (Object)JSON.toJSONString(idBoList), this.commodityIdCacheExpireTime);
        rspBo.setRedisCommodityIdCacheKey(redisCacheKey);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void qrySkuCount(UccSpuListQryAbilityRspBO rspBo) {
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            List<Long> spuIds = rspBo.getRows().stream().map(UccSpuListQryBO::getCommodityId).collect(Collectors.toList());
            String qrySkuCountEsSql = this.buildQrySkuCountEsSql(spuIds);
            log.info("\u67e5\u8be2\u5546\u54c1\u4e0b\u5355\u54c1\u5165\u53c2:{}", (Object)qrySkuCountEsSql);
            String searchInfo = this.searchInfo(qrySkuCountEsSql);
            log.info("\u67e5\u8be2\u5546\u54c1\u4e0b\u5355\u54c1\u51fa\u53c2:{}", (Object)searchInfo);
            JSONObject jsonObject = JSON.parseObject((String)searchInfo);
            JSONObject aggregations = jsonObject.getJSONObject("aggregations");
            JSONObject all_tags = aggregations.getJSONObject("all_tags");
            JSONArray buckets = all_tags.getJSONArray("buckets");
            if (!CollectionUtils.isEmpty((Collection)buckets)) {
                Map<String, String> skuCountMap = buckets.stream().collect(Collectors.toMap(o -> ((JSONObject)o).getString("key"), o -> ((JSONObject)o).getString("doc_count")));
                for (UccSpuListQryBO row : rspBo.getRows()) {
                    String count = skuCountMap.get(Convert.toStr((Object)row.getCommodityId()));
                    if (!StringUtils.isEmpty((Object)count)) {
                        row.setSkuCount(Convert.toInt((Object)count));
                        continue;
                    }
                    row.setSkuCount(Integer.valueOf(0));
                }
            }
        }
    }

    private String buildQrySkuCountEsSql(List<Long> spuIds) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", spuIds));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"sku_id"));
        JSONObject queryJson = new JSONObject();
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        JSONObject collapse = new JSONObject();
        collapse.put("field", (Object)"commodity_id");
        queryJson.put("collapse", (Object)collapse);
        JSONObject aggs = new JSONObject();
        JSONObject terms = new JSONObject();
        JSONObject all_tags = new JSONObject();
        terms.put("field", (Object)"commodity_id");
        terms.put("size", (Object)spuIds.size());
        all_tags.put("terms", (Object)terms);
        aggs.put("all_tags", (Object)all_tags);
        queryJson.put("aggs", (Object)aggs);
        queryJson.put("_source", (Object)"commodity_id");
        return queryJson.toJSONString();
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSpuListQryAbilityReqBO reqBo) {
        WildcardQueryBuilder wildcardQuery;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getAgrType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agrType", (Object)reqBo.getAgrType()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getApprovalStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"spu_approval_status", (Object)reqBo.getApprovalStatus()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityTypeId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityClass())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodityClass", (Object)reqBo.getCommodityClass()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (String)reqBo.getCommodityId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExportCommodityIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", (Collection)reqBo.getExportCommodityIds()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"L4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getApproveOrderId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"audit_no_list.orderId", (Object)reqBo.getApproveOrderId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (null != reqBo.getMinimalismFlag()) {
            BoolQueryBuilder should = new BoolQueryBuilder();
            should.should().add(QueryBuilders.termQuery((String)"minimalism_flag", (Object)reqBo.getMinimalismFlag()));
            BoolQueryBuilder mustNot = new BoolQueryBuilder();
            mustNot.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"minimalism_flag"));
            should.should().add(mustNot);
            boolQueryBuilder.must((QueryBuilder)should);
        }
        if (null != reqBo.getIsAddCoefficient()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_add_coefficient", (Object)reqBo.getMinimalismFlag()));
        }
        ArrayList proNotExtOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getProNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getPurNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getSupNotExtendOrgIds());
        }
        ArrayList extOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getProExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getPurExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getSupExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty(proNotExtOrgIdList) || !CollectionUtils.isEmpty(extOrgIdList)) {
            BoolQueryBuilder orgQueryBuilder = QueryBuilders.boolQuery();
            if (!CollectionUtils.isEmpty(proNotExtOrgIdList)) {
                List collect = proNotExtOrgIdList.stream().distinct().collect(Collectors.toList());
                orgQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_org_id", collect));
            }
            boolQueryBuilder.must((QueryBuilder)orgQueryBuilder);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", (Collection)reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperOrgIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operOrgIds", (Collection)reqBo.getOperOrgIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperRoleIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operRoleIds", (Collection)reqBo.getOperRoleIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperStationCodes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operStationCodes", (Collection)reqBo.getOperStationCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getLimitOrderList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"limit_order", (Collection)reqBo.getLimitOrderList()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", (Collection)reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getOtherSourceId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"other_source_id", (Object)reqBo.getOtherSourceId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)("*" + reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)("*" + reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)("*" + reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getContractCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"contractCode.keyword", (String)("*" + reqBo.getContractCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSpuListQryAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        ArrayList<String> sourceList;
        ArrayList<String> sourceList2;
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        if (UccConstants.IsBatchDealQry.YES.equals(reqBo.getIsBatchDealQry())) {
            sourceList2 = new ArrayList<String>();
            sourceList2.add("commodity_id");
            queryJson.put("_source", sourceList2);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getQueryCommodityIdOnly()) && reqBo.getQueryCommodityIdOnly().booleanValue()) {
            sourceList2 = new ArrayList();
            sourceList2.add("commodity_id");
            queryJson.put("_source", sourceList2);
        }
        String queryString = null;
        if (UccConstants.IsQryNoPicSku.NO_PIC.equals(reqBo.getIsQryNoPicSku())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_pic_count", (int)0));
            sourceList = new ArrayList();
            sourceList.add("commodity_code");
            sourceList.add("sku_code");
            sourceList.add("commodity_name");
            sourceList.add("vendor_name");
            queryJson.put("_source", sourceList);
        }
        if (UccConstants.IsQryNoPicSku.CODE.equals(reqBo.getIsQryNoPicSku())) {
            sourceList = new ArrayList<String>();
            sourceList.add("commodity_code");
            sourceList.add("sku_code");
            sourceList.add("commodity_name");
            sourceList.add("vendor_name");
            queryJson.put("_source", sourceList);
        }
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"update_time").order(SortOrder.DESC);
        queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        if (!UccConstants.IsQryNoPicSku.CODE.equals(reqBo.getIsQryNoPicSku()) && !UccConstants.IsQryNoPicSku.NO_PIC.equals(reqBo.getIsQryNoPicSku())) {
            JSONObject collapse = new JSONObject();
            collapse.put("field", (Object)"commodity_id");
            queryJson.put("collapse", (Object)collapse);
            JSONObject aggs = new JSONObject();
            if (reqBo.isCollapse()) {
                JSONObject total = new JSONObject();
                JSONObject cardinality = new JSONObject();
                total.put("field", (Object)"commodity_id");
                total.put("precision_threshold", (Object)40000);
                cardinality.put("cardinality", (Object)total);
                aggs.put("books_count", (Object)cardinality);
            }
            queryJson.put("aggs", (Object)aggs);
        }
        return queryJson.toString();
    }

    private UccSpuListQryAbilityRspBO dealSearchData(String result, UccSpuListQryAbilityReqBO reqBo) {
        UccSpuListQryAbilityRspBO rspBo = new UccSpuListQryAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccEsCommodityBo> commodityModels = new ArrayList<UccEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccEsCommodityBo commodity = new UccEsCommodityBo();
                try {
                    commodity = (UccEsCommodityBo)JSON.toJavaObject((JSON)data, UccEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        if (reqBo.isCollapse()) {
            String agss = JSONObject.parseObject((String)result).get((Object)"aggregations").toString();
            total = Integer.valueOf(JSONObject.parseObject((String)JSONObject.parseObject((String)agss).get((Object)"books_count").toString()).get((Object)"value").toString());
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize(), reqBo.getUserId());
        return rspBo;
    }

    private UccSpuListQryAbilityRspBO copyData(List<UccEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize, Long userId) {
        UccSpuListQryAbilityRspBO rspBo = new UccSpuListQryAbilityRspBO();
        ArrayList<UccSpuListQryBO> uccSkuManagementListQryBOs = new ArrayList<UccSpuListQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            if (!CollectionUtils.isEmpty(commodityModels)) {
                Map<String, String> commodityStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS_NEW.toString());
                for (UccEsCommodityBo uccEsCommodityBo : commodityModels) {
                    UccSpuListQryBO uccSpuManagementListQryBO = new UccSpuListQryBO();
                    uccSpuManagementListQryBO.setCommodityCode(uccEsCommodityBo.getCommodity_code());
                    uccSpuManagementListQryBO.setCommodityId(Long.valueOf(uccEsCommodityBo.getCommodity_id()));
                    uccSpuManagementListQryBO.setCommodityName(uccEsCommodityBo.getCommodity_name());
                    uccSpuManagementListQryBO.setCommodityStatus(uccEsCommodityBo.getCommodity_status());
                    uccSpuManagementListQryBO.setCommodityTypeId(uccEsCommodityBo.getType_id());
                    uccSpuManagementListQryBO.setCommodityTypeName(uccEsCommodityBo.getType_name());
                    uccSpuManagementListQryBO.setApprovalStatus(uccEsCommodityBo.getSpu_approval_status());
                    uccSpuManagementListQryBO.setSkuSource(Integer.valueOf(uccEsCommodityBo.getSku_source()));
                    uccSpuManagementListQryBO.setFirstSubmitTime(uccEsCommodityBo.getSubmitTime());
                    uccSpuManagementListQryBO.setAgrType(uccEsCommodityBo.getAgrType());
                    uccSpuManagementListQryBO.setCommodityClass(uccEsCommodityBo.getCommodityClass());
                    uccSpuManagementListQryBO.setCommodityExpand(uccEsCommodityBo.getCommodityExpand());
                    uccSpuManagementListQryBO.setContractId(uccEsCommodityBo.getContractId());
                    uccSpuManagementListQryBO.setContractCode(uccEsCommodityBo.getContractCode());
                    uccSpuManagementListQryBO.setContractName(uccEsCommodityBo.getContractName());
                    if (uccSpuManagementListQryBO.getApprovalStatus() != null && uccSpuManagementListQryBO.getApprovalStatus() != 0) {
                        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
                        eacRuTaskPO.setBusinessId(uccSpuManagementListQryBO.getCommodityId().toString());
                        eacRuTaskPO.setStatus("ACTIVE");
                        eacRuTaskPO.setObjType(Integer.valueOf(Integer.parseInt(ApprovalTypeEnum.uccEditProcessOrder.getStep())));
                        eacRuTaskPO.setTacheCode(uccEsCommodityBo.getTache_code());
                        eacRuTaskPO.setUserId(Convert.toStr((Object)userId));
                        eacRuTaskPO.setOrderBy("CREATE_TIME");
                        List list = this.eacRuTaskMapper.getList(eacRuTaskPO);
                        if (!CollectionUtils.isEmpty((Collection)list)) {
                            uccSpuManagementListQryBO.setTaskId(((EacRuTaskPO)list.get(0)).getTaskId());
                            uccSpuManagementListQryBO.setIsJoinTransfer(((EacRuTaskPO)list.get(0)).getIsJoinTransfer());
                            uccSpuManagementListQryBO.setSubmitTime(((EacRuTaskPO)list.get(list.size() - 1)).getCreateTime());
                        }
                    }
                    if (null != uccEsCommodityBo.getCommodity_status()) {
                        uccSpuManagementListQryBO.setCommodityStatusDesc(commodityStatusMap.get(uccEsCommodityBo.getCommodity_status().toString()));
                    }
                    uccSpuManagementListQryBO.setSupplierShopId(uccEsCommodityBo.getSupplier_shop_id());
                    uccSpuManagementListQryBO.setBrandId(Long.valueOf(uccEsCommodityBo.getBrand_id()));
                    uccSpuManagementListQryBO.setBrandName(uccEsCommodityBo.getBrand_name());
                    uccSpuManagementListQryBO.setVendorId(uccEsCommodityBo.getVendor_id());
                    uccSpuManagementListQryBO.setVendorName(uccEsCommodityBo.getVendor_name());
                    uccSpuManagementListQryBO.setMeasureName(uccEsCommodityBo.getMeasure_name());
                    uccSpuManagementListQryBO.setL4mgCategoryId(uccEsCommodityBo.getL4mg_category_id());
                    uccSpuManagementListQryBO.setL4mgCategoryName(uccEsCommodityBo.getL4mg_category_name());
                    uccSpuManagementListQryBO.setOtherSourceId(uccEsCommodityBo.getOther_source_id());
                    uccSpuManagementListQryBO.setOtherSourceCode(uccEsCommodityBo.getOther_source_code());
                    uccSpuManagementListQryBO.setOtherSourceName(uccEsCommodityBo.getOther_source_name());
                    uccSpuManagementListQryBO.setSourceAssort(uccEsCommodityBo.getSourceAssort());
                    uccSpuManagementListQryBO.setCommodityExpand1(uccEsCommodityBo.getCommodity_expand1());
                    uccSpuManagementListQryBO.setSettlementUnit(uccEsCommodityBo.getSettlement_unit());
                    uccSpuManagementListQryBO.setCreateOperName(uccEsCommodityBo.getCreate_oper_name());
                    uccSpuManagementListQryBO.setOrgName(uccEsCommodityBo.getSupplier_org_name());
                    uccSpuManagementListQryBO.setAgreementDetailsId(uccEsCommodityBo.getAgreement_details_id());
                    uccSpuManagementListQryBO.setAgreementId(Long.valueOf(uccEsCommodityBo.getAgreement_id()));
                    uccSkuManagementListQryBOs.add(uccSpuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void newResetStatus(List<UccSpuListQryBO> rows) {
        List comBatchDealRecordPOList;
        ComBatchDealRecordPO comBatchDealRecordPO = new ComBatchDealRecordPO();
        comBatchDealRecordPO.setObjIdList(rows.stream().map(UccSpuListQryBO::getCommodityId).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty((Collection)comBatchDealRecordPO.getObjIdList()) && !CollectionUtils.isEmpty((Collection)(comBatchDealRecordPOList = this.comBatchDealRrecordMapper.getListByObjIds(comBatchDealRecordPO)))) {
            Map objIdMap = comBatchDealRecordPOList.stream().collect(Collectors.toConcurrentMap(ComBatchDealRecordPO::getObjId, ComBatchDealRecordPO::getDealType));
            for (UccSpuListQryBO row : rows) {
                Integer dealType = (Integer)objIdMap.get(row.getCommodityId());
                if (null == dealType) continue;
                if ((CommodityStatusConstants.COMMD_STATUS_DRAFT.equals(row.getCommodityStatus()) || CommodityStatusConstants.COMMD_STATUS_EDIT_AUDIT_REJECT.equals(row.getCommodityStatus())) && UccConstants.BatchDealType.COMM_EDIT_SUBMIT.equals(dealType)) {
                    row.setCommodityStatus(CommodityStatusConstants.COMMD_STATUS_EDIT_SUBMIT_ING);
                    row.setCommodityStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (CommodityStatusConstants.COMMD_STATUS_WAIT_SHELF.equals(row.getCommodityStatus()) && UccConstants.BatchDealType.COMM_EDIT_SUBMIT.equals(dealType)) {
                    row.setCommodityStatus(CommodityStatusConstants.COMMD_STATUS_EDIT_SUBMIT_ING);
                    row.setCommodityStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (CommodityStatusConstants.COMMD_STATUS_ON_SHELF.equals(row.getCommodityStatus()) && UccConstants.BatchDealType.COMM_EDIT_SUBMIT.equals(dealType)) {
                    row.setCommodityStatus(CommodityStatusConstants.COMMD_STATUS_EDIT_SUBMIT_ING);
                    row.setCommodityStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (CommodityStatusConstants.COMMD_STATUS_DOWN_SHELF.equals(row.getCommodityStatus()) && UccConstants.BatchDealType.COMM_EDIT_SUBMIT.equals(dealType)) {
                    row.setCommodityStatus(CommodityStatusConstants.COMMD_STATUS_EDIT_SUBMIT_ING);
                    row.setCommodityStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (CommodityStatusConstants.COMMD_STATUS_DRAFT.equals(row.getCommodityStatus()) && UccConstants.BatchDealType.COMM_DELETE.equals(dealType)) {
                    row.setCommodityStatus(CommodityStatusConstants.COMMD_STATUS_DELETE_ING);
                    row.setCommodityStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (!CommodityStatusConstants.COMMD_STATUS_DRAFT.equals(row.getCommodityStatus()) || !UccConstants.BatchDealType.COMM_DELETE.equals(dealType)) continue;
                row.setCommodityStatus(CommodityStatusConstants.COMMD_STATUS_DELETE_ING);
                row.setCommodityStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
            }
        }
    }
}

