/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.base.bo.OrderColumBo;
import com.tydic.commodity.base.bo.OrgCacheBo;
import com.tydic.commodity.base.bo.SearchBarEsReqBO;
import com.tydic.commodity.base.bo.SearchBarEsRspBO;
import com.tydic.commodity.base.bo.SearchBarEsRspInfo;
import com.tydic.commodity.base.bo.UccExtSearchBarEsReqBO;
import com.tydic.commodity.base.bo.UccExtSearchBarEsRspBO;
import com.tydic.commodity.base.bo.UccSearchOrderConfigBO;
import com.tydic.commodity.base.bo.UccSourceTypeBo;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.busi.api.UccReplacementPriceBusiService;
import com.tydic.commodity.busibase.busi.bo.ReplacePriceInfoBO;
import com.tydic.commodity.busibase.busi.bo.UccReplacementPriceBusiReqBo;
import com.tydic.commodity.busibase.busi.bo.UccReplacementPriceBusiRspBo;
import com.tydic.commodity.busibase.comb.api.SearchBarEsCombService;
import com.tydic.commodity.busibase.comb.bo.UccCommodityClassEnum;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.estore.ability.api.UccExtSearchBarEsAbilityService;
import com.tydic.commodity.po.UccCommodityChannelPO;
import com.tydic.commodity.utils.ListUtils;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccExtSearchBarEsAbilityService.class)
public class UccExtSearchBarEsAbilityServiceImpl
implements UccExtSearchBarEsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccExtSearchBarEsAbilityServiceImpl.class);
    @Autowired
    private SearchBarEsCombService searchBarEsAbilityService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccReplacementPriceBusiService uccReplacementPriceBusiService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;

    public UccExtSearchBarEsRspBO qryBySearchBar(UccExtSearchBarEsReqBO reqBO) {
        List<UccCommodityChannelPO> uccCommodityPoolList;
        Object obj;
        UccExtSearchBarEsRspBO uccExtSearchBarEsRspBO = new UccExtSearchBarEsRspBO();
        String orgPath = reqBO.getOrgPath();
        if (StringUtils.isEmpty((Object)orgPath)) {
            log.error("orgId = " + reqBO.getOrgIdIn() + "\u5f53\u524d\u7528\u6237\u673a\u6784\u6811\u4e3a\u7a7a");
        }
        OrgCacheBo limitGui = null;
        if (!StringUtils.isEmpty((Object)reqBO.getOrgPath())) {
            limitGui = this.searchLimitGui(orgPath);
        }
        log.info("\u5546\u54c1\u641c\u7d22\u6392\u9664\u7684\u9650\u552e\u5546\u54c1\uff1a" + JSONObject.toJSONString((Object)limitGui));
        SearchBarEsReqBO searchBarEsReqBO = new SearchBarEsReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)searchBarEsReqBO);
        if (reqBO.getSkuStatus() == null || reqBO.getSkuStatus().size() == 0) {
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF);
            reqBO.setSkuStatus(skuStatus);
        }
        SearchBarEsReqBO searchEsReqBO = new SearchBarEsReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)searchEsReqBO);
        if (reqBO.getTypeId() != null) {
            searchEsReqBO.setTypeId(reqBO.getTypeId());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTypeName())) {
            searchEsReqBO.setTypeName(reqBO.getTypeName());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuList())) {
            searchEsReqBO.setSkuList(reqBO.getSkuList());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getIgnoreList())) {
            searchEsReqBO.setIgnoreList(reqBO.getIgnoreList());
        }
        if (limitGui != null) {
            if (!CollectionUtils.isEmpty((Collection)limitGui.getIgnoreList())) {
                if (CollectionUtils.isEmpty((Collection)searchEsReqBO.getIgnoreList())) {
                    searchEsReqBO.setIgnoreList(limitGui.getIgnoreList());
                } else {
                    searchEsReqBO.getIgnoreList().addAll(limitGui.getIgnoreList());
                }
            }
            obj = this.cacheClient.get("UCC_COMMODITY_TYPE_ALL");
            List typeListCache = new ArrayList();
            if (obj != null) {
                typeListCache = JSONObject.parseArray((String)JSONObject.toJSONString((Object)obj), Long.class);
            }
            if (!CollectionUtils.isEmpty((Collection)limitGui.getIgSourceTypeBoList())) {
                ArrayList<UccSourceTypeBo> typeBoList = new ArrayList<UccSourceTypeBo>();
                for (UccSourceTypeBo uccSourceTypeBo : limitGui.getIgSourceTypeBoList()) {
                    UccSourceTypeBo uccSourceTypeBo2 = new UccSourceTypeBo();
                    typeBoList.add(uccSourceTypeBo2);
                    uccSourceTypeBo2.setSkuSource(uccSourceTypeBo.getSkuSource());
                    if (CollectionUtils.isEmpty(typeListCache) || CollectionUtils.isEmpty((Collection)uccSourceTypeBo.getType())) continue;
                    ArrayList allTpye = new ArrayList(typeListCache);
                    allTpye.removeAll(uccSourceTypeBo.getType());
                    uccSourceTypeBo2.setType((List)allTpye);
                }
                if (!CollectionUtils.isEmpty((Collection)searchEsReqBO.getSearchTypeList())) {
                    searchEsReqBO.getSearchTypeList().addAll(typeBoList);
                } else {
                    searchEsReqBO.setSearchTypeList(typeBoList);
                }
            }
        }
        if ((obj = this.cacheClient.get("UCC_SKU_SEARCH_ORDER_CONFIG")) != null) {
            List<UccSearchOrderConfigBO> searchOrderConfigBoList = new ArrayList();
            try {
                searchOrderConfigBoList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)obj), UccSearchOrderConfigBO.class);
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38 \uff1a\u5546\u54c1\u6392\u5e8f\u8f6c\u6362\u5f02\u5e38" + JSONObject.toJSONString((Object)reqBO));
            }
            if (!CollectionUtils.isEmpty(searchOrderConfigBoList)) {
                searchOrderConfigBoList.sort(Comparator.comparing(UccSearchOrderConfigBO::getId));
                ArrayList<OrderColumBo> orderColum = new ArrayList<OrderColumBo>();
                for (UccSearchOrderConfigBO uccSearchOrderConfigBO : searchOrderConfigBoList) {
                    if (uccSearchOrderConfigBO.getStatus() != 1L) continue;
                    OrderColumBo bo = new OrderColumBo();
                    bo.setOrderByColumn(uccSearchOrderConfigBO.getColName());
                    bo.setOrderType(Integer.valueOf(uccSearchOrderConfigBO.getType().intValue()));
                    orderColum.add(bo);
                }
                searchEsReqBO.setOrderColum(orderColum);
            }
        }
        searchEsReqBO.setIgnoreSourceAssort((List)Lists.newArrayList((Object[])new Integer[]{UccCommodityClassEnum.RS_GOODS.getKey()}));
        List<Object> ignoreAgrIds = new ArrayList();
        if (!StringUtils.isEmpty((Object)reqBO.getOrgPath())) {
            ignoreAgrIds = this.searchWhiteLimit(orgPath);
        }
        searchEsReqBO.setIgnoreAgrList(ignoreAgrIds);
        SearchBarEsRspBO searchBarEsRspBO = this.searchBarEsAbilityService.qryBySearchBar(searchEsReqBO);
        if ("1".equals(reqBO.getIsprofess()) && !"".equals(reqBO.getCompanyId())) {
            UccReplacementPriceBusiReqBo uccReplacementPriceBusiReqBo = new UccReplacementPriceBusiReqBo();
            Object var11_15 = null;
            ArrayList<ReplacePriceInfoBO> replacePriceInfoBOList = new ArrayList<ReplacePriceInfoBO>();
            for (SearchBarEsRspInfo each : searchBarEsRspBO.getResult()) {
                ReplacePriceInfoBO replacePriceInfoBO = new ReplacePriceInfoBO();
                replacePriceInfoBO.setCommodityTypeId(each.getTypeId());
                replacePriceInfoBO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each.getAgreementPrice())));
                replacePriceInfoBO.setSkuSource(each.getSkuSource());
                replacePriceInfoBO.setSupplierShopId(each.getSupplierShopId());
                replacePriceInfoBO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each.getSalePrice())));
                replacePriceInfoBO.setSkuId(each.getSkuId());
                replacePriceInfoBO.setCommodityId(each.getCommodityId());
                replacePriceInfoBO.setAgreementId(each.getAgreementId());
                replacePriceInfoBO.setVendorId(each.getVendorId());
                replacePriceInfoBOList.add(replacePriceInfoBO);
            }
            uccReplacementPriceBusiReqBo.setIsprofess(reqBO.getIsprofess());
            uccReplacementPriceBusiReqBo.setCompanyId(reqBO.getCompanyId());
            uccReplacementPriceBusiReqBo.setReplacePriceInfo(replacePriceInfoBOList);
            uccReplacementPriceBusiReqBo.setPsDiscountRate(reqBO.getPsDiscountRate());
            UccReplacementPriceBusiRspBo uccReplacementPriceBusiRspBo = this.uccReplacementPriceBusiService.replacePrice(uccReplacementPriceBusiReqBo);
            if ("0000".equals(uccReplacementPriceBusiRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)uccReplacementPriceBusiRspBo.getRows())) {
                Map<Long, Long> replacePriceMap = uccReplacementPriceBusiRspBo.getRows().stream().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, ReplacePriceInfoBO::getSalePrice));
                for (SearchBarEsRspInfo each : searchBarEsRspBO.getResult()) {
                    if (!replacePriceMap.containsKey(each.getSkuId())) continue;
                    each.setSalePrice(MoneyUtils.haoToYuan((Long)replacePriceMap.get(each.getSkuId())));
                }
            }
        } else {
            for (SearchBarEsRspInfo searchBarEsRspInfo : searchBarEsRspBO.getResult()) {
                if (!"2".equals(reqBO.getIsprofess()) || searchBarEsRspInfo.getSourceAssort() == null || searchBarEsRspInfo.getSourceAssort() != 0 && searchBarEsRspInfo.getSourceAssort() != 3 || searchBarEsRspInfo.getAgreementPrice() == null) continue;
                searchBarEsRspInfo.setSalePrice(searchBarEsRspInfo.getAgreementPrice());
            }
            if (reqBO.getPsDiscountRate() != null && reqBO.getPsDiscountRate().compareTo(BigDecimal.ZERO) != 0) {
                for (SearchBarEsRspInfo searchBarEsRspInfo : searchBarEsRspBO.getResult()) {
                    BigDecimal agreementPrice;
                    BigDecimal salePrice = searchBarEsRspInfo.getSalePrice();
                    if (salePrice.compareTo(agreementPrice = searchBarEsRspInfo.getAgreementPrice()) == 0) continue;
                    BigDecimal difValue = salePrice.subtract(agreementPrice);
                    BigDecimal salePirce = difValue.multiply(reqBO.getPsDiscountRate().divide(BigDecimal.valueOf(100L), 4, 0)).add(agreementPrice);
                    searchBarEsRspInfo.setSalePrice(salePirce);
                }
            }
        }
        if (!CollectionUtils.isEmpty(uccCommodityPoolList = this.getUccCommodityPoolList(searchBarEsRspBO.getResult()))) {
            for (SearchBarEsRspInfo each : searchBarEsRspBO.getResult()) {
                List collect;
                Long skuId;
                List collect2;
                Long vendorId;
                List collect3;
                Long agreementId;
                List collect4;
                ArrayList channelIds = new ArrayList();
                ArrayList channelNames = new ArrayList();
                Long typeId = each.getTypeId();
                if (typeId != null && !CollectionUtils.isEmpty(collect4 = uccCommodityPoolList.stream().filter(s -> s.getSource().equals(typeId) && s.getPoolRelated().equals(1)).collect(Collectors.toList()))) {
                    List channelIdList = collect4.stream().map(UccCommodityChannelPO::getChannelId).collect(Collectors.toList());
                    List channelNameList = collect4.stream().map(UccCommodityChannelPO::getChannelName).collect(Collectors.toList());
                    channelIds.addAll(channelIdList);
                    channelNames.addAll(channelNameList);
                }
                if ((agreementId = each.getAgreementId()) != null && !CollectionUtils.isEmpty(collect3 = uccCommodityPoolList.stream().filter(s -> s.getSource().equals(agreementId) && s.getPoolRelated().equals(2)).collect(Collectors.toList()))) {
                    List channelIdList = collect3.stream().map(UccCommodityChannelPO::getChannelId).collect(Collectors.toList());
                    List channelNameList = collect3.stream().map(UccCommodityChannelPO::getChannelName).collect(Collectors.toList());
                    channelIds.addAll(channelIdList);
                    channelNames.addAll(channelNameList);
                }
                if ((vendorId = each.getVendorId()) != null && !CollectionUtils.isEmpty(collect2 = uccCommodityPoolList.stream().filter(s -> s.getSource().equals(vendorId) && s.getPoolRelated().equals(3)).collect(Collectors.toList()))) {
                    List channelIdList = collect2.stream().map(UccCommodityChannelPO::getChannelId).collect(Collectors.toList());
                    List channelNameList = collect2.stream().map(UccCommodityChannelPO::getChannelName).collect(Collectors.toList());
                    channelIds.addAll(channelIdList);
                    channelNames.addAll(channelNameList);
                }
                if ((skuId = each.getSkuId()) != null && !CollectionUtils.isEmpty(collect = uccCommodityPoolList.stream().filter(s -> s.getSource().equals(skuId) && s.getPoolRelated().equals(4)).collect(Collectors.toList()))) {
                    List channelIdList = collect.stream().map(UccCommodityChannelPO::getChannelId).collect(Collectors.toList());
                    List channelNameList = collect.stream().map(UccCommodityChannelPO::getChannelName).collect(Collectors.toList());
                    channelIds.addAll(channelIdList);
                    channelNames.addAll(channelNameList);
                }
                List channelIdCollect = channelIds.stream().distinct().collect(Collectors.toList());
                List channelNameCollect = channelNames.stream().distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(channelIdCollect)) {
                    each.setChannelIds(channelIdCollect);
                }
                if (CollectionUtils.isEmpty(channelNameCollect)) continue;
                each.setChannelNames(channelNameCollect);
            }
        }
        BeanUtils.copyProperties((Object)searchBarEsRspBO, (Object)uccExtSearchBarEsRspBO);
        return uccExtSearchBarEsRspBO;
    }

    private List<UccCommodityChannelPO> getUccCommodityPoolList(List<SearchBarEsRspInfo> searchResult) {
        ArrayList uccCommodityPoolList = null;
        if (!CollectionUtils.isEmpty(searchResult)) {
            List uccCommodityPoolPOS;
            List skuIds;
            List uccCommodityPoolPOS2;
            List vendorIds;
            List uccCommodityPoolPOS3;
            List agreementIds;
            List uccCommodityPoolPOS4;
            uccCommodityPoolList = new ArrayList();
            List typeIds = searchResult.stream().map(SearchBarEsRspInfo::getTypeId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(typeIds) && !CollectionUtils.isEmpty((Collection)(uccCommodityPoolPOS4 = this.uccCommodityPoolMapper.selectChannelByPool(typeIds, Integer.valueOf(1))))) {
                uccCommodityPoolList.addAll(uccCommodityPoolPOS4);
            }
            if (!CollectionUtils.isEmpty(agreementIds = searchResult.stream().map(SearchBarEsRspInfo::getAgreementId).collect(Collectors.toList())) && !CollectionUtils.isEmpty((Collection)(uccCommodityPoolPOS3 = this.uccCommodityPoolMapper.selectChannelByPool(agreementIds, Integer.valueOf(2))))) {
                uccCommodityPoolList.addAll(uccCommodityPoolPOS3);
            }
            if (!CollectionUtils.isEmpty(vendorIds = searchResult.stream().map(SearchBarEsRspInfo::getVendorId).collect(Collectors.toList())) && !CollectionUtils.isEmpty((Collection)(uccCommodityPoolPOS2 = this.uccCommodityPoolMapper.selectChannelByPool(vendorIds, Integer.valueOf(3))))) {
                uccCommodityPoolList.addAll(uccCommodityPoolPOS2);
            }
            if (!CollectionUtils.isEmpty(skuIds = searchResult.stream().map(SearchBarEsRspInfo::getSkuId).collect(Collectors.toList())) && !CollectionUtils.isEmpty((Collection)(uccCommodityPoolPOS = this.uccCommodityPoolMapper.selectChannelByPool(skuIds, Integer.valueOf(4))))) {
                uccCommodityPoolList.addAll(uccCommodityPoolPOS);
            }
        }
        return uccCommodityPoolList;
    }

    public OrgCacheBo searchLimitGui(String orgPath) {
        OrgCacheBo resultBo = new OrgCacheBo();
        ArrayList igSkuList = new ArrayList();
        if (StringUtils.isEmpty((Object)orgPath)) {
            return null;
        }
        String[] orgPathList = orgPath.split("-");
        HashedMap igListMap = new HashedMap();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < orgPathList.length; ++i) {
            if (StringUtils.isEmpty((Object)sb.toString())) {
                sb.append("ORG_PATH_LIMIT_SALE_TYPE");
            }
            String sb1 = sb.append(orgPathList[i]).append("-").toString();
            Object object = this.cacheClient.get(sb1);
            log.info("\u83b7\u53d6\u5230\u7f13\u5b58:\u7f13\u5b58\u540d\uff1a" + sb1 + "\u5185\u5bb9\uff1a" + JSONObject.toJSONString((Object)object));
            if (object == null) continue;
            OrgCacheBo bo = (OrgCacheBo)JSONObject.toJavaObject((JSON)JSON.parseObject((String)JSONObject.toJSONString((Object)object)), OrgCacheBo.class);
            if (!CollectionUtils.isEmpty((Collection)bo.getIgnoreList())) {
                igSkuList.addAll(bo.getIgnoreList());
            }
            if (CollectionUtils.isEmpty((Collection)bo.getIgSourceTypeBoList())) continue;
            for (UccSourceTypeBo each : bo.getIgSourceTypeBoList()) {
                if (!igListMap.containsKey(each.getSkuSource())) {
                    List getType = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)each.getType())) {
                        getType = each.getType();
                    }
                    igListMap.put(each.getSkuSource(), getType);
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)igListMap.get(each.getSkuSource())))) {
                    ((List)igListMap.get(each.getSkuSource())).addAll(each.getType());
                    continue;
                }
                igListMap.put(each.getSkuSource(), each.getType());
            }
        }
        resultBo.setIgnoreList(igSkuList);
        Iterator entries = igListMap.entrySet().iterator();
        ArrayList<UccSourceTypeBo> uccSourceTypeBoList = new ArrayList<UccSourceTypeBo>();
        while (entries.hasNext()) {
            UccSourceTypeBo uccSourceTypeBo = new UccSourceTypeBo();
            Map.Entry entry = entries.next();
            uccSourceTypeBo.setType((List)entry.getValue());
            uccSourceTypeBo.setSkuSource((Integer)entry.getKey());
            uccSourceTypeBoList.add(uccSourceTypeBo);
        }
        resultBo.setIgSourceTypeBoList(uccSourceTypeBoList);
        resultBo.setOrgPath(orgPath);
        return resultBo;
    }

    public List<Long> searchWhiteLimit(String orgPath) {
        if (StringUtils.isEmpty((Object)orgPath)) {
            return new ArrayList<Long>();
        }
        Object object = this.cacheClient.get("UCC_ORG_AGR_EXCLUDE_RESTRICTION");
        List igAgrIds = JSONObject.parseArray((String)JSONObject.toJSONString((Object)object), Long.class);
        if (CollectionUtils.isEmpty((Collection)(igAgrIds = ListUtils.removeReapet((List)igAgrIds)))) {
            return new ArrayList<Long>();
        }
        String[] orgPathList = orgPath.split("-");
        for (int i = 0; i < orgPathList.length; ++i) {
            List havAgrIds;
            StringBuffer sb = new StringBuffer();
            sb.append("UCC_ORG_AGR_WHITELIST_RESTRICTION");
            String sb1 = sb.append(orgPathList[i]).toString();
            Object object1 = this.cacheClient.get(sb1);
            log.info("\u83b7\u53d6\u5230\u7f13\u5b58:\u7f13\u5b58\u540d\uff1a" + sb1 + "\u5185\u5bb9\uff1a" + JSONObject.toJSONString((Object)object1));
            if (object1 == null || CollectionUtils.isEmpty((Collection)(havAgrIds = JSONObject.parseArray((String)JSONObject.toJSONString((Object)object1), Long.class)))) continue;
            for (Long havCommd : havAgrIds) {
                igAgrIds.remove(havCommd);
            }
        }
        return igAgrIds;
    }
}

