/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccShopingComdWithChannelAbilityService;
import com.tydic.commodity.estore.ability.bo.UccComdWithChannelAbilityBo;
import com.tydic.commodity.estore.ability.bo.UccComdWithChannelAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.UccComdWithChannelAbilityRspBo;
import com.tydic.commodity.estore.ability.bo.UccComdWithChannelRequstBo;
import com.tydic.commodity.po.CnncQrySkuChannelForMroPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.ListUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccShopingComdWithChannelAbilityService.class)
public class UccShopingComdWithChannelAbilityServiceImpl
implements UccShopingComdWithChannelAbilityService {
    private static final String channel_code = "MRO_CHANNEL";
    private static final Long channel_Id_first = 1001L;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    public UccComdWithChannelAbilityRspBo qryChannel(UccComdWithChannelAbilityReqBo reqBo) {
        UccComdWithChannelAbilityRspBo rspBo = new UccComdWithChannelAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getQryInfo())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u8f93\u5165\u5fc5\u8981\u53c2\u6570");
            return rspBo;
        }
        ArrayList<UccComdWithChannelAbilityBo> uccComdWithChannelAbilityBos = new ArrayList<UccComdWithChannelAbilityBo>();
        List skus = reqBo.getQryInfo().stream().map(UccComdWithChannelRequstBo::getSkuId).collect(Collectors.toList());
        List skuPoList = this.uccSkuMapper.qeryBatchSkus(skus);
        if (CollectionUtils.isEmpty((Collection)skuPoList)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1ID");
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        Map<Long, List<UccSkuPo>> map = skuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Map.Entry<Long, List<UccSkuPo>> each : map.entrySet()) {
            Long supplierShopId = each.getKey();
            List skuIds = each.getValue().stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            List cnncQrySkuChannelForMroPos = this.uccBrandExtMapper.qrySkuChannelForMro(skuIds, supplierShopId, null);
            if (CollectionUtils.isEmpty((Collection)cnncQrySkuChannelForMroPos)) continue;
            Map<Long, List<CnncQrySkuChannelForMroPo>> skuMap = cnncQrySkuChannelForMroPos.stream().collect(Collectors.groupingBy(CnncQrySkuChannelForMroPo::getSkuId));
            for (Map.Entry<Long, List<CnncQrySkuChannelForMroPo>> skuEach : skuMap.entrySet()) {
                Long skuId = skuEach.getKey();
                UccComdWithChannelAbilityBo uccComdWithChannelAbilityBo = new UccComdWithChannelAbilityBo();
                uccComdWithChannelAbilityBo.setSkuId(skuId);
                uccComdWithChannelAbilityBo.setSupplierShopId(supplierShopId);
                uccComdWithChannelAbilityBo.setSkuSource(skuEach.getValue().get(0).getSkuSource());
                List channelIds = skuEach.getValue().stream().map(CnncQrySkuChannelForMroPo::getChannelId).collect(Collectors.toList());
                List newList = ListUtils.removeReapet(channelIds);
                ArrayList<Long> canList = new ArrayList<Long>();
                for (Long channelId : newList) {
                    if (channel_Id_first.equals(channelId)) continue;
                    canList.add(channelId);
                }
                uccComdWithChannelAbilityBo.setChannels(canList);
                List channelCodes = skuEach.getValue().stream().map(CnncQrySkuChannelForMroPo::getChannelCode).collect(Collectors.toList());
                if (channelCodes.contains(channel_code)) {
                    uccComdWithChannelAbilityBo.setMro(true);
                }
                uccComdWithChannelAbilityBos.add(uccComdWithChannelAbilityBo);
            }
        }
        rspBo.setRows(uccComdWithChannelAbilityBos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

