/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccSkuAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchUpdateService;
import com.tydic.commodity.estore.ability.bo.UccAddPriceInfoBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchUpdateReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchUpdateRspBO;
import com.tydic.commodity.po.UccSkuAddCoefficientLogPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccSkuAddPriceBatchUpdateService.class)
public class UccSkuAddPriceBatchUpdateServiceImpl
implements UccSkuAddPriceBatchUpdateService {
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientLogMapper uccSkuAddCoefficientLogMapper;
    private Sequence sequence = Sequence.getInstance();

    public UccSkuAddPriceBatchUpdateRspBO batchUpdateSkuAddPrice(UccSkuAddPriceBatchUpdateReqBO reqBO) {
        UccSkuAddPriceBatchUpdateRspBO rspBO = new UccSkuAddPriceBatchUpdateRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getAddPriceInfoList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        List addPriceInfoList = reqBO.getAddPriceInfoList();
        List skuIds = addPriceInfoList.stream().map(UccAddPriceInfoBO::getSkuId).collect(Collectors.toList());
        List uccSkuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.selectBySkuIds(skuIds);
        this.uccSkuAddCoefficientLogMapper.batchUpdateTime(skuIds);
        List<UccSkuAddCoefficientPO> updateListBO = this.createUpdateListBO(addPriceInfoList, reqBO);
        List<UccSkuAddCoefficientLogPO> batchInsertLogBO = this.createBatchInsertLogBO(updateListBO, reqBO, uccSkuAddCoefficientPOS);
        this.uccSkuAddCoefficientLogMapper.batchInsert(batchInsertLogBO);
        this.uccSkuAddCoefficientMapper.batchUpdateAddPrice(updateListBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UccSkuAddCoefficientPO> createUpdateListBO(List<UccAddPriceInfoBO> addPriceInfoList, UccSkuAddPriceBatchUpdateReqBO reqBO) {
        ArrayList<UccSkuAddCoefficientPO> list = new ArrayList<UccSkuAddCoefficientPO>();
        for (UccAddPriceInfoBO uccAddPriceInfoBO : addPriceInfoList) {
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
            uccSkuAddCoefficientPO.setSkuId(uccAddPriceInfoBO.getSkuId());
            uccSkuAddCoefficientPO.setAddCoefficient(uccAddPriceInfoBO.getSkuAddCoefficient());
            uccSkuAddCoefficientPO.setAllowMarketPrice(uccAddPriceInfoBO.getAllowMoreMarket());
            uccSkuAddCoefficientPO.setUpdateTime(new Date());
            uccSkuAddCoefficientPO.setUpdateOperId(reqBO.getName());
            list.add(uccSkuAddCoefficientPO);
        }
        return list;
    }

    private List<UccSkuAddCoefficientLogPO> createBatchInsertLogBO(List<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOS, UccSkuAddPriceBatchUpdateReqBO reqBO, List<UccSkuAddCoefficientPO> beforeData) {
        ArrayList<UccSkuAddCoefficientLogPO> list = new ArrayList<UccSkuAddCoefficientLogPO>();
        for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : uccSkuAddCoefficientPOS) {
            UccSkuAddCoefficientLogPO uccSkuAddCoefficientLogPO = new UccSkuAddCoefficientLogPO();
            BeanUtils.copyProperties((Object)uccSkuAddCoefficientPO, (Object)uccSkuAddCoefficientLogPO);
            uccSkuAddCoefficientLogPO.setId(Long.valueOf(this.sequence.nextId()));
            uccSkuAddCoefficientLogPO.setCreateOperId(reqBO.getName());
            uccSkuAddCoefficientLogPO.setAccountNumber(reqBO.getUsername());
            uccSkuAddCoefficientLogPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientLogPO.setUpdateTime(new Date());
            uccSkuAddCoefficientLogPO.setCreateTime(new Date());
            List collect = beforeData.stream().filter(s -> s.getSkuId().equals(uccSkuAddCoefficientPO.getSkuId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                UccSkuAddCoefficientPO beforeBO = (UccSkuAddCoefficientPO)collect.get(0);
                uccSkuAddCoefficientLogPO.setSupplierShopId(beforeBO.getSupplierShopId());
                uccSkuAddCoefficientLogPO.setShopName(beforeBO.getShopName());
                uccSkuAddCoefficientLogPO.setSkuPriceId(beforeBO.getSkuId());
            }
            list.add(uccSkuAddCoefficientLogPO);
        }
        return list;
    }
}

