/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.base.bo.OrgCacheBo;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.UccSourceTypeBo;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccExtCommodityTypeMapper;
import com.tydic.commodity.dao.UccOrgGuideCatalogSalesRestrictionMapper;
import com.tydic.commodity.dao.UccOrgSkuSalesRestrictionMapper;
import com.tydic.commodity.estore.busi.api.OrgOnloadRedisSourceTypeService;
import com.tydic.commodity.po.UccExtCommodityTypePo;
import com.tydic.commodity.po.UccOrgGuideCatalogSalesRestrictionPO;
import com.tydic.commodity.po.UccOrgSkuSalesRestrictionPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="orgOnloadRedisSourceTypeService")
public class OrgOnloadRedisSourceTypeServiceImpl
implements OrgOnloadRedisSourceTypeService {
    private static final Logger log = LoggerFactory.getLogger(OrgOnloadRedisSourceTypeServiceImpl.class);
    @Autowired
    private UccOrgGuideCatalogSalesRestrictionMapper uccOrgGuideCatalogSalesRestrictionMapper;
    @Autowired
    private UccExtCommodityTypeMapper uccExtCommodityTypeMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccOrgSkuSalesRestrictionMapper uccOrgSkuSalesRestrictionMapper;
    @Autowired
    private CacheClient cacheClient;

    @Override
    public RspUccBo dealLimitCache(String orgPath) {
        UccExtCommodityTypePo uccCommodityTypePo;
        List typeList;
        RspUccBo rspUccBo = new RspUccBo();
        OrgCacheBo bo = new OrgCacheBo();
        bo.setOrgPath(orgPath);
        UccOrgGuideCatalogSalesRestrictionPO uccOrgGuideCatalogSalesRestrictionPO = new UccOrgGuideCatalogSalesRestrictionPO();
        uccOrgGuideCatalogSalesRestrictionPO.setOrgTreePath(orgPath);
        uccOrgGuideCatalogSalesRestrictionPO.setStatus(Long.valueOf(1L));
        uccOrgGuideCatalogSalesRestrictionPO.setRestrictionType(Long.valueOf(1L));
        List orgPathCatalog = this.uccOrgGuideCatalogSalesRestrictionMapper.getList(uccOrgGuideCatalogSalesRestrictionPO);
        List igTypeList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)orgPathCatalog)) {
            List orgPathCatalogList = orgPathCatalog.stream().map(UccOrgGuideCatalogSalesRestrictionPO::getGuideCatalogIdL3).collect(Collectors.toList());
            igTypeList = this.uccCatRCommdTypeMapper.queryTypeByGuideCatalogIds(orgPathCatalogList);
        }
        UccOrgSkuSalesRestrictionPO uccOrgSkuSalesRestrictionPO = new UccOrgSkuSalesRestrictionPO();
        uccOrgSkuSalesRestrictionPO.setOrgTreePath(orgPath);
        uccOrgSkuSalesRestrictionPO.setStatus(Long.valueOf(UccConstants.Status.VALID.longValue()));
        List uccOrgSkuSalesRestrictionPOS = this.uccOrgSkuSalesRestrictionMapper.getList(uccOrgSkuSalesRestrictionPO);
        List<Object> igSkuList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)uccOrgSkuSalesRestrictionPOS)) {
            igSkuList = uccOrgSkuSalesRestrictionPOS.stream().map(UccOrgSkuSalesRestrictionPO::getSkuId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(igTypeList) && CollectionUtils.isEmpty(igSkuList)) {
            bo.setIgSourceTypeBoList(new ArrayList());
            bo.setIgnoreList(new ArrayList());
        }
        if (!CollectionUtils.isEmpty(igTypeList)) {
            ArrayList<UccSourceTypeBo> igSourceTypeBoList = new ArrayList<UccSourceTypeBo>();
            UccSourceTypeBo UccSourceTypeBo2 = new UccSourceTypeBo();
            UccSourceTypeBo2.setSkuSource(Integer.valueOf(2));
            UccSourceTypeBo2.setType(igTypeList);
            UccSourceTypeBo UccSourceTypeBo1 = new UccSourceTypeBo();
            UccSourceTypeBo1.setSkuSource(Integer.valueOf(1));
            UccSourceTypeBo UccSourceTypeBo3 = new UccSourceTypeBo();
            UccSourceTypeBo3.setSkuSource(Integer.valueOf(3));
            igSourceTypeBoList.add(UccSourceTypeBo1);
            igSourceTypeBoList.add(UccSourceTypeBo2);
            igSourceTypeBoList.add(UccSourceTypeBo3);
            bo.setIgSourceTypeBoList(igSourceTypeBoList);
        }
        if (!CollectionUtils.isEmpty(igSkuList)) {
            bo.setIgnoreList(igSkuList);
        }
        try {
            String key = "ORG_PATH_LIMIT_SALE_TYPE" + orgPath;
            log.info("\u653e\u5165\u7f13\u5b58\u7684key\uff1a" + key + "-------\u653e\u5165\u7f13\u5b58\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)bo));
            this.cacheClient.set(key, (Object)bo);
        }
        catch (Exception e) {
            log.error("\u6743\u9650\u63a7\u5236\u7f13\u5b58\u5931\u8d25 orgPaht = " + orgPath + "{}=" + JSONObject.toJSONString((Object)bo));
            rspUccBo.setRespCode("0000");
            rspUccBo.setRespDesc("\u6743\u9650\u63a7\u5236\u7f13\u5b58\u5931\u8d25 orgPaht = " + orgPath + "{}=" + JSONObject.toJSONString((Object)bo));
            return rspUccBo;
        }
        Object obj = this.cacheClient.get("UCC_COMMODITY_TYPE_ALL");
        List typeListCache = new ArrayList();
        if (obj != null) {
            typeListCache = JSONObject.parseArray((String)JSONObject.toJSONString((Object)obj), Long.class);
        }
        if (!typeListCache.containsAll(typeList = this.uccExtCommodityTypeMapper.qryTypeIdBySearch(uccCommodityTypePo = new UccExtCommodityTypePo()))) {
            this.cacheClient.set("UCC_COMMODITY_TYPE_ALL", (Object)typeList);
        }
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        return rspUccBo;
    }

    @Override
    public RspUccBo dealCanCache(Long userId) {
        RspUccBo rspUccBo = new RspUccBo();
        OrgCacheBo bo = new OrgCacheBo();
        UccOrgGuideCatalogSalesRestrictionPO uccOrgGuideCatalogSalesRestrictionPO = new UccOrgGuideCatalogSalesRestrictionPO();
        uccOrgGuideCatalogSalesRestrictionPO.setOrgId(userId);
        uccOrgGuideCatalogSalesRestrictionPO.setStatus(Long.valueOf(1L));
        uccOrgGuideCatalogSalesRestrictionPO.setRestrictionType(Long.valueOf(0L));
        List orgPathCatalog = this.uccOrgGuideCatalogSalesRestrictionMapper.getList(uccOrgGuideCatalogSalesRestrictionPO);
        if (CollectionUtils.isEmpty((Collection)orgPathCatalog)) {
            rspUccBo.setRespCode("0000");
            return rspUccBo;
        }
        String orgPath = ((UccOrgGuideCatalogSalesRestrictionPO)orgPathCatalog.get(0)).getOrgTreePath();
        List orgPathCatalogList = orgPathCatalog.stream().map(UccOrgGuideCatalogSalesRestrictionPO::getGuideCatalogIdL3).collect(Collectors.toList());
        List canTypeList = this.uccCatRCommdTypeMapper.queryTypeByGuideCatalogIds(orgPathCatalogList);
        ArrayList<UccSourceTypeBo> igSourceTypeBoList = new ArrayList<UccSourceTypeBo>();
        if (!CollectionUtils.isEmpty((Collection)canTypeList)) {
            UccSourceTypeBo UccSourceTypeBo2 = new UccSourceTypeBo();
            UccSourceTypeBo2.setSkuSource(Integer.valueOf(2));
            UccSourceTypeBo2.setType(canTypeList);
            UccSourceTypeBo UccSourceTypeBo1 = new UccSourceTypeBo();
            UccSourceTypeBo1.setSkuSource(Integer.valueOf(1));
            UccSourceTypeBo UccSourceTypeBo3 = new UccSourceTypeBo();
            UccSourceTypeBo1.setSkuSource(Integer.valueOf(3));
            igSourceTypeBoList.add(UccSourceTypeBo1);
            igSourceTypeBoList.add(UccSourceTypeBo2);
            igSourceTypeBoList.add(UccSourceTypeBo3);
            bo.setIgSourceTypeBoList(igSourceTypeBoList);
        } else {
            UccSourceTypeBo UccSourceTypeBo1 = new UccSourceTypeBo();
            UccSourceTypeBo1.setSkuSource(Integer.valueOf(1));
            UccSourceTypeBo UccSourceTypeBo3 = new UccSourceTypeBo();
            UccSourceTypeBo1.setSkuSource(Integer.valueOf(3));
            UccSourceTypeBo UccSourceTypeBo2 = new UccSourceTypeBo();
            UccSourceTypeBo2.setSkuSource(Integer.valueOf(2));
            igSourceTypeBoList.add(UccSourceTypeBo1);
            igSourceTypeBoList.add(UccSourceTypeBo3);
            igSourceTypeBoList.add(UccSourceTypeBo2);
            bo.setIgSourceTypeBoList(igSourceTypeBoList);
        }
        bo.setIgSourceTypeBoList(igSourceTypeBoList);
        bo.setOrgPath(orgPath);
        try {
            this.cacheClient.set("USER_CASCHE_SALE_TYPE" + userId, (Object)bo);
        }
        catch (Exception e) {
            log.error("\u673a\u6784\u7f13\u5b58\u53ef\u591f\u7c7b\u76ee\u5931\u8d25\uff1a " + JSONObject.toJSONString((Object)bo));
        }
        rspUccBo.setRespCode("0000");
        return rspUccBo;
    }

    public OrgCacheBo searchLimitGui(String orgPath) {
        OrgCacheBo resultBo = new OrgCacheBo();
        ArrayList igSkuList = new ArrayList();
        if (StringUtils.isEmpty((Object)orgPath)) {
            return null;
        }
        String[] orgPathList = orgPath.split("-");
        HashedMap igListMap = new HashedMap();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < orgPathList.length; ++i) {
            Object object;
            if (!StringUtils.isEmpty((Object)sb.toString())) {
                sb.append("-");
            }
            if ((object = this.cacheClient.get(sb.append(orgPathList[i]).toString())) == null) continue;
            OrgCacheBo bo = (OrgCacheBo)JSONObject.toJavaObject((JSON)JSON.parseObject((String)JSONObject.toJSONString((Object)object)), OrgCacheBo.class);
            if (!CollectionUtils.isEmpty((Collection)bo.getIgnoreList())) {
                igSkuList.addAll(bo.getIgnoreList());
            }
            if (CollectionUtils.isEmpty((Collection)bo.getIgSourceTypeBoList())) continue;
            for (UccSourceTypeBo each : bo.getIgSourceTypeBoList()) {
                ((List)igListMap.get(each.getSkuSource())).addAll(each.getType());
            }
        }
        resultBo.setIgnoreList(igSkuList);
        Iterator entries = igListMap.entrySet().iterator();
        ArrayList<UccSourceTypeBo> uccSourceTypeBoList = new ArrayList<UccSourceTypeBo>();
        while (entries.hasNext()) {
            UccSourceTypeBo uccSourceTypeBo = new UccSourceTypeBo();
            Map.Entry entry = entries.next();
            uccSourceTypeBo.setType((List)entry.getValue());
            uccSourceTypeBo.setSkuSource((Integer)entry.getKey());
            uccSourceTypeBoList.add(uccSourceTypeBo);
        }
        resultBo.setIgSourceTypeBoList(uccSourceTypeBoList);
        resultBo.setOrgPath(orgPath);
        return resultBo;
    }
}

