/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.XextSkuChangeFailMapper;
import com.tydic.commodity.dao.XextSkuChangeHistoryMapper;
import com.tydic.commodity.dao.XextSkuChangeMapper;
import com.tydic.commodity.dao.XextSkuChangeRunMapper;
import com.tydic.commodity.estore.busi.api.UccUpdateMsgTableBusiService;
import com.tydic.commodity.estore.busi.bo.UccUpdateMsgTableBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccUpdateMsgTableBusiRspBO;
import com.tydic.commodity.estore.busi.bo.XextSkuChangeBo;
import com.tydic.commodity.po.XextSkuChangeHistoryPo;
import com.tydic.commodity.po.XextSkuChangePo;
import com.tydic.commodity.utils.CacheMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccUpdateMsgTableBusiServiceImpl
implements UccUpdateMsgTableBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateMsgTableBusiServiceImpl.class);
    @Autowired
    private XextSkuChangeMapper xextSkuChangeMapper;
    @Autowired
    private XextSkuChangeHistoryMapper xextSkuChangeHistoryMapper;
    @Autowired
    private OrderSequence uccCommodityIdSequence;
    @Autowired
    private OrderSequence uccSkuIdSequence;
    @Autowired
    private XextSkuChangeRunMapper xextSkuChangeRunMapper;
    @Autowired
    private XextSkuChangeFailMapper xextSkuChangeFailMapper;

    @Override
    public UccUpdateMsgTableBusiRspBO updateSuccess(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        XextSkuChangePo po = new XextSkuChangePo();
        po.setMsgGetId(reqBo.getMsgId());
        po.setSupplierShopId(reqBo.getSupplierShopId());
        po.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_SUCCESS_PROCESS);
        po.setExtSkuHandleState(ModelRuleConstant.EXT_SKU_HANDLE_STATE_SUCCESS);
        po.setRemark(reqBo.getRemark());
        try {
            this.xextSkuChangeMapper.deleteRecords(po);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25\uff1a\u5165\u5e93\u4fe1\u606f" + JSONObject.toJSONString((Object)po) + "---- \u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("xextSkuChangeMapper_updateSucces", "\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25");
        }
        XextSkuChangePo xextSkuChangePo = new XextSkuChangePo();
        xextSkuChangePo.setMsgGetId(reqBo.getMsgId());
        xextSkuChangePo.setSupplierShopId(reqBo.getSupplierShopId());
        List skuChangePos = this.xextSkuChangeMapper.querMsg(xextSkuChangePo);
        XextSkuChangeHistoryPo xextSkuChangeHistoryPo = new XextSkuChangeHistoryPo();
        BeanUtils.copyProperties(skuChangePos.get(0), (Object)xextSkuChangeHistoryPo);
        int count = 0;
        try {
            count = this.xextSkuChangeHistoryMapper.insertMsg(xextSkuChangeHistoryPo);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6210\u529f\u6d88\u606f\u5165\u5e93{\u5386\u53f2}\u5931\u8d25\uff1a" + e.getMessage() + "  msgID = " + reqBo.getMsgId() + "  and supplierShopId = " + reqBo.getSupplierShopId());
        }
        if (count > 0) {
            XextSkuChangePo skuChangePo = new XextSkuChangePo();
            skuChangePo.setId(xextSkuChangeHistoryPo.getId());
            try {
                this.xextSkuChangeMapper.deleteRealRecords(skuChangePo);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u6d88\u606f\u8868\u4e2d\u7684\u5904\u7406\u6210\u529f\u8bb0\u5f55\u5931\u8d25");
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public UccUpdateMsgTableBusiRspBO updateFailed(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        XextSkuChangePo po = new XextSkuChangePo();
        po.setMsgGetId(reqBo.getMsgId());
        po.setSupplierShopId(reqBo.getSupplierShopId());
        po.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_SUCCESS_PROCESS);
        po.setExtSkuHandleState(ModelRuleConstant.EXT_SKU_HANDLE_STATE_FAIL);
        po.setRemark(reqBo.getRemark());
        try {
            this.xextSkuChangeMapper.deleteRecords(po);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25\uff1a\u5165\u5e93\u4fe1\u606f" + JSONObject.toJSONString((Object)po) + "---- \u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("xextSkuChangeMapper_updateFail", "\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public UccUpdateMsgTableBusiRspBO deleteRecord(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        log.error("msgId = " + reqBo.getMsgId() + "and supplierShopId = " + reqBo.getSupplierShopId() + reqBo.getRemark());
        XextSkuChangePo po = new XextSkuChangePo();
        po.setMsgGetId(reqBo.getMsgId());
        po.setSupplierShopId(reqBo.getSupplierShopId());
        po.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_SUCCESS_PROCESS);
        po.setExtSkuHandleState(ModelRuleConstant.EXT_SKU_HANDLE_STATE_SUCCESS);
        po.setRemark(reqBo.getRemark());
        try {
            this.xextSkuChangeMapper.deleteRecords(po);
        }
        catch (Exception e) {
            log.error("msgId = " + reqBo.getMsgId() + "and supplierShopId = " + reqBo.getSupplierShopId() + "\u5220\u9664\u5931\u8d25");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public UccUpdateMsgTableBusiRspBO updateExecuting(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        XextSkuChangePo xextSkuChangePo = new XextSkuChangePo();
        xextSkuChangePo.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_EXECUTING_PROCESS);
        try {
            this.xextSkuChangeMapper.batchUpdateById(xextSkuChangePo, reqBo.getMsgIdList());
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6d88\u606f\u4e3a\u6267\u884c\u4e2d\u72b6\u6001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("xextSkuChangeMapper_updateExecuting", "\u66f4\u65b0\u6d88\u606f\u4e3a\u6267\u884c\u4e2d\u72b6\u6001\u5931\u8d25");
        }
        CacheMap cacheMap = CacheMap.getInstance();
        long id = Thread.currentThread().getId();
        cacheMap.putValue(id + "_commodity_id", new ArrayList());
        cacheMap.putValue(id + "_sku_id", new ArrayList());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public UccUpdateMsgTableBusiRspBO updateRuning(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBO = new UccUpdateMsgTableBusiRspBO();
        if (CollectionUtils.isEmpty(reqBo.getSkuChangeBos())) {
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (CollectionUtils.isEmpty(reqBo.getMsgIdList())) {
            List<Long> idList = reqBo.getSkuChangeBos().stream().map(XextSkuChangeBo::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(idList)) {
                rspBO.setRespCode("\u5931\u8d25");
                return rspBO;
            }
            reqBo.setMsgIdList(idList);
        }
        try {
            int count = this.xextSkuChangeMapper.batchdeleteRealRecordsById(reqBo.getMsgIdList());
            if (count < 1) {
                rspBO.setRespCode("0000");
                return rspBO;
            }
        }
        catch (Exception e2) {
            rspBO.setRespCode("8888");
            log.error("UccUpdateMsgTableBusiServiceImpl \u5220\u9664\u5546\u54c1\u6d88\u606f\u5931\u8d25 \uff1a" + e2.getMessage());
            return rspBO;
        }
        List skuChangePos = reqBo.getSkuChangeBos().stream().map(e -> {
            XextSkuChangePo t = new XextSkuChangePo();
            BeanUtils.copyProperties((Object)e, (Object)t);
            return t;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(skuChangePos)) {
            for (XextSkuChangePo each : skuChangePos) {
                each.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_EXECUTING_PROCESS);
            }
        }
        try {
            this.xextSkuChangeRunMapper.batchInsert(skuChangePos);
        }
        catch (Exception e3) {
            log.error(" UccUpdateMsgTableBusiServiceImpl \u6279\u91cf\u653e\u5165\u6267\u884c\u6570\u636e\u5931\u8d25 \uff1a" + e3.getMessage());
            throw new ZTBusinessException("\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Override
    public UccUpdateMsgTableBusiRspBO dealFailMessage(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        List skuChangePosReq = reqBo.getSkuChangeBos().stream().map(e -> {
            XextSkuChangePo t = new XextSkuChangePo();
            BeanUtils.copyProperties((Object)e, (Object)t);
            t.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_SUCCESS_PROCESS);
            t.setExtSkuHandleState(ModelRuleConstant.EXT_SKU_HANDLE_STATE_SUCCESS);
            return t;
        }).collect(Collectors.toList());
        try {
            this.xextSkuChangeRunMapper.updateBatchByMsgId(skuChangePosReq, reqBo.getSupplierShopId());
        }
        catch (Exception e2) {
            log.error("\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25\uff1a\u5165\u5e93\u4fe1\u606f" + JSONObject.toJSONString(skuChangePosReq) + "---- \u5931\u8d25\u539f\u56e0\uff1a" + e2.getMessage());
            throw new BusinessException("xextSkuChangeMapper_updateSucces", "\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25");
        }
        List msgIdList = skuChangePosReq.stream().map(XextSkuChangePo::getMsgGetId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(msgIdList)) {
            log.error("\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25\uff1a\u5165\u5e93\u4fe1\u606f" + JSONObject.toJSONString(skuChangePosReq) + "---- \u5931\u8d25\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u5165\u5e93\u6570\u636e");
            throw new BusinessException("xextSkuChangeMapper_updateSucces", "\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25");
        }
        List skuChangePos = this.xextSkuChangeRunMapper.querMsgByMsgIdList(msgIdList, reqBo.getSupplierShopId());
        int count = 0;
        try {
            count = this.xextSkuChangeFailMapper.batchInsert(skuChangePos);
        }
        catch (Exception e3) {
            log.error("\u5904\u7406\u6210\u529f\u6d88\u606f\u5165\u5e93{\u5386\u53f2}\u5931\u8d25\uff1a" + e3.getMessage() + "  msgID = " + reqBo.getMsgId() + "  and supplierShopId = " + reqBo.getSupplierShopId());
        }
        if (count > 0) {
            List ids = skuChangePos.stream().map(XextSkuChangePo::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids)) {
                rspBo.setRespCode("\u5931\u8d25");
                return rspBo;
            }
            try {
                this.xextSkuChangeRunMapper.deleteRealRecordsByIds(ids);
            }
            catch (Exception e4) {
                log.error("\u5220\u9664\u6d88\u606f\u8868\u4e2d\u7684\u5904\u7406\u6210\u529f\u8bb0\u5f55\u5931\u8d25");
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public UccUpdateMsgTableBusiRspBO dealRealFailMessage(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        List skuChangePosReq = reqBo.getSkuChangeBos().stream().map(e -> {
            XextSkuChangePo t = new XextSkuChangePo();
            BeanUtils.copyProperties((Object)e, (Object)t);
            t.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_SUCCESS_PROCESS);
            t.setExtSkuHandleState(ModelRuleConstant.EXT_SKU_HANDLE_STATE_FAIL);
            return t;
        }).collect(Collectors.toList());
        try {
            this.xextSkuChangeRunMapper.updateBatchByMsgId(skuChangePosReq, reqBo.getSupplierShopId());
        }
        catch (Exception e2) {
            log.error("\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25\uff1a\u5165\u5e93\u4fe1\u606f" + JSONObject.toJSONString(skuChangePosReq) + "---- \u5931\u8d25\u539f\u56e0\uff1a" + e2.getMessage());
            throw new BusinessException("xextSkuChangeMapper_updateSucces", "\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25");
        }
        List msgIdList = skuChangePosReq.stream().map(XextSkuChangePo::getMsgGetId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(msgIdList)) {
            log.error("\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25\uff1a\u5165\u5e93\u4fe1\u606f" + JSONObject.toJSONString(skuChangePosReq) + "---- \u5931\u8d25\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u5165\u5e93\u6570\u636e");
            throw new BusinessException("xextSkuChangeMapper_updateSucces", "\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25");
        }
        List skuChangePos = this.xextSkuChangeRunMapper.querMsgByMsgIdList(msgIdList, reqBo.getSupplierShopId());
        int count = 0;
        try {
            count = this.xextSkuChangeFailMapper.batchInsert(skuChangePos);
        }
        catch (Exception e3) {
            log.error("\u5904\u7406\u6210\u529f\u6d88\u606f\u5165\u5e93{\u5386\u53f2}\u5931\u8d25\uff1a" + e3.getMessage() + "  msgID = " + reqBo.getMsgId() + "  and supplierShopId = " + reqBo.getSupplierShopId());
        }
        if (count > 0) {
            List ids = skuChangePos.stream().map(XextSkuChangePo::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids)) {
                rspBo.setRespCode("\u5931\u8d25");
                return rspBo;
            }
            try {
                this.xextSkuChangeRunMapper.deleteRealRecordsByIds(ids);
            }
            catch (Exception e4) {
                log.error("\u5220\u9664\u6d88\u606f\u8868\u4e2d\u7684\u5904\u7406\u6210\u529f\u8bb0\u5f55\u5931\u8d25");
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public UccUpdateMsgTableBusiRspBO dealSuccessMessage(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        List skuChangePosReq = reqBo.getSkuChangeBos().stream().map(e -> {
            XextSkuChangePo t = new XextSkuChangePo();
            BeanUtils.copyProperties((Object)e, (Object)t);
            t.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_SUCCESS_PROCESS);
            t.setExtSkuHandleState(ModelRuleConstant.EXT_SKU_HANDLE_STATE_SUCCESS);
            return t;
        }).collect(Collectors.toList());
        try {
            this.xextSkuChangeRunMapper.updateBatchByMsgId(skuChangePosReq, reqBo.getSupplierShopId());
        }
        catch (Exception e2) {
            log.error("\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25\uff1a\u5165\u5e93\u4fe1\u606f" + JSONObject.toJSONString(skuChangePosReq) + "---- \u5931\u8d25\u539f\u56e0\uff1a" + e2.getMessage());
            throw new BusinessException("xextSkuChangeMapper_updateSucces", "\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25");
        }
        List msgIdList = skuChangePosReq.stream().map(XextSkuChangePo::getMsgGetId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(msgIdList)) {
            log.error("\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25\uff1a\u5165\u5e93\u4fe1\u606f" + JSONObject.toJSONString(skuChangePosReq) + "---- \u5931\u8d25\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u5165\u5e93\u6570\u636e");
            throw new BusinessException("xextSkuChangeMapper_updateSucces", "\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25");
        }
        List skuChangePos = this.xextSkuChangeRunMapper.querMsgByMsgIdList(msgIdList, reqBo.getSupplierShopId());
        int count = 0;
        try {
            count = this.xextSkuChangeHistoryMapper.batchInsert(skuChangePos);
        }
        catch (Exception e3) {
            log.error("\u5904\u7406\u6210\u529f\u6d88\u606f\u5165\u5e93{\u5386\u53f2}\u5931\u8d25\uff1a" + e3.getMessage() + "  msgID = " + reqBo.getMsgId() + "  and supplierShopId = " + reqBo.getSupplierShopId());
        }
        if (count > 0) {
            List ids = skuChangePos.stream().map(XextSkuChangePo::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids)) {
                rspBo.setRespCode("\u5931\u8d25");
                return rspBo;
            }
            try {
                this.xextSkuChangeRunMapper.deleteRealRecordsByIds(ids);
            }
            catch (Exception e4) {
                log.error("\u5220\u9664\u6d88\u606f\u8868\u4e2d\u7684\u5904\u7406\u6210\u529f\u8bb0\u5f55\u5931\u8d25");
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

