/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.bo.UccBatchSpuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccDeleteSkuAbilityService;
import com.tydic.commodity.estore.ability.bo.UccDeleteSkuAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccDeleteSkuAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccEstoreDeleteCommodityBusiService;
import com.tydic.commodity.estore.busi.api.UccEstoreDeleteSkuBusiService;
import com.tydic.commodity.estore.busi.api.UccEstoreInsertCommodityLogBusiService;
import com.tydic.commodity.estore.busi.api.UccEstoreInsertSkuLogBusiService;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.self.ability.bo.UccDeleteCommodityAbilityReqBO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccDeleteSkuAbilityService"})
public class UccDeleteSkuAbilityServiceImpl
implements UccDeleteSkuAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccDeleteSkuAbilityServiceImpl.class);
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccEstoreDeleteCommodityBusiService uccSelfDeleteCommodityBusiService;
    @Autowired
    private UccEstoreDeleteSkuBusiService uccSelfDeleteSkuBusiService;
    @Autowired
    private UccEstoreInsertCommodityLogBusiService uccSelfInsertCommodityLogBusiService;
    @Autowired
    private UccEstoreInsertSkuLogBusiService uccSelfInsertSkuLogBusiService;

    @PostMapping(value={"dealDeleteSku"})
    public UccDeleteSkuAbilityRspBO dealDeleteSku(@RequestBody UccDeleteSkuAbilityReqBO reqBO) {
        UccDeleteSkuAbilityRspBO rspBO = new UccDeleteSkuAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5220\u9664\u5355\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List reqSkuIds = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
        List poList = this.uccSkuMapper.qeryBatchSkus(reqSkuIds);
        if (CollectionUtils.isEmpty((Collection)poList) || poList.size() != reqSkuIds.size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5220\u9664\u5355\u54c1\u4e0d\u5b58\u5728");
            return rspBO;
        }
        for (UccSkuPo each : poList) {
            if (!ModelRuleConstant.SKU_STATUS_INVALID.equals(each.getSkuStatus())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(each.getSkuId() + "\u5355\u54c1\u4e0d\u662f\u5931\u6548\u72b6\u6001");
                return rspBO;
            }
            if (!ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO.equals(each.getApprovalStatus())) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(each.getSkuId() + "\u5355\u54c1\u6b63\u5728\u5ba1\u6838\u4e2d");
            return rspBO;
        }
        this.syncEsBySku(reqBO);
        List allSku = this.uccSkuMapper.queryOtherSkuBySkuIds(reqSkuIds);
        Map<Long, List<UccSkuPo>> listMap = allSku.stream().collect(Collectors.groupingBy(UccSkuPo::getCommodityId));
        for (int i = 0; i < poList.size(); ++i) {
            for (int z = 0; z < listMap.get(((UccSkuPo)poList.get(i)).getCommodityId()).size(); ++z) {
                if (!listMap.get(((UccSkuPo)poList.get(i)).getCommodityId()).get(z).getSkuId().equals(((UccSkuPo)poList.get(i)).getSkuId())) continue;
                listMap.get(((UccSkuPo)poList.get(i)).getCommodityId()).remove(z);
            }
        }
        this.uccSelfInsertSkuLogBusiService.batchInsertSkuLog(poList);
        this.uccSelfDeleteSkuBusiService.batchDeleteSku(poList);
        for (Long key : listMap.keySet()) {
            List<UccSkuPo> skuPos = listMap.get(key);
            ArrayList<UccBatchSpuBO> batchSpuList = new ArrayList<UccBatchSpuBO>();
            if (!skuPos.isEmpty() && skuPos.size() != 0) continue;
            UccBatchSpuBO uccBatchSpuBO = new UccBatchSpuBO();
            uccBatchSpuBO.setCommodityId(key);
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.queryByCommodityId(key);
            if (uccCommodityPo == null) {
                log.error("\u5546\u54c1\u5df2\u4e0d\u5b58\u5728");
            }
            uccBatchSpuBO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
            batchSpuList.add(uccBatchSpuBO);
            UccDeleteCommodityAbilityReqBO uccDeleteCommodityAbilityReqBO = new UccDeleteCommodityAbilityReqBO();
            uccDeleteCommodityAbilityReqBO.setBatchSpuList(batchSpuList);
            this.syncEsBySpu(uccDeleteCommodityAbilityReqBO);
            this.uccSelfInsertCommodityLogBusiService.insertCommodityLog(uccCommodityPo);
            this.uccSelfDeleteCommodityBusiService.deleteCommodity(uccCommodityPo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncEsBySku(UccDeleteSkuAbilityReqBO reqBO) {
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        for (Long supplierShopId : mapSku.keySet()) {
            List skuIds = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u5355\u54c1ID\u540c\u6b65ES\u6570\u636e MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25" + e.getMessage());
            }
        }
    }

    private void syncEsBySpu(UccDeleteCommodityAbilityReqBO reqBO) {
        Map<Long, List<UccBatchSpuBO>> group = reqBO.getBatchSpuList().stream().collect(Collectors.groupingBy(UccBatchSpuBO::getSupplierShopId));
        for (Long shopId : group.keySet()) {
            List cmmds = group.get(shopId).stream().map(UccBatchSpuBO::getCommodityId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(cmmds);
            syncSceneCommodityToEsReqBO.setSupplierId(shopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u5546\u54c1ID\u540c\u6b65ES\u6570\u636e MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25" + e.getMessage());
            }
        }
    }
}

