/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.enumType.YesNoEnum;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuStandardRelationMapper;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuBindAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuBindAbilityRspBO;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuBindBO;
import com.tydic.commodity.estore.atom.api.UccQueryYwymDetailAtomService;
import com.tydic.commodity.estore.atom.bo.StdSkuDetailInfoReqBO;
import com.tydic.commodity.estore.atom.bo.StdSkuDetailInfoRspBO;
import com.tydic.commodity.estore.busi.api.UccStandardSkuBindBusiService;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuStandardRelationPO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccStandardSkuBindBusiServiceImpl
implements UccStandardSkuBindBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardSkuBindBusiServiceImpl.class);
    @Autowired
    private UccSkuStandardRelationMapper uccSkuStandardRelationMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccQueryYwymDetailAtomService uccQueryYwymDetailAtomService;
    @Value(value="${ywym_insert_url}")
    private String ywymInsertUrl;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccStandardSkuBindAbilityRspBO dealStandardSkuBind(UccStandardSkuBindAbilityReqBO reqBO) {
        UccStandardSkuBindAbilityRspBO rspBO = new UccStandardSkuBindAbilityRspBO();
        List bindList = reqBO.getBindList();
        Map<Long, List<UccStandardSkuBindBO>> stdSkuMap = bindList.stream().collect(Collectors.groupingBy(UccStandardSkuBindBO::getStdSkuId));
        for (Long stdSkuId : stdSkuMap.keySet()) {
            UccSkuPo qrySource = new UccSkuPo();
            qrySource.setSkuId(stdSkuId);
            List qryResult = this.uccSkuMapper.qerySku(qrySource);
            List<UccStandardSkuBindBO> uccStandardSkuBindBOS = stdSkuMap.get(stdSkuId);
            List collect = uccStandardSkuBindBOS.stream().map(e -> {
                StdSkuDetailInfoReqBO stdSkuDetailInfoReqBO = new StdSkuDetailInfoReqBO();
                stdSkuDetailInfoReqBO.setSkuId(e.getSkuId().toString());
                return stdSkuDetailInfoReqBO;
            }).collect(Collectors.toList());
            for (StdSkuDetailInfoReqBO stdSkuDetailInfoReqBO : collect) {
                StdSkuDetailInfoRspBO stdSkuDetailInfoRspBO = this.uccQueryYwymDetailAtomService.queryYwymDetail(stdSkuDetailInfoReqBO);
                if (!stdSkuDetailInfoRspBO.getResultMessage().equals("SUCCESS")) continue;
                UccSkuPo querySource = new UccSkuPo();
                querySource.setSkuName(stdSkuDetailInfoRspBO.getName());
                querySource.setSkuCode(stdSkuDetailInfoRspBO.getSku());
                List stdSkuPos = this.uccSkuMapper.qerySku(querySource);
                if (CollectionUtil.isEmpty((Collection)stdSkuPos)) {
                    String insertSourceStr = JSONObject.toJSONString((Object)stdSkuDetailInfoRspBO);
                    log.info("\u8c03\u7528\u4e00\u7269\u4e00\u7801\u65b0\u589e\u63a5\u53e3\u5165\u53c2\u4e3a\uff1a" + insertSourceStr);
                    String insertResultStr = HttpUtil.post((String)this.ywymInsertUrl, (String)insertSourceStr, (int)4000);
                    log.info("\u8c03\u7528\u4e00\u7269\u4e00\u7801\u65b0\u589e\u63a5\u53e3\u51fa\u53c2\u4e3a\uff1a" + insertResultStr);
                    StdSkuDetailInfoRspBO insertResult = (StdSkuDetailInfoRspBO)JSONObject.parseObject((String)insertResultStr, StdSkuDetailInfoRspBO.class);
                    if (!insertResult.getResultCode().equals(200)) {
                        throw new ZTBusinessException("\u8c03\u7528\u4e00\u7269\u4e00\u7801\u65b0\u589e\u63a5\u53e3\u5931\u8d25:" + insertResult.getResultMessage());
                    }
                    rspBO.setStdSkuName(stdSkuDetailInfoRspBO.getName());
                    continue;
                }
                if (((UccSkuPo)stdSkuPos.get(0)).getSkuName().equals(((UccSkuPo)qryResult.get(0)).getSkuName())) continue;
                rspBO.setStdSkuName(((UccSkuPo)stdSkuPos.get(0)).getSkuName());
            }
            List skuIds = uccStandardSkuBindBOS.stream().map(UccStandardSkuBindBO::getSkuId).collect(Collectors.toList());
            List skuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
            Map<Long, List<UccSkuPo>> skuPoMap = skuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long supplierShopId : skuPoMap.keySet()) {
                List<UccSkuPo> skuPos1 = skuPoMap.get(supplierShopId);
                UccStatusChangeUpdateSpuAtomReqBO bo = new UccStatusChangeUpdateSpuAtomReqBO();
                bo.setSupplierShopId(supplierShopId);
                bo.setUserId(reqBO.getUserId());
                List skuStatusList = skuPos1.stream().map(e -> {
                    UccSkuUpdateStatusBO uccSkuUpdateStatusBO = new UccSkuUpdateStatusBO();
                    uccSkuUpdateStatusBO.setSkuId(e.getSkuId());
                    uccSkuUpdateStatusBO.setSkuStatus(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
                    uccSkuUpdateStatusBO.setMaterialId(((UccSkuPo)qryResult.get(0)).getMaterialId());
                    uccSkuUpdateStatusBO.setMaterialName(((UccSkuPo)qryResult.get(0)).getMaterialName());
                    return uccSkuUpdateStatusBO;
                }).collect(Collectors.toList());
                bo.setSkuStatusList(skuStatusList);
                bo.setApprovalStatus("");
                UccStatusChangeUpdateSpuAtomRspBO result = this.uccSkuStatusUpdatesAtomService.delaStatusChange(bo);
                if (!"0000".equals(result.getRespCode())) {
                    rspBO.setRespCode(result.getRespCode());
                    rspBO.setRespDesc(result.getRespDesc());
                    return rspBO;
                }
                for (UccSkuPo skuPo : skuPos1) {
                    UccSkuPo updaterocessingStepsSource = new UccSkuPo();
                    updaterocessingStepsSource.setProcessingSteps(Integer.valueOf(0));
                    updaterocessingStepsSource.setSkuId(skuPo.getSkuId());
                    updaterocessingStepsSource.setSupplierShopId(skuPo.getSupplierShopId());
                    this.uccSkuMapper.updateSku(updaterocessingStepsSource);
                }
            }
        }
        bindList.forEach(x -> {
            UccSkuStandardRelationPO relationPO = new UccSkuStandardRelationPO();
            relationPO.setSkuId(x.getSkuId());
            relationPO.setStdSkuId(x.getStdSkuId());
            int count = this.uccSkuStandardRelationMapper.getCheckBy(relationPO);
            relationPO.setBindStatus(YesNoEnum.IS.getType());
            if (count > 0) {
                try {
                    UccSkuStandardRelationPO wrapper = (UccSkuStandardRelationPO)BeanUtil.toBean((Object)relationPO, UccSkuStandardRelationPO.class);
                    wrapper.setBindStatus(null);
                    this.uccSkuStandardRelationMapper.updateBy(relationPO, wrapper);
                }
                catch (Exception e) {
                    log.error("\u4fee\u6539\u7ed1\u5b9a\u72b6\u6001\u4e3a\u5df2\u7ed1\u5b9a\u5931\u8d25: {}", (Object)e.getMessage());
                    throw new ZTBusinessException(e.getMessage());
                }
            }
            relationPO.setId(Long.valueOf(this.sequence.nextId()));
            try {
                this.uccSkuStandardRelationMapper.insert(relationPO);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u7ed1\u5b9a\u72b6\u6001\u4e3a\u5df2\u7ed1\u5b9a\u5931\u8d25: {}", (Object)e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

