/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.commodity.base.bo.UccSpuImportReasonAbilityBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddCoefficientImportAbilityService;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchInsertService;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchUpdateService;
import com.tydic.commodity.estore.ability.bo.UccAddPriceInfoBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddCoefficientImportAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.UccSkuAddCoefficientImportAbilityRspBo;
import com.tydic.commodity.estore.ability.bo.UccSkuAddCoefficientImportBo;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertRspBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchUpdateReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchUpdateRspBO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccVendorPo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddCoefficientImportAbilityService"})
public class UccSkuAddCoefficientImportAbilityServiceImpl
implements UccSkuAddCoefficientImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddCoefficientImportAbilityServiceImpl.class);
    private static final Integer LONG_TIME_FLAG_NO = 0;
    private static final Integer ALLOW_MARKET_PRICE_YES = 1;
    private static final String ALLOW_MARKET_PRICE_YES_STR = "\u662f";
    private static final Integer ALLOW_MARKET_PRICE_NO = 0;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccSkuAddPriceBatchInsertService uccSkuAddPriceBatchInsertService;
    @Autowired
    private UccSkuAddPriceBatchUpdateService uccSkuAddPriceBatchUpdateService;

    @PostMapping(value={"saveSkuAddCoefficientImport"})
    public UccSkuAddCoefficientImportAbilityRspBo saveSkuAddCoefficientImport(@RequestBody UccSkuAddCoefficientImportAbilityReqBo reqBo) {
        this.paramValidation(reqBo);
        UccSkuAddCoefficientImportAbilityRspBo rspBo = new UccSkuAddCoefficientImportAbilityRspBo();
        ArrayList<UccSpuImportReasonAbilityBO> successReasonList = new ArrayList<UccSpuImportReasonAbilityBO>(10);
        ArrayList<UccSpuImportReasonAbilityBO> failReasonList = new ArrayList<UccSpuImportReasonAbilityBO>(10);
        List<UccSkuPo> uccSkuPoList = this.getUccSkuInfo(reqBo);
        Map<String, UccSkuPo> uccSkuInfoMap = this.getUccSkuInfoMap(uccSkuPoList);
        Map<Long, UccVendorPo> uccVendorPoMap = this.getVendorInfoMap(uccSkuPoList);
        Map<Long, UccCommodityTypePo> uccCommodityTypeInfoMap = this.getUccCommodityTypeInfoMap(uccSkuPoList);
        ArrayList<UccSkuAddPriceBatchInsertBO> uccSkuAddPriceBatchInsertBOList = new ArrayList<UccSkuAddPriceBatchInsertBO>(10);
        for (UccSkuAddCoefficientImportBo uccSkuAddCoefficientImportBo : reqBo.getUccSkuAddCoefficientImportBoList()) {
            StringBuffer failReason = new StringBuffer();
            failReason.append(StrUtil.format((CharSequence)"\u5217\u8868\u7b2c{}\u884c", (Object[])new Object[]{uccSkuAddCoefficientImportBo.getGluttonLineNum()}));
            boolean dataValidationFlag = this.dataValidation(uccSkuAddCoefficientImportBo, failReason);
            if (dataValidationFlag) {
                UccSkuAddPriceBatchInsertBO uccSkuAddPriceBatchInsertBO = this.packagingPassData(uccSkuAddCoefficientImportBo, uccSkuInfoMap, uccVendorPoMap, uccCommodityTypeInfoMap);
                uccSkuAddPriceBatchInsertBOList.add(uccSkuAddPriceBatchInsertBO);
                UccSpuImportReasonAbilityBO uccSpuImportReasonAbilityBO = new UccSpuImportReasonAbilityBO();
                uccSpuImportReasonAbilityBO.setLineNum(Integer.valueOf(Math.toIntExact(uccSkuAddCoefficientImportBo.getGluttonLineNum())));
                uccSpuImportReasonAbilityBO.setSuccessReason(StrUtil.format((CharSequence)"\u5217\u8868\u7b2c{}\u884c\u5bfc\u5165\u6210\u529f", (Object[])new Object[]{uccSkuAddCoefficientImportBo.getGluttonLineNum()}));
                successReasonList.add(uccSpuImportReasonAbilityBO);
                continue;
            }
            UccSpuImportReasonAbilityBO uccSpuImportReasonAbilityBO = new UccSpuImportReasonAbilityBO();
            uccSpuImportReasonAbilityBO.setLineNum(Integer.valueOf(Math.toIntExact(uccSkuAddCoefficientImportBo.getGluttonLineNum())));
            uccSpuImportReasonAbilityBO.setFailReason(String.valueOf(failReason));
            failReasonList.add(uccSpuImportReasonAbilityBO);
        }
        if (reqBo.getOperationType() == 1) {
            this.uccSkuAddPriceBatchSave(uccSkuAddPriceBatchInsertBOList);
        }
        if (reqBo.getOperationType() == 2) {
            this.uccSkuAddPriceBatchUpdate(uccSkuAddPriceBatchInsertBOList);
        }
        rspBo.setFailReasonList(failReasonList);
        rspBo.setSuccessReasonList(successReasonList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void paramValidation(UccSkuAddCoefficientImportAbilityReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOperationType())) {
            throw new BusinessException("8888", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUccSkuAddCoefficientImportBoList())) {
            throw new BusinessException("8888", "\u5355\u54c1\u52a0\u4ef7\u7cfb\u6570\u5bfc\u5165\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<UccSkuPo> getUccSkuInfo(UccSkuAddCoefficientImportAbilityReqBo reqBo) {
        List skuCodes = reqBo.getUccSkuAddCoefficientImportBoList().stream().map(UccSkuAddCoefficientImportBo::getSkuCode).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());
        return this.uccSkuMapper.querySkuInfoBySkuCodes(skuCodes);
    }

    private Map<String, UccSkuPo> getUccSkuInfoMap(List<UccSkuPo> uccSkuPoList) {
        Map<String, UccSkuPo> uccSkuPoMap = new HashMap<String, UccSkuPo>(10);
        if (!CollectionUtils.isEmpty(uccSkuPoList)) {
            uccSkuPoMap = uccSkuPoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuCode, po -> po, (k1, k2) -> k2));
        }
        return uccSkuPoMap;
    }

    private Map<Long, UccVendorPo> getVendorInfoMap(List<UccSkuPo> uccSkuPoList) {
        Map<Long, UccVendorPo> uccVendorPoMap = new HashMap<Long, UccVendorPo>(10);
        List uccVendorPoList = new ArrayList(10);
        if (!CollectionUtils.isEmpty(uccSkuPoList)) {
            List VendorIds = uccSkuPoList.stream().map(UccSkuPo::getVendorId).collect(Collectors.toList());
            uccVendorPoList = this.uccVendorMapper.getVendorList(VendorIds);
        }
        if (CollectionUtils.isNotEmpty(uccVendorPoList)) {
            uccVendorPoMap = uccVendorPoList.stream().collect(Collectors.toMap(UccVendorPo::getVendorId, po -> po, (k1, k2) -> k2));
        }
        return uccVendorPoMap;
    }

    private Map<Long, UccCommodityTypePo> getUccCommodityTypeInfoMap(List<UccSkuPo> uccSkuPoList) {
        Map<Long, UccCommodityTypePo> uccCommodityTypePoMap = new HashMap<Long, UccCommodityTypePo>(10);
        List uccCommodityTypePoList = new ArrayList(10);
        if (!CollectionUtils.isEmpty(uccSkuPoList)) {
            List commodityTypeIds = uccSkuPoList.stream().map(UccSkuPo::getCommodityTypeId).collect(Collectors.toList());
            uccCommodityTypePoList = this.uccCommodityTypeMapper.batchQryInType(commodityTypeIds);
        }
        if (CollectionUtils.isNotEmpty(uccCommodityTypePoList)) {
            uccCommodityTypePoMap = uccCommodityTypePoList.stream().collect(Collectors.toMap(UccCommodityTypePo::getCommodityTypeId, po -> po, (k1, k2) -> k2));
        }
        return uccCommodityTypePoMap;
    }

    private boolean dataValidation(UccSkuAddCoefficientImportBo uccSkuAddCoefficientImportBo, StringBuffer failReason) {
        boolean dataValidationFlag = true;
        if (ObjectUtil.isEmpty((Object)uccSkuAddCoefficientImportBo.getSkuCode())) {
            failReason.append("\u201d\u5355\u54c1\u7f16\u7801\u201c\u4e0d\u80fd\u4e3a\u7a7a").append("\u3001");
            dataValidationFlag = false;
        }
        if (ObjectUtil.isEmpty((Object)uccSkuAddCoefficientImportBo.getAddCoefficient())) {
            failReason.append("\u201d\u5355\u54c1\u52a0\u4ef7\u7cfb\u6570\u201c\u5fc5\u586b").append("\u3001");
            dataValidationFlag = false;
        }
        if (!NumberUtil.isNumber((CharSequence)uccSkuAddCoefficientImportBo.getAddCoefficient())) {
            failReason.append("\u201d\u5355\u54c1\u52a0\u4ef7\u7cfb\u6570\u201c\u8f93\u5165\u503c\u683c\u5f0f\u9519\u8bef").append("\u3001");
            dataValidationFlag = false;
        }
        if (ObjectUtil.isEmpty((Object)uccSkuAddCoefficientImportBo.getAllowMarketPrice())) {
            failReason.append("\u201d\u4e0a\u9650\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7\u201c\u5fc5\u586b").append("\u3001");
            dataValidationFlag = false;
        }
        if (!Arrays.asList(ALLOW_MARKET_PRICE_YES_STR, "\u5426").contains(uccSkuAddCoefficientImportBo.getAllowMarketPrice())) {
            failReason.append("\u201d\u4e0a\u9650\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7\u201c\u8f93\u5165\u503c\u683c\u5f0f\u9519\u8bef").append("\u3001");
            dataValidationFlag = false;
        }
        if (ObjectUtil.isEmpty((Object)uccSkuAddCoefficientImportBo.getEffTime())) {
            failReason.append("\u201d\u751f\u6548\u65f6\u95f4\u201c\u5fc5\u586b").append("\u3001");
            dataValidationFlag = false;
        }
        if (!this.dateValidation(uccSkuAddCoefficientImportBo.getEffTime().length(), uccSkuAddCoefficientImportBo.getEffTime(), "yyyy-MM-dd")) {
            failReason.append("\u201d\u751f\u6548\u65f6\u95f4\u201c\u8f93\u5165\u503c\u683c\u5f0f\u9519\u8bef").append("\u3001");
            dataValidationFlag = false;
        }
        if (ObjectUtil.isEmpty((Object)uccSkuAddCoefficientImportBo.getExpTime())) {
            failReason.append("\u201d\u5931\u6548\u65f6\u95f4\u201c\u5fc5\u586b").append("\u3001");
            dataValidationFlag = false;
        }
        if (!this.dateValidation(uccSkuAddCoefficientImportBo.getExpTime().length(), uccSkuAddCoefficientImportBo.getExpTime(), "yyyy-MM-dd")) {
            failReason.append("\u201d\u5931\u6548\u65f6\u95f4\u201c\u8f93\u5165\u503c\u683c\u5f0f\u9519\u8bef").append("\u3001");
            dataValidationFlag = false;
        }
        return dataValidationFlag;
    }

    public boolean dateValidation(int strDateLength, String strDate, String format) {
        if (StringUtils.isEmpty((Object)strDate) || strDate.length() != strDateLength) {
            return false;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Date date = dateFormat.parse(strDate);
            return strDate.equals(dateFormat.format(date));
        }
        catch (Exception e) {
            return false;
        }
    }

    public Date dateFormat(String strDate, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(strDate);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u5b57\u7b26\u4e32\u65e5\u671f\u8f6c\u65f6\u95f4\u7c7b\u578b\u5931\u8d25");
        }
    }

    private UccSkuAddPriceBatchInsertBO packagingPassData(UccSkuAddCoefficientImportBo uccSkuAddCoefficientImportBo, Map<String, UccSkuPo> uccSkuInfoMap, Map<Long, UccVendorPo> uccVendorPoMap, Map<Long, UccCommodityTypePo> uccCommodityTypeInfoMap) {
        UccSkuAddPriceBatchInsertBO uccSkuAddPriceBatchInsertBO = new UccSkuAddPriceBatchInsertBO();
        UccSkuPo uccSkuPo = uccSkuInfoMap.get(uccSkuAddCoefficientImportBo.getSkuCode());
        UccVendorPo uccVendorPo = uccVendorPoMap.get(uccSkuPo.getVendorId());
        UccCommodityTypePo uccCommodityTypePo = uccCommodityTypeInfoMap.get(uccSkuPo.getCommodityTypeId());
        uccSkuAddPriceBatchInsertBO.setSkuId(uccSkuPo.getSkuId());
        uccSkuAddPriceBatchInsertBO.setExtSkuId(uccSkuPo.getExtSkuId());
        uccSkuAddPriceBatchInsertBO.setExtSpuId(uccSkuPo.getExtSpuId());
        uccSkuAddPriceBatchInsertBO.setCommodityId(uccSkuPo.getCommodityId());
        uccSkuAddPriceBatchInsertBO.setSkuName(uccSkuPo.getSkuName());
        uccSkuAddPriceBatchInsertBO.setSupplierShopId(uccSkuPo.getSupplierShopId());
        uccSkuAddPriceBatchInsertBO.setShopName(uccSkuPo.getShopName());
        uccSkuAddPriceBatchInsertBO.setVendorId(uccVendorPo.getVendorId());
        uccSkuAddPriceBatchInsertBO.setVendorName(uccVendorPo.getVendorName());
        uccSkuAddPriceBatchInsertBO.setCatalogId(uccCommodityTypePo.getCatalogId());
        uccSkuAddPriceBatchInsertBO.setSkuAddCoefficient(new BigDecimal(uccSkuAddCoefficientImportBo.getAddCoefficient()));
        uccSkuAddPriceBatchInsertBO.setAllowMarketPrice(ALLOW_MARKET_PRICE_YES_STR.equals(uccSkuAddCoefficientImportBo.getAllowMarketPrice()) ? ALLOW_MARKET_PRICE_YES : ALLOW_MARKET_PRICE_NO);
        uccSkuAddPriceBatchInsertBO.setEffTime(this.dateFormat(uccSkuAddCoefficientImportBo.getEffTime(), "yyyy-MM-dd"));
        uccSkuAddPriceBatchInsertBO.setExpTime(this.dateFormat(uccSkuAddCoefficientImportBo.getExpTime(), "yyyy-MM-dd"));
        uccSkuAddPriceBatchInsertBO.setLongTimeFlag(LONG_TIME_FLAG_NO);
        return uccSkuAddPriceBatchInsertBO;
    }

    private void uccSkuAddPriceBatchSave(List<UccSkuAddPriceBatchInsertBO> uccSkuAddPriceBatchInsertBOList) {
        UccSkuAddPriceBatchInsertReqBO uccSkuAddPriceBatchInsertReqBO = new UccSkuAddPriceBatchInsertReqBO();
        uccSkuAddPriceBatchInsertReqBO.setAddPriceInfoList(uccSkuAddPriceBatchInsertBOList);
        UccSkuAddPriceBatchInsertRspBO uccSkuAddPriceBatchInsertRspBO = this.uccSkuAddPriceBatchInsertService.batchInsertSkuAddPrice(uccSkuAddPriceBatchInsertReqBO);
        if (!"0000".equals(uccSkuAddPriceBatchInsertRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u5355\u54c1\u52a0\u4ef7\u6279\u91cf\u63d2\u5165\u5931\u8d25");
        }
    }

    private void uccSkuAddPriceBatchUpdate(List<UccSkuAddPriceBatchInsertBO> uccSkuAddPriceBatchInsertBOList) {
        UccSkuAddPriceBatchUpdateReqBO uccSkuAddPriceBatchUpdateReqBO = new UccSkuAddPriceBatchUpdateReqBO();
        ArrayList<UccAddPriceInfoBO> uccAddPriceInfoBOList = new ArrayList<UccAddPriceInfoBO>(10);
        for (UccSkuAddPriceBatchInsertBO uccSkuAddPriceBatchInsertBO : uccSkuAddPriceBatchInsertBOList) {
            UccAddPriceInfoBO uccAddPriceInfoBO = new UccAddPriceInfoBO();
            uccAddPriceInfoBO.setSkuId(uccSkuAddPriceBatchInsertBO.getSkuId());
            uccAddPriceInfoBO.setSkuAddCoefficient(uccSkuAddPriceBatchInsertBO.getSkuAddCoefficient());
            uccAddPriceInfoBO.setAllowMoreMarket(uccSkuAddPriceBatchInsertBO.getAllowMarketPrice());
            uccAddPriceInfoBO.setEffTime(uccSkuAddPriceBatchInsertBO.getEffTime());
            uccAddPriceInfoBO.setExpTime(uccSkuAddPriceBatchInsertBO.getExpTime());
            uccAddPriceInfoBOList.add(uccAddPriceInfoBO);
        }
        uccSkuAddPriceBatchUpdateReqBO.setAddPriceInfoList(uccAddPriceInfoBOList);
        UccSkuAddPriceBatchUpdateRspBO uccSkuAddPriceBatchUpdateRspBO = this.uccSkuAddPriceBatchUpdateService.batchUpdateSkuAddPrice(uccSkuAddPriceBatchUpdateReqBO);
        if (!"0000".equals(uccSkuAddPriceBatchUpdateRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u5355\u54c1\u52a0\u4ef7\u6279\u91cf\u4fee\u6539\u5931\u8d25");
        }
    }
}

