/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPriceModifyAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceReqBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceRspBo;
import com.tydic.commodity.dao.UccCommodityTypeAddCoefficientMapper;
import com.tydic.commodity.dao.UccParamsConfigDetailMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.busi.api.UccCommodityTypeCoefficientModifyBusiService;
import com.tydic.commodity.estore.busi.bo.UccCommodityTypeCoefficientBo;
import com.tydic.commodity.estore.busi.bo.UccCommodityTypeCoefficientModifyBusiReqBo;
import com.tydic.commodity.estore.busi.bo.UccCommodityTypeCoefficientModifyBusiRspBo;
import com.tydic.commodity.po.UccCommodityTypeAddCoefficientPO;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccSkuPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class UccCommodityTypeCoefficientModifyBusiServiceImpl
implements UccCommodityTypeCoefficientModifyBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityTypeCoefficientModifyBusiServiceImpl.class);
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceModifyAtomService uccSkuPriceModifyAtomService;
    @Autowired
    private UccCommodityTypeAddCoefficientMapper uccCommodityTypeAddCoefficientMapper;
    @Autowired
    private UccParamsConfigDetailMapper uccParamsConfigDetailMapper;

    @Override
    public UccCommodityTypeCoefficientModifyBusiRspBo dealCoefficientConfigModify(UccCommodityTypeCoefficientModifyBusiReqBo reqBo) {
        List<UccCommodityTypeAddCoefficientPO> uccCommodityTypeAddCoefficientPOList;
        this.paramVerify(reqBo);
        UccCommodityTypeCoefficientModifyBusiRspBo rspBo = new UccCommodityTypeCoefficientModifyBusiRspBo();
        if ((reqBo.getOperationType() == 1 || reqBo.getOperationType() == 2) && CollectionUtils.isNotEmpty(uccCommodityTypeAddCoefficientPOList = this.packagingCommodityTypeCoefficient(reqBo.getUccCommodityTypeCoefficientBoList()))) {
            Map<String, UccCommodityTypeAddCoefficientPO> uccCommodityTypeAddCoefficientPOMap = uccCommodityTypeAddCoefficientPOList.stream().collect(Collectors.toMap(po -> Convert.toStr((Object)po.getSupplierId()) + "-" + Convert.toStr((Object)po.getCommodityTypeId()), po -> po, (k1, k2) -> k2));
            for (UccCommodityTypeCoefficientBo uccCommodityTypeCoefficientBo : reqBo.getUccCommodityTypeCoefficientBoList()) {
                UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO;
                if (!ObjectUtil.isNotEmpty((Object)uccCommodityTypeCoefficientBo) || !ObjectUtil.isNotEmpty((Object)uccCommodityTypeCoefficientBo.getSupplierId()) || !ObjectUtil.isNotEmpty((Object)uccCommodityTypeCoefficientBo.getCommodityTypeId()) || !ObjectUtil.isNotEmpty((Object)(uccCommodityTypeAddCoefficientPO = uccCommodityTypeAddCoefficientPOMap.get(Convert.toStr((Object)uccCommodityTypeCoefficientBo.getSupplierId()) + "-" + Convert.toStr((Object)uccCommodityTypeCoefficientBo.getCommodityTypeId())))) || !ObjectUtil.isNotEmpty((Object)uccCommodityTypeAddCoefficientPO.getAddCoefficient()) || Convert.toInt((Object)uccCommodityTypeAddCoefficientPO.getAddCoefficient()) < 0 || !UccConstants.UccAddCoefficientDealState.DEALING.equals(uccCommodityTypeAddCoefficientPO.getDealStatus())) continue;
                UccParamsConfigDetailPO uccParamsConfigDetailPO = new UccParamsConfigDetailPO();
                uccParamsConfigDetailPO.setRule(Convert.toStr((Object)uccCommodityTypeAddCoefficientPO.getAddCoefficient()));
                uccParamsConfigDetailPO.setAllowMarketPrice(uccCommodityTypeAddCoefficientPO.getAllowMarketPrice());
                this.commodityTypeCoefficientModify(uccCommodityTypeAddCoefficientPO, uccParamsConfigDetailPO);
            }
        }
        if (reqBo.getOperationType() == 3) {
            for (UccCommodityTypeCoefficientBo uccCommodityTypeCoefficientBo : reqBo.getUccCommodityTypeCoefficientBoList()) {
                if (!ObjectUtil.isNotEmpty((Object)uccCommodityTypeCoefficientBo) || !ObjectUtil.isNotEmpty((Object)uccCommodityTypeCoefficientBo.getSupplierId()) || !ObjectUtil.isNotEmpty((Object)uccCommodityTypeCoefficientBo.getCommodityTypeId())) continue;
                UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO = (UccCommodityTypeAddCoefficientPO)JSON.parseObject((String)JSON.toJSONString((Object)uccCommodityTypeCoefficientBo), UccCommodityTypeAddCoefficientPO.class);
                UccParamsConfigDetailPO uccParamsConfigDetailPO = this.getSuperiorAddCoefficient();
                this.commodityTypeCoefficientModify(uccCommodityTypeAddCoefficientPO, uccParamsConfigDetailPO);
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commodityTypeCoefficientModify(UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO, UccParamsConfigDetailPO uccParamsConfigDetailPO) {
        try {
            ArrayList<Long> skuIds = new ArrayList<Long>();
            this.batchEditSkuInfo(uccParamsConfigDetailPO, uccCommodityTypeAddCoefficientPO, skuIds);
            this.syncEsCommodity(skuIds);
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u7c7b\u578b\u52a0\u4ef7\u914d\u7f6e\u4fee\u6539\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            this.updateRiseInPriceState(uccCommodityTypeAddCoefficientPO);
        }
    }

    private void updateRiseInPriceState(UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO) {
        UccCommodityTypeAddCoefficientPO where = new UccCommodityTypeAddCoefficientPO();
        where.setId(uccCommodityTypeAddCoefficientPO.getId());
        UccCommodityTypeAddCoefficientPO set = new UccCommodityTypeAddCoefficientPO();
        set.setDealStatus(UccConstants.UccAddCoefficientDealState.DEAL_SUCCESS);
        this.uccCommodityTypeAddCoefficientMapper.updateBy(set, where);
    }

    private void batchEditSkuInfo(UccParamsConfigDetailPO paramsConfigDetailPO, UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO, List<Long> skuIdList) {
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setCommodityTypeId(uccCommodityTypeAddCoefficientPO.getCommodityTypeId());
        uccSkuPo.setSkuSource(Integer.valueOf(2));
        uccSkuPo.setSupplierShopId(uccCommodityTypeAddCoefficientPO.getSupplierId());
        Page page = new Page(1, 1000);
        List uccSkuPos = this.uccSkuMapper.getListPage(uccSkuPo, page);
        if (CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
            this.skuPriceChangeByCoefficient(uccSkuPos, paramsConfigDetailPO, skuIdList);
            if (page.getTotalPages() > 1) {
                for (int i = 2; i <= page.getTotalPages(); ++i) {
                    Page iPage = new Page(i, 1000);
                    List iUccSkuPos = this.uccSkuMapper.getListPage(uccSkuPo, iPage);
                    if (!CollectionUtils.isNotEmpty((Collection)iUccSkuPos)) continue;
                    this.skuPriceChangeByCoefficient(iUccSkuPos, paramsConfigDetailPO, skuIdList);
                }
            }
        }
    }

    private void skuPriceChangeByCoefficient(List<UccSkuPo> uccSkuPos, UccParamsConfigDetailPO paramsConfigDetailPO, List<Long> skuIdList) {
        List skuIds = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        UccSkuPriceModifyAtomServiceReqBo uccSkuPriceModifyAtomServiceReqBo = new UccSkuPriceModifyAtomServiceReqBo();
        uccSkuPriceModifyAtomServiceReqBo.setSkuIds(skuIds);
        uccSkuPriceModifyAtomServiceReqBo.setChangeType(UccConstants.SkuPriceChangeType.COEFFICIENT);
        uccSkuPriceModifyAtomServiceReqBo.setAddCoefficient(new BigDecimal(paramsConfigDetailPO.getRule()));
        uccSkuPriceModifyAtomServiceReqBo.setAllowMarketPrice(paramsConfigDetailPO.getAllowMarketPrice());
        UccSkuPriceModifyAtomServiceRspBo uccSkuPriceModifyAtomServiceRspBo = this.uccSkuPriceModifyAtomService.skuPriceChange(uccSkuPriceModifyAtomServiceReqBo);
        if (!"0000".equals(uccSkuPriceModifyAtomServiceRspBo.getRespCode())) {
            throw new BusinessException("8888", uccSkuPriceModifyAtomServiceRspBo.getRespDesc());
        }
        skuIdList.addAll(skuIds);
    }

    private void syncEsCommodity(List<Long> skuIds) {
        if (CollectionUtils.isNotEmpty(skuIds)) {
            int INCREMENT;
            int endIndex = INCREMENT = 200;
            if (skuIds.size() > INCREMENT) {
                int times = skuIds.size() % INCREMENT == 0 ? skuIds.size() / INCREMENT : skuIds.size() / INCREMENT + 1;
                int startIndex = 0;
                for (int i = 1; i <= times; ++i) {
                    this.sendSyncEsCommodityMq(skuIds.subList(startIndex, i == times ? skuIds.size() : endIndex));
                    startIndex += INCREMENT;
                    endIndex += INCREMENT;
                }
            } else {
                this.sendSyncEsCommodityMq(skuIds);
            }
        }
    }

    private void sendSyncEsCommodityMq(List<Long> subList) {
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(subList);
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_PRICE.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u7c7b\u578b\u52a0\u4ef7\u63a8\u9001ES\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private UccParamsConfigDetailPO getSuperiorAddCoefficient() {
        UccParamsConfigDetailPO uccParamsConfigDetailPO = new UccParamsConfigDetailPO();
        ArrayList<String> codeList = new ArrayList<String>(3);
        codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT");
        codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_ALLOW_MARKET");
        codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_STATE");
        List listByCode = this.uccParamsConfigDetailMapper.getListByCode(codeList);
        if (CollectionUtils.isNotEmpty((Collection)listByCode)) {
            Map<String, UccParamsConfigDetailPO> paramsConfigDetailMap = listByCode.stream().collect(Collectors.toMap(UccParamsConfigDetailPO::getCode, po -> po, (k1, k2) -> k2));
            uccParamsConfigDetailPO.setRule(paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT").getRule());
            uccParamsConfigDetailPO.setDealStatus(Integer.valueOf(paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_STATE").getRule()));
            uccParamsConfigDetailPO.setAllowMarketPrice(Integer.valueOf(paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_ALLOW_MARKET").getRule()));
        }
        if (CollectionUtils.isEmpty((Collection)listByCode) || ObjectUtil.isEmpty((Object)uccParamsConfigDetailPO)) {
            uccParamsConfigDetailPO.setRule("1");
            uccParamsConfigDetailPO.setDealStatus(Integer.valueOf(1));
            uccParamsConfigDetailPO.setAllowMarketPrice(Integer.valueOf(0));
        }
        return uccParamsConfigDetailPO;
    }

    private List<UccCommodityTypeAddCoefficientPO> packagingCommodityTypeCoefficient(List<UccCommodityTypeCoefficientBo> uccCommodityTypeCoefficientBoList) {
        List<Object> uccCommodityTypeAddCoefficientPOList = new ArrayList<UccCommodityTypeAddCoefficientPO>(10);
        if (CollectionUtils.isNotEmpty(uccCommodityTypeCoefficientBoList)) {
            List commodityTypeIds = uccCommodityTypeCoefficientBoList.stream().map(UccCommodityTypeCoefficientBo::getCommodityTypeId).collect(Collectors.toList());
            List supplierIds = uccCommodityTypeCoefficientBoList.stream().map(UccCommodityTypeCoefficientBo::getSupplierId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(commodityTypeIds) && CollectionUtils.isNotEmpty(supplierIds)) {
                uccCommodityTypeAddCoefficientPOList = this.uccCommodityTypeAddCoefficientMapper.getListByCommodityTypeIdAndSupplierId(commodityTypeIds, supplierIds);
            }
        }
        log.info("\u5546\u54c1\u7c7b\u578b\u52a0\u4ef7\u4fee\u6539\u5904\u7406\u670d\u52a1|\u5c01\u88c5\u52a0\u4ef7\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(uccCommodityTypeAddCoefficientPOList));
        return uccCommodityTypeAddCoefficientPOList;
    }

    private void paramVerify(UccCommodityTypeCoefficientModifyBusiReqBo reqBo) {
        if (ObjectUtils.isEmpty((Object)reqBo)) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getOperationType())) {
            throw new BusinessException("8888", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getUccCommodityTypeCoefficientBoList())) {
            throw new BusinessException("8888", "\u5546\u54c1\u7c7b\u578b\u52a0\u4ef7\u914d\u7f6e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

