/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccSkuAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchUpdateService;
import com.tydic.commodity.estore.ability.bo.UccAddPriceInfoBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchUpdateReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchUpdateRspBO;
import com.tydic.commodity.estore.busi.api.UccSkuAddCoefficientModifyBusiService;
import com.tydic.commodity.estore.busi.bo.UccSkuAddCoefficientModifyBusiReqBo;
import com.tydic.commodity.estore.busi.bo.UccSkuAddCoefficientModifyBusiRspBo;
import com.tydic.commodity.po.UccSkuAddCoefficientLogPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchUpdateService"})
public class UccSkuAddPriceBatchUpdateServiceImpl
implements UccSkuAddPriceBatchUpdateService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddPriceBatchUpdateServiceImpl.class);
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientLogMapper uccSkuAddCoefficientLogMapper;
    @Autowired
    private UccSkuAddCoefficientModifyBusiService uccSkuAddCoefficientModifyBusiService;
    private Sequence sequence = Sequence.getInstance();

    @PostMapping(value={"batchUpdateSkuAddPrice"})
    public UccSkuAddPriceBatchUpdateRspBO batchUpdateSkuAddPrice(@RequestBody UccSkuAddPriceBatchUpdateReqBO reqBO) {
        UccSkuAddPriceBatchUpdateRspBO rspBO = new UccSkuAddPriceBatchUpdateRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getAddPriceInfoList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        List addPriceInfoList = reqBO.getAddPriceInfoList();
        List skuIds = addPriceInfoList.stream().map(UccAddPriceInfoBO::getSkuId).collect(Collectors.toList());
        List uccSkuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.selectBySkuIds(skuIds);
        this.uccSkuAddCoefficientLogMapper.batchUpdateTime(skuIds);
        List<UccSkuAddCoefficientPO> updateListBO = this.createUpdateListBO(addPriceInfoList, reqBO);
        List<UccSkuAddCoefficientLogPO> batchInsertLogBO = this.createBatchInsertLogBO(updateListBO, reqBO, uccSkuAddCoefficientPOS);
        this.uccSkuAddCoefficientLogMapper.batchInsert(batchInsertLogBO);
        this.uccSkuAddCoefficientMapper.batchUpdateAddPrice(updateListBO);
        List<Long> LongTimeFlagSkuIds = reqBO.getAddPriceInfoList().stream().filter(bo -> (null == bo.getEffTime() || bo.getEffTime().before(new Date())) && ObjectUtil.isNotEmpty((Object)bo.getLongTimeFlag()) && bo.getLongTimeFlag() == 1).map(UccAddPriceInfoBO::getSkuId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(LongTimeFlagSkuIds)) {
            UccSkuAddCoefficientModifyBusiReqBo uccSkuAddCoefficientModifyBusiReqBo = new UccSkuAddCoefficientModifyBusiReqBo();
            uccSkuAddCoefficientModifyBusiReqBo.setOperationType(2);
            uccSkuAddCoefficientModifyBusiReqBo.setEffectiveState(1);
            uccSkuAddCoefficientModifyBusiReqBo.setSkuIds(LongTimeFlagSkuIds);
            UccSkuAddCoefficientModifyBusiRspBo uccSkuAddCoefficientModifyBusiRspBo = this.uccSkuAddCoefficientModifyBusiService.dealCoefficientConfigModify(uccSkuAddCoefficientModifyBusiReqBo);
            if (!"0000".equals(uccSkuAddCoefficientModifyBusiRspBo.getRespCode())) {
                log.error("\u5355\u54c1\u52a0\u4ef7\u4fee\u6539\u5904\u7406\u670d\u52a1\u5931\u8d25\uff1a" + uccSkuAddCoefficientModifyBusiRspBo.getRespDesc());
                throw new ZTBusinessException("\u5355\u54c1\u52a0\u4ef7\u4fee\u6539\u5904\u7406\u670d\u52a1\u5931\u8d25\uff1a" + uccSkuAddCoefficientModifyBusiRspBo.getRespDesc());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UccSkuAddCoefficientPO> createUpdateListBO(List<UccAddPriceInfoBO> addPriceInfoList, UccSkuAddPriceBatchUpdateReqBO reqBO) {
        ArrayList<UccSkuAddCoefficientPO> list = new ArrayList<UccSkuAddCoefficientPO>();
        for (UccAddPriceInfoBO uccAddPriceInfoBO : addPriceInfoList) {
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
            uccSkuAddCoefficientPO.setSkuId(uccAddPriceInfoBO.getSkuId());
            uccSkuAddCoefficientPO.setAddCoefficient(uccAddPriceInfoBO.getSkuAddCoefficient());
            uccSkuAddCoefficientPO.setAllowMarketPrice(uccAddPriceInfoBO.getAllowMoreMarket());
            uccSkuAddCoefficientPO.setUpdateTime(new Date());
            uccSkuAddCoefficientPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientPO.setEffTime(uccAddPriceInfoBO.getEffTime());
            uccSkuAddCoefficientPO.setExpTime(uccAddPriceInfoBO.getExpTime());
            list.add(uccSkuAddCoefficientPO);
        }
        return list;
    }

    private List<UccSkuAddCoefficientLogPO> createBatchInsertLogBO(List<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOS, UccSkuAddPriceBatchUpdateReqBO reqBO, List<UccSkuAddCoefficientPO> beforeData) {
        ArrayList<UccSkuAddCoefficientLogPO> list = new ArrayList<UccSkuAddCoefficientLogPO>();
        for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : uccSkuAddCoefficientPOS) {
            UccSkuAddCoefficientLogPO uccSkuAddCoefficientLogPO = new UccSkuAddCoefficientLogPO();
            BeanUtils.copyProperties((Object)uccSkuAddCoefficientPO, (Object)uccSkuAddCoefficientLogPO);
            uccSkuAddCoefficientLogPO.setId(Long.valueOf(this.sequence.nextId()));
            uccSkuAddCoefficientLogPO.setCreateOperId(reqBO.getName());
            uccSkuAddCoefficientLogPO.setAccountNumber(reqBO.getUsername());
            uccSkuAddCoefficientLogPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientLogPO.setUpdateTime(new Date());
            uccSkuAddCoefficientLogPO.setCreateTime(new Date());
            List collect = beforeData.stream().filter(s -> s.getSkuId().equals(uccSkuAddCoefficientPO.getSkuId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                UccSkuAddCoefficientPO beforeBO = (UccSkuAddCoefficientPO)collect.get(0);
                uccSkuAddCoefficientLogPO.setSupplierShopId(beforeBO.getSupplierShopId());
                uccSkuAddCoefficientLogPO.setShopName(beforeBO.getShopName());
                uccSkuAddCoefficientLogPO.setSkuPriceId(beforeBO.getSkuId());
                uccSkuAddCoefficientLogPO.setExpiryTime(beforeBO.getExpTime());
            }
            list.add(uccSkuAddCoefficientLogPO);
        }
        return list;
    }
}

