/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.estore.ability.api.UccSkuPriceChangeHistoryQryAbilityService;
import com.tydic.commodity.estore.ability.bo.UccSkuPriceChangeHistoryQryAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuPriceChangeHistoryQryAbilityRspBO;
import com.tydic.commodity.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuPriceChangeHistoryQryAbilityService"})
public class UccSkuPriceChangeHistoryQryAbilityServiceImpl
implements UccSkuPriceChangeHistoryQryAbilityService {
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Value(value="${priceChangeHistoryQry.default.month:3}")
    private Integer defaultMonth;

    @PostMapping(value={"getSkuPriceChangeHistoryQry"})
    public UccSkuPriceChangeHistoryQryAbilityRspBO getSkuPriceChangeHistoryQry(@RequestBody UccSkuPriceChangeHistoryQryAbilityReqBO reqBO) {
        this.val(reqBO);
        UccSkuPriceChangeHistoryQryAbilityRspBO rspBO = new UccSkuPriceChangeHistoryQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)eCommercePriceChangeLogPO);
        eCommercePriceChangeLogPO.setUpdateTimeStar(reqBO.getStartTime());
        eCommercePriceChangeLogPO.setUpdateTimeEnd(reqBO.getEndTime());
        ECommercePriceChangeLogPO maxMinPricePo = this.eCommercePriceChangeLogMapper.qryMaxMinPrice(eCommercePriceChangeLogPO);
        if (null != maxMinPricePo) {
            rspBO.setBottomPrice(maxMinPricePo.getBottomPrice());
            rspBO.setMaximumPrice(maxMinPricePo.getMaximumPrice());
        }
        ECommercePriceChangeLogPO currentPricePO = this.eCommercePriceChangeLogMapper.qryCurrentPrice(eCommercePriceChangeLogPO);
        currentPricePO.setAvgPrice(MoneyUtils.haoToYuan((BigDecimal)currentPricePO.getAvgPrice()));
        Calendar cal = Calendar.getInstance();
        cal.add(2, -this.defaultMonth.intValue());
        eCommercePriceChangeLogPO.setUpdateTimeStar(cal.getTime());
        ECommercePriceChangeLogPO avgPricePo = this.eCommercePriceChangeLogMapper.qryIntervalAvgPrice(eCommercePriceChangeLogPO);
        if (null != avgPricePo && null != avgPricePo.getAvgPrice()) {
            BigDecimal agr = avgPricePo.getAvgPrice().multiply(BigDecimal.valueOf(avgPricePo.getChangeCount().intValue())).add(currentPricePO.getAvgPrice()).divide(BigDecimal.valueOf(avgPricePo.getChangeCount().intValue()).add(BigDecimal.ONE), 2, RoundingMode.HALF_UP);
            rspBO.setAvgPrice(agr);
        } else {
            rspBO.setAvgPrice(currentPricePO.getAvgPrice());
            rspBO.setBottomPrice(currentPricePO.getAvgPrice());
            rspBO.setMaximumPrice(currentPricePO.getAvgPrice());
        }
        if (rspBO.getMaximumPrice().compareTo(currentPricePO.getAvgPrice()) < 0) {
            rspBO.setMaximumPrice(currentPricePO.getAvgPrice());
        }
        if (rspBO.getBottomPrice().compareTo(currentPricePO.getAvgPrice()) > 0) {
            rspBO.setBottomPrice(currentPricePO.getAvgPrice());
        }
        return rspBO;
    }

    private void val(UccSkuPriceChangeHistoryQryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("0001", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSkuId()) {
            throw new BaseBusinessException("0001", "\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierShopId()) {
            throw new BaseBusinessException("0001", "\u94fa\u8d27\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

