/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.base.bo.SkuPriceBo;
import com.tydic.commodity.base.enumType.CommodityStatusEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.ECommercePriceChangeMapper;
import com.tydic.commodity.dao.UccCyclePircePercentageMapper;
import com.tydic.commodity.dao.UccIntervalPircePercentageMapper;
import com.tydic.commodity.dao.UccPricePreventLogMapper;
import com.tydic.commodity.dao.UccPricePreventMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.estore.busi.api.UccMqSyncCommdPriceBusiService;
import com.tydic.commodity.estore.busi.api.UccSkuAdjustPriceBusiService;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceBo;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceReqBo;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceRspBo;
import com.tydic.commodity.estore.busi.bo.UccSkuAdjustPriceReqBO;
import com.tydic.commodity.estore.comb.bo.UccExecuteCommdMsgCombRspBO;
import com.tydic.commodity.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.po.ECommercePriceChangePO;
import com.tydic.commodity.po.UccCyclePircePercentagePO;
import com.tydic.commodity.po.UccIntervalPircePercentagePO;
import com.tydic.commodity.po.UccPricePreventPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMqSyncCommdPriceBusiServiceImpl
implements UccMqSyncCommdPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMqSyncCommdPriceBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ECommercePriceChangeMapper eCommercePriceChangeMapper;
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Autowired
    private UccSkuAdjustPriceBusiService uccSkuAdjustPriceBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    private Sequence coefficientSequence = Sequence.getInstance();
    @Autowired
    private UccIntervalPircePercentageMapper uccIntervalPircePercentageMapper;
    @Autowired
    private UccCyclePircePercentageMapper uccCyclePircePercentageMapper;
    @Autowired
    private BatchUpdateCommoStatusForMarketService batchUpdateCommoStatusForMarket;
    @Autowired
    private UccPricePreventMapper uccPricePreventMapper;
    @Autowired
    private UccPricePreventLogMapper uccPricePreventLogMapper;

    @Override
    public MqSyncCommdPriceRspBo dealSync(MqSyncCommdPriceReqBo mqSyncCommdPriceReqBo) throws ZTBusinessException {
        MqSyncCommdPriceRspBo rspBo = new MqSyncCommdPriceRspBo();
        if (CollectionUtils.isEmpty(mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        for (MqSyncCommdPriceBo each : mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList()) {
            UccSkuAdjustPriceReqBO uccSkuAdjustPriceReqBO = new UccSkuAdjustPriceReqBO();
            uccSkuAdjustPriceReqBO.setSkuId(each.getSkuId());
            uccSkuAdjustPriceReqBO.setSupplierShopId(each.getSupplierShopId());
            SkuPriceBo skuPriceBo = new SkuPriceBo();
            uccSkuAdjustPriceReqBO.setUpdateSkuPriceInfo(skuPriceBo);
            skuPriceBo.setSalePrice(each.getSalePrice());
            skuPriceBo.setAgreementPrice(each.getAgreementPrice());
            skuPriceBo.setMarketPrice(each.getMarketPrice());
            try {
                this.uccSkuAdjustPriceBusiService.dealSkuAdjustPrice(uccSkuAdjustPriceReqBO);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
        }
        try {
            this.dealUpFloatNew(mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList());
        }
        catch (Exception e) {
            log.error("\u4ef7\u683c\u9884\u8b66\u5f02\u5e38\uff1a" + e.getMessage());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<UccExecuteCommdMsgCombRspBO> dealUpFloatNew(List<MqSyncCommdPriceBo> bos) {
        ArrayList<UccExecuteCommdMsgCombRspBO> listRsp = new ArrayList<UccExecuteCommdMsgCombRspBO>();
        if (!CollectionUtils.isEmpty(bos)) {
            ArrayList<Long> commoditys = new ArrayList<Long>();
            UccIntervalPircePercentagePO uccIntervalPricePercentagePO = new UccIntervalPircePercentagePO();
            Page page = new Page();
            page.setPageSize(999);
            List uccIntervalPricePercentagePOS = this.uccIntervalPircePercentageMapper.getListPage(uccIntervalPricePercentagePO, page);
            if (CollectionUtils.isEmpty((Collection)uccIntervalPricePercentagePOS)) {
                UccExecuteCommdMsgCombRspBO rspBO = new UccExecuteCommdMsgCombRspBO();
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u67e5\u8be2\u4ef7\u683c\u9884\u8b66\u914d\u7f6e\u5931\u8d25");
                listRsp.add(rspBO);
                return listRsp;
            }
            ArrayList<UccPricePreventPO> uccPricePreventPOS = new ArrayList<UccPricePreventPO>();
            ArrayList<ECommercePriceChangePO> eCommercePriceChangePOList = new ArrayList<ECommercePriceChangePO>();
            ArrayList<ECommercePriceChangeLogPO> eCommercePriceChangeLogPOS = new ArrayList<ECommercePriceChangeLogPO>();
            for (MqSyncCommdPriceBo bo : bos) {
                UccCyclePircePercentagePO modelBy;
                BigDecimal downPrevent;
                UccIntervalPircePercentagePO skuPercentage = null;
                BigDecimal agreementPrice = MoneyUtils.haoToYuan((Long)bo.getAgreementPrice());
                if (null == bo.getOldAgreementPrice()) continue;
                BigDecimal oldAgreementPrice = MoneyUtils.haoToYuan((Long)bo.getOldAgreementPrice());
                boolean flag = false;
                for (UccIntervalPircePercentagePO intervalPricePercentagePO : uccIntervalPricePercentagePOS) {
                    BigDecimal maxPrice = intervalPricePercentagePO.getNumEnd();
                    BigDecimal minPrice = intervalPricePercentagePO.getNumStart();
                    if (maxPrice == null || new BigDecimal("-1").compareTo(maxPrice) == 0) {
                        if (oldAgreementPrice.compareTo(minPrice) <= 0) continue;
                        skuPercentage = intervalPricePercentagePO;
                        break;
                    }
                    if (oldAgreementPrice.compareTo(minPrice) <= 0 || oldAgreementPrice.compareTo(maxPrice) >= 1) continue;
                    skuPercentage = intervalPricePercentagePO;
                    break;
                }
                log.info("\u5339\u914d\u6240\u5728\u533a\u95f4\uff1a{}", (Object)JSON.toJSONString(skuPercentage));
                if (skuPercentage == null) continue;
                UccPricePreventPO uccPricePreventPO = new UccPricePreventPO();
                uccPricePreventPO.setBeforePrice(new BigDecimal(bo.getOldAgreementPrice().toString()));
                uccPricePreventPO.setPrice(new BigDecimal(bo.getAgreementPrice().toString()));
                uccPricePreventPO.setSupplierShopId(bo.getSupplierShopId());
                uccPricePreventPO.setUpdateTime(new Date());
                uccPricePreventPO.setSkuId(bo.getSkuId());
                uccPricePreventPO.setSkuName(bo.getSkuName());
                uccPricePreventPO.setBrandId(bo.getBrandId());
                uccPricePreventPO.setExtSkuId(bo.getExtSkuId());
                uccPricePreventPO.setOnShelveTime(bo.getOnShelveTime());
                uccPricePreventPO.setIsDown(Integer.valueOf(0));
                if (agreementPrice.compareTo(oldAgreementPrice) < 0 && (downPrevent = oldAgreementPrice.subtract(agreementPrice).divide(oldAgreementPrice, 4)).compareTo(skuPercentage.getDownPercentage().divide(new BigDecimal("100"))) > 0) {
                    uccPricePreventPO.setPercentage(downPrevent);
                    uccPricePreventPOS.add(uccPricePreventPO);
                    flag = true;
                }
                if (agreementPrice.compareTo(oldAgreementPrice) > 0) {
                    BigDecimal upPrevent = agreementPrice.subtract(oldAgreementPrice).divide(oldAgreementPrice, 4);
                    if (upPrevent.compareTo(skuPercentage.getUpperPercentage().divide(new BigDecimal("100"))) > 0) {
                        uccPricePreventPO.setPercentage(upPrevent);
                        uccPricePreventPOS.add(uccPricePreventPO);
                        flag = true;
                    }
                    if (upPrevent.compareTo(skuPercentage.getOffShelfPercentage().divide(new BigDecimal("100"))) > 0) {
                        uccPricePreventPO.setIsDown(Integer.valueOf(1));
                        commoditys.add(bo.getCommodityId());
                    }
                }
                if (!flag && (modelBy = this.uccCyclePircePercentageMapper.getModelBy(new UccCyclePircePercentagePO())) != null) {
                    BigDecimal downPrevent2;
                    ECommercePriceChangeLogPO eCommercePriceChangePO = new ECommercePriceChangeLogPO();
                    eCommercePriceChangePO.setSkuId(bo.getSkuId());
                    eCommercePriceChangePO.setSupplierShopId(bo.getSupplierShopId());
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
                    Calendar calendar1 = Calendar.getInstance();
                    calendar1.add(5, 0 - modelBy.getDate());
                    Date updateTime = calendar1.getTime();
                    eCommercePriceChangePO.setUpdateTime(updateTime);
                    List poList = this.eCommercePriceChangeLogMapper.queryCountNew(eCommercePriceChangePO);
                    if (!CollectionUtils.isEmpty((Collection)poList)) {
                        BigDecimal sum = poList.stream().map(ECommercePriceChangeLogPO::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                        oldAgreementPrice = sum.add(((ECommercePriceChangeLogPO)poList.get(0)).getOldPrice()).divide(new BigDecimal(poList.size()).add(new BigDecimal(1)));
                    }
                    if (agreementPrice.compareTo(oldAgreementPrice) < 0 && (downPrevent2 = oldAgreementPrice.subtract(agreementPrice).divide(oldAgreementPrice, 4)).compareTo(modelBy.getDownPercentage().divide(new BigDecimal("100"))) > 0) {
                        uccPricePreventPO.setPercentage(downPrevent2);
                        uccPricePreventPOS.add(uccPricePreventPO);
                        flag = true;
                    }
                    if (agreementPrice.compareTo(oldAgreementPrice) > 0) {
                        BigDecimal upPrevent = agreementPrice.subtract(oldAgreementPrice).divide(oldAgreementPrice, 4);
                        if (upPrevent.compareTo(modelBy.getUpperPercentage().divide(new BigDecimal("100"))) > 0) {
                            uccPricePreventPO.setPercentage(upPrevent);
                            uccPricePreventPOS.add(uccPricePreventPO);
                            flag = true;
                        }
                        if (upPrevent.compareTo(modelBy.getOffShelfPercentage().divide(new BigDecimal("100"))) > 0) {
                            uccPricePreventPO.setIsDown(Integer.valueOf(1));
                            commoditys.add(bo.getCommodityId());
                        }
                    }
                }
                ECommercePriceChangePO eCommercePriceChangePO = new ECommercePriceChangePO();
                eCommercePriceChangePO.setSkuId(bo.getSkuId());
                eCommercePriceChangePO.setSupplierShopId(bo.getSupplierShopId());
                List eCommercePriceChangePOS = this.eCommercePriceChangeMapper.qryECommercePriceChange(eCommercePriceChangePO);
                if (eCommercePriceChangePOS == null || eCommercePriceChangePOS.size() == 0) {
                    eCommercePriceChangePO.setId(Long.valueOf(this.coefficientSequence.nextId()));
                    eCommercePriceChangePO.setPrice(agreementPrice);
                    eCommercePriceChangePO.setCurrentPrice(agreementPrice);
                    eCommercePriceChangePO.setOldPrice(MoneyUtils.haoToYuan((BigDecimal)Convert.toBigDecimal((Object)bo.getOldAgreementPrice())));
                    eCommercePriceChangePO.setAveragePrice(agreementPrice);
                    eCommercePriceChangePO.setUpdateTime(new Date());
                    eCommercePriceChangePO.setFrequency(Integer.valueOf(1));
                    eCommercePriceChangePO.setIsDown(uccPricePreventPO.getIsDown());
                    eCommercePriceChangePO.setFloatingRate(uccPricePreventPO.getPercentage());
                    eCommercePriceChangePO.setExtSkuId(bo.getExtSkuId());
                    eCommercePriceChangePOList.add(eCommercePriceChangePO);
                } else {
                    eCommercePriceChangePO = (ECommercePriceChangePO)eCommercePriceChangePOS.get(0);
                    eCommercePriceChangePO.setPrice(agreementPrice);
                    eCommercePriceChangePO.setCurrentPrice(agreementPrice);
                    eCommercePriceChangePO.setOldPrice(MoneyUtils.haoToYuan((BigDecimal)Convert.toBigDecimal((Object)bo.getOldAgreementPrice())));
                    BigDecimal avgprice = eCommercePriceChangePO.getAveragePrice().add(bo.getOrgSalePrice()).divide(new BigDecimal(2));
                    eCommercePriceChangePO.setAveragePrice(avgprice);
                    eCommercePriceChangePO.setUpdateTime(new Date());
                    eCommercePriceChangePO.setFrequency(Integer.valueOf(eCommercePriceChangePO.getFrequency() + 1));
                    eCommercePriceChangePO.setIsDown(uccPricePreventPO.getIsDown());
                    eCommercePriceChangePO.setFloatingRate(uccPricePreventPO.getPercentage());
                    eCommercePriceChangePO.setExtSkuId(bo.getExtSkuId());
                    this.eCommercePriceChangeMapper.modifyECommercePriceChange(eCommercePriceChangePO);
                }
                ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
                BeanUtils.copyProperties((Object)eCommercePriceChangePO, (Object)eCommercePriceChangeLogPO);
                eCommercePriceChangeLogPO.setBatchId(Long.valueOf(this.coefficientSequence.nextId()));
                eCommercePriceChangeLogPO.setId(Long.valueOf(this.coefficientSequence.nextId()));
                eCommercePriceChangeLogPO.setOnShelveTime(bo.getOnShelveTime());
                eCommercePriceChangeLogPOS.add(eCommercePriceChangeLogPO);
            }
            if (!CollectionUtils.isEmpty(commoditys)) {
                BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
                Long[] longs = new Long[commoditys.size()];
                for (int i = 0; i < commoditys.size(); ++i) {
                    longs[i] = (Long)commoditys.get(i);
                }
                batchUpdateCommoStatusForMarketBO.setBusinessId(longs);
                batchUpdateCommoStatusForMarketBO.setReason("\u4ef7\u683c\u9884\u8b66\u8d85\u8fc7\u9608\u503c\uff0c\u5546\u54c1\u81ea\u52a8\u4e0b\u67b6");
                this.batchUpdateCommoStatusForMarket.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.FROZEN_STATUS, SkuStatusEnum.WARN_DOWN_STATUS);
            }
            try {
                if (!CollectionUtils.isEmpty(uccPricePreventPOS)) {
                    for (UccPricePreventPO po : uccPricePreventPOS) {
                        UccPricePreventPO preventPO = new UccPricePreventPO();
                        preventPO.setSkuId(po.getSkuId());
                        po.setPreventLogId(Long.valueOf(this.coefficientSequence.nextId()));
                        List list = this.uccPricePreventMapper.getList(preventPO);
                        if (list.size() != 0) {
                            this.uccPricePreventMapper.updateBy(po, (UccPricePreventPO)list.get(0));
                            continue;
                        }
                        po.setPreventId(Long.valueOf(this.coefficientSequence.nextId()));
                        this.uccPricePreventMapper.insert(po);
                    }
                    String json = JSONObject.toJSONString(uccPricePreventPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                    List logPOS = (List)JSON.parseObject((String)json, List.class);
                    this.uccPricePreventLogMapper.insertBatch(logPOS);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u67b6\u4e0a\u6d6e\u8d85\u8fc7\u9884\u8b66\uff0c\u6dfb\u52a0\u4e0a\u6d6e\u9884\u8b66\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u4e0a\u67b6\u4e0a\u6d6e\u8d85\u8fc7\u9884\u8b66\uff0c\u6dfb\u52a0\u4e0a\u6d6e\u9884\u8b66\u8bb0\u5f55\u5931\u8d25");
            }
            try {
                if (eCommercePriceChangePOList.size() > 0) {
                    this.eCommercePriceChangeMapper.insertPriceChange(eCommercePriceChangePOList);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u5931\u8d25");
            }
            try {
                if (eCommercePriceChangeLogPOS.size() > 0) {
                    this.eCommercePriceChangeLogMapper.insertECommercePriceChangeLogs(eCommercePriceChangeLogPOS);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
            }
        }
        UccExecuteCommdMsgCombRspBO rspBO = new UccExecuteCommdMsgCombRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        listRsp.add(rspBO);
        return listRsp;
    }
}

