/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccSkuPriceChangeHistoryQryAbilityService;
import com.tydic.commodity.estore.ability.bo.UccSkuPriceChangeHistoryQryAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuPriceChangeHistoryQryAbilityRspBO;
import com.tydic.commodity.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuPriceChangeHistoryQryAbilityService"})
public class UccSkuPriceChangeHistoryQryAbilityServiceImpl
implements UccSkuPriceChangeHistoryQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPriceChangeHistoryQryAbilityServiceImpl.class);
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Value(value="${priceChangeHistoryQry.default.day:90}")
    private Long defaultDays;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"getSkuPriceChangeHistoryQry"})
    public UccSkuPriceChangeHistoryQryAbilityRspBO getSkuPriceChangeHistoryQry(@RequestBody UccSkuPriceChangeHistoryQryAbilityReqBO reqBO) {
        this.val(reqBO);
        UccSkuPriceChangeHistoryQryAbilityRspBO rspBO = new UccSkuPriceChangeHistoryQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)eCommercePriceChangeLogPO);
        eCommercePriceChangeLogPO.setUpdateTimeStar(reqBO.getStartTime());
        eCommercePriceChangeLogPO.setUpdateTimeEnd(reqBO.getEndTime());
        ECommercePriceChangeLogPO maxMinPricePo = this.eCommercePriceChangeLogMapper.qryMaxMinPrice(eCommercePriceChangeLogPO);
        if (null != maxMinPricePo) {
            rspBO.setBottomPrice(maxMinPricePo.getBottomPrice());
            rspBO.setMaximumPrice(maxMinPricePo.getMaximumPrice());
        }
        ECommercePriceChangeLogPO currentPricePO = this.eCommercePriceChangeLogMapper.qryCurrentPrice(eCommercePriceChangeLogPO);
        currentPricePO.setAvgPrice(MoneyUtils.haoToYuan((BigDecimal)currentPricePO.getAvgPrice()));
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(reqBO.getSkuId());
        List uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            return rspBO;
        }
        this.calAvgPrice(reqBO, rspBO, currentPricePO, uccSkuPos);
        if (rspBO.getMaximumPrice().compareTo(currentPricePO.getAvgPrice()) < 0) {
            rspBO.setMaximumPrice(currentPricePO.getAvgPrice());
        }
        if (rspBO.getBottomPrice().compareTo(currentPricePO.getAvgPrice()) > 0) {
            rspBO.setBottomPrice(currentPricePO.getAvgPrice());
        }
        return rspBO;
    }

    private void calAvgPrice(UccSkuPriceChangeHistoryQryAbilityReqBO reqBO, UccSkuPriceChangeHistoryQryAbilityRspBO rspBO, ECommercePriceChangeLogPO currentPricePO, List<UccSkuPo> uccSkuPos) {
        LocalDate startDate;
        long days;
        UccSkuPo uccSkuPo = uccSkuPos.get(0);
        Date skuCreateTime = uccSkuPo.getCreateTime();
        LocalDate localDateCreateTime = skuCreateTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate today = LocalDate.now();
        LocalDate previousDate = today.minusDays(this.defaultDays);
        if (previousDate.isAfter(localDateCreateTime)) {
            days = this.defaultDays;
            startDate = previousDate;
        } else {
            days = ChronoUnit.DAYS.between(localDateCreateTime, today);
            startDate = localDateCreateTime;
        }
        ECommercePriceChangeLogPO avgPo = new ECommercePriceChangeLogPO();
        avgPo.setUpdateTimeStar(Date.from(startDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        avgPo.setSkuId(reqBO.getSkuId());
        avgPo.setSupplierShopId(reqBO.getSupplierShopId());
        List eCommercePriceChangeLogList = this.eCommercePriceChangeLogMapper.qryChangePriceByDate(avgPo);
        if (!CollectionUtils.isEmpty((Collection)eCommercePriceChangeLogList)) {
            long startDays = ChronoUnit.DAYS.between(startDate, ((ECommercePriceChangeLogPO)eCommercePriceChangeLogList.get(0)).getUpdateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            log.debug("{}.\u7b2c\u4e00\u6b21\u5929\u6570:{}", (Object)reqBO.getSkuId(), (Object)startDays);
            BigDecimal sum = ((ECommercePriceChangeLogPO)eCommercePriceChangeLogList.get(0)).getOldPrice().multiply(BigDecimal.valueOf(startDays));
            Date endChangeDate = ((ECommercePriceChangeLogPO)eCommercePriceChangeLogList.get(0)).getUpdateTime();
            if (eCommercePriceChangeLogList.size() > 1) {
                for (int i = 1; i < eCommercePriceChangeLogList.size(); ++i) {
                    long dd = ChronoUnit.DAYS.between(((ECommercePriceChangeLogPO)eCommercePriceChangeLogList.get(i - 1)).getUpdateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), ((ECommercePriceChangeLogPO)eCommercePriceChangeLogList.get(i)).getUpdateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                    sum = sum.add(((ECommercePriceChangeLogPO)eCommercePriceChangeLogList.get(i - 1)).getOldPrice().multiply(BigDecimal.valueOf(dd)));
                    log.debug("{}.\u7b2c{}\u6b21\u5929\u6570:{}", new Object[]{reqBO.getSkuId(), i, dd});
                }
                endChangeDate = ((ECommercePriceChangeLogPO)eCommercePriceChangeLogList.get(eCommercePriceChangeLogList.size() - 1)).getUpdateTime();
            }
            long endDays = ChronoUnit.DAYS.between(endChangeDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), today);
            log.debug("{}\u6700\u540e\u4e00\u6b21\u5929\u6570:{}", (Object)reqBO.getSkuId(), (Object)endDays);
            log.debug("{}\u603b\u5929\u6570:{}", (Object)reqBO.getSkuId(), (Object)days);
            if (endDays > 0L) {
                sum = sum.add(currentPricePO.getAvgPrice().multiply(BigDecimal.valueOf(endDays)));
                rspBO.setAvgPrice(sum.divide(BigDecimal.valueOf(days), 2, RoundingMode.HALF_UP));
            } else {
                rspBO.setAvgPrice(currentPricePO.getAvgPrice());
                rspBO.setBottomPrice(currentPricePO.getAvgPrice());
                rspBO.setMaximumPrice(currentPricePO.getAvgPrice());
            }
        } else {
            rspBO.setAvgPrice(currentPricePO.getAvgPrice());
            rspBO.setBottomPrice(currentPricePO.getAvgPrice());
            rspBO.setMaximumPrice(currentPricePO.getAvgPrice());
        }
    }

    private void val(UccSkuPriceChangeHistoryQryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("0001", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSkuId()) {
            throw new BaseBusinessException("0001", "\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierShopId()) {
            throw new BaseBusinessException("0001", "\u94fa\u8d27\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

