/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPriceModifyAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceReqBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceRspBo;
import com.tydic.commodity.dao.UccCommodityTypeAddCoefficientMapper;
import com.tydic.commodity.dao.UccParamsConfigDetailMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.busi.api.UccSkuAddCoefficientModifyBusiService;
import com.tydic.commodity.estore.busi.bo.UccAddCoefficientConfigBo;
import com.tydic.commodity.estore.busi.bo.UccSkuAddCoefficientModifyBusiReqBo;
import com.tydic.commodity.estore.busi.bo.UccSkuAddCoefficientModifyBusiRspBo;
import com.tydic.commodity.po.UccCommodityTypeAddCoefficientPO;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.po.UccSkuPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class UccSkuAddCoefficientModifyBusiServiceImpl
implements UccSkuAddCoefficientModifyBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddCoefficientModifyBusiServiceImpl.class);
    private static final Integer EFFECTIVE_STATE_YES = 1;
    private static final Integer EFFECTIVE_STATE_NO = 0;
    private static final Integer IS_ADD_COEFFICIENT_NO = 0;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuPriceModifyAtomService uccSkuPriceModifyAtomService;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccCommodityTypeAddCoefficientMapper uccCommodityTypeAddCoefficientMapper;
    @Autowired
    private UccParamsConfigDetailMapper uccParamsConfigDetailMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccSkuAddCoefficientModifyBusiRspBo dealCoefficientConfigModify(UccSkuAddCoefficientModifyBusiReqBo reqBo) {
        this.paramVerify(reqBo);
        UccSkuAddCoefficientModifyBusiRspBo rspBo = new UccSkuAddCoefficientModifyBusiRspBo();
        if (reqBo.getOperationType() == 1 || reqBo.getOperationType() == 2) {
            if (reqBo.getEffectiveState() == 1) {
                this.skuCoefficientModify(reqBo.getSkuIds(), reqBo.getOperationType(), EFFECTIVE_STATE_YES);
            }
            if (reqBo.getEffectiveState() == 0) {
                this.skuCoefficientModify(reqBo.getSkuIds(), reqBo.getOperationType(), EFFECTIVE_STATE_NO);
            }
        }
        if (reqBo.getOperationType() == 3) {
            this.skuCoefficientModify(reqBo.getSkuIds(), reqBo.getOperationType(), EFFECTIVE_STATE_NO);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skuCoefficientModify(List<Long> skuIds, Integer operationType, Integer effectiveState) {
        try {
            if (effectiveState.equals(EFFECTIVE_STATE_YES)) {
                List<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOList = this.packagingSkuAddCoefficient(skuIds);
                if (CollectionUtils.isNotEmpty(uccSkuAddCoefficientPOList)) {
                    Map<Long, UccSkuAddCoefficientPO> uccSkuAddCoefficientPOMap = uccSkuAddCoefficientPOList.stream().collect(Collectors.toMap(UccSkuAddCoefficientPO::getSkuId, po -> po, (k1, k2) -> k2));
                    for (Long skuId : skuIds) {
                        UccSkuAddCoefficientPO uccSkuAddCoefficientPO = uccSkuAddCoefficientPOMap.get(skuId);
                        if (!ObjectUtil.isNotEmpty((Object)uccSkuAddCoefficientPO) || !ObjectUtil.isNotEmpty((Object)uccSkuAddCoefficientPO.getAddCoefficient()) || !ObjectUtil.isNotEmpty((Object)uccSkuAddCoefficientPO.getAllowMarketPrice())) continue;
                        UccAddCoefficientConfigBo uccAddCoefficientConfigBo = new UccAddCoefficientConfigBo();
                        uccAddCoefficientConfigBo.setAddCoefficient(uccSkuAddCoefficientPO.getAddCoefficient());
                        uccAddCoefficientConfigBo.setAllowMarketPrice(uccSkuAddCoefficientPO.getAllowMarketPrice());
                        this.skuPriceChangeByCoefficient(uccAddCoefficientConfigBo, CollectionUtil.newArrayList((Object[])new Long[]{skuId}));
                    }
                }
            } else {
                List<UccAddCoefficientConfigBo> uccAddCoefficientConfigBoList = this.getSuperiorAddCoefficient(skuIds);
                log.info("\u5355\u54c1\u52a0\u4ef7\u4fee\u6539\u5904\u7406|\u83b7\u53d6\u4e0a\u7ea7\u52a0\u4ef7\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString(uccAddCoefficientConfigBoList));
                if (uccAddCoefficientConfigBoList.get(0).getAddCoefficientType() == 0 || uccAddCoefficientConfigBoList.get(0).getAddCoefficientType() == 1) {
                    this.skuPriceChangeByCoefficient(uccAddCoefficientConfigBoList.get(0), skuIds);
                }
                if (uccAddCoefficientConfigBoList.get(0).getAddCoefficientType() == 2) {
                    for (UccAddCoefficientConfigBo uccAddCoefficientConfigBo : uccAddCoefficientConfigBoList) {
                        this.skuPriceChangeByCoefficient(uccAddCoefficientConfigBo, uccAddCoefficientConfigBo.getSkuIdList());
                    }
                }
                this.effectiveStateExpInitialize(skuIds, effectiveState);
            }
            this.syncEsSku(skuIds);
        }
        catch (Exception e) {
            log.error("\u5355\u54c1\u52a0\u4ef7\u914d\u7f6e\u4fee\u6539\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            this.updateEffectiveState(skuIds, effectiveState);
        }
    }

    private void effectiveStateExpInitialize(List<Long> skuIds, Integer effectiveState) {
        if (effectiveState.equals(EFFECTIVE_STATE_NO)) {
            this.uccSkuMapper.batchUpdateIsAddCoefficient(IS_ADD_COEFFICIENT_NO, skuIds);
            this.uccSkuAddCoefficientMapper.batchDelete(skuIds);
        }
    }

    private void updateEffectiveState(List<Long> skuIds, Integer effectiveState) {
        UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
        uccSkuAddCoefficientPO.setEffectiveState(effectiveState);
        this.uccSkuAddCoefficientMapper.batchUpdateById(uccSkuAddCoefficientPO, skuIds);
    }

    private void skuPriceChangeByCoefficient(UccAddCoefficientConfigBo uccAddCoefficientConfigBo, List<Long> skuIds) {
        UccSkuPriceModifyAtomServiceReqBo uccSkuPriceModifyAtomServiceReqBo = new UccSkuPriceModifyAtomServiceReqBo();
        uccSkuPriceModifyAtomServiceReqBo.setSkuIds(skuIds);
        uccSkuPriceModifyAtomServiceReqBo.setChangeType(UccConstants.SkuPriceChangeType.COEFFICIENT);
        uccSkuPriceModifyAtomServiceReqBo.setAddCoefficient(uccAddCoefficientConfigBo.getAddCoefficient());
        uccSkuPriceModifyAtomServiceReqBo.setAllowMarketPrice(uccAddCoefficientConfigBo.getAllowMarketPrice());
        UccSkuPriceModifyAtomServiceRspBo uccSkuPriceModifyAtomServiceRspBo = this.uccSkuPriceModifyAtomService.skuPriceChange(uccSkuPriceModifyAtomServiceReqBo);
        if (!"0000".equals(uccSkuPriceModifyAtomServiceRspBo.getRespCode())) {
            throw new BusinessException("8888", uccSkuPriceModifyAtomServiceRspBo.getRespDesc());
        }
    }

    private void syncEsSku(List<Long> skuIds) {
        if (CollectionUtils.isNotEmpty(skuIds)) {
            int INCREMENT;
            int endIndex = INCREMENT = 200;
            if (skuIds.size() > INCREMENT) {
                int times = skuIds.size() % INCREMENT == 0 ? skuIds.size() / INCREMENT : skuIds.size() / INCREMENT + 1;
                int startIndex = 0;
                for (int i = 1; i <= times; ++i) {
                    this.sendSyncEsSkuMq(skuIds.subList(startIndex, i == times ? skuIds.size() : endIndex));
                    startIndex += INCREMENT;
                    endIndex += INCREMENT;
                }
            } else {
                this.sendSyncEsSkuMq(skuIds);
            }
        }
    }

    private void sendSyncEsSkuMq(List<Long> subList) {
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(subList);
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            log.info("\u5355\u54c1\u52a0\u4ef7\u4fee\u6539\u5904\u7406|\u5355\u54c1\u4fe1\u606f\u540c\u6b65|\u6d88\u606f\u53d1\u9001|\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
        }
        catch (Exception e) {
            log.error("\u5355\u54c1\u52a0\u4ef7\u63a8\u9001ES\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private List<UccSkuAddCoefficientPO> packagingSkuAddCoefficient(List<Long> skuIds) {
        ArrayList<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOList = new ArrayList(10);
        if (CollectionUtils.isNotEmpty(skuIds)) {
            uccSkuAddCoefficientPOList = this.uccSkuAddCoefficientMapper.selectBySkuIds(skuIds);
        }
        log.info("\u5355\u54c1\u52a0\u4ef7\u4fee\u6539\u5904\u7406\u670d\u52a1|\u5c01\u88c5\u52a0\u4ef7\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(uccSkuAddCoefficientPOList));
        return uccSkuAddCoefficientPOList;
    }

    private List<UccAddCoefficientConfigBo> getSuperiorAddCoefficient(List<Long> skuIds) {
        ArrayList<UccAddCoefficientConfigBo> uccAddCoefficientConfigBoList = new ArrayList<UccAddCoefficientConfigBo>(10);
        List skuPoList = this.uccSkuMapper.qeryBatchSkus(skuIds);
        List listByCommodityTypeIdAndSupplierId = new ArrayList(10);
        if (CollectionUtils.isNotEmpty((Collection)skuPoList)) {
            List commodityTypeIds = skuPoList.stream().map(UccSkuPo::getCommodityTypeId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());
            List supplierShopIds = skuPoList.stream().map(UccSkuPo::getSupplierShopId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());
            Map<String, List<UccSkuPo>> uccSkuPoGroupingByMap = skuPoList.stream().collect(Collectors.groupingBy(po -> Convert.toStr((Object)po.getSupplierShopId()) + "-" + Convert.toStr((Object)po.getCommodityTypeId())));
            listByCommodityTypeIdAndSupplierId = this.uccCommodityTypeAddCoefficientMapper.getListByCommodityTypeIdAndSupplierId(commodityTypeIds, supplierShopIds);
            if (CollectionUtils.isNotEmpty(listByCommodityTypeIdAndSupplierId)) {
                for (UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO : listByCommodityTypeIdAndSupplierId) {
                    UccAddCoefficientConfigBo uccAddCoefficientConfigBo = new UccAddCoefficientConfigBo();
                    uccAddCoefficientConfigBo.setAddCoefficient(uccCommodityTypeAddCoefficientPO.getAddCoefficient());
                    uccAddCoefficientConfigBo.setAllowMarketPrice(uccCommodityTypeAddCoefficientPO.getAllowMarketPrice());
                    uccAddCoefficientConfigBo.setAddCoefficientType(2);
                    List<UccSkuPo> uccSkuPoList = uccSkuPoGroupingByMap.get(Convert.toStr((Object)uccCommodityTypeAddCoefficientPO.getSupplierId()) + "-" + Convert.toStr((Object)uccCommodityTypeAddCoefficientPO.getCommodityTypeId()));
                    List<Long> skuIdList = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                    uccAddCoefficientConfigBo.setSkuIdList(skuIdList);
                    uccAddCoefficientConfigBoList.add(uccAddCoefficientConfigBo);
                }
            }
        }
        List listByCode = new ArrayList(10);
        if (CollectionUtils.isEmpty(listByCommodityTypeIdAndSupplierId) || CollectionUtils.isEmpty(uccAddCoefficientConfigBoList)) {
            ArrayList<String> codeList = new ArrayList<String>(3);
            codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT");
            codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_ALLOW_MARKET");
            codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_STATE");
            listByCode = this.uccParamsConfigDetailMapper.getListByCode(codeList);
            if (CollectionUtils.isNotEmpty(listByCode)) {
                Map<String, UccParamsConfigDetailPO> paramsConfigDetailMap = listByCode.stream().collect(Collectors.toMap(UccParamsConfigDetailPO::getCode, po -> po, (k1, k2) -> k2));
                UccAddCoefficientConfigBo uccAddCoefficientConfigBo = new UccAddCoefficientConfigBo();
                uccAddCoefficientConfigBo.setAddCoefficient(new BigDecimal(paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT").getRule()));
                uccAddCoefficientConfigBo.setDealStatus(Integer.valueOf(paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_STATE").getRule()));
                uccAddCoefficientConfigBo.setAllowMarketPrice(Integer.valueOf(paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_ALLOW_MARKET").getRule()));
                uccAddCoefficientConfigBo.setAddCoefficientType(1);
                uccAddCoefficientConfigBoList.add(uccAddCoefficientConfigBo);
            }
        }
        if (CollectionUtils.isEmpty(listByCommodityTypeIdAndSupplierId) && CollectionUtils.isEmpty(listByCode) || CollectionUtils.isEmpty(uccAddCoefficientConfigBoList)) {
            UccAddCoefficientConfigBo uccAddCoefficientConfigBo = new UccAddCoefficientConfigBo();
            uccAddCoefficientConfigBo.setAddCoefficient(new BigDecimal("1"));
            uccAddCoefficientConfigBo.setAllowMarketPrice(0);
            uccAddCoefficientConfigBo.setAddCoefficientType(0);
            uccAddCoefficientConfigBoList.add(uccAddCoefficientConfigBo);
        }
        return uccAddCoefficientConfigBoList;
    }

    private void paramVerify(UccSkuAddCoefficientModifyBusiReqBo reqBo) {
        if (ObjectUtils.isEmpty((Object)reqBo)) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getOperationType())) {
            throw new BusinessException("8888", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getEffectiveState())) {
            throw new BusinessException("8888", "\u751f\u6548\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getEffectiveState() != 1 && reqBo.getEffectiveState() != 0) {
            throw new BusinessException("8888", "\u751f\u6548\u72b6\u6001\u503c\u9519\u8bef");
        }
        if (CollectionUtils.isEmpty(reqBo.getSkuIds())) {
            throw new BusinessException("8888", "\u5355\u54c1ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

