/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.comb.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccParamsConfigDetailMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.estore.busi.api.UccAddCoefficientDealBusiService;
import com.tydic.commodity.estore.busi.bo.UccAddCoefficientDealBusiServiceReqBo;
import com.tydic.commodity.estore.comb.api.UccAddCoefficientConfigModifyCombService;
import com.tydic.commodity.estore.comb.bo.UccAddCoefficientConfigModifyCombServiceReqBo;
import com.tydic.commodity.estore.comb.bo.UccAddCoefficientConfigModifyCombServiceRspBo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccSkuPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccAddCoefficientConfigModifyCombServiceImpl
implements UccAddCoefficientConfigModifyCombService {
    private static final Logger log = LoggerFactory.getLogger(UccAddCoefficientConfigModifyCombServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccParamsConfigDetailMapper uccParamsConfigDetailMapper;
    @Autowired
    private UccAddCoefficientDealBusiService uccAddCoefficientDealBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;
    public static final String ESTORE_DEFAULT_COEFFICIENT = "ESTORE_DEFAULT_COEFFICIENT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UccAddCoefficientConfigModifyCombServiceRspBo dealCoefficientConfigModify(UccAddCoefficientConfigModifyCombServiceReqBo reqBo) {
        UccParamsConfigDetailPO uccParamsConfigDetailPO = new UccParamsConfigDetailPO();
        uccParamsConfigDetailPO.setCode(ESTORE_DEFAULT_COEFFICIENT);
        UccParamsConfigDetailPO paramsConfigDetailPO = this.uccParamsConfigDetailMapper.getModelBy(uccParamsConfigDetailPO);
        if (null != paramsConfigDetailPO && !StringUtils.isBlank((CharSequence)paramsConfigDetailPO.getRule()) && Convert.toInt((Object)paramsConfigDetailPO.getRule()) >= 0 && UccConstants.UccAddCoefficientDealState.DEALING.equals(paramsConfigDetailPO.getDealStatus())) {
            try {
                List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.getNoAddCoefficientList();
                if (CollectionUtils.isNotEmpty((Collection)uccEMdmCatalogPOS)) {
                    List commodityTypeIds = this.uccCommodityTypeMapper.qeryTypeIdByCatalogIds(uccEMdmCatalogPOS.stream().map(UccEMdmCatalogPO::getCatalogId).collect(Collectors.toList()));
                    for (Long commodityTypeId : commodityTypeIds) {
                        ArrayList<Long> skuIds = new ArrayList<Long>();
                        this.deal(paramsConfigDetailPO, commodityTypeId, skuIds);
                        this.syncEs(skuIds);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u7535\u5546\u52a0\u4ef7\u914d\u7f6e\u4fee\u6539\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.updateState(uccParamsConfigDetailPO);
            }
        }
        return new UccAddCoefficientConfigModifyCombServiceRspBo();
    }

    private void updateState(UccParamsConfigDetailPO uccParamsConfigDetailPO) {
        UccParamsConfigDetailPO set = new UccParamsConfigDetailPO();
        set.setDealStatus(UccConstants.UccAddCoefficientDealState.DEAL_SUCCESS);
        this.uccParamsConfigDetailMapper.updateBy(set, uccParamsConfigDetailPO);
    }

    private void deal(UccParamsConfigDetailPO paramsConfigDetailPO, Long commodityTypeId, List<Long> skuIdList) {
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setCommodityTypeId(commodityTypeId);
        uccSkuPo.setSkuSource(Integer.valueOf(2));
        Page page = new Page(1, 1000);
        List uccSkuPos = this.uccSkuMapper.getListPage(uccSkuPo, page);
        if (CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
            this.dealAddCoefficient(uccSkuPos, paramsConfigDetailPO, skuIdList);
            if (page.getTotalPages() > 1) {
                for (int i = 2; i <= page.getTotalPages(); ++i) {
                    Page iPage = new Page(i, 1000);
                    List iUccSkuPos = this.uccSkuMapper.getListPage(uccSkuPo, iPage);
                    if (!CollectionUtils.isNotEmpty((Collection)iUccSkuPos)) continue;
                    this.dealAddCoefficient(iUccSkuPos, paramsConfigDetailPO, skuIdList);
                }
            }
        }
    }

    private void dealAddCoefficient(List<UccSkuPo> uccSkuPos, UccParamsConfigDetailPO paramsConfigDetailPO, List<Long> skuIdList) {
        List skuIds = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List skuPriceIds = this.uccSkuPriceMapper.getBySkuIds(skuIds);
        UccAddCoefficientDealBusiServiceReqBo uccAddCoefficientDealBusiServiceReqBo = new UccAddCoefficientDealBusiServiceReqBo();
        uccAddCoefficientDealBusiServiceReqBo.setSkuPriceIds(skuPriceIds);
        uccAddCoefficientDealBusiServiceReqBo.setAddCoefficient(new BigDecimal(paramsConfigDetailPO.getRule()));
        uccAddCoefficientDealBusiServiceReqBo.setAllowMarketPrice(0);
        this.uccAddCoefficientDealBusiService.dealAddCoefficient(uccAddCoefficientDealBusiServiceReqBo);
        skuIdList.addAll(skuIds);
    }

    private void syncEs(List<Long> skuIds) {
        if (CollectionUtils.isNotEmpty(skuIds)) {
            int INCREMENT;
            int endIndex = INCREMENT = 200;
            if (skuIds.size() > INCREMENT) {
                int times = skuIds.size() % INCREMENT == 0 ? skuIds.size() / INCREMENT : skuIds.size() / INCREMENT + 1;
                int startIndex = 0;
                for (int i = 1; i <= times; ++i) {
                    this.sendMq(skuIds.subList(startIndex, i == times ? skuIds.size() : endIndex));
                    startIndex += INCREMENT;
                    endIndex += INCREMENT;
                }
            } else {
                this.sendMq(skuIds);
            }
        }
    }

    private void sendMq(List<Long> subList) {
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(subList);
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_PRICE.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u52a0\u4ef7\u63a8\u9001es\u5f02\u5e38--->", (Throwable)e);
        }
    }
}

