/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccStandardSkuUnBindAbilityService;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuUnBindAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuUnBindAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccStandardSkuUnBindBusiService;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccStandardSkuUnBindAbilityService"})
public class UccStandardSkuUnBindAbilityServiceImpl
implements UccStandardSkuUnBindAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardSkuUnBindAbilityServiceImpl.class);
    @Autowired
    private UccStandardSkuUnBindBusiService uccStandardSkuUnBindBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"dealStandardSkuUnBind"})
    public UccStandardSkuUnBindAbilityRspBO dealStandardSkuUnBind(@RequestBody UccStandardSkuUnBindAbilityReqBO reqBO) {
        Map<Long, List<UccSkuPo>> shopIdUccSkuMap;
        UccStandardSkuUnBindAbilityRspBO rspBO = new UccStandardSkuUnBindAbilityRspBO();
        List skuIds = reqBO.getSkuIds();
        if (CollectionUtil.isEmpty((Collection)skuIds)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("sku\u5217\u8868\u4e3a\u7a7a!");
            return rspBO;
        }
        Integer unBindMaterial = reqBO.getUnBindMaterial();
        if (ObjectUtil.isNull((Object)unBindMaterial)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u7269\u6599\u89e3\u7ed1\u4e3a\u7a7a!");
            return rspBO;
        }
        List uccSkuPoList = this.uccSkuMapper.qeryBatchSkus(skuIds);
        UccStandardSkuUnBindAbilityRspBO unBindReuslt = this.uccStandardSkuUnBindBusiService.dealStandardSkuUnBind(reqBO, uccSkuPoList, shopIdUccSkuMap = uccSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId)));
        if (!"0000".equals(unBindReuslt.getRespCode())) {
            BeanUtil.copyProperties((Object)unBindReuslt, (Object)rspBO);
            return rspBO;
        }
        shopIdUccSkuMap.forEach((k, v) -> {
            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(v.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
            syncSceneCommodityToEsReqBO.setSupplierId(k);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

