/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.enums;

import org.springframework.util.StringUtils;

public enum SupplierFactoryEnum {
    JD("jd", "jdFactoryImpl"),
    SUNING("suning", "suningFactoryImpl"),
    TIANMAO("tianmao", "tianmaoFactoryImpl"),
    OTHER("other", "otherCommonFactoryImpl");

    private String supplierCode;
    private String factoryBeanName;

    private SupplierFactoryEnum(String supplierCode, String factoryBeanName) {
        this.supplierCode = supplierCode;
        this.factoryBeanName = factoryBeanName;
    }

    public String getSupplierCode() {
        return this.supplierCode;
    }

    public String getFactoryBeanName() {
        return this.factoryBeanName;
    }

    public static SupplierFactoryEnum getFactoryBeanName(String supplierCode) {
        if (!StringUtils.hasText((String)supplierCode)) {
            return null;
        }
        for (SupplierFactoryEnum anEnum : SupplierFactoryEnum.values()) {
            if (!anEnum.getSupplierCode().equals(supplierCode)) continue;
            return anEnum;
        }
        return null;
    }
}

