/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.commodity.ability.api.CnncMallSearchShlfCommodityService;
import com.tydic.commodity.bo.ability.CnncMallEsCommodityBo;
import com.tydic.commodity.bo.ability.CnncMallSearchShlfCommodityReqBo;
import com.tydic.commodity.bo.ability.CnncMallSearchShlfCommodityRspBo;
import com.tydic.commodity.bo.ability.CnncSearchShlfCommodityBo;
import com.tydic.commodity.constant.UccMallCommodityClassEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.search.config.MallElasticsearchUtil;
import com.tydic.commodity.search.config.MallEsConfig;
import com.tydic.commodity.util.DateUtils;
import com.tydic.commodity.util.MoneyUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CnncMallSearchShlfCommodityServiceImpl
implements CnncMallSearchShlfCommodityService {
    private static final Logger log = LoggerFactory.getLogger(CnncMallSearchShlfCommodityServiceImpl.class);
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;

    public CnncMallSearchShlfCommodityRspBo getShlfCommodityList(CnncMallSearchShlfCommodityReqBo reqBo) {
        CnncMallSearchShlfCommodityRspBo rspBo = new CnncMallSearchShlfCommodityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBo);
        String queryString = this.excuteEsSql(reqBo, extBoolQueryBuilder);
        String endPoint = "/" + this.mallEsConfig.getIndexName() + "/" + this.mallEsConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            rspBo = this.dealSearchData(result, reqBo);
            return rspBo;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return rspBo;
        }
    }

    private BoolQueryBuilder buildEsSql(CnncMallSearchShlfCommodityReqBo reqBo) {
        Long timeEnd;
        Long timeBegin;
        RangeQueryBuilder qb;
        WildcardQueryBuilder queryBuilder1;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (int)1));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sourceAssort", (Collection)Lists.newArrayList((Object[])new Integer[]{UccMallCommodityClassEnum.POVERTY_GOODS.getKey(), UccMallCommodityClassEnum.SHELF_RUN_GOODS.getKey(), UccMallCommodityClassEnum.OTHER_GOODS.getKey()})));
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommodityIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", (Collection)reqBo.getCommodityIds()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            queryBuilder1 = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)queryBuilder1);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            queryBuilder1 = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)queryBuilder1);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (Collection)reqBo.getSkuIds()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            queryBuilder1 = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)queryBuilder1);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            queryBuilder1 = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)queryBuilder1);
        }
        if (reqBo.getCommodityTypeId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (reqBo.getCommodityClass() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_class", (Object)reqBo.getCommodityClass()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", (Collection)reqBo.getCommodityStatus()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", (Collection)reqBo.getSkuStatus()));
        }
        if (reqBo.getShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getShopId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getShopName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"shop_name", (String)reqBo.getShopName()));
        }
        if (reqBo.getSupplierOrgId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplierOrgId", (Object)reqBo.getSupplierOrgId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplierOrgName", (String)reqBo.getSupplierOrgName()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_name", (String)reqBo.getBrandName()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_name", (String)reqBo.getCreateName()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_name", (String)reqBo.getVendorName()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", (Collection)reqBo.getOperIds()));
        }
        try {
            qb = null;
            if (!StringUtils.isEmpty((Object)reqBo.getAuditTimeBegin())) {
                Long auditTimeBegin = DateUtils.strToDate((String)reqBo.getAuditTimeBegin()).getTime();
                qb = QueryBuilders.rangeQuery((String)"audit_time").gte((Object)auditTimeBegin);
            }
            if (!StringUtils.isEmpty((Object)reqBo.getAuditTimeEnd())) {
                Long auditTimeEnd = DateUtils.strToDate((String)reqBo.getAuditTimeEnd()).getTime();
                qb = QueryBuilders.rangeQuery((String)"audit_time").gte((Object)auditTimeEnd);
            }
            if (qb != null) {
                boolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5ba1\u6279\u65f6\u95f4\u8303\u56f4\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        try {
            qb = null;
            if (!StringUtils.isEmpty((Object)reqBo.getPushTimeBegin())) {
                timeBegin = DateUtils.strToDate((String)reqBo.getPushTimeBegin()).getTime();
                qb = QueryBuilders.rangeQuery((String)"push_time").gte((Object)timeBegin);
            }
            if (!StringUtils.isEmpty((Object)reqBo.getPushTimeEnd())) {
                timeEnd = DateUtils.strToDate((String)reqBo.getPushTimeEnd()).getTime();
                qb = QueryBuilders.rangeQuery((String)"push_time").gte((Object)timeEnd);
            }
            if (qb != null) {
                boolQueryBuilder.must((QueryBuilder)qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u53d1\u5e03\u65f6\u95f4\u8303\u56f4\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        try {
            qb = null;
            if (!StringUtils.isEmpty((Object)reqBo.getUpTimeBegin())) {
                timeBegin = DateUtils.strToDate((String)reqBo.getUpTimeBegin()).getTime();
                qb = QueryBuilders.rangeQuery((String)"up_time").gte((Object)timeBegin);
            }
            if (!StringUtils.isEmpty((Object)reqBo.getUpTimeEnd())) {
                timeEnd = DateUtils.strToDate((String)reqBo.getUpTimeEnd()).getTime();
                qb = QueryBuilders.rangeQuery((String)"up_time").gte((Object)timeEnd);
            }
            if (qb != null) {
                boolQueryBuilder.must((QueryBuilder)qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e0a\u67b6\u65f6\u95f4\u8303\u56f4\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        try {
            qb = null;
            if (!StringUtils.isEmpty((Object)reqBo.getDownTimeBegin())) {
                timeBegin = DateUtils.strToDate((String)reqBo.getDownTimeBegin()).getTime();
                qb = QueryBuilders.rangeQuery((String)"down_time").gte((Object)timeBegin);
            }
            if (!StringUtils.isEmpty((Object)reqBo.getDownTimeEnd())) {
                timeEnd = DateUtils.strToDate((String)reqBo.getDownTimeEnd()).getTime();
                qb = QueryBuilders.rangeQuery((String)"down_time").gte((Object)timeEnd);
            }
            if (qb != null) {
                boolQueryBuilder.must((QueryBuilder)qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e0b\u67b6\u65f6\u95f4\u8303\u56f4\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(CnncMallSearchShlfCommodityReqBo reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "create_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sku_id";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            }
        } else {
            sortField = "create_time";
        }
        if (!sortField.isEmpty()) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            fieldSortBuilders.add(sortQuery);
        }
        queryJson.put("sort", (Object)JSONObject.parseArray((String)((Object)fieldSortBuilders).toString()));
        if (reqBo.isCollapse()) {
            JSONObject collapse = new JSONObject();
            collapse.put("field", (Object)"commodity_id");
            queryJson.put("collapse", (Object)collapse);
        }
        JSONObject aggs = new JSONObject();
        if (reqBo.isCollapse()) {
            JSONObject total = new JSONObject();
            JSONObject cardinality = new JSONObject();
            total.put("field", (Object)"commodity_id");
            total.put("precision_threshold", (Object)40000);
            cardinality.put("cardinality", (Object)total);
            aggs.put("books_count", (Object)cardinality);
        }
        queryJson.put("aggs", (Object)aggs);
        return queryJson.toString();
    }

    private CnncMallSearchShlfCommodityRspBo dealSearchData(String result, CnncMallSearchShlfCommodityReqBo reqBo) {
        CnncMallSearchShlfCommodityRspBo rspBo = new CnncMallSearchShlfCommodityRspBo();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<CnncMallEsCommodityBo> commodityModels = new ArrayList<CnncMallEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                CnncMallEsCommodityBo commodity = new CnncMallEsCommodityBo();
                try {
                    commodity = (CnncMallEsCommodityBo)JSON.toJavaObject((JSON)data, CnncMallEsCommodityBo.class);
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                }
                if (!skuIdSet.contains(commodity.getSku_id())) {
                    commodityModels.add(commodity);
                }
                skuIdSet.add(commodity.getSku_id());
            }
        }
        if (reqBo.isCollapse()) {
            String agss = JSONObject.parseObject((String)result).get((Object)"aggregations").toString();
            total = Integer.valueOf(JSONObject.parseObject((String)JSONObject.parseObject((String)agss).get((Object)"books_count").toString()).get((Object)"value").toString());
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private CnncMallSearchShlfCommodityRspBo copyData(List<CnncMallEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        CnncMallSearchShlfCommodityRspBo rspBo = new CnncMallSearchShlfCommodityRspBo();
        ArrayList<CnncSearchShlfCommodityBo> cnncSearchShlfCommodityBos = new ArrayList<CnncSearchShlfCommodityBo>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (CnncMallEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    CnncSearchShlfCommodityBo cnncSearchShlfCommodityBo = new CnncSearchShlfCommodityBo();
                    cnncSearchShlfCommodityBo.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
                    cnncSearchShlfCommodityBo.setCommodityId(Long.valueOf(cnncEsCommodityBo.getCommodity_id()));
                    cnncSearchShlfCommodityBo.setCommodityName(cnncEsCommodityBo.getCommodity_name());
                    cnncSearchShlfCommodityBo.setSkuId(Long.valueOf(cnncEsCommodityBo.getSku_id()));
                    cnncSearchShlfCommodityBo.setSkuCode(cnncEsCommodityBo.getSku_code());
                    cnncSearchShlfCommodityBo.setSkuName(cnncEsCommodityBo.getSku_name());
                    cnncSearchShlfCommodityBo.setCommodityTypeId(cnncEsCommodityBo.getType_id());
                    cnncSearchShlfCommodityBo.setCommodityTypeName(cnncEsCommodityBo.getType_name());
                    cnncSearchShlfCommodityBo.setCommodityClass(cnncEsCommodityBo.getSourceAssort());
                    cnncSearchShlfCommodityBo.setShopId(cnncEsCommodityBo.getSupplier_shop_id());
                    cnncSearchShlfCommodityBo.setShopName(cnncEsCommodityBo.getShop_name());
                    cnncSearchShlfCommodityBo.setSupplierOrgId(cnncEsCommodityBo.getSupplierOrgId());
                    cnncSearchShlfCommodityBo.setSupplierOrgName(cnncEsCommodityBo.getSupplierOrgName());
                    cnncSearchShlfCommodityBo.setBrandId(Long.valueOf(cnncEsCommodityBo.getBrand_id()));
                    cnncSearchShlfCommodityBo.setBrandName(cnncEsCommodityBo.getBrand_name());
                    cnncSearchShlfCommodityBo.setCreateName(cnncEsCommodityBo.getCreate_name());
                    cnncSearchShlfCommodityBo.setVendorId(cnncEsCommodityBo.getVendor_id());
                    cnncSearchShlfCommodityBo.setSupplierId(cnncEsCommodityBo.getSupplier_id());
                    cnncSearchShlfCommodityBo.setSupplierName(cnncEsCommodityBo.getSupplier_name());
                    cnncSearchShlfCommodityBo.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
                    cnncSearchShlfCommodityBo.setMaterialName(cnncEsCommodityBo.getMaterial_name());
                    cnncSearchShlfCommodityBo.setMaterialCatalogId(cnncEsCommodityBo.getL4mg_category_id());
                    cnncSearchShlfCommodityBo.setCommodityStatus(cnncEsCommodityBo.getCommodity_status());
                    cnncSearchShlfCommodityBo.setSkuStatus(Integer.valueOf(cnncEsCommodityBo.getSku_status()));
                    cnncSearchShlfCommodityBo.setMeasureName(cnncEsCommodityBo.getMeasure_name());
                    if (cnncEsCommodityBo.getUp_time() != null) {
                        cnncSearchShlfCommodityBo.setUpTime(DateUtils.dateToStr((Date)new Date(cnncEsCommodityBo.getUp_time())));
                    }
                    if (cnncEsCommodityBo.getDown_time() != null) {
                        cnncSearchShlfCommodityBo.setDownTime(DateUtils.dateToStr((Date)new Date(cnncEsCommodityBo.getDown_time())));
                    }
                    if (cnncEsCommodityBo.getPush_time() != null) {
                        log.info(new Date(cnncEsCommodityBo.getPush_time()).toString());
                        cnncSearchShlfCommodityBo.setPushTime(DateUtils.dateToStr((Date)new Date(cnncEsCommodityBo.getPush_time())));
                    }
                    if (cnncEsCommodityBo.getAudit_time() != null) {
                        cnncSearchShlfCommodityBo.setAuditTime(DateUtils.dateToStr((Date)new Date(cnncEsCommodityBo.getAudit_time())));
                    }
                    cnncSearchShlfCommodityBo.setSalePrice(MoneyUtils.haoToYuan((Long)cnncEsCommodityBo.getSale_price()));
                    cnncSearchShlfCommodityBo.setAgreementPrice(MoneyUtils.haoToYuan((Long)cnncEsCommodityBo.getAgreement_price()));
                    cnncSearchShlfCommodityBo.setMarketPrice(MoneyUtils.haoToYuan((Long)cnncEsCommodityBo.getMarket_price()));
                    cnncSearchShlfCommodityBo.setCreateName(cnncEsCommodityBo.getCreate_name());
                    if (cnncEsCommodityBo.getCreate_time() != null) {
                        cnncSearchShlfCommodityBo.setCreateTime(DateUtils.dateToStr((Date)new Date(cnncEsCommodityBo.getCreate_time())));
                    }
                    cnncSearchShlfCommodityBo.setVendorName(cnncEsCommodityBo.getVendor_name());
                    cnncSearchShlfCommodityBo.setTaxCode(cnncEsCommodityBo.getTaxCode());
                    cnncSearchShlfCommodityBo.setTaxRate(cnncEsCommodityBo.getTaxRate());
                    cnncSearchShlfCommodityBo.setSevenFree(cnncEsCommodityBo.getSeven_free());
                    cnncSearchShlfCommodityBos.add(cnncSearchShlfCommodityBo);
                }
            }
            rspBo.setRows(cnncSearchShlfCommodityBos);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

