/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.ability.api.UccMallAgrGoodListQueryAbilityService;
import com.tydic.commodity.bo.UmcStationWebBO;
import com.tydic.commodity.bo.ability.UccMallAgrGoodListQueryAbilityReqBO;
import com.tydic.commodity.bo.ability.UccMallAgrGoodListQueryAbilityRspBO;
import com.tydic.commodity.bo.ability.UccMallCommodityPackBO;
import com.tydic.commodity.bo.ability.UccMallCommodityRecordBO;
import com.tydic.commodity.bo.ability.UccMallLadderPriceBo;
import com.tydic.commodity.bo.busi.UccMallCommodityPicBo;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccMallCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccMallCatalogDealMapper;
import com.tydic.commodity.dao.UccMallCommodityMeasureMapper;
import com.tydic.commodity.dao.UccMallCommodityPicMapper;
import com.tydic.commodity.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.dao.UccMallExamineEditInfoMapper;
import com.tydic.commodity.dao.UccMallLadderPriceMapper;
import com.tydic.commodity.dao.UccMallSkuMapper;
import com.tydic.commodity.dao.po.CommodityRecordPO;
import com.tydic.commodity.dao.po.CommodityRecordVO;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.dao.po.UccCommodityMeasurePo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.dao.po.UccMallBrandRelPO;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.enumType.YesNoEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallAgrGoodListQueryAbilityService.class)
public class UccMallAgrGoodListQueryAbilityServiceImpl
implements UccMallAgrGoodListQueryAbilityService {
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallCatalogDealMapper uccMallCatalogDealMapper;
    @Autowired
    private UccMallCatRCommdTypeMapper uccMallCatRCommdTypeMapper;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private UccMallExamineEditInfoMapper uccMallExamineEditInfoMapper;
    @Autowired
    private UccMallLadderPriceMapper uccMallLadderPriceMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    @Autowired
    private UccMallCommodityPicMapper uccMallCommodityPicMapper;
    @Autowired
    private UccMallCommodityMeasureMapper uccMallCommodityMeasureMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    private static final String DateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallAgrGoodListQueryAbilityServiceImpl.class);

    public UccMallAgrGoodListQueryAbilityRspBO getUccAgrGoodListQuery(UccMallAgrGoodListQueryAbilityReqBO reqBO) {
        List<Object> commodityRecordPOS;
        Page page;
        UccMallAgrGoodListQueryAbilityRspBO rspBO;
        block53: {
            CommodityRecordVO commodityRecordVO;
            rspBO = new UccMallAgrGoodListQueryAbilityRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            if (!StringUtils.isEmpty((Object)reqBO.getSkuCode())) {
                reqBO.setSkuId(Long.valueOf(Long.parseLong(reqBO.getSkuCode())));
            }
            page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            if (reqBO.getSkuId() != null && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                if (!reqBO.getSkuIds().contains(reqBO.getSkuId())) {
                    return rspBO;
                }
                reqBO.setSkuId(null);
            }
            if (null == (commodityRecordVO = this.dealReq(reqBO))) {
                rspBO.setRows(new ArrayList());
                rspBO.setPageNo(reqBO.getPageNo());
                rspBO.setTotal(0);
                rspBO.setRecordsTotal(0);
                return rspBO;
            }
            commodityRecordPOS = new ArrayList();
            if (!StringUtils.isEmpty((Object)reqBO.getUccOperCode())) {
                if ("uadCode".equals(reqBO.getUccOperCode())) {
                    commodityRecordVO.setExtField1(Lists.newArrayList((Object[])new String[]{"upCode", "downCode"}));
                } else {
                    commodityRecordVO.setExtField1(Lists.newArrayList((Object[])new String[]{reqBO.getUccOperCode()}));
                }
            }
            try {
                if (reqBO.getType() == 0) {
                    commodityRecordPOS = this.uccMallSkuMapper.qryBaseCommdList(page, commodityRecordVO);
                    break block53;
                }
                if (reqBO.getType() == 1) {
                    commodityRecordVO.setUpDownType(reqBO.getUpDownType());
                    if (reqBO.getUpDownType() != null && reqBO.getUpDownType() == 1) {
                        commodityRecordVO.setPutCirRemark("\u6062\u590d\u4e0a\u67b6");
                    }
                    commodityRecordPOS = this.uccMallSkuMapper.qryCommdUpDownRecordList(page, commodityRecordVO);
                    break block53;
                }
                if (reqBO.getType() == 2) {
                    commodityRecordPOS = this.uccMallExamineEditInfoMapper.selectRecordPO(page, commodityRecordVO);
                    break block53;
                }
                if (reqBO.getType() == 3) {
                    Collection umcStationWebBOS = null;
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
                        try {
                            umcStationWebBOS = JSONObject.parseArray((String)JSON.toJSONString((Object)reqBO.getUmcStationsListWebExt()), UmcStationWebBO.class);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(umcStationWebBOS)) {
                        List<Long> stationIds = umcStationWebBOS.stream().map(UmcStationWebBO::getStationId).collect(Collectors.toList());
                        commodityRecordVO.setOperIds(stationIds);
                    }
                    commodityRecordVO.setAuditType(reqBO.getAuditType());
                    if (ApprovalTypeEnum.APPROVAL_EDIT.getStep().equals(reqBO.getAuditType().toString())) {
                        commodityRecordPOS = this.uccMallExamineEditInfoMapper.qryEditAuditCommdList(page, commodityRecordVO);
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commodityRecordPOS)) {
                            for (Object commodityRecordPO : commodityRecordPOS) {
                                List commodityPicBos;
                                String string = ((CommodityRecordPO)commodityRecordPO).getSkuPicUrl();
                                if (StringUtils.isEmpty((Object)string) || !org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(commodityPicBos = JSONObject.parseArray((String)string, UccMallCommodityPicBo.class)))) continue;
                                for (UccMallCommodityPicBo uccMallCommodityPicBo : commodityPicBos) {
                                    if (uccMallCommodityPicBo.getCommodityPicType() != 1) continue;
                                    ((CommodityRecordPO)commodityRecordPO).setSkuPicUrl(uccMallCommodityPicBo.getCommodityPicUrl());
                                }
                            }
                        }
                    } else {
                        commodityRecordPOS = this.uccMallSkuMapper.qryAuditList(page, commodityRecordVO);
                    }
                    break block53;
                }
                if (reqBO.getType() == 4) {
                    if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                        commodityRecordPOS = this.uccMallSkuMapper.qryOtherCommdList(page, commodityRecordVO);
                    } else {
                        UccSkuPo skuPo = new UccSkuPo();
                        skuPo.setSkuId(reqBO.getSkuId());
                        List<UccSkuPo> mallsku = this.uccMallSkuMapper.qerySku(skuPo);
                        if (!org.apache.commons.collections.CollectionUtils.isEmpty(mallsku)) {
                            commodityRecordVO.setIgrAgreementSkuId(mallsku.get(0).getAgreementDetailsId());
                            commodityRecordPOS = this.uccMallSkuMapper.qryOtherCommdList(page, commodityRecordVO);
                        }
                    }
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(commodityRecordPOS)) {
                        List<UccCommodityMeasurePo> measurePoList = this.uccMallCommodityMeasureMapper.queryAll();
                        Map<Long, UccCommodityMeasurePo> measureMap = null;
                        if (!org.apache.commons.collections.CollectionUtils.isEmpty(measurePoList)) {
                            measureMap = measurePoList.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureId, UccCommodityMeasurePo2 -> UccCommodityMeasurePo2));
                        }
                        for (CommodityRecordPO commodityRecordPO : commodityRecordPOS) {
                            if (commodityRecordPO.getMeasure() == null || measureMap.isEmpty()) continue;
                            if (measureMap.containsKey(commodityRecordPO.getMeasureId())) {
                                commodityRecordPO.setMeasureType(measureMap.get(commodityRecordPO.getMeasureId()).getMeasureType());
                                continue;
                            }
                            LOGGER.error("\u8ba1\u91cf\u5355\u4f4d\u67e5\u8be2\u5f02\u5e38->{}" + commodityRecordPO.getMeasureId());
                        }
                    }
                    this.getBrandInfo(commodityRecordPOS);
                    break block53;
                }
                if (reqBO.getType() == 5) {
                    commodityRecordPOS = this.uccMallSkuMapper.qryNoPicCommdList(page, commodityRecordVO);
                    break block53;
                }
                throw new BusinessException("8888", "\u6ca1\u6709\u8be5\u67e5\u8be2\u7c7b\u578b");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(commodityRecordPOS)) {
            return rspBO;
        }
        ArrayList<UccMallCommodityRecordBO> commodityRecordBOS = new ArrayList<UccMallCommodityRecordBO>();
        List<Long> skuIds = commodityRecordPOS.stream().map(CommodityRecordPO::getSkuId).collect(Collectors.toList());
        List<UccLadderPricePO> uccLadderPricePOList = this.uccMallLadderPriceMapper.selectBySkuIds(skuIds, null);
        List<Long> list = commodityRecordPOS.stream().map(CommodityRecordPO::getCommodityTypeId).collect(Collectors.toList());
        List<UccCommodityTypePo> uccCommodityTypePos = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeIds(list);
        for (CommodityRecordPO commodityRecordPO : commodityRecordPOS) {
            UccMallCommodityRecordBO commodityRecordBO = new UccMallCommodityRecordBO();
            commodityRecordBOS.add(commodityRecordBO);
            commodityRecordBO.setCommodityId(commodityRecordPO.getCommodityId());
            commodityRecordBO.setSalesUnitName(commodityRecordPO.getSalesUnitName());
            commodityRecordBO.setSalesUnitRate(commodityRecordPO.getSalesUnitRate());
            commodityRecordBO.setPackageSpec(commodityRecordPO.getPackageSpec());
            commodityRecordBO.setSettlementUnit(commodityRecordPO.getSettlementUnit());
            commodityRecordBO.setUpdateTime(commodityRecordPO.getUpdateTime());
            commodityRecordBO.setSkuId(commodityRecordPO.getSkuId());
            commodityRecordBO.setSkuCode(commodityRecordPO.getSkuCode());
            commodityRecordBO.setSkuStatus(commodityRecordPO.getSkuStatus());
            if (commodityRecordPO.getSkuStatus() != null) {
                commodityRecordBO.setSkuStatusDesc(SkuStatusEnum.getStatusDesc((Integer)commodityRecordPO.getSkuStatus()).getStatusDesc());
            }
            commodityRecordBO.setCatalogName(commodityRecordPO.getCatalogName());
            commodityRecordBO.setSkuPicUrl(commodityRecordPO.getSkuPicUrl());
            commodityRecordBO.setSkuName(commodityRecordPO.getSkuName());
            commodityRecordBO.setBrandName(commodityRecordPO.getBrandName());
            commodityRecordBO.setSupplierName(commodityRecordPO.getSupplierName());
            commodityRecordBO.setSupplierId(commodityRecordPO.getSupplierId());
            commodityRecordBO.setMiniOrderNum(commodityRecordPO.getMiniOrderNum());
            commodityRecordBO.setReleaseTime(commodityRecordPO.getCreateTime());
            commodityRecordBO.setSkuDesc(commodityRecordPO.getSkuDesc());
            commodityRecordBO.setSupplierShopName(commodityRecordPO.getShopName());
            commodityRecordBO.setDownReason(commodityRecordPO.getDownReason());
            commodityRecordBO.setDownTime(commodityRecordPO.getDownTime());
            commodityRecordBO.setRestoreUpTime(commodityRecordPO.getRestoreUpTime());
            commodityRecordBO.setMeasure(commodityRecordPO.getMeasure());
            commodityRecordBO.setOrgName(commodityRecordPO.getOrgName());
            commodityRecordBO.setDeliveryCycle(commodityRecordPO.getDeliveryCycle());
            commodityRecordBO.setGuaranteePeriod(commodityRecordPO.getGuaranteePeriod());
            commodityRecordBO.setAuditType(commodityRecordPO.getAuditType());
            commodityRecordBO.setMaterialCode(commodityRecordPO.getMaterialCode());
            if (commodityRecordPO.getAuditType() != null) {
                commodityRecordBO.setAuditTypeDesc(ApprovalTypeEnum.findByStep((String)commodityRecordPO.getAuditType().toString()).getMessage());
            }
            commodityRecordBO.setDealResult(commodityRecordPO.getDealResult());
            if (commodityRecordPO.getDealResult() != null) {
                commodityRecordBO.setDealResultDesc(AuditResultStatusEnum.getByStatus((Integer)commodityRecordPO.getDealResult()).getMessage());
            }
            commodityRecordBO.setDealName(commodityRecordPO.getDealName());
            commodityRecordBO.setAuditTime(commodityRecordPO.getAuditTime());
            commodityRecordBO.setSpec(commodityRecordPO.getSpec());
            commodityRecordBO.setModel(commodityRecordPO.getModel());
            commodityRecordBO.setFigure(commodityRecordPO.getFigure());
            commodityRecordBO.setTexture(commodityRecordPO.getTexture());
            commodityRecordBO.setSupplierShopId(commodityRecordPO.getSupplierShopId());
            commodityRecordBO.setShowPack(commodityRecordPO.getShowPack());
            commodityRecordBO.setMaterialName(commodityRecordPO.getMeterialName());
            if (commodityRecordPO.getShowPack() != null) {
                commodityRecordBO.setShowPackDesc(YesNoEnum.getTypeDesc((Integer)commodityRecordPO.getShowPack()));
            }
            commodityRecordBO.setCreateTime(commodityRecordPO.getCreateTime());
            if (commodityRecordPO.getSalePrice() != null) {
                commodityRecordBO.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)commodityRecordPO.getSalePrice()));
            }
            if (commodityRecordPO.getMarketPrice() != null) {
                commodityRecordBO.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)commodityRecordPO.getMarketPrice()));
            }
            commodityRecordBO.setTaxCategoryCode(commodityRecordPO.getTaxCategoryCode());
            commodityRecordBO.setBelongCategory(commodityRecordPO.getBelongCategory());
            commodityRecordBO.setAgreementDetailsId(commodityRecordPO.getAgreementDetailsId());
            commodityRecordBO.setVendorName(commodityRecordPO.getVendorName());
            commodityRecordBO.setVendorId(commodityRecordPO.getVendorId());
            commodityRecordBO.setManufacturer(commodityRecordPO.getManufacturer());
            UccMallCommodityPackBO commodityPackBO = new UccMallCommodityPackBO();
            ArrayList<UccMallCommodityPackBO> commodityPackBOS = new ArrayList<UccMallCommodityPackBO>();
            commodityPackBOS.add(commodityPackBO);
            commodityPackBO.setCommodityId(commodityRecordPO.getCommodityId());
            commodityPackBO.setWeight(commodityRecordPO.getWeight());
            commodityPackBO.setHeight(commodityRecordPO.getHeight());
            commodityPackBO.setLength(commodityRecordPO.getLength());
            commodityPackBO.setWidth(commodityRecordPO.getWidth());
            commodityPackBO.setList(commodityRecordPO.getList());
            commodityRecordBO.setCommodityPackInfo(commodityPackBOS);
            List<UccMallLadderPriceBo> ladderPriceBOS = new ArrayList();
            if (reqBO.getAuditType() != null && ApprovalTypeEnum.APPROVAL_EDIT.getStep().equals(reqBO.getAuditType().toString())) {
                String ladderPrice = commodityRecordPO.getLadderPrice();
                if (!StringUtils.isEmpty((Object)ladderPrice)) {
                    ladderPriceBOS = JSONObject.parseArray((String)ladderPrice, UccMallLadderPriceBo.class);
                }
            } else {
                try {
                    List uccLadderPricePOS;
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccLadderPricePOList) && org.apache.commons.collections.CollectionUtils.isNotEmpty(uccLadderPricePOS = uccLadderPricePOList.stream().filter(s -> s.getSkuId().equals(commodityRecordBO.getSkuId())).collect(Collectors.toList()))) {
                        for (UccLadderPricePO uccLadderPricePO : uccLadderPricePOS) {
                            UccMallLadderPriceBo ladderPriceBO = new UccMallLadderPriceBo();
                            if (uccLadderPricePO.getStart() != null) {
                                ladderPriceBO.setStartPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getStart()));
                            }
                            if (uccLadderPricePO.getStop() != null) {
                                ladderPriceBO.setStopPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getStop()));
                            }
                            if (uccLadderPricePO.getPrice() != null) {
                                ladderPriceBO.setPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getPrice()));
                            }
                            ladderPriceBOS.add(ladderPriceBO);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new BusinessException("8888", "\u67e5\u8be2\u9636\u68af\u4ef7\u683c\u5931\u8d25");
                }
            }
            if (reqBO.getExportType() != null && reqBO.getExportType() != 1 && reqBO.getType() == 0) {
                List approvalObjInfoMQBO;
                UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
                uacQryAuditLogReqBO.setObjId(commodityRecordPO.getCommodityId().toString());
                uacQryAuditLogReqBO.setObjType(Integer.valueOf(Integer.parseInt(ApprovalTypeEnum.APPROVAL_UP_SHELF.getStep())));
                UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
                if ("0000".equals(uacQryAuditLogRspBO.getRespCode()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(approvalObjInfoMQBO = uacQryAuditLogRspBO.getRows()))) {
                    commodityRecordBO.setAuditMsg(((ApprovalLogBO)approvalObjInfoMQBO.get(0)).getAuditAdvice());
                }
            }
            commodityRecordBO.setLadderPrice(ladderPriceBOS);
            Long catalogId = null;
            if (org.apache.commons.collections.CollectionUtils.isEmpty(uccCommodityTypePos)) continue;
            List catalogIds = uccCommodityTypePos.stream().filter(s -> s.getCommodityTypeId().equals(commodityRecordPO.getCommodityTypeId())).collect(Collectors.toList());
            if (catalogIds != null && catalogIds.size() > 0) {
                UccCommodityTypePo uccCommodityTypePo = (UccCommodityTypePo)catalogIds.get(0);
                catalogId = uccCommodityTypePo.getCatalogId();
            }
            commodityRecordBO.setCatalogId(catalogId);
        }
        this.getComPic(commodityRecordBOS);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(commodityRecordBOS);
        return rspBO;
    }

    private List<Long> getCommodityTypeIds(Long catalogId) {
        List<UccCatalogDealPO> uccCatalogDealPOS;
        if (catalogId == null) {
            return null;
        }
        List<Long> catalogIds = new ArrayList<Long>();
        catalogIds.add(catalogId);
        while (!org.apache.commons.collections.CollectionUtils.isEmpty(uccCatalogDealPOS = this.uccMallCatalogDealMapper.selectByUpperCatIds(catalogIds))) {
            catalogIds = uccCatalogDealPOS.stream().map(UccCatalogDealPO::getGuideCatalogId).collect(Collectors.toList());
            if (uccCatalogDealPOS.get(0).getCatalogLevel() != 3) continue;
            break;
        }
        List<Long> commodityTypeIds = this.uccMallCatRCommdTypeMapper.queryTypeByGuideCatalogIds(catalogIds);
        return commodityTypeIds;
    }

    private Long getCatalogId(Long commodityTypeId) {
        UccCommodityTypePo uccCommodityTypePo;
        Long catalogId = null;
        if (commodityTypeId != null && (uccCommodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(commodityTypeId)) != null) {
            catalogId = uccCommodityTypePo.getCatalogId();
        }
        return catalogId;
    }

    private CommodityRecordVO dealReq(UccMallAgrGoodListQueryAbilityReqBO reqBO) {
        List<Long> commodityTypeIds = this.getCommodityTypeIds(reqBO.getCatalogId());
        if (reqBO.getCatalogId() != null && org.apache.commons.collections.CollectionUtils.isEmpty(commodityTypeIds)) {
            return null;
        }
        CommodityRecordVO commodityRecordVO = new CommodityRecordVO();
        if (reqBO.getAgreementId() != null) {
            commodityRecordVO.setAgreementId(String.valueOf(reqBO.getAgreementId()));
        }
        commodityRecordVO.setSkuName(reqBO.getSkuName());
        commodityRecordVO.setSkuCode(reqBO.getSkuCode());
        commodityRecordVO.setBrandName(reqBO.getBrandName());
        commodityRecordVO.setSkuStatus(reqBO.getSkuStatus());
        commodityRecordVO.setSkuId(reqBO.getSkuId());
        commodityRecordVO.setSkuIds(reqBO.getSkuIds());
        commodityRecordVO.setShowPack(reqBO.getShowPack());
        commodityRecordVO.setModel(reqBO.getModel());
        commodityRecordVO.setSpec(reqBO.getSpec());
        commodityRecordVO.setFigure(reqBO.getFigure());
        commodityRecordVO.setManufacturer(reqBO.getManufacturer());
        commodityRecordVO.setMaterialCode(reqBO.getMaterialCode());
        commodityRecordVO.setCommodityTypeIds(commodityTypeIds);
        if (reqBO.getBeginIssueTime() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getBeginIssueTime(), (String)DateFormat));
            } else {
                commodityRecordVO.setBeginIssueTime(DateUtils.strToDateAsFormat((String)reqBO.getBeginIssueTime(), (String)DateFormat));
            }
        }
        if (reqBO.getEndIssueTime() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getEndIssueTime(), (String)DateFormat));
            } else {
                commodityRecordVO.setEndIssueTime(DateUtils.strToDateAsFormat((String)reqBO.getEndIssueTime(), (String)DateFormat));
            }
        }
        if (reqBO.getUpdateTimeBegin() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getUpdateTimeBegin(), (String)DateFormat));
            } else {
                commodityRecordVO.setUpdateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getUpdateTimeBegin(), (String)DateFormat));
            }
        }
        if (reqBO.getUpdateTimeEnd() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getUpdateTimeEnd(), (String)DateFormat));
            } else {
                commodityRecordVO.setUpdateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getUpdateTimeEnd(), (String)DateFormat));
            }
        }
        if (reqBO.getDownTimeBegin() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getDownTimeBegin(), (String)DateFormat));
            } else {
                commodityRecordVO.setDownTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getDownTimeBegin(), (String)DateFormat));
            }
        }
        if (reqBO.getDownTimeEnd() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getDownTimeEnd(), (String)DateFormat));
            } else {
                commodityRecordVO.setDownTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getDownTimeEnd(), (String)DateFormat));
            }
        }
        if (reqBO.getRestoreUpTimeBegin() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getRestoreUpTimeBegin(), (String)DateFormat));
            } else {
                commodityRecordVO.setRestoreUpTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getRestoreUpTimeBegin(), (String)DateFormat));
            }
        }
        if (reqBO.getRestoreUpTimeEnd() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getRestoreUpTimeEnd(), (String)DateFormat));
            } else {
                commodityRecordVO.setRestoreUpTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getRestoreUpTimeEnd(), (String)DateFormat));
            }
        }
        if (reqBO.getCreateTimeBegin() != null) {
            commodityRecordVO.setCreateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getCreateTimeBegin(), (String)DateFormat));
        }
        if (reqBO.getCreateTimeEnd() != null) {
            commodityRecordVO.setCreateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getCreateTimeEnd(), (String)DateFormat));
        }
        return commodityRecordVO;
    }

    private void getComPic(List<UccMallCommodityRecordBO> bos) {
        List<Long> commodityIds;
        List<UccCommodityPicPo> uccCommodityPicPos;
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(bos) && !org.apache.commons.collections.CollectionUtils.isEmpty(uccCommodityPicPos = this.uccMallCommodityPicMapper.queryBatchByCommdId(commodityIds = bos.stream().map(UccMallCommodityRecordBO::getCommodityId).collect(Collectors.toList()), null))) {
            for (UccMallCommodityRecordBO bo : bos) {
                for (UccCommodityPicPo uccCommodityPicPo : uccCommodityPicPos) {
                    if (!bo.getCommodityId().equals(uccCommodityPicPo.getCommodityId()) || uccCommodityPicPo.getCommodityPicType() != 1) continue;
                    bo.setSkuPicUrl(uccCommodityPicPo.getCommodityPicUrl());
                }
            }
        }
    }

    private void getBrandInfo(List<CommodityRecordPO> pos) {
        List<Long> brandIds;
        List<UccMallBrandRelPO> uccMallBrandRelPOS;
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(pos) && !org.apache.commons.collections.CollectionUtils.isEmpty(uccMallBrandRelPOS = this.uccMallBrandRelMapper.getRelByBrandList(brandIds = pos.stream().filter(a -> a.getBrandId() != null).map(CommodityRecordPO::getBrandId).collect(Collectors.toList())))) {
            Map<Long, UccMallBrandRelPO> map = uccMallBrandRelPOS.stream().filter(a -> a.getBrandId() != null).collect(Collectors.toMap(a -> a.getBrandId(), b -> b, (oldKey, newKey) -> newKey));
            for (CommodityRecordPO commodityRecordPO : pos) {
                if (commodityRecordPO.getBrandId() == null || map.get(commodityRecordPO.getBrandId()) == null) continue;
                commodityRecordPO.setBrandId(map.get(commodityRecordPO.getBrandId()).getMallBrandId());
                commodityRecordPO.setBrandName(map.get(commodityRecordPO.getBrandId()).getMallBrandName());
            }
        }
    }
}

