/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.ability.api.UccMallAreaAvailableQryAbilityService;
import com.tydic.commodity.bo.ability.UccMallAreaAvailableQryAbilityReqBO;
import com.tydic.commodity.bo.ability.UccMallAreaAvailableQryAbilityRspBO;
import com.tydic.commodity.bo.busi.UccMallAreaAvailableQryBo;
import com.tydic.commodity.bo.busi.UccMallAreaAvailableQryBusiReqBO;
import com.tydic.commodity.bo.busi.UccMallAreaAvailableQryBusiRspBO;
import com.tydic.commodity.busi.api.UccMallAreaAvailableQryBusiService;
import com.tydic.commodity.constant.RspConstantEnums;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallAreaAvailableQryAbilityService.class)
public class UccMallAreaAvailableQryAbilityServiceImpl
implements UccMallAreaAvailableQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallAreaAvailableQryAbilityServiceImpl.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV")
    private UccMallAreaAvailableQryBusiService uccMallAreaAvailableQryBusiService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallAreaAvailableQryAbilityServiceImpl.class);

    public UccMallAreaAvailableQryAbilityRspBO qryAreaAvailable(UccMallAreaAvailableQryAbilityReqBO reqBO) {
        UccMallAreaAvailableQryAbilityRspBO rspBO = new UccMallAreaAvailableQryAbilityRspBO();
        Map<Long, UccMallAreaAvailableQryBusiReqBO> skuInfo = this.groupByShopid(reqBO);
        if (skuInfo == null || skuInfo.isEmpty()) {
            rspBO.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccMallAreaAvailableQryBusiRspBO uccMallAreaAvailableQryBusiRspBO = null;
        try {
            ArrayList bo_busis = new ArrayList();
            for (Map.Entry<Long, UccMallAreaAvailableQryBusiReqBO> entry : skuInfo.entrySet()) {
                uccMallAreaAvailableQryBusiRspBO = this.uccMallAreaAvailableQryBusiService.qryUccAreaAvailable(entry.getValue());
                if ("0000".equals(uccMallAreaAvailableQryBusiRspBO.getRespCode())) {
                    bo_busis.addAll(uccMallAreaAvailableQryBusiRspBO.getAreaAvailableCommdInfos());
                    continue;
                }
                BeanUtils.copyProperties((Object)uccMallAreaAvailableQryBusiRspBO, (Object)rspBO);
                return rspBO;
            }
            rspBO.setAreaAvailableCommdInfos(bo_busis);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u67e5\u8be2\u53ef\u552e\u4fe1\u606f\u9519\u8bef\uff1a {}->" + e.getMessage());
            rspBO.setRespCode(RspConstantEnums.EXTERNAL_AVAILABLE_COMMODITY_FAIL.code());
            rspBO.setRespDesc("\u6279\u91cf\u67e5\u8be2\u53ef\u552e\u4fe1\u606f\u9519\u8bef");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<Long, UccMallAreaAvailableQryBusiReqBO> groupByShopid(UccMallAreaAvailableQryAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAreaAvailableSkuInfo())) {
            return null;
        }
        HashedMap result = new HashedMap();
        for (UccMallAreaAvailableQryBo each : reqBO.getAreaAvailableSkuInfo()) {
            if (result.containsKey(each.getSupplierShopId())) {
                ((UccMallAreaAvailableQryBusiReqBO)result.get(each.getSupplierShopId())).getSkuIds().add(each.getSkuId());
                continue;
            }
            UccMallAreaAvailableQryBusiReqBO bo = new UccMallAreaAvailableQryBusiReqBO();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            bo.setSkuIds(new ArrayList<Long>(Arrays.asList(each.getSkuId())));
            result.put(each.getSupplierShopId(), bo);
        }
        return result;
    }
}

