/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.ability.api.UccMallComdWithChannelAbilityService;
import com.tydic.commodity.bo.ability.UccMallComdWithChannelAbilityBo;
import com.tydic.commodity.bo.ability.UccMallComdWithChannelAbilityReqBo;
import com.tydic.commodity.bo.ability.UccMallComdWithChannelAbilityRspBo;
import com.tydic.commodity.bo.ability.UccMallComdWithChannelRequstBo;
import com.tydic.commodity.dao.UccMallBrandExtMapper;
import com.tydic.commodity.dao.po.CnncQrySkuChannelForMroPo;
import com.tydic.commodity.util.ListUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallComdWithChannelAbilityService.class)
public class UccMallComdWithChannelAbilityServiceImpl
implements UccMallComdWithChannelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallComdWithChannelAbilityServiceImpl.class);
    private static final String channel_code = "MRO_CHANNEL";
    private static final Long channel_Id_first = 1001L;
    @Autowired
    private UccMallBrandExtMapper uccMallBrandExtMapper;

    public UccMallComdWithChannelAbilityRspBo qryChannel(UccMallComdWithChannelAbilityReqBo reqBo) {
        UccMallComdWithChannelAbilityRspBo rspBo = new UccMallComdWithChannelAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getQryInfo())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u8f93\u5165\u5fc5\u8981\u53c2\u6570");
            return rspBo;
        }
        ArrayList<UccMallComdWithChannelAbilityBo> uccMallComdWithChannelAbilityBos = new ArrayList<UccMallComdWithChannelAbilityBo>();
        Map<Long, List<UccMallComdWithChannelRequstBo>> map = reqBo.getQryInfo().stream().collect(Collectors.groupingBy(UccMallComdWithChannelRequstBo::getSupplierShopId));
        for (Map.Entry<Long, List<UccMallComdWithChannelRequstBo>> each : map.entrySet()) {
            Long supplierShopId = each.getKey();
            List<Long> skuIds = each.getValue().stream().map(UccMallComdWithChannelRequstBo::getSkuId).collect(Collectors.toList());
            List<CnncQrySkuChannelForMroPo> cnncQrySkuChannelForMroPos = this.uccMallBrandExtMapper.qrySkuChannelForMro(skuIds, supplierShopId, null);
            if (CollectionUtils.isEmpty(cnncQrySkuChannelForMroPos)) continue;
            Map<Long, List<CnncQrySkuChannelForMroPo>> skuMap = cnncQrySkuChannelForMroPos.stream().collect(Collectors.groupingBy(CnncQrySkuChannelForMroPo::getSkuId));
            for (Map.Entry<Long, List<CnncQrySkuChannelForMroPo>> skuEach : skuMap.entrySet()) {
                Long skuId = skuEach.getKey();
                UccMallComdWithChannelAbilityBo uccMallComdWithChannelAbilityBo = new UccMallComdWithChannelAbilityBo();
                uccMallComdWithChannelAbilityBo.setSkuId(skuId);
                uccMallComdWithChannelAbilityBo.setSupplierShopId(supplierShopId);
                List channelIds = skuEach.getValue().stream().map(CnncQrySkuChannelForMroPo::getChannelId).collect(Collectors.toList());
                List newList = ListUtils.removeReapet(channelIds);
                ArrayList<Long> canList = new ArrayList<Long>();
                for (Long channelId : newList) {
                    if (channel_Id_first.equals(channelId)) continue;
                    canList.add(channelId);
                }
                uccMallComdWithChannelAbilityBo.setChannels(canList);
                List shopCatalogTypes = skuEach.getValue().stream().map(CnncQrySkuChannelForMroPo::getShopCatalogType).collect(Collectors.toList());
                if (shopCatalogTypes.contains(1)) {
                    uccMallComdWithChannelAbilityBo.setMro(true);
                } else {
                    uccMallComdWithChannelAbilityBo.setMro(false);
                }
                uccMallComdWithChannelAbilityBos.add(uccMallComdWithChannelAbilityBo);
            }
        }
        rspBo.setRows(uccMallComdWithChannelAbilityBos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

