/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.google.common.collect.Lists;
import com.tydic.commodity.ability.api.UccMallCommdDetailQryAbilityService;
import com.tydic.commodity.bo.ability.UccMallCommdDetailQryAbilityReqBO;
import com.tydic.commodity.bo.ability.UccMallCommdDetailQryAbilityRspBO;
import com.tydic.commodity.bo.ability.UccMallCommdDetailsQryAbilityReqBo;
import com.tydic.commodity.bo.ability.UccMallCommdDetailsQryAbilityRspBo;
import com.tydic.commodity.bo.ability.UccMallSkuInfoSaleNumBo;
import com.tydic.commodity.bo.busi.UccMallAreaAvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.UccMallAvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.UccMallCommdDetailsBO_busi;
import com.tydic.commodity.bo.busi.UccMallCommdDetailsQryReqBO;
import com.tydic.commodity.bo.busi.UccMallCommdDetailsQryRspBo;
import com.tydic.commodity.bo.busi.UccMallCommdPriceBO_busi;
import com.tydic.commodity.bo.busi.UccMallCommdShufflingPicBO_busi;
import com.tydic.commodity.bo.busi.UccMallCommdStockBO_busi;
import com.tydic.commodity.bo.busi.UccMallESupermarketCommdBO;
import com.tydic.commodity.bo.busi.UccMallNotJdCommdDetailsBO_busi;
import com.tydic.commodity.bo.busi.UccMallNotJdCommdPicBO_busi;
import com.tydic.commodity.bo.busi.UccMallNotJdPriceBO_busi;
import com.tydic.commodity.bo.busi.UccMallSkuBo;
import com.tydic.commodity.bo.busi.UccMallSupplierShopBO;
import com.tydic.commodity.busi.api.UccMallAgreementProduceCommdQryBusiService;
import com.tydic.commodity.busi.api.UccMallCommdDetailsQryBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallChannelPutMapper;
import com.tydic.commodity.dao.UccMallCommodityMapper;
import com.tydic.commodity.dao.UccMallSaleNumMapper;
import com.tydic.commodity.dao.UccMallSkuMapper;
import com.tydic.commodity.dao.UccMallSupplierMapper;
import com.tydic.commodity.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.dao.UccMallVendorMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccChannelPutPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccVendorPo;
import com.tydic.commodity.enumType.SkuSourceEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.external.bo.UccTmCommdQryReqBO;
import com.tydic.commodity.external.bo.UccTmCommdQryRspBO;
import com.tydic.commodity.external.service.UccTmCommdQryService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallCommdDetailQryAbilityService.class)
public class UccMallCommdDetailQryAbilityServiceImpl
implements UccMallCommdDetailQryAbilityService {
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV")
    private UccMallCommdDetailsQryBusiService uccMallCommdDetailsQryBusiService;
    @Autowired
    private UccTmCommdQryService uccTmCommdQryService;
    @Autowired
    private UccMallAgreementProduceCommdQryBusiService uccMallAgreementProduceCommdQryBusiService;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallVendorMapper uccMallVendorMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    @Autowired
    private UccMallChannelPutMapper uccMallChannelPutMapper;
    @Autowired
    private UccMallSaleNumMapper uccMallSaleNumMapper;

    public UccMallCommdDetailQryAbilityRspBO qryCommdDetail(UccMallCommdDetailQryAbilityReqBO reqBo) {
        UccMallCommdDetailQryAbilityRspBO rspBo = new UccMallCommdDetailQryAbilityRspBO();
        if (null == reqBo || null == reqBo.getSkuId() || null == reqBo.getSupplierShopId()) {
            rspBo.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5355\u54c1ID\u3001\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        UccMallCommdDetailsBO_busi commdDetailsBOBusi = new UccMallCommdDetailsBO_busi();
        UccCommodityPo uccCommodityPo = this.judgeSource(reqBo);
        if (uccCommodityPo != null && uccCommodityPo.getCommodityId() != null) {
            rspBo = this.getImCommdInfo(uccCommodityPo, reqBo);
            return rspBo;
        }
        UccSkuPo uccSkuPo1 = new UccSkuPo();
        uccSkuPo1.setSkuId(reqBo.getSkuId());
        uccSkuPo1.setSupplierShopId(reqBo.getSupplierShopId());
        List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo1);
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            rspBo.setRespCode(RspConstantEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBo.setRespDesc("sku_id =" + reqBo.getSkuId() + "\u5355\u54c1\u4e0d\u5b58\u5728");
            return rspBo;
        }
        if (uccSkuPos.get(0).getSkuSource().equals(SkuSourceEnum.AGREEMENT_SOURCE.getSource())) {
            UccMallCommdDetailsQryAbilityReqBo detailsQryReqBo = new UccMallCommdDetailsQryAbilityReqBo();
            detailsQryReqBo.setSkuId(reqBo.getSkuId());
            detailsQryReqBo.setSupplierShopId(reqBo.getSupplierShopId());
            UccMallCommdDetailsQryAbilityRspBo uccMallCommdDetailsQryAbilityRspBo = this.uccMallAgreementProduceCommdQryBusiService.getAgreementProduceCommd(detailsQryReqBo);
            rspBo.setRespCode(uccMallCommdDetailsQryAbilityRspBo.getRespCode());
            rspBo.setRespDesc(uccMallCommdDetailsQryAbilityRspBo.getRespDesc());
            rspBo.setCommdDetailsInfo(uccMallCommdDetailsQryAbilityRspBo.getCommdDetailsInfo());
            return rspBo;
        }
        SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId());
        if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
            rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(RspConstantEnums.STORE_QUERY_FAILED.code());
            return rspBo;
        }
        Long supplierId = supplierShopPo.getSupplierId();
        UccMallSupplierShopBO uccMallSupplierShopBO = new UccMallSupplierShopBO();
        BeanUtils.copyProperties((Object)supplierShopPo, (Object)uccMallSupplierShopBO);
        commdDetailsBOBusi.setSupplierShopInfo(uccMallSupplierShopBO);
        SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId);
        if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
            rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(RspConstantEnums.SUPPLIER_CODE_QUERY_FAIL.code());
            return rspBo;
        }
        String supplierCode = supplierBusiPo.getSupplierCode();
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
        uccSkuPo.setSkuId(reqBo.getSkuId());
        List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
        if (uccSkuPoList == null) {
            commdDetailsBOBusi.setStatus("3");
            rspBo.setCommdDetailsInfo(commdDetailsBOBusi);
            rspBo.setRespCode(RspConstantEnums.SKU_INVALID.code());
            rspBo.setRespDesc("\u5355\u54c1\u5931\u6548");
            return rspBo;
        }
        if (uccSkuPoList.size() != 1) {
            rspBo.setRespDesc("\u5355\u54c1\u4e0d\u552f\u4e00");
            rspBo.setRespCode(RspConstantEnums.SKU_NOT_UNIQUE.code());
            return rspBo;
        }
        String extSkuId = uccSkuPoList.get(0).getExtSkuId();
        if (StringUtils.isEmpty((CharSequence)extSkuId)) {
            rspBo.setRespDesc("\u5916\u90e8\u5355\u54c1ID\u4e3a\u7a7a");
            rspBo.setRespCode(RspConstantEnums.EXTERNAL_SKU_ID_ISNULL.code());
            return rspBo;
        }
        if (!uccSkuPoList.get(0).getSkuStatus().equals(ModelRuleConstant.SKU_STATUS_ON_SHELF)) {
            commdDetailsBOBusi.setStatus("2");
        } else {
            commdDetailsBOBusi.setStatus("1");
        }
        UccMallSkuBo uccMallSkuBo = new UccMallSkuBo();
        BeanUtils.copyProperties((Object)uccSkuPoList.get(0), (Object)uccMallSkuBo);
        if (uccMallSkuBo.getSkuStatus().equals(SkuStatusEnum.ON_SHELVES_STATUS.getStatus())) {
            uccMallSkuBo.setSkuStatus(Integer.valueOf(1));
        } else {
            uccMallSkuBo.setSkuStatus(Integer.valueOf(2));
        }
        if (uccMallSkuBo.getSkuSource() != null) {
            uccMallSkuBo.setSkuSourceDesc(SkuSourceEnum.getSourceDesc((Integer)uccMallSkuBo.getSkuSource()).getSourceDesc());
        }
        commdDetailsBOBusi.setSkuInfo(uccMallSkuBo);
        commdDetailsBOBusi.setSupplierId(supplierId);
        commdDetailsBOBusi.setSupplierCode(supplierCode);
        UccMallCommdDetailsQryReqBO uccMallCommdDetailsQryReqBO = new UccMallCommdDetailsQryReqBO();
        uccMallCommdDetailsQryReqBO.setSkuId(reqBo.getSkuId());
        uccMallCommdDetailsQryReqBO.setSupplierShopId(reqBo.getSupplierShopId());
        UccMallCommdDetailsQryRspBo uccMallCommdDetailsQryRspBO = this.uccMallCommdDetailsQryBusiService.qryCommdDetails(uccMallCommdDetailsQryReqBO);
        if (!"0000".equals(uccMallCommdDetailsQryRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)uccMallCommdDetailsQryRspBO, (Object)rspBo);
            return rspBo;
        }
        if (uccMallCommdDetailsQryRspBO.getCommdInfo() != null) {
            commdDetailsBOBusi.setCommdInfo(uccMallCommdDetailsQryRspBO.getCommdInfo());
        }
        String catalogCode = this.uccMallSkuMapper.qryMdmCodeBySkuId(reqBo.getSkuId());
        commdDetailsBOBusi.setCatalogCode(catalogCode);
        UccChannelPutPo uccChannelPutPo = new UccChannelPutPo();
        uccChannelPutPo.setPutObjId(reqBo.getSkuId());
        uccChannelPutPo.setSupplierShopId(reqBo.getSupplierShopId());
        List<UccChannelPutPo> channelPutPos = this.uccMallChannelPutMapper.qryChannels(uccChannelPutPo);
        if (channelPutPos != null && channelPutPos.size() > 0) {
            ArrayList<Long> chanelIds = new ArrayList<Long>();
            for (UccChannelPutPo each : channelPutPos) {
                chanelIds.add(each.getChannelId());
            }
            commdDetailsBOBusi.setChannelIds(chanelIds);
        }
        List<UccSaleNumPo> uccSaleNumPos = this.uccMallSaleNumMapper.qryBySkuIds(Lists.newArrayList((Object[])new Long[]{reqBo.getSkuId()}));
        UccMallSkuInfoSaleNumBo uccMallSkuInfoSaleNumBo = new UccMallSkuInfoSaleNumBo();
        if (CollectionUtils.isNotEmpty(uccSaleNumPos)) {
            if (uccSaleNumPos.get(0).getSoldNumber() == null) {
                uccMallSkuInfoSaleNumBo.setSoldNumber(new BigDecimal(0));
            } else {
                uccMallSkuInfoSaleNumBo.setSoldNumber(uccSaleNumPos.get(0).getSoldNumber());
            }
            if (uccSaleNumPos.get(0).getEcommerceSale() == null) {
                uccMallSkuInfoSaleNumBo.setEcommerceSale(new BigDecimal(0));
            } else {
                uccMallSkuInfoSaleNumBo.setEcommerceSale(uccSaleNumPos.get(0).getEcommerceSale());
            }
        } else {
            uccMallSkuInfoSaleNumBo.setEcommerceSale(new BigDecimal(0));
            uccMallSkuInfoSaleNumBo.setSoldNumber(new BigDecimal(0));
        }
        rspBo.setSkuInfoSaleNumBO(uccMallSkuInfoSaleNumBo);
        rspBo.setCommdDetailsInfo(commdDetailsBOBusi);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccCommodityPo judgeSource(UccMallCommdDetailQryAbilityReqBO reqBO) {
        UccSkuPo skuInfo;
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuPo.setSkuId(reqBO.getSkuId());
        List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isNotEmpty(uccSkuPoList) && (skuInfo = uccSkuPoList.get(0)).getSkuSource().equals(SkuSourceEnum.PROPRIETARY_SKU_SOURCE.getSource()) && (uccCommodityPo = this.uccMallCommodityMapper.qryCommdByCommdId(skuInfo.getCommodityId(), reqBO.getSupplierShopId())) != null && uccCommodityPo.getVendorId() != null) {
            UccVendorPo uccVendorPo = new UccVendorPo();
            uccVendorPo.setVendorId(uccCommodityPo.getVendorId());
            List<UccVendorPo> uccVendorPos = this.uccMallVendorMapper.queryVerdor(uccVendorPo);
            if (CollectionUtils.isNotEmpty(uccVendorPos) && !"tianmao".equals(uccVendorPos.get(0).getVendorCode())) {
                uccCommodityPo = new UccCommodityPo();
            }
        }
        return uccCommodityPo;
    }

    private UccMallCommdDetailQryAbilityRspBO getImCommdInfo(UccCommodityPo uccCommodityPo, UccMallCommdDetailQryAbilityReqBO reqBO) {
        UccMallCommdDetailQryAbilityRspBO rspBo = new UccMallCommdDetailQryAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        UccTmCommdQryReqBO uccTmCommdQryReqBO = new UccTmCommdQryReqBO();
        uccTmCommdQryReqBO.setItemId(Long.valueOf(Long.parseLong(uccCommodityPo.getExtSpuId())));
        UccTmCommdQryRspBO uccTmCommdQryRspBO = null;
        uccTmCommdQryRspBO = this.uccTmCommdQryService.qryTmCommd(uccTmCommdQryReqBO);
        if (!"0000".equals(uccTmCommdQryRspBO.getRespCode())) {
            rspBo.setRespCode(uccTmCommdQryRspBO.getRespCode());
            rspBo.setRespDesc(uccTmCommdQryRspBO.getRespDesc());
            return rspBo;
        }
        UccMallCommdDetailsBO_busi uccMallCommdDetailsBO_busi = new UccMallCommdDetailsBO_busi();
        ArrayList<UccMallAvailableCommdBO_busi> availableCommdInfos = new ArrayList<UccMallAvailableCommdBO_busi>();
        UccMallAvailableCommdBO_busi uccMallAvailableCommdBO_busi = new UccMallAvailableCommdBO_busi();
        uccMallAvailableCommdBO_busi.setSkuId(reqBO.getSkuId().toString());
        uccMallAvailableCommdBO_busi.setName(uccCommodityPo.getCommodityName());
        uccMallAvailableCommdBO_busi.setIs7ToReturn(Integer.valueOf(1));
        uccMallAvailableCommdBO_busi.setIsCanVAT(Integer.valueOf(1));
        if (uccTmCommdQryRspBO.getCanSell() == 1) {
            uccMallAvailableCommdBO_busi.setSaleState(Integer.valueOf(1));
        } else {
            uccMallAvailableCommdBO_busi.setSaleState(Integer.valueOf(0));
        }
        availableCommdInfos.add(uccMallAvailableCommdBO_busi);
        uccMallCommdDetailsBO_busi.setAvailableCommdInfos(availableCommdInfos);
        ArrayList<UccMallAreaAvailableCommdBO_busi> areaAvailableCommdInfos = new ArrayList<UccMallAreaAvailableCommdBO_busi>();
        UccMallAreaAvailableCommdBO_busi uccMallAreaAvailableCommdBO_busi = new UccMallAreaAvailableCommdBO_busi();
        uccMallAreaAvailableCommdBO_busi.setSkuId(reqBO.getSkuId().toString());
        uccMallAreaAvailableCommdBO_busi.setAreaRestrict(false);
        areaAvailableCommdInfos.add(uccMallAreaAvailableCommdBO_busi);
        uccMallCommdDetailsBO_busi.setAreaAvailableCommdInfos(areaAvailableCommdInfos);
        ArrayList commdStockInfo = new ArrayList();
        UccMallCommdStockBO_busi uccMallCommdStockBO_busi = new UccMallCommdStockBO_busi();
        uccMallCommdStockBO_busi.setSkuId(reqBO.getSkuId().toString());
        uccMallCommdStockBO_busi.setRemainNum(Integer.valueOf(uccTmCommdQryRspBO.getStock().intValue()));
        uccMallCommdDetailsBO_busi.setCommdStockInfo(commdStockInfo);
        UccMallESupermarketCommdBO commdInfo = new UccMallESupermarketCommdBO();
        UccMallNotJdCommdDetailsBO_busi uccMallNotJdCommdDetailsBO_busi = new UccMallNotJdCommdDetailsBO_busi();
        uccMallNotJdCommdDetailsBO_busi.setImagePath(uccTmCommdQryRspBO.getMainPicUrl());
        uccMallNotJdCommdDetailsBO_busi.setName(uccTmCommdQryRspBO.getItemTitle());
        uccMallNotJdCommdDetailsBO_busi.setIntroduction(uccTmCommdQryRspBO.getDescPath());
        if (uccTmCommdQryRspBO.getIsPost() == 1) {
            uccCommodityPo.setFreeFhipping(1);
        } else {
            uccCommodityPo.setFreeFhipping(0);
        }
        uccCommodityPo.setPostFee(uccTmCommdQryRspBO.getPostFee());
        commdInfo.setNotJdCommdDetails(uccMallNotJdCommdDetailsBO_busi);
        uccMallCommdDetailsBO_busi.setCommdInfo(commdInfo);
        UccMallCommdPriceBO_busi commdPriceInfo = new UccMallCommdPriceBO_busi();
        ArrayList<UccMallNotJdPriceBO_busi> uccMallNotJdPriceBO_busis = new ArrayList<UccMallNotJdPriceBO_busi>();
        UccMallNotJdPriceBO_busi uccMallNotJdPriceBO_busi = new UccMallNotJdPriceBO_busi();
        uccMallNotJdPriceBO_busi.setEcPrice(uccTmCommdQryRspBO.getOriginalPrice());
        uccMallNotJdPriceBO_busi.setPrice(uccTmCommdQryRspBO.getCurrentPrice());
        uccMallNotJdPriceBO_busi.setSkuId(reqBO.getSkuId().toString());
        uccMallNotJdPriceBO_busis.add(uccMallNotJdPriceBO_busi);
        commdPriceInfo.setNotJdPriceInfo(uccMallNotJdPriceBO_busis);
        uccMallCommdDetailsBO_busi.setCommdPriceInfo(commdPriceInfo);
        ArrayList<UccMallCommdShufflingPicBO_busi> commdShufflingPicInfos = new ArrayList<UccMallCommdShufflingPicBO_busi>();
        UccMallCommdShufflingPicBO_busi uccMallCommdShufflingPicBO_busi = new UccMallCommdShufflingPicBO_busi();
        ArrayList<UccMallNotJdCommdPicBO_busi> uccMallNotJdCommdPicBO_busis = new ArrayList<UccMallNotJdCommdPicBO_busi>();
        if (StringUtils.isNotEmpty((CharSequence)uccTmCommdQryRspBO.getItemImages())) {
            String[] imgs;
            for (String img : imgs = uccTmCommdQryRspBO.getItemImages().split(",")) {
                UccMallNotJdCommdPicBO_busi uccMallNotJdCommdPicBO_busi = new UccMallNotJdCommdPicBO_busi();
                uccMallNotJdCommdPicBO_busi.setPath(img);
                uccMallNotJdCommdPicBO_busis.add(uccMallNotJdCommdPicBO_busi);
            }
        }
        uccMallCommdShufflingPicBO_busi.setNotJdCommdPicInfo(uccMallNotJdCommdPicBO_busis);
        commdShufflingPicInfos.add(uccMallCommdShufflingPicBO_busi);
        uccMallCommdDetailsBO_busi.setCommdShufflingPicInfos(commdShufflingPicInfos);
        rspBo.setCommdDetailsInfo(uccMallCommdDetailsBO_busi);
        return rspBo;
    }
}

