/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.ability.api.UccMallComparePriceAbilityService;
import com.tydic.commodity.bo.ability.UccMallComparePriceReqBo;
import com.tydic.commodity.bo.ability.UccMallComparePriceRspBo;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.search.UccMallCompareCommodityService;
import com.tydic.commodity.search.bo.UccMallCommodityRspBo;
import com.tydic.commodity.search.bo.UccMallCompareEsReqBo;
import com.tydic.commodity.search.bo.UccMallCompareEsRspBo;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallComparePriceAbilityService.class)
public class UccMallComparePriceAbilityServiceImpl
implements UccMallComparePriceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallComparePriceAbilityServiceImpl.class);
    @Autowired
    private UccMallCompareCommodityService uccMallCompareCommodityService;

    public UccMallComparePriceRspBo compare(UccMallComparePriceReqBo reqBo) {
        UccMallComparePriceRspBo rspBo = new UccMallComparePriceRspBo();
        if (StringUtils.isEmpty((CharSequence)reqBo.getUpc()) && StringUtils.isEmpty((CharSequence)reqBo.getMfgsku())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u65e0\u6bd4\u4ef7\u5173\u952e\u4fe1\u606f");
            rspBo.setResult(new ArrayList());
            return rspBo;
        }
        UccMallCompareEsReqBo uccMallCompareEsReqBo = new UccMallCompareEsReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)uccMallCompareEsReqBo);
        UccMallCompareEsRspBo uccMallCompareEsRspBo = this.uccMallCompareCommodityService.compare(uccMallCompareEsReqBo);
        if (!"0000".equals(uccMallCompareEsRspBo.getRespCode())) {
            BeanUtils.copyProperties((Object)uccMallCompareEsRspBo, (Object)reqBo);
            return rspBo;
        }
        List uccMallCommodityRspBos = uccMallCompareEsRspBo.getUccMallCommodityRspBos();
        List<UccMallSearchBarEsRspInfo> result = this.convertRspBo(uccMallCommodityRspBos);
        HashMap<Long, Integer> filter = new HashMap<Long, Integer>();
        int i = 0;
        if (!result.isEmpty()) {
            for (UccMallSearchBarEsRspInfo each : result) {
                if (filter.containsKey(each.getSupplierShopId())) {
                    if (result.get((Integer)filter.get(each.getSupplierShopId())).getSalePrice().compareTo(each.getSalePrice()) > 0) {
                        filter.put(each.getSupplierShopId(), i);
                    }
                } else {
                    filter.put(each.getSupplierShopId(), i);
                }
                ++i;
            }
            ArrayList<UccMallSearchBarEsRspInfo> supplierShopPrice = new ArrayList<UccMallSearchBarEsRspInfo>();
            for (Long each : filter.keySet()) {
                supplierShopPrice.add(result.get((Integer)filter.get(each)));
            }
            result.clear();
            result.addAll(supplierShopPrice);
        }
        rspBo.setResult(result);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<UccMallSearchBarEsRspInfo> convertRspBo(List<UccMallCommodityRspBo> uccMallCommodityRspBos) {
        ArrayList<UccMallSearchBarEsRspInfo> uccMallSearchBarEsRspInfos = new ArrayList<UccMallSearchBarEsRspInfo>();
        if (uccMallCommodityRspBos != null && uccMallCommodityRspBos.size() > 0) {
            for (UccMallCommodityRspBo uccMallCommodityRspBo : uccMallCommodityRspBos) {
                UccMallSearchBarEsRspInfo uccMallSearchBarEsRspInfo = new UccMallSearchBarEsRspInfo();
                uccMallSearchBarEsRspInfo.setCommodityId(Long.valueOf(uccMallCommodityRspBo.getCommodity_id()));
                uccMallSearchBarEsRspInfo.setSkuId(Long.valueOf(uccMallCommodityRspBo.getSku_id()));
                uccMallSearchBarEsRspInfo.setExtSkuId(uccMallCommodityRspBo.getExt_sku_id());
                uccMallSearchBarEsRspInfo.setPriPicUrl(uccMallCommodityRspBo.getPicture_url());
                uccMallSearchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMarket_price())));
                uccMallSearchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getSale_price())));
                uccMallSearchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMember_price1())));
                uccMallSearchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMember_price2())));
                uccMallSearchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMember_price3())));
                uccMallSearchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMember_price4())));
                uccMallSearchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMember_price5())));
                uccMallSearchBarEsRspInfo.setSkuName(uccMallCommodityRspBo.getSku_name());
                uccMallSearchBarEsRspInfo.setSupplierShopId(uccMallCommodityRspBo.getSupplier_shop_id());
                uccMallSearchBarEsRspInfo.setSupplierShopName(uccMallCommodityRspBo.getShop_name());
                uccMallSearchBarEsRspInfo.setSupplierId(String.valueOf(uccMallCommodityRspBo.getSupplier_id()));
                uccMallSearchBarEsRspInfo.setSupplierName(uccMallCommodityRspBo.getSupplier_name());
                uccMallSearchBarEsRspInfo.setSkuSource(Integer.valueOf(uccMallCommodityRspBo.getSku_source()));
                uccMallSearchBarEsRspInfos.add(uccMallSearchBarEsRspInfo);
            }
        }
        return uccMallSearchBarEsRspInfos;
    }
}

