/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.ability.api.UccMallESearchToBrandAbilityService;
import com.tydic.commodity.bo.ability.UccMallESearchToBrandAbilityRspBO;
import com.tydic.commodity.bo.busi.UccMallBrandToEsBO;
import com.tydic.commodity.dao.UccMallBrandDealMapper;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.search.config.MallElasticsearchUtil;
import com.tydic.commodity.search.config.MallEsConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallESearchToBrandAbilityService.class)
public class UccMallESearchToBrandAbilityServiceImpl
implements UccMallESearchToBrandAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallESearchToBrandAbilityServiceImpl.class);
    @Autowired
    private UccMallBrandDealMapper uccMallBrandDealMapper;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;

    public UccMallESearchToBrandAbilityRspBO autoBrandToEs() {
        UccMallESearchToBrandAbilityRspBO rspBO = new UccMallESearchToBrandAbilityRspBO();
        List<UccBrandDealPO> uccBrandDealPOS = this.uccMallBrandDealMapper.queryAllBrand();
        if (CollectionUtils.isEmpty(uccBrandDealPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u54c1\u724c\u67e5\u8be2\u5931\u8d25");
            return rspBO;
        }
        ArrayList uccMallBrandToEsBOList = new ArrayList();
        uccBrandDealPOS.stream().sorted(Comparator.comparing(UccBrandDealPO::getBrandId).reversed()).collect(Collectors.toList()).forEach(uccBrandDeal -> {
            UccMallBrandToEsBO uccMallBrandToEsBO = new UccMallBrandToEsBO();
            uccMallBrandToEsBO.setBrand_en_name(uccBrandDeal.getBrandEnName());
            uccMallBrandToEsBO.setBrand_id(uccBrandDeal.getBrandId());
            uccMallBrandToEsBO.setBrand_name(uccBrandDeal.getBrandName());
            uccMallBrandToEsBO.setBrand_status(uccBrandDeal.getBrandStatus());
            uccMallBrandToEsBO.setRel_id(uccBrandDeal.getBrandId());
            uccMallBrandToEsBO.setBrand_type(uccBrandDeal.getBrandType());
            uccMallBrandToEsBOList.add(uccMallBrandToEsBO);
        });
        ArrayList list = new ArrayList();
        uccMallBrandToEsBOList.forEach(uccMallBrandToEsBO -> {
            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>(16);
            map.put(String.valueOf(uccMallBrandToEsBO.getBrand_id()), (JSONObject)JSONObject.toJSON((Object)uccMallBrandToEsBO));
            list.add(map);
        });
        this.mallElasticsearchUtil.addBatch(this.mallEsConfig.getBrandIndexName(), this.mallEsConfig.getBrandSuggestIndexType(), list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

