/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.ability.api.UccMallESearchToCatalogAbilityService;
import com.tydic.commodity.bo.ability.UccMallESearchToCatalogAbilityRspBO;
import com.tydic.commodity.bo.busi.UccMallCatalogToEsBO;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallCatalogDealMapper;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.search.config.MallElasticsearchUtil;
import com.tydic.commodity.search.config.MallEsConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallESearchToCatalogAbilityService.class)
public class UccMallESearchToCatalogAbilityServiceImpl
implements UccMallESearchToCatalogAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallESearchToCatalogAbilityServiceImpl.class);
    @Autowired
    private UccMallCatalogDealMapper uccMallCatalogDealMapper;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;

    public UccMallESearchToCatalogAbilityRspBO autoCatalogToEs() {
        UccMallESearchToCatalogAbilityRspBO rspBO = new UccMallESearchToCatalogAbilityRspBO();
        List<UccCatalogDealPO> uccCatalogDealPOS = this.uccMallCatalogDealMapper.queryAllyCatalog();
        if (CollectionUtils.isEmpty(uccCatalogDealPOS)) {
            rspBO.setRespCode(RspConstantEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBO.setRespDesc("\u7c7b\u76ee\u67e5\u8be2\u5931\u8d25");
            return rspBO;
        }
        ArrayList uccMallCatalogToEsBOList = new ArrayList();
        uccCatalogDealPOS.stream().sorted(Comparator.comparing(UccCatalogDealPO::getGuideCatalogId).reversed()).collect(Collectors.toList()).forEach(uccCatalogDeal -> {
            UccMallCatalogToEsBO uccMallCatalogToEsBO = new UccMallCatalogToEsBO();
            uccMallCatalogToEsBO.setCatalog_level(uccCatalogDeal.getCatalogLevel());
            uccMallCatalogToEsBO.setCatalog_name(uccCatalogDeal.getCatalogName());
            uccMallCatalogToEsBO.setCatalog_status(uccCatalogDeal.getCatalogStatus());
            uccMallCatalogToEsBO.setChannelId(uccCatalogDeal.getChannelId());
            uccMallCatalogToEsBO.setUpper_catalog_id(uccCatalogDeal.getUpperCatalogId());
            uccMallCatalogToEsBO.setShopCatalogType(uccCatalogDeal.getShopCatalogType());
            uccMallCatalogToEsBO.setGuide_catalog_id(uccCatalogDeal.getGuideCatalogId());
            uccMallCatalogToEsBOList.add(uccMallCatalogToEsBO);
        });
        ArrayList list = new ArrayList();
        uccMallCatalogToEsBOList.forEach(uccMallCatalogToEsBO -> {
            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>(16);
            map.put(String.valueOf(uccMallCatalogToEsBO.getGuide_catalog_id()), (JSONObject)JSONObject.toJSON((Object)uccMallCatalogToEsBO));
            list.add(map);
        });
        this.mallElasticsearchUtil.addBatch(this.mallEsConfig.getCatalogIndexName(), this.mallEsConfig.getCatalogSuggestIndexType(), list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

