/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.ability.api.UccMallQryChannelLableAbilityService;
import com.tydic.commodity.bo.ability.UccMallQryChannelLableAbilityReqBO;
import com.tydic.commodity.bo.ability.UccMallQryChannelLableAbilityRspBO;
import com.tydic.commodity.dao.UccMallChannelDealMapper;
import com.tydic.commodity.dao.UccMallCommodityLabelMapper;
import com.tydic.commodity.dao.UccMallRelChannelPoolMapper;
import com.tydic.commodity.dao.UccMallRelCommodityLabelPoolMapper;
import com.tydic.commodity.dao.po.UccChannelDealPO;
import com.tydic.commodity.dao.po.UccMallChannelPoolJoinPO;
import com.tydic.commodity.dao.po.UccMallCommodityLabelPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallQryChannelLableAbilityService.class)
public class UccMallQryChannelLableAbilityServiceImpl
implements UccMallQryChannelLableAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallQryChannelLableAbilityServiceImpl.class);
    @Autowired
    private UccMallChannelDealMapper uccMallChannelDealMapper;
    @Autowired
    private UccMallRelChannelPoolMapper cnncUccRelChannelPoolMapper;
    @Autowired
    private UccMallRelCommodityLabelPoolMapper cnncRelCommodityLabelPoolMapper;
    @Autowired
    private UccMallCommodityLabelMapper cnncCommodityLabelMapper;

    public UccMallQryChannelLableAbilityRspBO queryChannelLable(UccMallQryChannelLableAbilityReqBO reqBO) {
        UccMallQryChannelLableAbilityRspBO rspBO = new UccMallQryChannelLableAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getChannelId() == null) {
            rspBO.setHideLable(new ArrayList());
            rspBO.setShowLable(new ArrayList());
            return rspBO;
        }
        UccChannelDealPO uccChannelPO = this.uccMallChannelDealMapper.selectByPrimaryKey(reqBO.getChannelId());
        if (uccChannelPO == null) {
            rspBO.setHideLable(new ArrayList());
            rspBO.setShowLable(new ArrayList());
            return rspBO;
        }
        List<UccMallChannelPoolJoinPO> channelPoolJoinPOS = this.cnncUccRelChannelPoolMapper.queryRelList(Arrays.asList(reqBO.getChannelId()), null);
        if (CollectionUtils.isEmpty(channelPoolJoinPOS)) {
            rspBO.setHideLable(new ArrayList());
            rspBO.setShowLable(new ArrayList());
            return rspBO;
        }
        HashSet pools = new HashSet();
        channelPoolJoinPOS.stream().filter(s -> s.getPoolState() != 0).forEach(s -> pools.add(s.getPoolId()));
        if (!CollectionUtils.isEmpty(pools)) {
            List<UccMallCommodityLabelPo> show = this.cnncCommodityLabelMapper.selectLabel(1, new ArrayList<Long>(pools));
            List<UccMallCommodityLabelPo> hide = this.cnncCommodityLabelMapper.selectLabel(0, new ArrayList<Long>(pools));
            if (!CollectionUtils.isEmpty(show)) {
                HashSet showLabel = new HashSet();
                show.stream().forEach(s -> showLabel.add(s.getLabelName()));
                rspBO.setShowLable(new ArrayList(showLabel));
            }
            if (!CollectionUtils.isEmpty(hide)) {
                HashSet hideLabel = new HashSet();
                hide.stream().forEach(s -> hideLabel.add(s.getLabelName()));
                rspBO.setHideLable(new ArrayList(hideLabel));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

