/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.commodity.ability.api.UccMallSearchBarAnalyzerBusiService;
import com.tydic.commodity.ability.api.UccMallSearchBarEsAbilityService;
import com.tydic.commodity.bo.ability.UccMallQueryParam;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsReqBO;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsRspBO;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.bo.busi.CatalogMatchResultBo;
import com.tydic.commodity.bo.busi.UccMallSearchAnalyzerReqBO;
import com.tydic.commodity.bo.busi.UccMallSearchAnalyzerRspBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccMallSpuSpecMapper;
import com.tydic.commodity.dao.po.UccSpuSpecPo;
import com.tydic.commodity.enumType.EnumHelper;
import com.tydic.commodity.enumType.IntentRecognitionServiceEnum;
import com.tydic.commodity.search.UccMallSearchCommodityService;
import com.tydic.commodity.search.bo.UccMallCommodityRspBo;
import com.tydic.commodity.search.bo.UccMallSearchEsReqBO;
import com.tydic.commodity.search.bo.UccMallSearchEsRspBo;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallSearchBarEsAbilityService.class)
public class UccMallSearchBarEsAbilityServiceImpl
implements UccMallSearchBarEsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSearchBarEsAbilityServiceImpl.class);
    @Autowired
    private UccMallSearchCommodityService uccMallSearchCommodityService;
    @Autowired
    private UccMallSpuSpecMapper uccMallSpuSpecMapper;
    @Autowired
    private UccMallSearchBarAnalyzerBusiService uccMallSearchBarAnalyzerBusiService;
    @Value(value="${analyzer_tokens}")
    private Boolean analyzerTokens;

    public UccMallSearchBarEsRspBO qryBySearchBar(UccMallSearchBarEsReqBO reqBO) {
        UccMallSearchEsRspBo uccMallSearchEsRspBo;
        String jsonStr1 = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccMallSearchEsReqBO uccMallSearchEsReqBO = (UccMallSearchEsReqBO)JSON.parseObject((String)jsonStr1, UccMallSearchEsReqBO.class);
        if (reqBO.getBrandId() == null && reqBO.getCategoryId() == null && this.analyzerTokens.booleanValue() && !StringUtils.isEmpty((String)reqBO.getQueryStr()) && CollectionUtils.isEmpty((Collection)reqBO.getQueryParams())) {
            UccMallSearchAnalyzerReqBO uccMallSearchAnalyzerReqBO = new UccMallSearchAnalyzerReqBO();
            uccMallSearchAnalyzerReqBO.setTokens(reqBO.getQueryStr());
            UccMallSearchAnalyzerRspBO uccMallSearchAnalyzerRspBO = this.uccMallSearchBarAnalyzerBusiService.analyzerSearch(reqBO);
            if (log.isDebugEnabled()) {
                log.debug("analyzerSearch\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)uccMallSearchAnalyzerRspBO));
            }
            if ("0000".equals(uccMallSearchAnalyzerRspBO.getRespCode())) {
                ArrayList<UccMallQueryParam> uccMallQueryParams = new ArrayList<UccMallQueryParam>();
                if (!CollectionUtils.isEmpty((Map)uccMallSearchAnalyzerRspBO.getMatchParams())) {
                    Map matchParams = uccMallSearchAnalyzerRspBO.getMatchParams();
                    for (Map.Entry entry : matchParams.entrySet()) {
                        UccMallQueryParam uccMallQueryParam = new UccMallQueryParam();
                        List params = (List)entry.getValue();
                        IntentRecognitionServiceEnum serviceEnum = (IntentRecognitionServiceEnum)EnumHelper.getEnum((String)((String)entry.getKey()), IntentRecognitionServiceEnum.class);
                        uccMallQueryParam.setFilterId(serviceEnum.getParamName());
                        uccMallQueryParam.setFilterName(serviceEnum.getParamDesc());
                        uccMallQueryParam.setFilterValues(params);
                        uccMallQueryParams.add(uccMallQueryParam);
                    }
                }
                if (!CollectionUtils.isEmpty(uccMallQueryParams)) {
                    uccMallSearchEsReqBO.setAnalyzer(Boolean.valueOf(true));
                }
                uccMallSearchEsReqBO.setQueryParams(uccMallQueryParams);
                uccMallSearchEsReqBO.setQueryStr(uccMallSearchAnalyzerRspBO.getQueryStr());
                List catalogMatchResultBos = uccMallSearchAnalyzerRspBO.getMatchResultBos();
                if (!CollectionUtils.isEmpty((Collection)catalogMatchResultBos) && !CollectionUtils.isEmpty((Collection)catalogMatchResultBos)) {
                    List<Long> catalog = new ArrayList<Long>();
                    if (reqBO.getCategoryId() != null) {
                        catalog.add(reqBO.getCategoryId());
                        for (CatalogMatchResultBo each : catalogMatchResultBos) {
                            if (reqBO.getCategoryId() == null || each.getCatalogLevel().intValue() != reqBO.getLevel().intValue()) continue;
                            catalog.add(each.getGuideCatalogId());
                        }
                    } else {
                        Map<Long, List<CatalogMatchResultBo>> map = catalogMatchResultBos.stream().collect(Collectors.groupingBy(CatalogMatchResultBo::getCatalogLevel));
                        if (map.containsKey(3L)) {
                            catalog = map.get(3L).stream().map(CatalogMatchResultBo::getGuideCatalogId).collect(Collectors.toList());
                            reqBO.setLevel(Integer.valueOf(3));
                        } else if (map.containsKey(2L)) {
                            catalog = map.get(2L).stream().map(CatalogMatchResultBo::getGuideCatalogId).collect(Collectors.toList());
                            reqBO.setLevel(Integer.valueOf(2));
                        } else if (map.containsKey(1L)) {
                            catalog = map.get(1L).stream().map(CatalogMatchResultBo::getGuideCatalogId).collect(Collectors.toList());
                            reqBO.setLevel(Integer.valueOf(1));
                        }
                    }
                    if (!CollectionUtils.isEmpty(catalog)) {
                        uccMallSearchEsReqBO.setCategoryIds(catalog);
                        uccMallSearchEsReqBO.setLevel(reqBO.getLevel());
                    }
                    uccMallSearchEsReqBO.setAnalyzer(Boolean.valueOf(true));
                }
            }
        }
        UccMallSearchBarEsRspBO uccMallSearchBarEsRspBO = new UccMallSearchBarEsRspBO();
        if (reqBO.getSkuStatus() == null || reqBO.getSkuStatus().size() == 0) {
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF);
            uccMallSearchEsReqBO.setSkuStatus(skuStatus);
        }
        if (null != reqBO.getCategoryId()) {
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            categoryIds.add(reqBO.getCategoryId());
            uccMallSearchEsReqBO.setCategoryIds(categoryIds);
        }
        if (reqBO.getSupplierShopId() != null) {
            ArrayList<Long> supplierShopIds = new ArrayList<Long>();
            supplierShopIds.add(reqBO.getSupplierShopId());
            uccMallSearchEsReqBO.setSupplierShopIds(supplierShopIds);
        }
        if (reqBO.getBrandId() != null) {
            ArrayList<Long> brandIds = new ArrayList<Long>();
            brandIds.add(reqBO.getBrandId());
            uccMallSearchEsReqBO.setBrandIds(brandIds);
        }
        if (reqBO.getTypeId() != null) {
            uccMallSearchEsReqBO.setTypeId(reqBO.getTypeId());
        }
        if (reqBO.getTypeName() != null) {
            uccMallSearchEsReqBO.setTypeName(reqBO.getTypeName());
        }
        if (log.isInfoEnabled()) {
            log.info("queryByMatch\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uccMallSearchEsReqBO));
        }
        if ((uccMallSearchEsRspBo = this.uccMallSearchCommodityService.queryByMatch(uccMallSearchEsReqBO)) == null) {
            log.info("\u67e5\u8be2ES\u6570\u636e\u670d\u52a1\u5f02\u5e38!!");
            uccMallSearchBarEsRspBO.setRespCode("0000");
            uccMallSearchBarEsRspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
            uccMallSearchBarEsRspBO.setPageNo(1);
            uccMallSearchBarEsRspBO.setTotal(0);
            uccMallSearchBarEsRspBO.setRecordsTotal(0);
            return uccMallSearchBarEsRspBO;
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)uccMallSearchBarEsRspBO);
        List uccMallCommodityRspBos = uccMallSearchEsRspBo.getUccMallCommodityRspBos();
        List<UccMallSearchBarEsRspInfo> result = this.convertRspBo(uccMallCommodityRspBos);
        uccMallSearchBarEsRspBO.setResult(result);
        int size = reqBO.getPageSize();
        int n = reqBO.getPageNo();
        int totalPage = 0;
        int add = 0;
        Integer total = 0;
        totalPage = uccMallSearchEsRspBo.getTotal() / size;
        add = uccMallSearchEsRspBo.getTotal() % size == 0 ? 0 : 1;
        total = uccMallSearchEsRspBo.getTotal();
        uccMallSearchBarEsRspBO.setTotal(totalPage + add);
        uccMallSearchBarEsRspBO.setPageNo(n);
        if (uccMallSearchEsRspBo.getUccMallQueryParams() != null && uccMallSearchEsRspBo.getPropParams() != null) {
            uccMallSearchEsRspBo.getUccMallQueryParams().addAll(uccMallSearchEsRspBo.getPropParams());
        }
        uccMallSearchBarEsRspBO.setQueryParams(uccMallSearchEsRspBo.getUccMallQueryParams());
        uccMallSearchBarEsRspBO.setRecordsTotal(total.intValue());
        uccMallSearchBarEsRspBO.setRespCode("0000");
        uccMallSearchBarEsRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return uccMallSearchBarEsRspBO;
    }

    private List<UccMallSearchBarEsRspInfo> convertRspBo(List<UccMallCommodityRspBo> uccMallCommodityRspBos) {
        ArrayList<UccMallSearchBarEsRspInfo> uccMallSearchBarEsRspInfos = new ArrayList<UccMallSearchBarEsRspInfo>();
        if (uccMallCommodityRspBos != null && uccMallCommodityRspBos.size() > 0) {
            for (UccMallCommodityRspBo uccMallCommodityRspBo : uccMallCommodityRspBos) {
                UccMallSearchBarEsRspInfo uccMallSearchBarEsRspInfo = new UccMallSearchBarEsRspInfo();
                uccMallSearchBarEsRspInfo.setCommodityId(Long.valueOf(uccMallCommodityRspBo.getCommodity_id()));
                uccMallSearchBarEsRspInfo.setSkuId(Long.valueOf(uccMallCommodityRspBo.getSku_id()));
                uccMallSearchBarEsRspInfo.setExtSkuId(uccMallCommodityRspBo.getExt_sku_id());
                uccMallSearchBarEsRspInfo.setPriPicUrl(uccMallCommodityRspBo.getPicture_url());
                uccMallSearchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getAgreement_price())));
                uccMallSearchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMarket_price())));
                uccMallSearchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getSale_price())));
                uccMallSearchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMember_price1())));
                uccMallSearchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMember_price2())));
                uccMallSearchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMember_price3())));
                uccMallSearchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMember_price4())));
                uccMallSearchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(uccMallCommodityRspBo.getMember_price5())));
                uccMallSearchBarEsRspInfo.setCommentNumber(uccMallCommodityRspBo.getComment_number());
                uccMallSearchBarEsRspInfo.setMeasureName(uccMallCommodityRspBo.getMeasure_name());
                uccMallSearchBarEsRspInfo.setSkuName(uccMallCommodityRspBo.getSku_name());
                uccMallSearchBarEsRspInfo.setSupplierShopId(uccMallCommodityRspBo.getSupplier_shop_id());
                uccMallSearchBarEsRspInfo.setSupplierShopName(uccMallCommodityRspBo.getShop_name());
                uccMallSearchBarEsRspInfo.setSupplierId(String.valueOf(uccMallCommodityRspBo.getSupplier_id()));
                uccMallSearchBarEsRspInfo.setSupplierName(uccMallCommodityRspBo.getSupplier_name());
                uccMallSearchBarEsRspInfo.setSkuSource(Integer.valueOf(uccMallCommodityRspBo.getSku_source()));
                uccMallSearchBarEsRspInfo.setCommodityName(uccMallCommodityRspBo.getCommodity_name());
                uccMallSearchBarEsRspInfo.setCommdPicUrl(uccMallCommodityRspBo.getCommd_pic_url());
                if (uccMallCommodityRspBo.getEcommerce_sale() != null) {
                    uccMallSearchBarEsRspInfo.setEcommerceSale(Long.valueOf(uccMallCommodityRspBo.getEcommerce_sale().longValue()));
                }
                uccMallSearchBarEsRspInfo.setExtendProperties(uccMallCommodityRspBo.getExtendProperties());
                uccMallSearchBarEsRspInfo.setVendorName(uccMallCommodityRspBo.getVendor_name());
                uccMallSearchBarEsRspInfo.setAgreementId(Long.valueOf(uccMallCommodityRspBo.getAgreement_id()));
                uccMallSearchBarEsRspInfo.setHighLightSkuName(uccMallCommodityRspBo.getHighLightSkuName());
                uccMallSearchBarEsRspInfo.setHighLightCommodityName(uccMallCommodityRspBo.getHighLightCommodityName());
                uccMallSearchBarEsRspInfo.setChannelNames(uccMallCommodityRspBo.getChannel_Name());
                uccMallSearchBarEsRspInfo.setChannelIds(uccMallCommodityRspBo.getChannel_id());
                uccMallSearchBarEsRspInfo.setLabelIds(uccMallCommodityRspBo.getLabelIds());
                uccMallSearchBarEsRspInfo.setLabelNames(uccMallCommodityRspBo.getLabelNames());
                uccMallSearchBarEsRspInfo.setShowLabelIds(uccMallCommodityRspBo.getShowLabelIds());
                uccMallSearchBarEsRspInfo.setShowLabelNames(uccMallCommodityRspBo.getShowLabelNames());
                uccMallSearchBarEsRspInfo.setSalesUnitName(uccMallCommodityRspBo.getSales_unit_name());
                uccMallSearchBarEsRspInfo.setExtSpuId(uccMallCommodityRspBo.getExt_spu_id());
                uccMallSearchBarEsRspInfos.add(uccMallSearchBarEsRspInfo);
            }
        }
        uccMallCommodityRspBos = null;
        return uccMallSearchBarEsRspInfos;
    }

    private void queryOtherProp(List<UccMallSearchBarEsRspInfo> rspInfos) {
        if (rspInfos == null || rspInfos.size() == 0) {
            return;
        }
        HashedMap shopCommd = new HashedMap();
        for (UccMallSearchBarEsRspInfo each : rspInfos) {
            if (shopCommd.containsKey(each.getSupplierShopId())) {
                ((List)shopCommd.get(each.getSupplierShopId())).add(each.getCommodityId());
                continue;
            }
            ArrayList<Long> commoditys = new ArrayList<Long>();
            commoditys.add(each.getCommodityId());
            shopCommd.put(each.getSupplierShopId(), commoditys);
        }
        Iterator iterator = shopCommd.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            System.out.println(++i);
            Map.Entry data = iterator.next();
            List<UccSpuSpecPo> uccSpuSpecPoList = this.uccMallSpuSpecMapper.batchQueryLessSpecs((List)data.getValue(), ModelRuleConstant.PROP_GRP_TYPE_OTHER, (Long)data.getKey());
            if (uccSpuSpecPoList == null || uccSpuSpecPoList.size() == 0) continue;
            HashedMap specMap = new HashedMap();
            for (UccSpuSpecPo uccSpuSpecPo : uccSpuSpecPoList) {
                if (specMap.containsKey(uccSpuSpecPo.getCommodityId())) {
                    ((JSONObject)specMap.get(uccSpuSpecPo.getCommodityId())).put(uccSpuSpecPo.getPropShowName(), (Object)uccSpuSpecPo.getPropValue());
                    continue;
                }
                JSONObject specData = new JSONObject();
                specData.put(uccSpuSpecPo.getPropShowName(), (Object)uccSpuSpecPo.getPropValue());
                specMap.put(uccSpuSpecPo.getCommodityId(), specData);
            }
            for (UccMallSearchBarEsRspInfo uccMallSearchBarEsRspInfo : rspInfos) {
                uccMallSearchBarEsRspInfo.setExtendProperties(JSONObject.toJSONString(specMap.get(uccMallSearchBarEsRspInfo.getCommodityId())));
            }
        }
        shopCommd = null;
    }
}

