/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.ability.api.UccMallSearchBuildAbilityService;
import com.tydic.commodity.bo.ability.UccMallSeTermsBO;
import com.tydic.commodity.bo.ability.UccMallSearchBuildAbilityReqBO;
import com.tydic.commodity.bo.ability.UccMallSearchBuildAbilityRspBO;
import com.tydic.commodity.bo.ability.UccMallSourceTypeBo;
import com.tydic.commodity.bo.busi.UccMallOrderColumBo;
import com.tydic.commodity.bo.busi.UccMallOrgCacheBo;
import com.tydic.commodity.bo.busi.UccMallSearchOrderConfigBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallSearchBuildAbilityService.class)
public class UccMallSearchBuildAbilityServiceImpl
implements UccMallSearchBuildAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSearchBuildAbilityServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;

    public UccMallSearchBuildAbilityRspBO build(UccMallSearchBuildAbilityReqBO reqBO) {
        UccMallSeTermsBO assortBO;
        UccMallSeTermsBO verdorBO;
        UccMallSeTermsBO typeIdBO;
        ArrayList<String> valueList;
        UccMallSearchBuildAbilityRspBO rspBO = new UccMallSearchBuildAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setQueryStr(reqBO.getQueryStr());
        if (reqBO.getMaxSalesPrice() != null) {
            rspBO.setMaxSalePrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getMaxSalesPrice()).toString());
        }
        if (reqBO.getMinSalesPrice() != null) {
            rspBO.setMinSalePrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getMinSalesPrice()).toString());
        }
        ArrayList<UccMallSeTermsBO> mustTermsList = new ArrayList<UccMallSeTermsBO>();
        ArrayList<UccMallSeTermsBO> mustNotTermsList = new ArrayList<UccMallSeTermsBO>();
        String orgPath = reqBO.getOrgPath();
        UccMallOrgCacheBo limitGui = null;
        if (!StringUtils.isEmpty((Object)reqBO.getOrgPath())) {
            limitGui = this.searchLimitGui(orgPath);
        }
        ArrayList<UccMallOrderColumBo> orderColum = new ArrayList<UccMallOrderColumBo>();
        if (reqBO.getOrderByColumn() != null && reqBO.getOrderByColumn() != 0) {
            String sortField = "";
            if (reqBO.getOrderByColumn() != null) {
                if (reqBO.getOrderByColumn() == 1) {
                    sortField = "sold_number";
                } else if (reqBO.getOrderByColumn() == 2) {
                    sortField = "on_shelve_time";
                } else if (reqBO.getOrderByColumn() == 3) {
                    sortField = "sale_price";
                } else if (reqBO.getOrderByColumn() == 4) {
                    sortField = "discounts";
                } else if (reqBO.getOrderByColumn() == 5) {
                    sortField = "comment_number";
                }
            }
            if (!StringUtils.isEmpty((Object)sortField)) {
                UccMallOrderColumBo bo = new UccMallOrderColumBo();
                bo.setOrderByColumn(sortField);
                bo.setOrderType(reqBO.getOrderType());
                orderColum.add(bo);
                rspBO.setComSortList(orderColum);
            }
        } else {
            Object obj = null;
            obj = this.cacheClient.get("UCC_SKU_SEARCH_ORDER_CONFIG" + reqBO.getQueryChannelId());
            if (obj == null) {
                obj = this.cacheClient.get("UCC_SKU_SEARCH_ORDER_CONFIG");
            }
            if (obj != null) {
                List<UccMallSearchOrderConfigBO> searchOrderConfigBoList = new ArrayList();
                try {
                    searchOrderConfigBoList = obj instanceof String ? JSONObject.parseArray((String)((String)obj), UccMallSearchOrderConfigBO.class) : JSONObject.parseArray((String)JSONObject.toJSONString((Object)obj), UccMallSearchOrderConfigBO.class);
                }
                catch (Exception e) {
                    log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38 \uff1a\u5546\u54c1\u6392\u5e8f\u8f6c\u6362\u5f02\u5e38" + JSONObject.toJSONString((Object)reqBO));
                }
                if (!CollectionUtils.isEmpty(searchOrderConfigBoList)) {
                    searchOrderConfigBoList.sort(Comparator.comparing(UccMallSearchOrderConfigBO::getId));
                    for (UccMallSearchOrderConfigBO each : searchOrderConfigBoList) {
                        if (each.getStatus() != 1L) continue;
                        UccMallOrderColumBo bo = new UccMallOrderColumBo();
                        bo.setOrderByColumn(each.getColName());
                        bo.setOrderType(Integer.valueOf(each.getType().intValue()));
                        orderColum.add(bo);
                    }
                    rspBO.setComSortList(orderColum);
                }
            }
        }
        if (reqBO.getSkuStatus() == null || reqBO.getSkuStatus().size() == 0) {
            ArrayList<String> skuStatus = new ArrayList<String>();
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF.toString());
            UccMallSeTermsBO statusBO = new UccMallSeTermsBO();
            statusBO.setName("sku_status");
            statusBO.setValueList(skuStatus);
            mustTermsList.add(statusBO);
        }
        if (reqBO.getCategoryId() != null && reqBO.getLevel() != null) {
            UccMallSeTermsBO categoryIdBO = new UccMallSeTermsBO();
            valueList = new ArrayList<String>();
            valueList.add(reqBO.getCategoryId().toString());
            if (reqBO.getLevel() == 1) {
                categoryIdBO.setName("l1_category_id");
            }
            if (reqBO.getLevel() == 2) {
                categoryIdBO.setName("l2_category_id");
            }
            if (reqBO.getLevel() == 3) {
                categoryIdBO.setName("l3_category_id");
            }
            categoryIdBO.setValueList(valueList);
            mustTermsList.add(categoryIdBO);
        }
        if (reqBO.getBrandId() != null) {
            UccMallSeTermsBO brandIdBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getBrandId().toString());
            brandIdBO.setName("brand_id");
            brandIdBO.setValueList(valueList);
            mustTermsList.add(brandIdBO);
        }
        if (reqBO.getTypeId() != null) {
            typeIdBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getTypeId().toString());
            typeIdBO.setName("type_id");
            typeIdBO.setValueList(valueList);
            mustTermsList.add(typeIdBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTypeIds())) {
            typeIdBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getTypeIds().forEach(a -> valueList.add(a.toString()));
            typeIdBO.setName("type_id");
            typeIdBO.setValueList(valueList);
            mustTermsList.add(typeIdBO);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTypeName())) {
            UccMallSeTermsBO typeNameBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getTypeName());
            typeNameBO.setName("type_name");
            typeNameBO.setValueList(valueList);
            mustTermsList.add(typeNameBO);
        }
        if (reqBO.getQueryChannelId() != null) {
            UccMallSeTermsBO channelBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getQueryChannelId().toString());
            channelBO.setName("channel_id");
            channelBO.setValueList(valueList);
            mustTermsList.add(channelBO);
        }
        if (reqBO.getSupplierShopId() != null) {
            UccMallSeTermsBO shopBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getSupplierShopId().toString());
            shopBO.setName("supplier_shop_id");
            shopBO.setValueList(valueList);
            mustTermsList.add(shopBO);
        }
        if (reqBO.getSupplierId() != null) {
            UccMallSeTermsBO suppllierBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getSupplierId().toString());
            suppllierBO.setName("supplier_id");
            suppllierBO.setValueList(valueList);
            mustTermsList.add(suppllierBO);
        }
        if (reqBO.getVendorId() != null) {
            verdorBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getVendorId().toString());
            verdorBO.setName("vendor_id");
            verdorBO.setValueList(valueList);
            mustTermsList.add(verdorBO);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getAgreementId())) {
            verdorBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getAgreementId());
            verdorBO.setName("agreement_id");
            verdorBO.setValueList(valueList);
            mustTermsList.add(verdorBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuList())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getSkuList().forEach(a -> valueList.add(a.toString()));
            assortBO.setName("sku_id");
            assortBO.setValueList(valueList);
            mustTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExtSkuIds())) {
            assortBO = new UccMallSeTermsBO();
            assortBO.setName("ext_sku_id");
            assortBO.setValueList(reqBO.getExtSkuIds());
            mustTermsList.add(assortBO);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getUpcCode())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getUpcCode());
            assortBO.setName("upc");
            assortBO.setValueList(valueList);
            mustTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSourceAssort())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getSourceAssort().forEach(a -> valueList.add(a.toString()));
            valueList.add(reqBO.getVendorId().toString());
            assortBO.setName("sourceAssort");
            assortBO.setValueList(valueList);
            mustTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getIgnoreList())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getIgnoreList().forEach(a -> valueList.add(a.toString()));
            assortBO.setName("sku_id");
            assortBO.setValueList(valueList);
            mustNotTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getIgnoreSourceAssort())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getIgnoreSourceAssort().forEach(a -> valueList.add(a.toString()));
            valueList.add(reqBO.getVendorId().toString());
            assortBO.setName("sourceAssort");
            assortBO.setValueList(valueList);
            mustNotTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getIgnoreCommdList())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getIgnoreCommdList().forEach(a -> valueList.add(a.toString()));
            valueList.add(reqBO.getVendorId().toString());
            assortBO.setName("commodity_id");
            assortBO.setValueList(valueList);
            mustNotTermsList.add(assortBO);
        }
        rspBO.setMustNotTermsList(mustNotTermsList);
        rspBO.setMustTermsList(mustTermsList);
        return rspBO;
    }

    public UccMallOrgCacheBo searchLimitGui(String orgPath) {
        UccMallOrgCacheBo resultBo = new UccMallOrgCacheBo();
        ArrayList igSkuList = new ArrayList();
        if (StringUtils.isEmpty((Object)orgPath)) {
            return null;
        }
        String[] orgPathList = orgPath.split("-");
        HashedMap igListMap = new HashedMap();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < orgPathList.length; ++i) {
            if (StringUtils.isEmpty((Object)sb.toString())) {
                sb.append("ORG_PATH_LIMIT_SALE_TYPE");
            }
            String sb1 = sb.append(orgPathList[i]).append("-").toString();
            Object object = this.cacheClient.get(sb1);
            if (object == null) continue;
            Object parse = JSON.parse((String)object.toString());
            String jsonStr1 = JSONObject.toJSONString((Object)parse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            UccMallOrgCacheBo bo = (UccMallOrgCacheBo)JSON.parseObject((String)jsonStr1, UccMallOrgCacheBo.class);
            if (!CollectionUtils.isEmpty((Collection)bo.getIgnoreList())) {
                igSkuList.addAll(bo.getIgnoreList());
            }
            if (CollectionUtils.isEmpty((Collection)bo.getIgSourceTypeBoList())) continue;
            for (UccMallSourceTypeBo each : bo.getIgSourceTypeBoList()) {
                if (!igListMap.containsKey(each.getSkuSource())) {
                    List getType = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)each.getType())) {
                        getType = each.getType();
                    }
                    igListMap.put(each.getSkuSource(), getType);
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)igListMap.get(each.getSkuSource())))) {
                    ((List)igListMap.get(each.getSkuSource())).addAll(each.getType());
                    continue;
                }
                igListMap.put(each.getSkuSource(), each.getType());
            }
        }
        resultBo.setIgnoreList(igSkuList);
        Iterator entries = igListMap.entrySet().iterator();
        ArrayList<UccMallSourceTypeBo> uccMallSourceTypeBoList = new ArrayList<UccMallSourceTypeBo>();
        while (entries.hasNext()) {
            UccMallSourceTypeBo uccMallSourceTypeBo = new UccMallSourceTypeBo();
            Map.Entry entry = entries.next();
            uccMallSourceTypeBo.setType((List)entry.getValue());
            uccMallSourceTypeBo.setSkuSource((Integer)entry.getKey());
            uccMallSourceTypeBoList.add(uccMallSourceTypeBo);
        }
        resultBo.setIgSourceTypeBoList(uccMallSourceTypeBoList);
        resultBo.setOrgPath(orgPath);
        return resultBo;
    }
}

