/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.ability.api.UccMallSearchBarEsAbilityService;
import com.tydic.commodity.ability.api.UccMallSpuDetailSkuListAbilityService;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsReqBO;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsRspBO;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.bo.ability.UccMallSpuDetailSkuListAbilityReqBO;
import com.tydic.commodity.bo.ability.UccMallSpuDetailSkuListAbilityRspBO;
import com.tydic.commodity.bo.ability.UccMallSpuDetailSkuListBO;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.po.Prop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallSpuDetailSkuListAbilityService.class)
public class UccMallSpuDetailSkuListAbilityServiceImpl
implements UccMallSpuDetailSkuListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSpuDetailSkuListAbilityServiceImpl.class);
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccMallSearchBarEsAbilityService uccMallSearchBarEsAbilityService;

    public UccMallSpuDetailSkuListAbilityRspBO getSpuDetailSkuList(UccMallSpuDetailSkuListAbilityReqBO reqBO) {
        UccMallSpuDetailSkuListAbilityRspBO rspBO = new UccMallSpuDetailSkuListAbilityRspBO();
        if (reqBO == null || reqBO.getCommodityId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u67e5\u8be2\u6570\u636e\u5185\u5bb9");
            return rspBO;
        }
        ArrayList commodityPropDefIds = new ArrayList();
        HashSet commodityPropDefIdSets = new HashSet();
        ArrayList propValueListIds = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getQryInfoList())) {
            reqBO.getQryInfoList().stream().forEach(item -> {
                commodityPropDefIdSets.add(item.getCommodityPropDefId());
                commodityPropDefIds.add(item.getCommodityPropDefId());
                propValueListIds.add(item.getPropValueListId());
            });
        }
        if (commodityPropDefIds.size() != commodityPropDefIds.size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7b5b\u9009\u5185\u5bb9\u4e0d\u5339\u914d");
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        ArrayList<Prop> props = new ArrayList<Prop>();
        commodityPropDefIdSets.stream().forEach(item -> {
            Prop prop = new Prop();
            prop.setPropId((Long)item);
            List<Long> values = reqBO.getQryInfoList().stream().filter(e -> e.getCommodityPropDefId().equals(item)).map(e -> e.getPropValueListId()).collect(Collectors.toList());
            prop.setPropValueIds(values);
            props.add(prop);
        });
        List<Long> skus = this.uccSkuSpecMapper.qrySKuFilterSpecTwo(reqBO.getCommodityId(), props, reqBO.getSkuName(), page);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(page.getPageNo());
        if (!CollectionUtils.isEmpty(skus)) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getQryInfoList()) && skus.size() == 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setRecordsTotal(0);
                rspBO.setTotal(0);
                return rspBO;
            }
            UccMallSearchBarEsReqBO uccMallSearchBarEsReqBO = new UccMallSearchBarEsReqBO();
            uccMallSearchBarEsReqBO.setSkuList(skus);
            uccMallSearchBarEsReqBO.setField(false);
            UccMallSearchBarEsRspBO uccMallSearchBarEsRspBO = this.uccMallSearchBarEsAbilityService.qryBySearchBar(uccMallSearchBarEsReqBO);
            if (uccMallSearchBarEsRspBO != null && !CollectionUtils.isEmpty((Collection)uccMallSearchBarEsRspBO.getResult())) {
                ArrayList<UccMallSpuDetailSkuListBO> reslut = new ArrayList<UccMallSpuDetailSkuListBO>();
                for (UccMallSearchBarEsRspInfo each : uccMallSearchBarEsRspBO.getResult()) {
                    UccMallSpuDetailSkuListBO bo = new UccMallSpuDetailSkuListBO();
                    BeanUtils.copyProperties((Object)each, (Object)bo);
                    bo.setStock(each.getCommentNumber());
                    bo.setSkuId(each.getSkuId());
                    bo.setSalePrice(each.getSalePrice());
                    if (!StringUtils.isEmpty((Object)each.getPriPicUrl())) {
                        bo.setSkuPicUrl(each.getPriPicUrl());
                    } else {
                        bo.setSkuPicUrl(each.getCommdPicUrl());
                    }
                    reslut.add(bo);
                }
                rspBO.setRows(reslut);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

