/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.ability.api.UccSpuItemSpecInfodetailsAbilityService;
import com.tydic.commodity.bo.ability.UccMallFilterSkuSpecBO;
import com.tydic.commodity.bo.ability.UccMallSkuSpecListBo;
import com.tydic.commodity.bo.ability.UccMallSkuSpecPropValueListBo;
import com.tydic.commodity.bo.ability.UccSpuItemSpecInfodetailsAbilityReqBO;
import com.tydic.commodity.bo.ability.UccSpuItemSpecInfodetailsAbilityRspBO;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccSpuItemSpecInfodetailsAbilityService.class)
public class UccSpuItemSpecInfodetailsAbilityServiceImpl
implements UccSpuItemSpecInfodetailsAbilityService {
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;

    public UccSpuItemSpecInfodetailsAbilityRspBO dealItemSpecInfo(UccSpuItemSpecInfodetailsAbilityReqBO reqBO) {
        UccSpuItemSpecInfodetailsAbilityRspBO rspBO = new UccSpuItemSpecInfodetailsAbilityRspBO();
        if (reqBO == null || reqBO.getCommodityId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u67e5\u8be2\u6570\u636e\u5185\u5bb9");
            return rspBO;
        }
        ArrayList<Long> commodityPropDefIds = new ArrayList<Long>();
        ArrayList<Long> propValueListIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getQryInfoList())) {
            reqBO.getQryInfoList().stream().forEach(item -> {
                commodityPropDefIds.add(item.getCommodityPropDefId());
                propValueListIds.add(item.getPropValueListId());
            });
        }
        if (commodityPropDefIds.size() != propValueListIds.size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7b5b\u9009\u5185\u5bb9\u4e0d\u5339\u914d");
            return rspBO;
        }
        List<UccMallFilterSkuSpecBO> filterSkuSpecBOList = this.uccSkuSpecMapper.filterSkuSpec(reqBO.getCommodityId(), commodityPropDefIds, propValueListIds, reqBO.getSkuName());
        if (!CollectionUtils.isEmpty(filterSkuSpecBOList)) {
            Map<Long, List<UccMallFilterSkuSpecBO>> groubyDefId = filterSkuSpecBOList.stream().collect(Collectors.groupingBy(UccMallFilterSkuSpecBO::getCommodityPropDefId));
            Iterator<Map.Entry<Long, List<UccMallFilterSkuSpecBO>>> iterator = groubyDefId.entrySet().iterator();
            ArrayList<UccMallSkuSpecListBo> skuspecList = new ArrayList<UccMallSkuSpecListBo>();
            while (iterator.hasNext()) {
                Map.Entry<Long, List<UccMallFilterSkuSpecBO>> entry = iterator.next();
                UccMallSkuSpecListBo uccSkuSpecListBo = new UccMallSkuSpecListBo();
                uccSkuSpecListBo.setCommodityPropDefId(entry.getKey());
                uccSkuSpecListBo.setPropName(entry.getValue().get(0).getPropName());
                ArrayList<UccMallSkuSpecPropValueListBo> valueListBos = new ArrayList<UccMallSkuSpecPropValueListBo>();
                List mallFilterSkuSpecBOS = entry.getValue().stream().distinct().collect(Collectors.toList());
                for (UccMallFilterSkuSpecBO each : mallFilterSkuSpecBOS) {
                    UccMallSkuSpecPropValueListBo bo = new UccMallSkuSpecPropValueListBo();
                    bo.setPropValueListId(each.getPropValueListId());
                    bo.setPropValue(each.getPropValue());
                    valueListBos.add(bo);
                }
                uccSkuSpecListBo.setSkuSpecList(valueListBos);
                skuspecList.add(uccSkuSpecListBo);
            }
            rspBO.setSkuspecList(skuspecList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

