/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.tydic.commodity.atom.UccMallCatalogCommdNumQryAtomService;
import com.tydic.commodity.atom.bo.UccMallCatalogCommdNumQryRspBO;
import com.tydic.commodity.atom.bo.UccMallsCatalogCommdNumBO;
import com.tydic.commodity.atom.bo.UccMallsCatalogCommdNumQryReqBO;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccMallCatalogDealMapper;
import com.tydic.commodity.dao.UccMallCommodityMapper;
import com.tydic.commodity.dao.UccMallSkuMapper;
import com.tydic.commodity.dao.UccMallSkuStockMapper;
import com.tydic.commodity.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallCatalogCommdNumQryAtomServiceImpl
implements UccMallCatalogCommdNumQryAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallCatalogCommdNumQryAtomServiceImpl.class);
    @Autowired
    private UccMallCatalogDealMapper uccMallCatalogDealMapper;
    @Autowired
    private UccMallCatRCommdTypeMapper uccMallCatRCommdTypeMapper;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSkuStockMapper uccMallSkuStockMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;

    @Override
    public UccMallCatalogCommdNumQryRspBO qryCommdNum(UccMallsCatalogCommdNumQryReqBO reqBO) {
        this.checkReq(reqBO);
        UccMallCatalogCommdNumQryRspBO rspBO = new UccMallCatalogCommdNumQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        ArrayList<UccMallsCatalogCommdNumBO> uccMallsCatalogCommdNumBOList = new ArrayList<UccMallsCatalogCommdNumBO>();
        rspBO.setResult(uccMallsCatalogCommdNumBOList);
        List<SupplierShopPo> supplierShopPos = this.uccMallSupplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isEmpty(supplierShopPos)) {
            rspBO.setRespDesc("\u5546\u6237\u4e0b\u65e0\u5e97\u94fa\u4fe1\u606f");
            return rspBO;
        }
        List<Long> supplierShopIds = supplierShopPos.stream().map(SupplierShopPo::getSupplierShopId).collect(Collectors.toList());
        Map<Long, List<Long>> commodityTypeIdsMap = this.queryCommdTypeIds(reqBO.getCatalogIds());
        for (Map.Entry<Long, List<Long>> each : commodityTypeIdsMap.entrySet()) {
            Long catalogId = each.getKey();
            List<Long> commodityTypeIds = each.getValue();
            UccMallsCatalogCommdNumBO uccMallsCatalogCommdNumBO = new UccMallsCatalogCommdNumBO();
            uccMallsCatalogCommdNumBO.setCatalogId(catalogId);
            uccMallsCatalogCommdNumBO.setCommodityNum(0L);
            uccMallsCatalogCommdNumBO.setSaleItemNum(0L);
            uccMallsCatalogCommdNumBO.setDepotItemNum(0L);
            uccMallsCatalogCommdNumBO.setNotStockCount(0L);
            uccMallsCatalogCommdNumBOList.add(uccMallsCatalogCommdNumBO);
            if (CollectionUtils.isEmpty(commodityTypeIds)) continue;
            Long count = this.uccMallSkuMapper.qryNumsByStatus(null, supplierShopIds, commodityTypeIds);
            uccMallsCatalogCommdNumBO.setCommodityNum(count);
            ArrayList<Integer> status = new ArrayList<Integer>();
            status.add(0);
            status.add(1);
            status.add(2);
            status.add(5);
            status.add(7);
            status.add(10);
            Long depotItemNum = this.uccMallSkuMapper.qryNumsByStatus(status, supplierShopIds, commodityTypeIds);
            uccMallsCatalogCommdNumBO.setDepotItemNum(depotItemNum);
            status = new ArrayList();
            status.add(3);
            Long saleNums = this.uccMallSkuMapper.qryNumsByStatus(status, supplierShopIds, commodityTypeIds);
            uccMallsCatalogCommdNumBO.setSaleItemNum(saleNums);
            Long understockNum = this.uccMallCommodityMapper.qryRemark(reqBO.getSupplierId(), catalogId);
            uccMallsCatalogCommdNumBO.setNotStockCount(understockNum);
        }
        return rspBO;
    }

    public Map<Long, List<Long>> queryCommdTypeIds(List<Long> catalogIds) {
        if (CollectionUtils.isEmpty(catalogIds)) {
            return null;
        }
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        for (int i = 0; i < catalogIds.size(); ++i) {
            try {
                List<Long> commodityTypeIds = this.uccMallCatRCommdTypeMapper.qryCommodityTypeIds(catalogIds.get(i));
                map.put(catalogIds.get(i), commodityTypeIds);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException(RspConstantEnums.COMMODITY_TYPE_NON_EXISTENT.code(), RspConstantEnums.COMMODITY_TYPE_NON_EXISTENT.message());
            }
        }
        return map;
    }

    public void checkReq(UccMallsCatalogCommdNumQryReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getCatalogIds())) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), "\u8bf7\u4f20\u5165\u7c7b\u76eeID");
        }
        if (reqBO.getSupplierId() == null) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), "\u8bf7\u4f20\u5165\u5546\u6237ID");
        }
    }
}

