/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.tydic.commodity.atom.UccMallCatalogSoldNumQryAtomService;
import com.tydic.commodity.atom.UccMallQryCommodityTypeIdsAtomService;
import com.tydic.commodity.atom.bo.UccMallQryCommodityTypeIdsReqBO;
import com.tydic.commodity.atom.bo.UccMallQryCommodityTypeIdsRspBO;
import com.tydic.commodity.atom.bo.UccMallsCatalogSoldNumQryReqBO;
import com.tydic.commodity.atom.bo.UccMallsCatalogSoldNumQryRspBO;
import com.tydic.commodity.atom.bo.UccMallsCommdSoldNum;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallSaleNumMapper;
import com.tydic.commodity.dao.UccMallSkuMapper;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallCatalogSoldNumQryAtomServiceImpl
implements UccMallCatalogSoldNumQryAtomService {
    @Autowired
    private UccMallSaleNumMapper uccMallSaleNumMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallQryCommodityTypeIdsAtomService uccMallQryCommodityTypeIdsAtomService;

    @Override
    public UccMallsCatalogSoldNumQryRspBO qrySoldNum(UccMallsCatalogSoldNumQryReqBO reqBO) {
        UccMallsCatalogSoldNumQryRspBO rspBO = new UccMallsCatalogSoldNumQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBO.getCatalogIds())) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), "\u8bf7\u4f20\u5165\u7c7b\u76eeID");
        }
        UccMallQryCommodityTypeIdsReqBO uccMallQryCommodityTypeIdsReqBO = new UccMallQryCommodityTypeIdsReqBO();
        uccMallQryCommodityTypeIdsReqBO.setCatalogIds(reqBO.getCatalogIds());
        UccMallQryCommodityTypeIdsRspBO uccMallQryCommodityTypeIdsRspBO = this.uccMallQryCommodityTypeIdsAtomService.qryCommodityTypeIds(uccMallQryCommodityTypeIdsReqBO);
        Map<Long, List<Long>> commodityTypeIdMap = uccMallQryCommodityTypeIdsRspBO.getCommodityIds();
        Iterator<Map.Entry<Long, List<Long>>> iterator = commodityTypeIdMap.entrySet().iterator();
        ArrayList<UccMallsCommdSoldNum> uccMallsCommdSoldNums = new ArrayList<UccMallsCommdSoldNum>();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<Long>> each = iterator.next();
            Long catalogId = each.getKey();
            List<Long> commodityTypeIds = each.getValue();
            UccMallsCommdSoldNum uccMallsCommdSoldNum = new UccMallsCommdSoldNum();
            uccMallsCommdSoldNum.setCatalogId(catalogId);
            uccMallsCommdSoldNum.setSoldNum(0L);
            uccMallsCommdSoldNums.add(uccMallsCommdSoldNum);
            List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.querySkuByCommTypeIds(commodityTypeIds);
            if (CollectionUtils.isEmpty(uccSkuPoList)) continue;
            ArrayList<Long> skuIds = new ArrayList<Long>();
            for (UccSkuPo uccSkuPo : uccSkuPoList) {
                skuIds.add(uccSkuPo.getSkuId());
            }
            List<UccSaleNumPo> uccSaleNumPos = this.uccMallSaleNumMapper.qryBySkuIds(skuIds);
            if (CollectionUtils.isEmpty(uccSaleNumPos)) continue;
            BigDecimal soldNum = new BigDecimal(0);
            for (UccSaleNumPo uccSaleNumPo : uccSaleNumPos) {
                soldNum = soldNum.add(uccSaleNumPo.getSoldNumber());
            }
            uccMallsCommdSoldNum.setSoldNum(soldNum.longValue());
        }
        rspBO.setResult(uccMallsCommdSoldNums);
        return rspBO;
    }
}

