/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccMallCommodityAtomService;
import com.tydic.commodity.atom.bo.UccMallBatchUpdateCommodityStatusReqBo;
import com.tydic.commodity.atom.bo.UccMallBatchUpdateSkuStatusReqBO;
import com.tydic.commodity.atom.bo.UccMallsBatchUpdateCommodityStatusRspBO;
import com.tydic.commodity.atom.bo.UccMallsBatchUpdateSkuBO;
import com.tydic.commodity.atom.bo.UccMallsBatchUpdateSkuStatusRspBO;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallCommdQueryDealMapper;
import com.tydic.commodity.dao.UccMallSkuLogMapper;
import com.tydic.commodity.dao.UccMallSkuMapper;
import com.tydic.commodity.dao.UccMallSkuQueryDealMapper;
import com.tydic.commodity.dao.po.UccSkuLogPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuQueryPO;
import com.tydic.commodity.exception.BusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallCommodityAtomServiceImpl
implements UccMallCommodityAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallCommodityAtomServiceImpl.class);
    @Autowired
    private UccMallCommdQueryDealMapper uccMallCommdQueryDealMapper;
    @Autowired
    private UccMallSkuQueryDealMapper skuMapper;
    @Autowired
    private UccMallSkuLogMapper uccMallSkuLogMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @Override
    public UccMallsBatchUpdateCommodityStatusRspBO batchUpdateCommodityByCommodityId(UccMallBatchUpdateCommodityStatusReqBo reqBo) {
        UccMallsBatchUpdateCommodityStatusRspBO uccMallsBatchUpdateCommodityStatusRspBO = new UccMallsBatchUpdateCommodityStatusRspBO();
        try {
            this.uccMallCommdQueryDealMapper.batchUpdateCommodityByCommodityId(reqBo.getBoList(), reqBo.getSupplierShopId());
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException(RspConstantEnums.UPDATE_COMMODITY_STATUS_FAIL.code(), "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5f02\u5e38");
        }
        uccMallsBatchUpdateCommodityStatusRspBO.setRespCode("0000");
        uccMallsBatchUpdateCommodityStatusRspBO.setRespDesc("\u6210\u529f");
        return uccMallsBatchUpdateCommodityStatusRspBO;
    }

    @Override
    public UccMallsBatchUpdateSkuStatusRspBO batchUpdateSkuInStatusByCommodityId(UccMallBatchUpdateSkuStatusReqBO reqBO) {
        UccMallsBatchUpdateSkuStatusRspBO uccMallsBatchUpdateSkuStatusRspBO = new UccMallsBatchUpdateSkuStatusRspBO();
        try {
            List<UccMallsBatchUpdateSkuBO> uccMallsBatchUpdateSkuBOList = reqBO.getBoList();
            for (UccMallsBatchUpdateSkuBO uccMallsBatchUpdateSkuBO : uccMallsBatchUpdateSkuBOList) {
                List<UccSkuQueryPO> skuQueryPO = this.skuMapper.selectSkuInfoByCommodityId(uccMallsBatchUpdateSkuBO.getCommodityId());
                UccSkuPo queryUccSkuPo = new UccSkuPo();
                for (UccSkuQueryPO SkuPo : skuQueryPO) {
                    Long batchId = this.uccBatchSequence.nextId();
                    queryUccSkuPo.setSkuId(SkuPo.getSkuId());
                    List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(queryUccSkuPo);
                    UccSkuPo uccSkuPo = uccSkuPos.get(0);
                    UccSkuLogPo po = new UccSkuLogPo();
                    BeanUtils.copyProperties((Object)uccSkuPo, (Object)po);
                    po.setBatchId(batchId);
                    po.setSkuSource(uccSkuPo.getSkuSource());
                    try {
                        this.uccMallSkuLogMapper.insert(po);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u63d2\u5165\u5355\u54c1\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
                    }
                }
                this.skuMapper.batchUpdateSkuStatusBySkuId(skuQueryPO, reqBO.getStatus(), uccMallsBatchUpdateSkuBO.getSupplierShopId());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("BATCH_UPDATE_SKU_ERROR", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u5931\u8d25");
        }
        uccMallsBatchUpdateSkuStatusRspBO.setRespCode("0000");
        uccMallsBatchUpdateSkuStatusRspBO.setRespDesc("\u6210\u529f");
        return uccMallsBatchUpdateSkuStatusRspBO;
    }

    @Override
    public UccMallsBatchUpdateSkuStatusRspBO batchSkuInStatus(UccMallBatchUpdateSkuStatusReqBO reqBO) {
        UccMallsBatchUpdateSkuStatusRspBO uccMallsBatchUpdateSkuStatusRspBO = new UccMallsBatchUpdateSkuStatusRspBO();
        try {
            List<UccMallsBatchUpdateSkuBO> uccMallsBatchUpdateSkuBOList = reqBO.getBoList();
            for (UccMallsBatchUpdateSkuBO uccMallsBatchUpdateSkuBO : uccMallsBatchUpdateSkuBOList) {
                List<UccSkuQueryPO> skuQueryPO = this.skuMapper.selectSkuInfoByCommodityId(uccMallsBatchUpdateSkuBO.getCommodityId());
                this.skuMapper.batchUpdateSkuStatusBySkuId(skuQueryPO, reqBO.getStatus(), uccMallsBatchUpdateSkuBO.getSupplierShopId());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("BATCH_UPDATE_SKU_ERROR", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u5931\u8d25");
        }
        uccMallsBatchUpdateSkuStatusRspBO.setRespCode("0000");
        uccMallsBatchUpdateSkuStatusRspBO.setRespDesc("\u6210\u529f");
        return uccMallsBatchUpdateSkuStatusRspBO;
    }
}

