/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.tydic.commodity.atom.UccMallGoodsInfoCheckAtomService;
import com.tydic.commodity.atom.bo.UccMallsGoodsInfoCheckAtomReqBO;
import com.tydic.commodity.atom.bo.UccMallsGoodsInfoCheckAtomRspBO;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallGoodsInfoCheckAtomServiceImpl
implements UccMallGoodsInfoCheckAtomService {
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallGoodsInfoCheckAtomServiceImpl.class);

    @Override
    public UccMallsGoodsInfoCheckAtomRspBO dealUccGoodsInfoCheck(UccMallsGoodsInfoCheckAtomReqBO reqBO) {
        UccMallsGoodsInfoCheckAtomRspBO rspBO = new UccMallsGoodsInfoCheckAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getSkuId() == null) {
            rspBO.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5355\u54c1ID");
            return rspBO;
        }
        if (reqBO.getSupplierShopId() == null) {
            rspBO.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5e97\u94faID");
            return rspBO;
        }
        try {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(reqBO.getSkuId());
            uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
            List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isEmpty(uccSkuPos)) {
                rspBO.setRespCode(RspConstantEnums.QUERY_RESULT_IS_EMPTY.code());
                rspBO.setRespDesc("\u5355\u54c1\u4e0d\u5b58\u5728");
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(RspConstantEnums.QUERY_RESULT_IS_EMPTY.code(), "\u67e5\u8be2\u5931\u8d25");
        }
        return rspBO;
    }
}

