/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.tydic.commodity.atom.UccMallQryCommodityTypeIdsAtomService;
import com.tydic.commodity.atom.bo.UccMallQryCommodityTypeIdsReqBO;
import com.tydic.commodity.atom.bo.UccMallQryCommodityTypeIdsRspBO;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccMallCatalogDealMapper;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallQryCommodityTypeIdsAtomServiceImpl
implements UccMallQryCommodityTypeIdsAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallQryCommodityTypeIdsAtomServiceImpl.class);
    @Autowired
    private UccMallCatalogDealMapper uccMallCatalogDealMapper;
    @Autowired
    private UccMallCatRCommdTypeMapper uccMallCatRCommdTypeMapper;

    @Override
    public UccMallQryCommodityTypeIdsRspBO qryCommodityTypeIds(UccMallQryCommodityTypeIdsReqBO reqBO) {
        UccMallQryCommodityTypeIdsRspBO rspBO = new UccMallQryCommodityTypeIdsRspBO();
        List<Long> catalogIds = reqBO.getCatalogIds();
        if (CollectionUtils.isEmpty(catalogIds)) {
            return null;
        }
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        for (int i = 0; i < catalogIds.size(); ++i) {
            List<Object> commodityTypeIds = new ArrayList();
            map.put(catalogIds.get(i), commodityTypeIds);
            try {
                ArrayList<Long> upperCatIds = new ArrayList<Long>();
                upperCatIds.add(catalogIds.get(i));
                List<UccCatalogDealPO> uccCatalogDealPOList = this.uccMallCatalogDealMapper.selectByUpperCatIds(upperCatIds);
                if (CollectionUtils.isEmpty(uccCatalogDealPOList)) continue;
                upperCatIds = new ArrayList();
                for (UccCatalogDealPO uccCatalogDealPO1 : uccCatalogDealPOList) {
                    upperCatIds.add(uccCatalogDealPO1.getGuideCatalogId());
                }
                List<UccCatalogDealPO> uccCatalogDealPOList1 = this.uccMallCatalogDealMapper.selectByUpperCatIds(upperCatIds);
                if (CollectionUtils.isEmpty(uccCatalogDealPOList1)) continue;
                upperCatIds = new ArrayList();
                for (UccCatalogDealPO uccCatalogDealPO1 : uccCatalogDealPOList1) {
                    upperCatIds.add(uccCatalogDealPO1.getGuideCatalogId());
                }
                commodityTypeIds = this.uccMallCatRCommdTypeMapper.queryTypeByGuideCatalogIds(upperCatIds);
                if (!CollectionUtils.isEmpty(commodityTypeIds)) continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException(RspConstantEnums.QUERY_COMMODITY_CATEGORY_IDS_FAIL.code(), RspConstantEnums.QUERY_COMMODITY_CATEGORY_IDS_FAIL.message());
            }
        }
        rspBO.setCommodityIds(map);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

