/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.atom.UccMallStockQryAtomService;
import com.tydic.commodity.atom.bo.UccMallStockQryReqBO;
import com.tydic.commodity.atom.bo.UccMallStockQryRspBO;
import com.tydic.commodity.bo.busi.UccMallsSkuStockBO;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallStockQryAtomServiceImpl
implements UccMallStockQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccMallStockQryAtomServiceImpl.class);
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;

    @Override
    public UccMallStockQryRspBO qrySkuStock(UccMallStockQryReqBO reqBO) {
        HashMap stockMap;
        UccMallStockQryRspBO rspBO;
        block14: {
            rspBO = new UccMallStockQryRspBO();
            if (CollectionUtils.isEmpty(reqBO.getSkuIds())) {
                rspBO.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
                rspBO.setRespDesc("\u5355\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (reqBO.getSupplierShopId() == null) {
                rspBO.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
                rspBO.setRespDesc("\u5e97\u94fa\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            stockMap = new HashMap();
            try {
                SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
                smcsdkQryStockNumReqBO.setSkuIds(reqBO.getSkuIds());
                SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
                if ("0000".equals(smcsdkQryStockNumRspBO.getRespCode())) {
                    Map getMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
                    if (getMap != null) {
                        for (Map.Entry each : getMap.entrySet()) {
                            if (each.getValue() != null) {
                                stockMap.put(each.getKey(), MoneyUtils.haoToYuan((Long)((Long)each.getValue())));
                                continue;
                            }
                            stockMap.put(each.getKey(), new BigDecimal("0"));
                        }
                    }
                    break block14;
                }
                log.error("\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
                throw new ZTBusinessException("\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        }
        ArrayList<UccMallsSkuStockBO> uccMallsSkuStockBOS = new ArrayList<UccMallsSkuStockBO>();
        if (!stockMap.isEmpty()) {
            for (Long sku : reqBO.getSkuIds()) {
                UccMallsSkuStockBO uccMallsSkuStockBO = new UccMallsSkuStockBO();
                uccMallsSkuStockBO.setSkuId(sku);
                if (stockMap.containsKey(sku)) {
                    uccMallsSkuStockBO.setStockNum((BigDecimal)stockMap.get(sku));
                    if (uccMallsSkuStockBO.getStockNum().compareTo(new BigDecimal("0")) > 0) {
                        uccMallsSkuStockBO.setStockStatus(Integer.valueOf(0));
                    } else {
                        uccMallsSkuStockBO.setStockStatus(Integer.valueOf(1));
                    }
                } else {
                    uccMallsSkuStockBO.setStockNum(new BigDecimal("0"));
                    uccMallsSkuStockBO.setStockStatus(Integer.valueOf(1));
                }
                uccMallsSkuStockBOS.add(uccMallsSkuStockBO);
            }
        }
        rspBO.setUccSkuStockInfos(uccMallsSkuStockBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

