/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.atom.UccMallAreaAvailableQryAtomService;
import com.tydic.commodity.atom.bo.UccMallsAreaAvailableQryReqBO;
import com.tydic.commodity.atom.bo.UccMallsAreaAvailableQryRspBO;
import com.tydic.commodity.atom.impl.UccMallAvailableCommdQryAtomServiceImpl;
import com.tydic.commodity.bo.busi.UccMallAreaAvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.UccMallAreaAvailableQryBusiReqBO;
import com.tydic.commodity.bo.busi.UccMallAreaAvailableQryBusiRspBO;
import com.tydic.commodity.busi.api.UccMallAreaAvailableQryBusiService;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallSkuMapper;
import com.tydic.commodity.dao.UccMallSupplierMapper;
import com.tydic.commodity.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallAreaAvailableQryBusiService.class)
public class UccMallAreaAvailableQryBusiServiceImpl
implements UccMallAreaAvailableQryBusiService {
    @Autowired
    private UccMallAreaAvailableQryAtomService uccMallAreaAvailableQryAtomService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallAvailableCommdQryAtomServiceImpl.class);

    public UccMallAreaAvailableQryBusiRspBO qryUccAreaAvailable(UccMallAreaAvailableQryBusiReqBO reqBO) {
        String supplierCode;
        Long supplierId;
        UccMallAreaAvailableQryBusiRspBO rspBO = new UccMallAreaAvailableQryBusiRspBO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc(s);
            return rspBO;
        }
        try {
            SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId());
            if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
                rspBO.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode(RspConstantEnums.STORE_QUERY_FAILED.code());
                return rspBO;
            }
            supplierId = supplierShopPo.getSupplierId();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(RspConstantEnums.STORE_QUERY_FAILED.code(), RspConstantEnums.STORE_QUERY_FAILED.message());
        }
        try {
            SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId);
            if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
                rspBO.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode(RspConstantEnums.SUPPLIER_CODE_QUERY_FAIL.code());
                return rspBO;
            }
            supplierCode = supplierBusiPo.getSupplierCode();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(RspConstantEnums.SUPPLIER_CODE_QUERY_FAIL.code(), RspConstantEnums.SUPPLIER_CODE_QUERY_FAIL.message());
        }
        ArrayList<String> extSkuIds = new ArrayList<String>();
        try {
            for (Long skuId : reqBO.getSkuIds()) {
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPo.setSkuId(skuId);
                List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
                if (uccSkuPoList == null || uccSkuPoList.size() != 1) {
                    rspBO.setRespDesc("\u5355\u54c1\u4e0d\u5b58\u5728\u6216\u4e0d\u552f\u4e00");
                    rspBO.setRespCode(RspConstantEnums.SKU_NOT_UNIQUE.code());
                    return rspBO;
                }
                String extSkuId = uccSkuPoList.get(0).getExtSkuId();
                if (StringUtils.isEmpty((CharSequence)extSkuId)) {
                    rspBO.setRespDesc("\u5916\u90e8\u5355\u54c1ID\u4e3a\u7a7a");
                    rspBO.setRespCode(RspConstantEnums.SKU_NOT_UNIQUE.code());
                    return rspBO;
                }
                extSkuIds.add(extSkuId);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        try {
            List<UccMallAreaAvailableCommdBO_busi> uccMallAreaAvailableCommdBO_busis;
            UccMallsAreaAvailableQryReqBO uccMallsAreaAvailableQryReqBO = new UccMallsAreaAvailableQryReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccMallsAreaAvailableQryReqBO);
            uccMallsAreaAvailableQryReqBO.setSupplierCode(supplierCode);
            uccMallsAreaAvailableQryReqBO.setSkuIds(extSkuIds);
            UccMallsAreaAvailableQryRspBO uccMallsAreaAvailableQryRspBO = this.uccMallAreaAvailableQryAtomService.qryAreaAvailableCommd(uccMallsAreaAvailableQryReqBO);
            BeanUtils.copyProperties((Object)((Object)uccMallsAreaAvailableQryRspBO), (Object)rspBO);
            if (uccMallsAreaAvailableQryRspBO.getAreaAvailableCommdInfos() != null && (uccMallAreaAvailableCommdBO_busis = uccMallsAreaAvailableQryRspBO.getAreaAvailableCommdInfos()).size() > 0) {
                ArrayList<UccMallAreaAvailableCommdBO_busi> uccMallAreaAvailableCommdBO_busis1 = new ArrayList<UccMallAreaAvailableCommdBO_busi>();
                for (UccMallAreaAvailableCommdBO_busi uccMallAreaAvailableCommdBO_busi : uccMallAreaAvailableCommdBO_busis) {
                    if (!StringUtils.isNotEmpty((CharSequence)uccMallAreaAvailableCommdBO_busi.getSkuId())) continue;
                    UccSkuPo uccSkuPo = new UccSkuPo();
                    uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
                    uccSkuPo.setExtSkuId(uccMallAreaAvailableCommdBO_busi.getSkuId());
                    List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
                    if (uccSkuPoList == null || uccSkuPoList.size() != 1) {
                        rspBO.setRespDesc("\u5916\u90e8\u5355\u54c1\u4e0d\u5b58\u5728\u6216\u4e0d\u552f\u4e00");
                        rspBO.setRespCode(RspConstantEnums.SKU_NOT_UNIQUE.code());
                        return rspBO;
                    }
                    Long skuId = uccSkuPoList.get(0).getSkuId();
                    if (skuId == null) {
                        rspBO.setRespDesc("\u5355\u54c1ID\u4e3a\u7a7a");
                        rspBO.setRespCode(RspConstantEnums.SKU_NOT_UNIQUE.code());
                        return rspBO;
                    }
                    UccMallAreaAvailableCommdBO_busi uccMallAreaAvailableCommdBO_busi1 = new UccMallAreaAvailableCommdBO_busi();
                    BeanUtils.copyProperties((Object)uccMallAreaAvailableCommdBO_busi, (Object)uccMallAreaAvailableCommdBO_busi1);
                    uccMallAreaAvailableCommdBO_busi1.setSkuId(skuId.toString());
                    uccMallAreaAvailableCommdBO_busis1.add(uccMallAreaAvailableCommdBO_busi1);
                }
                rspBO.setAreaAvailableCommdInfos(uccMallAreaAvailableCommdBO_busis1);
            }
            return rspBO;
        }
        catch (BusinessException e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(e.getMsgCode(), e.getMsgInfo());
        }
    }

    public String judge(UccMallAreaAvailableQryBusiReqBO reqBO) {
        String s = "";
        if (reqBO.getSkuIds() == null || reqBO.getSkuIds().size() == 0) {
            s = "\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getSupplierShopId() == null) {
            s = "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return s;
    }
}

