/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccMallCommodityAtomService;
import com.tydic.commodity.atom.bo.UccMallBatchUpdateCommodityStatusReqBo;
import com.tydic.commodity.atom.bo.UccMallBatchUpdateSkuStatusReqBO;
import com.tydic.commodity.atom.bo.UccMallsBatchUpdateCommodityBO;
import com.tydic.commodity.atom.bo.UccMallsBatchUpdateSkuBO;
import com.tydic.commodity.bo.RspUccBo;
import com.tydic.commodity.bo.busi.UccMallBatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.bo.busi.UccMallCommodityBo;
import com.tydic.commodity.bo.busi.UccMallSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.busi.api.UccMallBatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.businessenums.BusinessRsponseEnums;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallCommodityLogMapper;
import com.tydic.commodity.dao.UccMallCommodityMapper;
import com.tydic.commodity.dao.UccMallSkuLogMapper;
import com.tydic.commodity.dao.UccMallSkuMapper;
import com.tydic.commodity.dao.po.UccCommodityLogPO;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccJoinQuerySkusPo;
import com.tydic.commodity.dao.po.UccSkuLogPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.validate.UccMallValidatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallBatchUpdateCommoStatusForMarketService.class)
public class UccMallBatchUpdateCommoStatusForMarketServiceImpl
implements UccMallBatchUpdateCommoStatusForMarketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallBatchUpdateCommoStatusForMarketServiceImpl.class);
    @Autowired
    private UccMallCommodityAtomService uccMallCommodityAtomService;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallCommodityLogMapper uccMallCommodityLogMapper;
    @Autowired
    private UccMallSkuMapper skuMapper;
    @Autowired
    private UccMallSkuLogMapper uccMallSkuLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Resource(name="uccMalllmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer uccMalllmSyncCommodityMqServiceProvider;

    public RspUccBo batchUpdateCommoStatusForMarket(UccMallBatchUpdateCommoStatusForMarketBO statusForMarketBO, CommodityStatusEnum commodityStatusEnum, SkuStatusEnum skuStatusEnum) {
        UccMallValidatorUtil.validator((Object)statusForMarketBO);
        if (statusForMarketBO.getBusinessId() == null || statusForMarketBO.getBusinessId().length == 0) {
            throw new BusinessException(BusinessRsponseEnums.PARAMETER_ERROR.code(), "\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object batchId = null;
        ArrayList uccCommodityLogPOS = Lists.newArrayList();
        ArrayList uccMallsBatchUpdateSkuBOS = Lists.newArrayList();
        ArrayList uccMallsBatchUpdateCommodityBOS = Lists.newArrayList();
        UccMallBatchUpdateSkuStatusReqBO uccMallBatchUpdateSkuStatusReqBO = new UccMallBatchUpdateSkuStatusReqBO();
        UccMallBatchUpdateCommodityStatusReqBo commodityStatusReqBo = new UccMallBatchUpdateCommodityStatusReqBo();
        long[] sequence = new long[statusForMarketBO.getBusinessId().length];
        sequence = this.uccBatchSequence.nextIds(statusForMarketBO.getBusinessId().length);
        for (int i = 0; i < statusForMarketBO.getBusinessId().length; ++i) {
            UccCommodityPo uccCommodityPo = this.uccMallCommodityMapper.getCommodityById(statusForMarketBO.getBusinessId()[i]);
            if (uccCommodityPo == null) continue;
            if (commodityStatusEnum != null) {
                UccCommodityLogPO uccCommodityLogPO = new UccCommodityLogPO();
                BeanUtils.copyProperties((Object)uccCommodityPo, (Object)uccCommodityLogPO);
                uccCommodityLogPO.setBatchId(sequence[i]);
                uccCommodityLogPO.setAduitResult(statusForMarketBO.getReason());
                uccCommodityLogPOS.add(uccCommodityLogPO);
                UccMallsBatchUpdateCommodityBO uccMallsBatchUpdateCommodityBO = new UccMallsBatchUpdateCommodityBO();
                uccMallsBatchUpdateCommodityBO.setCommodityId(uccCommodityPo.getCommodityId());
                uccMallsBatchUpdateCommodityBO.setStatus(commodityStatusEnum.getStatus());
                commodityStatusReqBo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
                uccMallsBatchUpdateCommodityBOS.add(uccMallsBatchUpdateCommodityBO);
            }
            if (skuStatusEnum == null) continue;
            UccMallsBatchUpdateSkuBO uccMallsBatchUpdateSkuBO = new UccMallsBatchUpdateSkuBO();
            uccMallsBatchUpdateSkuBO.setCommodityId(statusForMarketBO.getBusinessId()[i]);
            uccMallsBatchUpdateSkuBO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
            uccMallsBatchUpdateSkuBO.setStatus(skuStatusEnum.getStatus());
            uccMallsBatchUpdateSkuBOS.add(uccMallsBatchUpdateSkuBO);
        }
        if (skuStatusEnum != null) {
            UccJoinQuerySkusPo uccJoinQuerySkusPo = new UccJoinQuerySkusPo();
            uccJoinQuerySkusPo.setCommodityIdArrays(statusForMarketBO.getBusinessId());
            List<UccSkuPo> skuPos = this.skuMapper.queryJoinSkuByCommodityId(uccJoinQuerySkusPo);
            List<UccSkuLogPo> UccSkuLogPo2 = this.cloneUccSkuPo(skuPos);
            uccMallBatchUpdateSkuStatusReqBO.setStatus(skuStatusEnum.getStatus());
            uccMallBatchUpdateSkuStatusReqBO.setBoList(uccMallsBatchUpdateSkuBOS);
            this.processUpdateSkuAndLog(uccMallBatchUpdateSkuStatusReqBO, UccSkuLogPo2);
        }
        if (commodityStatusEnum != null) {
            commodityStatusReqBo.setBoList(uccMallsBatchUpdateCommodityBOS);
            this.processUpdateCommodityAndLog(commodityStatusReqBo, uccCommodityLogPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)uccMallsBatchUpdateSkuBOS)) {
            UccMallSyncSceneCommodityToEsReqBO uccMallSyncSceneCommodityToEsReqBO = new UccMallSyncSceneCommodityToEsReqBO();
            uccMallSyncSceneCommodityToEsReqBO.setCommodityIds(uccMallsBatchUpdateSkuBOS.stream().map(UccMallsBatchUpdateSkuBO::getCommodityId).collect(Collectors.toList()));
            uccMallSyncSceneCommodityToEsReqBO.setSupplierId(((UccMallsBatchUpdateSkuBO)uccMallsBatchUpdateSkuBOS.get(0)).getSupplierShopId());
            uccMallSyncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
            uccMallSyncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            uccMallSyncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
            this.uccMalllmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)uccMallSyncSceneCommodityToEsReqBO)));
        }
        LOGGER.info("\u5904\u7406\u5546\u54c1\u5355\u54c1\u72b6\u6001\u5b8c\u6210");
        RspUccBo rspUccBo = new RspUccBo();
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        return rspUccBo;
    }

    public void updateCommoApprovalStatus(UccMallCommodityBo uccMallCommodityBo, AuditResultStatusEnum auditResultStatusEnum) {
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityId(uccMallCommodityBo.getCommodityId());
        uccCommodityPo.setApprovalStatus(uccMallCommodityBo.getApprovalStatus());
        uccCommodityPo.setSupplierShopId(uccMallCommodityBo.getSupplierShopId());
        this.uccMallCommodityMapper.updateCommodity(uccCommodityPo);
    }

    private void processUpdateCommodityAndLog(UccMallBatchUpdateCommodityStatusReqBo reqBO, List<UccCommodityLogPO> commodityLogPOS) {
        try {
            if (CollectionUtils.isNotEmpty(commodityLogPOS)) {
                this.uccMallCommodityLogMapper.batchInsert(commodityLogPOS);
            }
            this.uccMallCommodityAtomService.batchUpdateCommodityByCommodityId(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException(RspConstantEnums.UPDATE_COMMODITY_STATUS_FAIL.code(), "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private void processUpdateSkuAndLog(UccMallBatchUpdateSkuStatusReqBO reqBO, List<UccSkuLogPo> uccSkuLogPos) {
        try {
            if (CollectionUtils.isNotEmpty(uccSkuLogPos)) {
                this.uccMallSkuLogMapper.addSkuLog(uccSkuLogPos);
            }
            this.uccMallCommodityAtomService.batchSkuInStatus(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException(RspConstantEnums.UPDATE_COMMODITY_STATUS_FAIL.code(), "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private List<UccSkuLogPo> cloneUccSkuPo(List<UccSkuPo> skuPos) {
        ArrayList uccSkuLogPos = Lists.newArrayList();
        for (UccSkuPo skuPo : skuPos) {
            Long batchId = this.uccBatchSequence.nextId();
            UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
            uccSkuLogPo.setBatchId(batchId);
            BeanUtils.copyProperties((Object)skuPo, (Object)uccSkuLogPo);
            uccSkuLogPos.add(uccSkuLogPo);
        }
        return uccSkuLogPos;
    }
}

