/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccMallDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccMallChannelDateBO;
import com.tydic.commodity.bo.busi.UccMallChannelSelectReqBO;
import com.tydic.commodity.bo.busi.UccMallChannelSelectRspBO;
import com.tydic.commodity.busi.api.UccMallChannelSelectBusiService;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallChannelDealMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccChannelDealPO;
import com.tydic.commodity.enumType.Channel;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallChannelSelectBusiService.class)
public class UccMallChannelSelectBusiServiceImpl
implements UccMallChannelSelectBusiService {
    @Autowired
    private UccMallChannelDealMapper mapper;
    @Autowired
    private UccMallDictionaryAtomService uccMallDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallChannelSelectBusiServiceImpl.class);
    UccMallChannelSelectRspBO rspBO = new UccMallChannelSelectRspBO();

    public UccMallChannelSelectRspBO selectChannel(UccMallChannelSelectReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
            return this.rspBO;
        }
        this.rspBO = new UccMallChannelSelectRspBO();
        UccChannelDealPO channelDealPO = new UccChannelDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)channelDealPO);
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        List<UccChannelDealPO> result = null;
        try {
            result = this.mapper.selectChannel(channelDealPO, page);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u6570\u636e\u5e93\u67e5\u8be2\u5f02\u5e38");
        }
        if (result != null && result.size() > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u9891\u9053\u4fe1\u606f\u6210\u529f");
            ArrayList<UccMallChannelDateBO> dataList = new ArrayList<UccMallChannelDateBO>();
            DicDictionaryPo dicDictionaryPo = null;
            UccMallChannelDateBO result1 = null;
            for (UccChannelDealPO po : result) {
                result1 = new UccMallChannelDateBO();
                BeanUtils.copyProperties((Object)po, (Object)result1);
                dicDictionaryPo = this.uccMallDictionaryAtomService.queryByCodeAndPcode(String.valueOf(po.getChannelStatus()), Channel.CHANNEL_STATUS.toString());
                if (dicDictionaryPo != null) {
                    result1.setChannelStatusTranslation(dicDictionaryPo.getTitle());
                }
                dataList.add(result1);
            }
            this.rspBO.setPageNo(page.getPageNo());
            this.rspBO.setRecordsTotal(page.getTotalCount());
            this.rspBO.setTotal(page.getTotalPages());
            this.rspBO.setRows(dataList);
        } else {
            this.rspBO.setRows(null);
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u9891\u9053\u4fe1\u606f\u6210\u529f");
        }
        return this.rspBO;
    }

    public boolean judge(UccMallChannelSelectReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getChannelStatus() != null && !(map = this.uccMallDictionaryAtomService.queryBypCodeBackMap(Channel.CHANNEL_STATUS.toString())).containsKey(String.valueOf(reqBO.getChannelStatus()))) {
            this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u72b6\u6001");
            return false;
        }
        return true;
    }
}

