/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.atom.UccMallCurrentStockQryAtomService;
import com.tydic.commodity.atom.UccMallStockQryAtomService;
import com.tydic.commodity.atom.bo.UccMallStockQryReqBO;
import com.tydic.commodity.atom.bo.UccMallStockQryRspBO;
import com.tydic.commodity.atom.bo.UccMallsCurrentStockQryReqBO;
import com.tydic.commodity.atom.bo.UccMallsCurrentStockQryRspBO;
import com.tydic.commodity.atom.bo.UccMallsSkuNumBO_Atom;
import com.tydic.commodity.bo.busi.UccMallCommdStockBO_busi;
import com.tydic.commodity.bo.busi.UccMallCurrentStockQryReqBO;
import com.tydic.commodity.bo.busi.UccMallCurrentStockQryRspBO;
import com.tydic.commodity.bo.busi.UccMallSkuNumBO_busi;
import com.tydic.commodity.bo.busi.UccMallsSkuStockBO;
import com.tydic.commodity.busi.api.UccMallCommdStockQryBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallCommodityMapper;
import com.tydic.commodity.dao.UccMallSkuMapper;
import com.tydic.commodity.dao.UccMallSkuStockMapper;
import com.tydic.commodity.dao.UccMallSupplierMapper;
import com.tydic.commodity.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.dao.UccMallVendorMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.SkuSourceEnum;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallCommdStockQryBusiService.class)
public class UccMallCommdStockQryBusiServiceImpl
implements UccMallCommdStockQryBusiService {
    @Autowired
    private UccMallCurrentStockQryAtomService uccMallCurrentStockQryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallCommdStockQryBusiServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallStockQryAtomService uccMallStockQryAtomService;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallVendorMapper uccMallVendorMapper;
    @Autowired
    private UccMallSkuStockMapper uccMallSkuStockMapper;

    public UccMallCurrentStockQryRspBO qryStock(UccMallCurrentStockQryReqBO reqBO) {
        Object uccCommodityPos;
        Long supplierId;
        UccMallCurrentStockQryRspBO rspBO = new UccMallCurrentStockQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<Object> uccMallCommdStockBO_busis1 = new ArrayList<Object>();
        rspBO.setCommdStockInfo(uccMallCommdStockBO_busis1);
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespDesc(s);
            rspBO.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
            return rspBO;
        }
        String supplierCode = "";
        try {
            SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId());
            if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
                rspBO.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode(RspConstantEnums.STORE_QUERY_FAILED.code());
                return rspBO;
            }
            supplierId = supplierShopPo.getSupplierId();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        try {
            SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId);
            if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
                rspBO.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode(RspConstantEnums.SUPPLIER_CODE_QUERY_FAIL.code());
                return rspBO;
            }
            supplierCode = supplierBusiPo.getSupplierCode();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(RspConstantEnums.SUPPLIER_CODE_QUERY_FAIL.code(), RspConstantEnums.SUPPLIER_CODE_QUERY_FAIL.message());
        }
        HashMap tm = new HashMap();
        HashMap<String, Long> extSkuAndSku = new HashMap<String, Long>();
        List<Long> reqSkuList = reqBO.getSkuNum().stream().map(UccMallSkuNumBO_busi::getSkuId).collect(Collectors.toList());
        List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.batchQrySku(reqSkuList, reqBO.getSupplierShopId());
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            return rspBO;
        }
        ArrayList<UccSkuPo> uccSkuPoList = new ArrayList<UccSkuPo>();
        for (UccSkuPo uccSkuPo : uccSkuPos) {
            extSkuAndSku.put(uccSkuPo.getExtSkuId(), uccSkuPo.getSkuId());
            if (!ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(uccSkuPo.getSkuStatus())) {
                UccMallCommdStockBO_busi bo = new UccMallCommdStockBO_busi();
                bo.setSkuId(uccSkuPo.getSkuId().toString());
                bo.setStockStateId(Integer.valueOf(34));
                bo.setStockStateDesc("\u65e0\u8d27");
                bo.setRemainNum(Integer.valueOf(0));
                uccMallCommdStockBO_busis1.add(bo);
                continue;
            }
            uccSkuPoList.add(uccSkuPo);
        }
        if (CollectionUtils.isEmpty(uccSkuPoList)) {
            return rspBO;
        }
        ArrayList<UccMallsSkuNumBO_Atom> uccMallsSkuNumBO_atoms = new ArrayList<UccMallsSkuNumBO_Atom>();
        ArrayList<UccSkuPo> proprietarySkus = new ArrayList<UccSkuPo>();
        for (UccSkuPo uccSkuPo : uccSkuPoList) {
            if (SkuSourceEnum.ELECTRONIC_SUPERMARKET_SOURCE.getSource() == uccSkuPo.getSkuSource()) {
                UccMallsSkuNumBO_Atom uccMallsSkuNumBO_atom = new UccMallsSkuNumBO_Atom();
                uccMallsSkuNumBO_atom.setSkuId(uccSkuPo.getExtSkuId());
                for (UccMallSkuNumBO_busi uccMallSkuNumBO_busi : reqBO.getSkuNum()) {
                    if (!uccSkuPo.getSkuId().equals(uccMallSkuNumBO_busi.getSkuId())) continue;
                    uccMallsSkuNumBO_atom.setNum(uccMallSkuNumBO_busi.getNum());
                }
                uccMallsSkuNumBO_atoms.add(uccMallsSkuNumBO_atom);
                continue;
            }
            if (SkuSourceEnum.PROPRIETARY_SKU_SOURCE.getSource() == uccSkuPo.getSkuSource()) {
                proprietarySkus.add(uccSkuPo);
                continue;
            }
            if (SkuSourceEnum.AGREEMENT_SOURCE.getSource() != uccSkuPo.getSkuSource()) continue;
            proprietarySkus.add(uccSkuPo);
        }
        List<Long> tianMaoCommd = new ArrayList<Long>();
        Object groupByCommdId = new HashedMap();
        if (!CollectionUtils.isEmpty(proprietarySkus)) {
            groupByCommdId = proprietarySkus.stream().collect(Collectors.groupingBy(UccSkuPo::getCommodityId));
            List<Long> commodityIds = proprietarySkus.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
            tianMaoCommd = this.uccMallCommodityMapper.qryTypeByVendor(commodityIds, reqBO.getSupplierShopId());
        }
        ArrayList localSku = new ArrayList();
        proprietarySkus = new ArrayList();
        for (Map.Entry entry : groupByCommdId.entrySet()) {
            if (!tianMaoCommd.contains(entry.getKey())) {
                localSku.addAll((Collection)entry.getValue());
                continue;
            }
            proprietarySkus.addAll((Collection)entry.getValue());
        }
        if (!CollectionUtils.isEmpty(tianMaoCommd) && CollectionUtils.isNotEmpty(uccCommodityPos = this.uccMallCommodityMapper.batchQryCommd(tianMaoCommd, reqBO.getSupplierShopId()))) {
            Iterator<UccCommodityPo> iterator = uccCommodityPos.iterator();
            while (iterator.hasNext()) {
                UccCommodityPo uccCommodityPo = iterator.next();
                for (UccSkuPo uccSkuPo : proprietarySkus) {
                    ArrayList<String> skuExt;
                    if (!uccSkuPo.getCommodityId().equals(uccCommodityPo.getCommodityId())) continue;
                    if (uccSkuPo.getExtSkuId().equals(uccCommodityPo.getExtSpuId())) {
                        if (tm.containsKey(uccCommodityPo.getExtSpuId())) {
                            ((List)tm.get(uccCommodityPo.getExtSpuId())).add("-1");
                            continue;
                        }
                        skuExt = new ArrayList<String>();
                        skuExt.add("-1");
                        tm.put(uccCommodityPo.getExtSpuId(), skuExt);
                        continue;
                    }
                    if (tm.containsKey(uccCommodityPo.getExtSpuId())) {
                        ((List)tm.get(uccCommodityPo.getExtSpuId())).add(uccSkuPo.getExtSkuId());
                        continue;
                    }
                    skuExt = new ArrayList();
                    skuExt.add(uccSkuPo.getExtSkuId());
                    tm.put(uccCommodityPo.getExtSpuId(), skuExt);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(uccMallsSkuNumBO_atoms)) {
            if (reqBO.getProvince() == null || reqBO.getCity() == null || reqBO.getCounty() == null) {
                rspBO.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
                rspBO.setRespDesc("\u8bf7\u8f93\u5165\u5b8c\u6574\u5730\u5740");
                return rspBO;
            }
            for (UccMallSkuNumBO_busi uccMallSkuNumBO_busi : reqBO.getSkuNum()) {
                if (uccMallSkuNumBO_busi.getSkuId() == null) {
                    throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), "\u8bf7\u8f93\u5165\u5355\u54c1ID");
                }
                if (uccMallSkuNumBO_busi.getNum() != null) continue;
                throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), "\u8bf7\u8f93\u5165\u5e93\u5b58\u6570\u91cf");
            }
            UccMallsCurrentStockQryReqBO uccMallsCurrentStockQryReqBO = new UccMallsCurrentStockQryReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccMallsCurrentStockQryReqBO);
            uccMallsCurrentStockQryReqBO.setSkuNum(uccMallsSkuNumBO_atoms);
            uccMallsCurrentStockQryReqBO.setSupplierCode(supplierCode);
            UccMallsCurrentStockQryRspBO uccMallsCurrentStockQryRspBO = this.uccMallCurrentStockQryAtomService.qryCommdCurrentStock(uccMallsCurrentStockQryReqBO);
            if (!"0000".equals(uccMallsCurrentStockQryRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)((Object)uccMallsCurrentStockQryRspBO), (Object)rspBO);
                return rspBO;
            }
            BeanUtils.copyProperties((Object)((Object)uccMallsCurrentStockQryRspBO), (Object)rspBO);
            List<UccMallCommdStockBO_busi> uccMallCommdStockBO_busis = uccMallsCurrentStockQryRspBO.getCommdStockInfo();
            for (UccMallCommdStockBO_busi uccMallCommdStockBO_busi : uccMallCommdStockBO_busis) {
                UccMallCommdStockBO_busi uccMallCommdStockBO_busi1 = new UccMallCommdStockBO_busi();
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPo.setExtSkuId(uccMallCommdStockBO_busi.getSkuId());
                List<UccSkuPo> uccSkuPoLists = this.uccMallSkuMapper.qerySku(uccSkuPo);
                if (uccSkuPoLists == null || uccSkuPoLists.size() != 1) continue;
                BeanUtils.copyProperties((Object)uccMallCommdStockBO_busi, (Object)uccMallCommdStockBO_busi1);
                uccMallCommdStockBO_busi1.setSkuId(uccSkuPoLists.get(0).getSkuId().toString());
                uccMallCommdStockBO_busis1.add(uccMallCommdStockBO_busi1);
            }
        }
        ArrayList<UccMallCommdStockBO_busi> uccMallCommdStockBO_busis = new ArrayList<UccMallCommdStockBO_busi>();
        if (CollectionUtils.isNotEmpty(localSku)) {
            List<Long> list = localSku.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            UccMallStockQryReqBO uccMallStockQryReqBO = new UccMallStockQryReqBO();
            uccMallStockQryReqBO.setSkuIds(list);
            uccMallStockQryReqBO.setSupplierShopId(reqBO.getSupplierShopId());
            UccMallStockQryRspBO uccMallStockQryRspBO = this.uccMallStockQryAtomService.qrySkuStock(uccMallStockQryReqBO);
            if (!"0000".equals(uccMallStockQryRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)((Object)uccMallStockQryRspBO), (Object)rspBO);
                return rspBO;
            }
            if (CollectionUtils.isNotEmpty(uccMallStockQryRspBO.getUccSkuStockInfos())) {
                for (UccMallsSkuStockBO uccMallsSkuStockBO : uccMallStockQryRspBO.getUccSkuStockInfos()) {
                    UccMallCommdStockBO_busi uccMallCommdStockBO_busi = new UccMallCommdStockBO_busi();
                    uccMallCommdStockBO_busi.setSkuId(uccMallsSkuStockBO.getSkuId().toString());
                    if (uccMallsSkuStockBO.getStockStatus() == 0) {
                        uccMallCommdStockBO_busi.setStockStateId(Integer.valueOf(33));
                        uccMallCommdStockBO_busi.setStockStateDesc("\u6709\u8d27 \u73b0\u8d27-\u4e0b\u5355\u7acb\u5373\u53d1\u8d27");
                    } else {
                        uccMallCommdStockBO_busi.setStockStateId(Integer.valueOf(34));
                        uccMallCommdStockBO_busi.setStockStateDesc("\u65e0\u8d27");
                    }
                    uccMallCommdStockBO_busi.setRemainNum(Integer.valueOf(uccMallsSkuStockBO.getStockNum().intValue()));
                    StringBuffer areaId = new StringBuffer();
                    areaId.append(reqBO.getProvince()).append("_").append(reqBO.getCity()).append("_").append(reqBO.getCounty()).append("_").append(reqBO.getTown());
                    uccMallCommdStockBO_busi.setAreaId(areaId.toString());
                    uccMallCommdStockBO_busis.add(uccMallCommdStockBO_busi);
                }
                uccMallCommdStockBO_busis1.addAll(uccMallCommdStockBO_busis);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (reqBO.getProvince() != null) {
            stringBuffer.append(reqBO.getProvince());
        }
        if (reqBO.getCity() != null) {
            stringBuffer.append(reqBO.getCity());
        }
        if (reqBO.getCounty() != null) {
            stringBuffer.append(reqBO.getCounty());
        }
        if (reqBO.getTown() != null) {
            stringBuffer.append(reqBO.getTown());
        }
        if (!tm.isEmpty() && StringUtils.isEmpty((Object)stringBuffer.toString())) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), "\u8bf7\u8f93\u5165\u5730\u5740");
        }
        List resultSkuIds = uccMallCommdStockBO_busis1.stream().map(UccMallCommdStockBO_busi::getSkuId).collect(Collectors.toList());
        for (int i = 0; i < reqBO.getSkuNum().size(); ++i) {
            UccMallCommdStockBO_busi uccMallCommdStockBO_busi;
            if (resultSkuIds.contains(((UccMallSkuNumBO_busi)reqBO.getSkuNum().get(i)).getSkuId().toString())) continue;
            uccMallCommdStockBO_busi = new UccMallCommdStockBO_busi();
            uccMallCommdStockBO_busi.setRemainNum(Integer.valueOf(0));
            uccMallCommdStockBO_busi.setAreaId(stringBuffer.toString());
            uccMallCommdStockBO_busi.setSkuId(((UccMallSkuNumBO_busi)reqBO.getSkuNum().get(i)).getSkuId().toString());
            uccMallCommdStockBO_busis1.add(uccMallCommdStockBO_busi);
        }
        rspBO.setCommdStockInfo(uccMallCommdStockBO_busis1);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    public String judge(UccMallCurrentStockQryReqBO reqBO) {
        String s = "";
        if (reqBO.getSupplierShopId() == null) {
            s = "\u8bf7\u8f93\u5165\u5e97\u94faID";
            return s;
        }
        return s;
    }
}

