/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.commodity.ability.api.UccMallSearchBarAnalyzerBusiService;
import com.tydic.commodity.bo.ability.UccMallQueryParam;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsReqBO;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsRspBO;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.bo.busi.TextNormalizationReqBo;
import com.tydic.commodity.bo.busi.TextNormalizationRspBo;
import com.tydic.commodity.bo.busi.UccMallOrderColumBo;
import com.tydic.commodity.bo.busi.UccMallSearchAnalyzerReqBO;
import com.tydic.commodity.bo.busi.UccMallSearchAnalyzerRspBO;
import com.tydic.commodity.busi.api.UccMallSearchAnalyzerBusiService;
import com.tydic.commodity.busi.api.UccSearchTextNormalizationBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.enumType.EnumHelper;
import com.tydic.commodity.enumType.IntentRecognitionServiceEnum;
import com.tydic.commodity.search.UccMallSearchCommodityService;
import com.tydic.commodity.search.bo.UccMallCommodityRspBo;
import com.tydic.commodity.search.bo.UccMallSearchEsReqBO;
import com.tydic.commodity.search.bo.UccMallSearchEsRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallSearchBarAnalyzerBusiServiceImpl
implements UccMallSearchBarAnalyzerBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSearchBarAnalyzerBusiServiceImpl.class);
    @Autowired
    private UccMallSearchCommodityService uccMallSearchCommodityService;
    @Autowired
    private UccMallSearchAnalyzerBusiService uccMallSearchAnalyzerBusiService;
    @Autowired
    private UccSearchTextNormalizationBusiService uccSearchTextNormalizationBusiService;
    @Value(value="${analyzer_counts}")
    private Integer analyzerCounts;
    private static final String HAS = "1";
    private int foreCastSize = 0;
    private String queryStr;
    private String normalQueryStr;

    public UccMallSearchAnalyzerRspBO analyzerSearch(UccMallSearchBarEsReqBO reqBO) {
        this.queryStr = reqBO.getQueryStr();
        UccMallSearchAnalyzerRspBO uccMallSearchBarEsRspBO = new UccMallSearchAnalyzerRspBO();
        TextNormalizationReqBo normalizationReqBo = new TextNormalizationReqBo();
        normalizationReqBo.setQueryStr(reqBO.getQueryStr());
        TextNormalizationRspBo normalizationRspBo = this.uccSearchTextNormalizationBusiService.normalization(normalizationReqBo);
        this.normalQueryStr = normalizationRspBo.getQueryStr();
        this.foreCastSize = normalizationRspBo.getMatchResultMap().size();
        reqBO.setQueryStr(this.normalQueryStr);
        UccMallSearchEsRspBo uccMallSearchEsRspBo = this.queryByMatch(reqBO);
        if (uccMallSearchEsRspBo == null) {
            uccMallSearchBarEsRspBO.setRespCode("0000");
            uccMallSearchBarEsRspBO.setRespDesc("\u6210\u529f");
            uccMallSearchBarEsRspBO.setQueryStr(this.queryStr);
            return uccMallSearchBarEsRspBO;
        }
        if (CollectionUtils.isEmpty((Collection)uccMallSearchEsRspBo.getUccMallCommodityRspBos()) || uccMallSearchEsRspBo.getUccMallCommodityRspBos().size() < 10 && this.queryStr.equals(this.normalQueryStr)) {
            uccMallSearchBarEsRspBO.setRespCode("0000");
            uccMallSearchBarEsRspBO.setRespDesc("\u6210\u529f");
            uccMallSearchBarEsRspBO.setQueryStr(reqBO.getQueryStr());
            return uccMallSearchBarEsRspBO;
        }
        HashMap<String, List<String>> paramsMap = new HashMap<String, List<String>>(16);
        for (Map.Entry entry : normalizationRspBo.getMatchResultMap().entrySet()) {
            IntentRecognitionServiceEnum serviceEnum = IntentRecognitionServiceEnum.getServiceEnum((String)((String)entry.getKey()));
            List<String> params = this.getQueryParams(serviceEnum, (List)entry.getValue(), uccMallSearchEsRspBo.getUccMallQueryParams());
            if (CollectionUtils.isEmpty(params)) continue;
            if (serviceEnum.equals((Object)IntentRecognitionServiceEnum.CATALOG)) {
                for (String param : params) {
                    if (!param.equals(this.normalQueryStr)) continue;
                    paramsMap.put(serviceEnum.name(), params);
                }
                continue;
            }
            paramsMap.put(serviceEnum.name(), params);
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)uccMallSearchBarEsRspBO);
        List uccMallCommodityRspBos = uccMallSearchEsRspBo.getUccMallCommodityRspBos();
        List<UccMallSearchBarEsRspInfo> result = this.convertRspBo(uccMallCommodityRspBos);
        if (CollectionUtils.isEmpty(result)) {
            uccMallSearchBarEsRspBO.setRespCode("0000");
            uccMallSearchBarEsRspBO.setRespDesc("\u6210\u529f");
            uccMallSearchBarEsRspBO.setQueryStr(this.queryStr);
            return uccMallSearchBarEsRspBO;
        }
        return this.constructForeCast(paramsMap, result);
    }

    private UccMallSearchAnalyzerRspBO constructForeCast(Map<String, List<String>> paramsMap, List<UccMallSearchBarEsRspInfo> result) {
        UccMallSearchAnalyzerRspBO uccMallSearchBarEsRspBO = new UccMallSearchAnalyzerRspBO();
        UccMallSearchBarEsRspBO searchBarEsRspBO = new UccMallSearchBarEsRspBO();
        searchBarEsRspBO.setResult(result);
        UccMallSearchAnalyzerReqBO uccMallSearchAnalyzerReqBO = new UccMallSearchAnalyzerReqBO();
        uccMallSearchAnalyzerReqBO.setTokens(this.queryStr);
        uccMallSearchAnalyzerReqBO.setSearchBarEsRspBO(searchBarEsRspBO);
        uccMallSearchAnalyzerReqBO.setParamsMap(paramsMap);
        UccMallSearchAnalyzerRspBO forecastAnalyzerRspBO = this.uccMallSearchAnalyzerBusiService.analyzerSearch(uccMallSearchAnalyzerReqBO);
        HashMap<String, List<String>> paramsTypeMap = new HashMap<String, List<String>>(16);
        if ("0000".equals(forecastAnalyzerRspBO.getRespCode())) {
            int foreCastType = forecastAnalyzerRspBO.getQueryType();
            String bs = this.binary2decimal(foreCastType, this.foreCastSize);
            log.info("\u5339\u914d\u6700\u5927\u7ed3\u679c\u5b57\u7b26\u8868\u8fbe\u5f0f:" + bs);
            for (Map.Entry<String, List<String>> entry : paramsMap.entrySet()) {
                IntentRecognitionServiceEnum serviceEnum = (IntentRecognitionServiceEnum)EnumHelper.getEnum((String)entry.getKey(), IntentRecognitionServiceEnum.class);
                if (!HAS.equals(String.valueOf(bs.charAt(serviceEnum.ordinal())))) continue;
                paramsTypeMap.put(serviceEnum.name(), entry.getValue());
            }
            if (!CollectionUtils.isEmpty((Collection)forecastAnalyzerRspBO.getMatchResultBos())) {
                uccMallSearchBarEsRspBO.setMatchResultBos(forecastAnalyzerRspBO.getMatchResultBos());
            }
        }
        uccMallSearchBarEsRspBO.setQueryStr(this.normalQueryStr);
        uccMallSearchBarEsRspBO.setMatchParams(paramsTypeMap);
        uccMallSearchBarEsRspBO.setRespCode("0000");
        uccMallSearchBarEsRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return uccMallSearchBarEsRspBO;
    }

    public String binary2decimal(int decNum, int digit) {
        String binStr = "";
        for (int i = digit - 1; i >= 0; --i) {
            binStr = binStr + (decNum >> i & 1);
        }
        return binStr;
    }

    private UccMallSearchEsRspBo queryByMatch(UccMallSearchBarEsReqBO reqBO) {
        if (reqBO.getSkuStatus() == null || reqBO.getSkuStatus().size() == 0) {
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF);
            reqBO.setSkuStatus(skuStatus);
        }
        String jsonStr1 = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccMallSearchEsReqBO uccMallSearchEsReqBO = (UccMallSearchEsReqBO)JSON.parseObject((String)jsonStr1, UccMallSearchEsReqBO.class);
        if (reqBO.getSupplierShopId() != null) {
            ArrayList<Long> supplierShopIds = new ArrayList<Long>();
            supplierShopIds.add(reqBO.getSupplierShopId());
            uccMallSearchEsReqBO.setSupplierShopIds(supplierShopIds);
        }
        if (reqBO.getTypeId() != null) {
            uccMallSearchEsReqBO.setTypeId(reqBO.getTypeId());
        }
        if (reqBO.getTypeName() != null) {
            uccMallSearchEsReqBO.setTypeName(reqBO.getTypeName());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderColum())) {
            ArrayList<UccMallOrderColumBo> replae = new ArrayList<UccMallOrderColumBo>();
            for (UccMallOrderColumBo each : reqBO.getOrderColum()) {
                if ("_score".equals(each.getOrderByColumn())) continue;
                replae.add(each);
            }
            uccMallSearchEsReqBO.setOrderColum(replae);
        }
        uccMallSearchEsReqBO.setPageNo(1);
        uccMallSearchEsReqBO.setPageSize(this.analyzerCounts.intValue());
        return this.uccMallSearchCommodityService.queryByMatch(uccMallSearchEsReqBO);
    }

    private List<String> getQueryParams(IntentRecognitionServiceEnum serviceEnum, List<String> matchNames, List<UccMallQueryParam> queryParams) {
        ArrayList<String> paramsNameValues = new ArrayList<String>();
        if (queryParams != null) {
            List<UccMallQueryParam> brandList = queryParams.stream().filter(uccMallQueryParam -> serviceEnum.getParamName().equals(uccMallQueryParam.getFilterId())).collect(Collectors.toList());
            brandList.forEach(uccMallQueryParam -> {
                List filterValues = uccMallQueryParam.getFilterValues();
                for (String filterValue : filterValues) {
                    for (String matchName : matchNames) {
                        if (!filterValue.contains(matchName)) continue;
                        paramsNameValues.add(filterValue);
                    }
                }
            });
        }
        return paramsNameValues;
    }

    private List<UccMallSearchBarEsRspInfo> convertRspBo(List<UccMallCommodityRspBo> uccMallCommodityRspBos) {
        ArrayList<UccMallSearchBarEsRspInfo> uccMallSearchBarEsRspInfos = new ArrayList<UccMallSearchBarEsRspInfo>();
        if (uccMallCommodityRspBos != null && uccMallCommodityRspBos.size() > 0) {
            for (UccMallCommodityRspBo uccMallCommodityRspBo : uccMallCommodityRspBos) {
                UccMallSearchBarEsRspInfo uccMallSearchBarEsRspInfo = new UccMallSearchBarEsRspInfo();
                uccMallSearchBarEsRspInfo.setCommodityId(Long.valueOf(uccMallCommodityRspBo.getCommodity_id()));
                uccMallSearchBarEsRspInfo.setSkuId(Long.valueOf(uccMallCommodityRspBo.getSku_id()));
                uccMallSearchBarEsRspInfo.setExtSkuId(uccMallCommodityRspBo.getExt_sku_id());
                uccMallSearchBarEsRspInfo.setExtendProperties(uccMallCommodityRspBo.getProperties());
                uccMallSearchBarEsRspInfo.setSkuName(uccMallCommodityRspBo.getSku_name());
                uccMallSearchBarEsRspInfo.setCommodityName(uccMallCommodityRspBo.getCommodity_name());
                uccMallSearchBarEsRspInfo.setL3CategoryId(uccMallCommodityRspBo.getL3_category_id());
                uccMallSearchBarEsRspInfo.setL3CategoryName(uccMallCommodityRspBo.getL3_category_name());
                uccMallSearchBarEsRspInfo.setBrandName(uccMallCommodityRspBo.getBrand_name());
                uccMallSearchBarEsRspInfo.setVendorName(uccMallCommodityRspBo.getVendor_name());
                uccMallSearchBarEsRspInfos.add(uccMallSearchBarEsRspInfo);
            }
        }
        return uccMallSearchBarEsRspInfos;
    }
}

