/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.atom.UccMallShufflingPicQryAtomService;
import com.tydic.commodity.atom.bo.UccMallShufflingPicQryReqBO;
import com.tydic.commodity.atom.bo.UccMallShufflingPicQryRspBO;
import com.tydic.commodity.bo.busi.UccMallShufflingPicQryBusiReqBO;
import com.tydic.commodity.bo.busi.UccMallShufflingPicQryBusiRspBO;
import com.tydic.commodity.busi.api.UccMallShufflingPicQryBusiService;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.dao.UccMallSkuMapper;
import com.tydic.commodity.dao.UccMallSupplierMapper;
import com.tydic.commodity.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallShufflingPicQryBusiService.class)
public class UccMallShufflingPicQryBusiServiceImpl
implements UccMallShufflingPicQryBusiService {
    @Autowired
    private UccMallShufflingPicQryAtomService uccMallShufflingPicQryAtomService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;

    public UccMallShufflingPicQryBusiRspBO qryShufflingPic(UccMallShufflingPicQryBusiReqBO reqBo) {
        UccMallShufflingPicQryBusiRspBO rspBo = new UccMallShufflingPicQryBusiRspBO();
        if (null == reqBo || null == reqBo.getSkuId() || null == reqBo.getSupplierShopId()) {
            rspBo.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5355\u54c1ID\u3001\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(reqBo.getSkuId());
        uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
        List<UccSkuPo> skuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isEmpty(skuPoList)) {
            rspBo.setRespCode(RspConstantEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94SKU\u4fe1\u606f");
            return rspBo;
        }
        uccSkuPo = skuPoList.get(0);
        SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId());
        if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
            rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(RspConstantEnums.STORE_QUERY_FAILED.code());
            return rspBo;
        }
        Long supplierId = supplierShopPo.getSupplierId();
        SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId);
        if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
            rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(RspConstantEnums.SUPPLIER_CODE_QUERY_FAIL.code());
            return rspBo;
        }
        String supplierCode = supplierBusiPo.getSupplierCode();
        UccMallShufflingPicQryReqBO uccMallShufflingPicQryReqBo = new UccMallShufflingPicQryReqBO();
        uccMallShufflingPicQryReqBo.setSkuIds(Collections.singletonList(uccSkuPo.getExtSkuId()));
        uccMallShufflingPicQryReqBo.setSupplierCode(supplierCode);
        uccMallShufflingPicQryReqBo.setSupplierId(supplierId);
        UccMallShufflingPicQryRspBO uccMallShufflingPicQryRspBo = null;
        uccMallShufflingPicQryRspBo = this.uccMallShufflingPicQryAtomService.qryShufflingPic(uccMallShufflingPicQryReqBo);
        if (!"0000".equals(uccMallShufflingPicQryRspBo.getRespCode())) {
            rspBo.setRespCode(uccMallShufflingPicQryRspBo.getRespCode());
            rspBo.setRespDesc(uccMallShufflingPicQryRspBo.getRespDesc());
            return rspBo;
        }
        if (!CollectionUtils.isEmpty(uccMallShufflingPicQryRspBo.getCommdShufflingPicInfos())) {
            rspBo.setSku(uccMallShufflingPicQryRspBo.getCommdShufflingPicInfos().get(0).getSku());
            rspBo.setJdCommdPicInfos(uccMallShufflingPicQryRspBo.getCommdShufflingPicInfos().get(0).getJdCommdPicInfos());
            rspBo.setNotJdCommdPicInfo(uccMallShufflingPicQryRspBo.getCommdShufflingPicInfos().get(0).getNotJdCommdPicInfo());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

