/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.ability.api.UccMallSuggestSearchAbilityService;
import com.tydic.commodity.bo.busi.UccMallNameSuggest;
import com.tydic.commodity.bo.busi.UccMallSuggestSearchReqBO;
import com.tydic.commodity.bo.busi.UccMallSuggestSearchRspBO;
import com.tydic.commodity.constant.RspConstantEnums;
import com.tydic.commodity.search.config.MallElasticsearchUtil;
import com.tydic.commodity.search.config.MallEsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMallSuggestSearchAbilityService.class)
public class UccMallSuggestSearchAbilityServiceImpl
implements UccMallSuggestSearchAbilityService {
    private static final Logger LOGGER = LogManager.getLogger(UccMallSuggestSearchAbilityServiceImpl.class);
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;

    public UccMallSuggestSearchRspBO suggestAutomatic(UccMallSuggestSearchReqBO reqBO) {
        UccMallSuggestSearchRspBO rspBO = new UccMallSuggestSearchRspBO();
        if (null == reqBO || null == reqBO.getSearch()) {
            rspBO.setRespCode(RspConstantEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List<UccMallNameSuggest> completionSuggests = this.completionSuggester(reqBO.getSearch());
        String highlight = this.Highlight(reqBO.getSearch());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u81ea\u52a8\u8865\u5168\u4fee\u6b63\u6570\u636e\u67e5\u8be2\u6210\u529f");
        rspBO.setSuggests(completionSuggests);
        rspBO.setHightName(highlight);
        return rspBO;
    }

    public List<UccMallNameSuggest> completionSuggester(String suggestValue) {
        ArrayList<UccMallNameSuggest> suggests = new ArrayList<UccMallNameSuggest>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.mallEsConfig.getSuggestIndexName()});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.size(0);
            CompletionSuggestionBuilder termSuggestionBuilder = SuggestBuilders.completionSuggestion((String)"commodityTypeName").prefix(suggestValue).skipDuplicates(true);
            SuggestBuilder suggestBuilder = new SuggestBuilder();
            suggestBuilder.addSuggestion("commodity-suggest", (SuggestionBuilder)termSuggestionBuilder);
            sourceBuilder.suggest(suggestBuilder);
            searchRequest.source(sourceBuilder);
            LOGGER.info("\u6784\u5efa\u81ea\u52a8\u8865\u5168ES\u8bed\u53e5suggest\uff1a" + JSONObject.toJSONString((Object)sourceBuilder));
            SearchResponse searchResponse = this.client.search(searchRequest, new Header[0]);
            if (RestStatus.OK.equals((Object)searchResponse.status())) {
                Suggest suggest = searchResponse.getSuggest();
                CompletionSuggestion termSuggestion = (CompletionSuggestion)suggest.getSuggestion("commodity-suggest");
                for (CompletionSuggestion.Entry entry : termSuggestion.getEntries()) {
                    LOGGER.info("text: " + entry.getText().string());
                    for (CompletionSuggestion.Entry.Option option : entry) {
                        Map sourceAsMap = option.getHit().getSourceAsMap();
                        UccMallNameSuggest uccMallNameSuggest = new UccMallNameSuggest();
                        uccMallNameSuggest.setCommodityTypeId(Long.valueOf(((Integer)sourceAsMap.get("commodityTypeId")).longValue()));
                        uccMallNameSuggest.setCommodityTypeName((String)sourceAsMap.get("commodityTypeName"));
                        uccMallNameSuggest.setCommodityNum((Integer)sourceAsMap.get("commodityNum"));
                        uccMallNameSuggest.setChannelId(Long.valueOf(((Integer)sourceAsMap.get("channelId")).longValue()));
                        suggests.add(uccMallNameSuggest);
                        String suggestText = option.getText().string();
                        LOGGER.info("   suggest option : " + suggestText);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        return suggests;
    }

    public String Highlight(String highValue) {
        String highName = "";
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.mallEsConfig.getSuggestIndexName()});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)"commodityTypeName", (Object)highValue);
            sourceBuilder.query((QueryBuilder)matchQueryBuilder);
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            ((HighlightBuilder)((HighlightBuilder)highlightBuilder.requireFieldMatch(Boolean.valueOf(false))).field("commodityTypeName").preTags(new String[]{"<strong>"})).postTags(new String[]{"</strong>"});
            sourceBuilder.highlighter(highlightBuilder);
            searchRequest.source(sourceBuilder);
            SearchResponse searchResponse = this.client.search(searchRequest, new Header[0]);
            if (RestStatus.OK.equals((Object)searchResponse.status())) {
                SearchHit[] searchHits;
                SearchHits hits = searchResponse.getHits();
                long totalHits = hits.getTotalHits();
                for (SearchHit hit : searchHits = hits.getHits()) {
                    Text[] fragments;
                    String index = hit.getIndex();
                    String type = hit.getType();
                    String id = hit.getId();
                    float score = hit.getScore();
                    Map sourceAsMap = hit.getSourceAsMap();
                    LOGGER.info("index:" + index + "  type:" + type + "  id:" + id);
                    LOGGER.info("sourceMap : " + sourceAsMap);
                    Map highlightFields = hit.getHighlightFields();
                    HighlightField highlight = (HighlightField)highlightFields.get("commodityTypeName");
                    if (highlight == null || (fragments = highlight.fragments()) == null) continue;
                    String fragmentString = fragments[0].string();
                    LOGGER.info("title highlight : " + fragmentString);
                    highName = fragmentString;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        return highName;
    }
}

