/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.MatchResultBo;
import com.tydic.commodity.bo.busi.TextNormalizationReqBo;
import com.tydic.commodity.bo.busi.TextNormalizationRspBo;
import com.tydic.commodity.busi.api.UccSearchTextNormalizationBusiService;
import com.tydic.commodity.search.AnalyzerTokensService;
import com.tydic.commodity.search.TokensMatchIndexService;
import com.tydic.commodity.search.bo.AnalyzerTokensBo;
import com.tydic.commodity.search.bo.AnalyzerTokensReqBO;
import com.tydic.commodity.search.bo.AnalyzerTokensRspBO;
import com.tydic.commodity.search.bo.TokensMatchIndexReqBO;
import com.tydic.commodity.search.bo.TokensMatchIndexRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSearchTextNormalizationBusiServiceImpl
implements UccSearchTextNormalizationBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSearchTextNormalizationBusiServiceImpl.class);
    @Autowired
    private Map<String, TokensMatchIndexService> matchIndexServices;
    @Autowired
    private AnalyzerTokensService analyzerTokensService;
    private static final int ROW_SIZE = 10;

    public TextNormalizationRspBo normalization(TextNormalizationReqBo reqBo) {
        TextNormalizationRspBo rspBo = new TextNormalizationRspBo();
        String defaultQueryStr = reqBo.getQueryStr();
        String queryStr = reqBo.getQueryStr();
        AnalyzerTokensReqBO analyzerTokensReqBO = new AnalyzerTokensReqBO();
        analyzerTokensReqBO.setTokens(reqBo.getQueryStr());
        HashMap matchResultMap = new HashMap(16);
        AnalyzerTokensRspBO rspBO = this.analyzerTokensService.analyzer(analyzerTokensReqBO);
        TokensMatchIndexReqBO tokensMatchIndexReqBO = new TokensMatchIndexReqBO();
        if (rspBO.getRows() != null && rspBO.getRows().size() < 10) {
            defaultQueryStr = ((AnalyzerTokensBo)rspBO.getRows().stream().reduce((first, second) -> second).get()).getToken();
            tokensMatchIndexReqBO.setRows(rspBO.getRows());
            for (Map.Entry<Object, Object> entry : this.matchIndexServices.entrySet()) {
                ArrayList matchNames = new ArrayList();
                TokensMatchIndexRspBO indexRspBO = ((TokensMatchIndexService)entry.getValue()).match(tokensMatchIndexReqBO);
                if (!"0000".equals(indexRspBO.getRespCode())) continue;
                if (!CollectionUtils.isEmpty((Collection)indexRspBO.getMatchBos())) {
                    List matchResultBos = indexRspBO.getMatchBos();
                    Map<String, List<MatchResultBo>> matchMaps = matchResultBos.stream().collect(Collectors.groupingBy(MatchResultBo::getTagName));
                    matchMaps.forEach((k, v) -> matchNames.add(k));
                }
                matchResultMap.put(entry.getKey(), matchNames);
            }
        }
        for (Map.Entry entry : matchResultMap.entrySet()) {
            for (String str : (List)entry.getValue()) {
                if (!queryStr.contains(str)) continue;
                queryStr = queryStr.replace(str, "");
            }
        }
        if (StringUtils.isEmpty((Object)queryStr.trim())) {
            queryStr = defaultQueryStr;
        }
        rspBo.setMatchResultMap(matchResultMap);
        rspBo.setQueryStr(queryStr);
        return rspBo;
    }
}

