/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallSimilarSkuListAbilityService;
import com.tydic.commodity.mall.ability.bo.UccCombEsCommodityBo;
import com.tydic.commodity.mall.ability.bo.UccMallSimilarSkuBO;
import com.tydic.commodity.mall.ability.bo.UccMallSimilarSkuListAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSimilarSkuListAbilityRspBO;
import com.tydic.commodity.mall.atom.api.UccMallCurrentStockQryAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentStockQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentStockQryRspBO;
import com.tydic.commodity.mall.atom.bo.UccMallSkuNumBO_Atom;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.dao.UccMallCommodityMeasureMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuStandardRelationMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.UccCommodityMeasurePo;
import com.tydic.commodity.mall.po.UccMallSimilarSkuPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallSimilarSkuListAbilityService"})
public class UccMallSimilarSkuListAbilityServiceImpl
implements UccMallSimilarSkuListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSimilarSkuListAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper skuMapper;
    @Autowired
    private UccMallSkuStandardRelationMapper uccMallSkuStandardRelationMapper;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private UccMallCommodityMeasureMapper uccMallCommodityMeasureMapper;
    @Autowired
    private UccMallCurrentStockQryAtomService uccMallCurrentStockQryAtomService;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;

    @PostMapping(value={"qrySimilarSkuList"})
    public UccMallSimilarSkuListAbilityRspBO qrySimilarSkuList(@RequestBody UccMallSimilarSkuListAbilityReqBO reqBO) {
        UccCommodityMeasurePo uccCommodityMeasurePo;
        UccMallSimilarSkuListAbilityRspBO rspBO = new UccMallSimilarSkuListAbilityRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getSkuId())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        if (reqBO.getOrderByColumn() != 0 && reqBO.getOrderByColumn() != 1 && reqBO.getOrderByColumn() != 3 && reqBO.getOrderType() != 0 && reqBO.getOrderType() != 1) {
            rspBO.setRespCode("0002");
            rspBO.setRespDesc("\u5165\u53c2\u5b57\u6bb5\u4e0d\u7b26\u5408\u8981\u6c42");
            return rspBO;
        }
        List<Long> otherSkuId = this.uccMallSkuStandardRelationMapper.qryOtherSkuIdBySkuId(reqBO.getSkuId());
        ArrayList<Long> similarSkuIds = new ArrayList<Long>();
        for (Long skuId : otherSkuId) {
            if (reqBO.getSkuId().equals(skuId)) continue;
            similarSkuIds.add(skuId);
        }
        if (ObjectUtil.isNotEmpty(similarSkuIds)) {
            List<UccMallSimilarSkuPO> similarSkuPoList = this.skuMapper.qrySimilarSkuList((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize(), similarSkuIds, reqBO.getOrderByColumn(), reqBO.getOrderType());
            ArrayList<UccMallSimilarSkuBO> similarSkuBOList = new ArrayList<UccMallSimilarSkuBO>();
            if (!CollectionUtils.isEmpty(similarSkuPoList)) {
                for (UccMallSimilarSkuPO similarSkuPo : similarSkuPoList) {
                    if (!similarSkuPo.getSkuStatus().equals(3)) continue;
                    UccMallSimilarSkuBO similarSkuBO = this.editSkuBo(similarSkuPo);
                    similarSkuBOList.add(similarSkuBO);
                }
            }
            rspBO.setRows(similarSkuBOList);
            Integer total = this.skuMapper.qrySimilarSkuCount(similarSkuIds);
            rspBO.setTotal(total.intValue());
            rspBO.setRecordsTotal(total.intValue());
        } else {
            log.error("\u672a\u67e5\u8be2\u51fa\u5f53\u524d\u5355\u54c1\u7684\u5176\u4ed6\u5355\u54c1");
        }
        ArrayList<Long> thisSkuId = new ArrayList<Long>();
        thisSkuId.add(reqBO.getSkuId());
        UccMallSimilarSkuPO thisSkuPO = this.skuMapper.qrySimilarSkuList((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize(), thisSkuId, reqBO.getOrderByColumn(), reqBO.getOrderType()).get(0);
        UccMallSimilarSkuBO thisSkuBO = this.editSkuBo(thisSkuPO);
        rspBO.setThisSku(thisSkuBO);
        UccSkuPo uccSkuPo = this.skuMapper.qerySkuById(rspBO.getThisSku().getSkuId());
        if (ObjectUtil.isNotEmpty((Object)uccSkuPo.getMeasureId()) && ObjectUtil.isNotEmpty((Object)(uccCommodityMeasurePo = this.uccMallCommodityMeasureMapper.queryMeasureById(uccSkuPo.getMeasureId())))) {
            rspBO.getThisSku().setDecimalLimit(uccCommodityMeasurePo.getDecimalLimit());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccMallSimilarSkuBO editSkuBo(UccMallSimilarSkuPO similarSkuPo) {
        UccMallCurrentStockQryRspBO uccMallCurrentStockQryRspBO;
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)similarSkuPo.getSkuId()));
        JSONObject queryJson = new JSONObject();
        String queryString = boolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String result = this.searchInfo(queryJson.toString());
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                }
            }
        }
        UccCombEsCommodityBo uccCombEsCommodityBo = (UccCombEsCommodityBo)commodityModels.get(0);
        UccMallSimilarSkuBO similarSkuBO = new UccMallSimilarSkuBO();
        similarSkuBO = (UccMallSimilarSkuBO)JSONObject.parseObject((String)JSON.toJSONString((Object)similarSkuPo), UccMallSimilarSkuBO.class);
        similarSkuBO.setOtherSkuCode(similarSkuBO.getExtSkuId());
        similarSkuBO.setChannelIds(uccCombEsCommodityBo.getChannel_id());
        UccMallCurrentStockQryReqBO uccMallCurrentStockQryReqBO = new UccMallCurrentStockQryReqBO();
        UccMallSkuNumBO_Atom uccMallSkuNumBO_atom = new UccMallSkuNumBO_Atom();
        uccMallSkuNumBO_atom.setSkuId(similarSkuBO.getSkuId().toString());
        uccMallSkuNumBO_atom.setNum(new BigDecimal(String.valueOf(similarSkuBO.getMoq())));
        ArrayList<UccMallSkuNumBO_Atom> skuNum = new ArrayList<UccMallSkuNumBO_Atom>();
        skuNum.add(uccMallSkuNumBO_atom);
        uccMallCurrentStockQryReqBO.setSkuNum(skuNum);
        uccMallCurrentStockQryReqBO.setSupplierId(similarSkuBO.getSupplierShopId());
        SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(similarSkuBO.getSupplierId());
        if (ObjectUtil.isNotEmpty((Object)supplierBusiPo)) {
            uccMallCurrentStockQryReqBO.setSupplierCode(supplierBusiPo.getSupplierCode());
        }
        if ("0000".equals((uccMallCurrentStockQryRspBO = this.uccMallCurrentStockQryAtomService.qryCommdCurrentStock(uccMallCurrentStockQryReqBO)).getRespCode())) {
            BigDecimal remainNum = uccMallCurrentStockQryRspBO.getCommdStockInfo().get(0).getRemainNum();
            similarSkuBO.setUnsaleNum(Long.valueOf(remainNum.longValue()));
        }
        return similarSkuBO;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.mallEsConfig.getIndexName() + "/" + this.mallEsConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }
}

