/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccStdSkuCanSaleCheckAbilityService;
import com.tydic.commodity.mall.ability.bo.UccStdSkuCanSaleCheckAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccStdSkuCanSaleCheckAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccStdSkuCanSaleCheckBO;
import com.tydic.commodity.mall.atom.api.InterfaceAreaAvailableQryService;
import com.tydic.commodity.mall.atom.api.InterfaceAvailableCommdQryService;
import com.tydic.commodity.mall.atom.api.InterfaceCurrentStockQryService;
import com.tydic.commodity.mall.atom.api.InterfaceQrySkuStateService;
import com.tydic.commodity.mall.atom.bo.InterfaceAreaAvailableCommdBO;
import com.tydic.commodity.mall.atom.bo.InterfaceAreaAvailableQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceAreaAvailableQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceAvailableCommdBO;
import com.tydic.commodity.mall.atom.bo.InterfaceAvailableCommdQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceAvailableCommdQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdStockBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentStockQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentStockQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuNumBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateRsp;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateRspBo;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.dao.UccSkuStandardRelationMapper;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuStandardRelationPO;
import com.tydic.smcsdk.dao.SmcsdkSkuStockInfoMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccStdSkuCanSaleCheckAbilityService"})
public class UccStdSkuCanSaleCheckAbilityServiceImpl
implements UccStdSkuCanSaleCheckAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStdSkuCanSaleCheckAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStandardRelationMapper uccSkuStandardRelationMapper;
    @Autowired
    private SmcsdkSkuStockInfoMapper smcsdkSkuStockInfoMapper;
    @Autowired
    private InterfaceAreaAvailableQryService interfaceAreaAvailableQryService;
    @Autowired
    private InterfaceAvailableCommdQryService interfaceAvailableCommdQryService;
    @Autowired
    private InterfaceCurrentStockQryService interfaceCurrentStockQryService;
    @Autowired
    private InterfaceQrySkuStateService interfaceQrySkuStateService;
    @Autowired
    private UccMallSupplierShopMapper supplierShopMapper;
    @Autowired
    private UccMallSupplierMapper supplierMapper;

    @PostMapping(value={"dealStdSkuCanSaleCheck"})
    public UccStdSkuCanSaleCheckAbilityRspBO dealStdSkuCanSaleCheck(@RequestBody UccStdSkuCanSaleCheckAbilityReqBO reqBO) {
        this.validition(reqBO);
        UccStdSkuCanSaleCheckAbilityRspBO rspBO = new UccStdSkuCanSaleCheckAbilityRspBO();
        ArrayList checkResults = new ArrayList();
        reqBO.getStdSkuIds().forEach(stdSkuId -> {
            UccStdSkuCanSaleCheckBO uccStdSkuCanSaleCheckBO = new UccStdSkuCanSaleCheckBO();
            UccSkuStandardRelationPO uccSkuStandardRelationPO = new UccSkuStandardRelationPO();
            uccSkuStandardRelationPO.setStdSkuId((Long)stdSkuId);
            List<UccSkuStandardRelationPO> uccSkuStandardRelationPOS = this.uccSkuStandardRelationMapper.getList(uccSkuStandardRelationPO);
            if (CollectionUtils.isEmpty(uccSkuStandardRelationPOS)) {
                return;
            }
            List<Long> skuIds = uccSkuStandardRelationPOS.stream().map(UccSkuStandardRelationPO::getSkuId).collect(Collectors.toList());
            UccSkuPo uccSkuPo1 = this.uccSkuMapper.qerySkuById(uccSkuStandardRelationPOS.get(0).getSkuId());
            SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(uccSkuPo1.getSupplierShopId());
            if (supplierShopPo == null) {
                throw new ZTBusinessException("\u6570\u636e\u5e93\u672a\u67e5\u8be2\u5230supplierShop\u7684\u76f8\u5173\u6027\u606f\uff0c\u8bf7\u68c0\u67e5supplierShopId\u662f\u5426\u6b63\u786e");
            }
            SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(supplierShopPo.getSupplierId());
            Long supplierShopId = supplierShopPo.getSupplierShopId();
            Long supplierId = supplierBusiPo.getSupplierId();
            String supplierCode = supplierBusiPo.getSupplierCode();
            Boolean canSale = this.stdSkuCanSaleCheckOfEc(reqBO, skuIds, supplierShopId, supplierId, supplierCode);
            UccStdSkuCanSaleCheckBO stdSkuCanSaleCheckBO = new UccStdSkuCanSaleCheckBO();
            stdSkuCanSaleCheckBO.setStdSkuId(stdSkuId);
            stdSkuCanSaleCheckBO.setCanSale(canSale);
            checkResults.add(stdSkuCanSaleCheckBO);
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setCheckResults(checkResults);
        return rspBO;
    }

    private Boolean stdSkuCanSaleCheckOfEc(UccStdSkuCanSaleCheckAbilityReqBO reqBO, List<Long> skuIds, Long supplierShopId, Long supplierId, String supplierCode) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return false;
        }
        List skuIdsString = JSONArray.parseArray((String)JSON.toJSONString(skuIds), String.class);
        if (ObjectUtil.isEmpty((Object)reqBO.getCityCode()) && ObjectUtil.isEmpty((Object)reqBO.getCountyCode()) && ObjectUtil.isEmpty((Object)reqBO.getProvinceCode()) && ObjectUtil.isEmpty((Object)reqBO.getTownCode())) {
            InterfaceAreaAvailableQryReqBO interfaceAreaAvailableQryReqBO = new InterfaceAreaAvailableQryReqBO();
            if (ObjectUtil.isNotEmpty((Object)reqBO.getCityCode())) {
                interfaceAreaAvailableQryReqBO.setCity(Long.valueOf(reqBO.getCityCode()));
            }
            if (ObjectUtil.isNotEmpty((Object)reqBO.getProvinceCode())) {
                interfaceAreaAvailableQryReqBO.setProvince(Long.valueOf(reqBO.getProvinceCode()));
            }
            if (ObjectUtil.isNotEmpty((Object)reqBO.getCountyCode())) {
                interfaceAreaAvailableQryReqBO.setCounty(Long.valueOf(reqBO.getCountyCode()));
            }
            if (ObjectUtil.isNotEmpty((Object)reqBO.getTownCode())) {
                interfaceAreaAvailableQryReqBO.setTown(Long.valueOf(reqBO.getTownCode()));
            } else {
                interfaceAreaAvailableQryReqBO.setTown(0L);
            }
            interfaceAreaAvailableQryReqBO.setSupplierId(supplierId);
            interfaceAreaAvailableQryReqBO.setSupplierCode(supplierCode);
            interfaceAreaAvailableQryReqBO.setSkuIds(skuIdsString);
            InterfaceAreaAvailableQryRspBO interfaceAreaAvailableQryRspBO = this.interfaceAreaAvailableQryService.qryAreaAvailableCommd(interfaceAreaAvailableQryReqBO);
            if (!interfaceAreaAvailableQryRspBO.isSuccess()) {
                throw new ZTBusinessException("[InterfaceAreaAvailableQryRspBO]\u4e1a\u52a1\u8c03\u7528\u5931\u8d25!");
            }
            List<InterfaceAreaAvailableCommdBO> result = interfaceAreaAvailableQryRspBO.getResult();
            if (CollectionUtils.isEmpty(result)) {
                log.warn("\u6821\u9a8c\u533a\u57df\u8d2d\u4e70\u9650\u5236\u7ed3\u679c\u96c6\u4e3a\u7a7a[result]");
                throw new ZTBusinessException("[InterfaceAreaAvailableQryRspBO]\u4e1a\u52a1\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38!");
            }
            result.forEach(interfaceAreaAvailableCommdBO -> {
                if (interfaceAreaAvailableCommdBO.isAreaRestrict()) {
                    skuIdsString.remove(interfaceAreaAvailableCommdBO.getSkuId());
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)skuIdsString)) {
            log.warn("\u524d\u5e8f\u6821\u9a8c\u6570\u636e\u5168\u90e8\u672a\u901a\u8fc7!skuId\u96c6\u5408\u4e3a\u7a7a[skuIdEc]");
            return false;
        }
        InterfaceAvailableCommdQryReqBO interfaceAvailableCommdQryReqBO = new InterfaceAvailableCommdQryReqBO();
        interfaceAvailableCommdQryReqBO.setSupplierCode(supplierCode);
        interfaceAvailableCommdQryReqBO.setSupplierShopId(supplierShopId);
        interfaceAvailableCommdQryReqBO.setSupplierId(supplierId);
        interfaceAvailableCommdQryReqBO.setSkuIds(skuIdsString);
        InterfaceAvailableCommdQryRspBO interfaceAvailableCommdQryRspBO = this.interfaceAvailableCommdQryService.qryAvailableCommd(interfaceAvailableCommdQryReqBO);
        if (!interfaceAvailableCommdQryRspBO.isSuccess()) {
            throw new ZTBusinessException("[interfaceAvailableCommdQryService]\u4e1a\u52a1\u8c03\u7528\u5931\u8d25!");
        }
        List<InterfaceAvailableCommdBO> result2 = interfaceAvailableCommdQryRspBO.getResult();
        if (CollectionUtils.isEmpty(result2)) {
            log.warn("\u53ef\u552e\u5546\u54c1\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a[result2]");
            throw new ZTBusinessException("[InterfaceAvailableCommdQryRspBO]\u4e1a\u52a1\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38!");
        }
        result2.forEach(interfaceAvailableCommdBO -> {
            if (interfaceAvailableCommdBO.getSaleState() == 0) {
                skuIdsString.remove(interfaceAvailableCommdBO.getSkuId());
            }
        });
        if (CollectionUtils.isEmpty((Collection)skuIdsString)) {
            log.warn("\u524d\u5e8f\u6821\u9a8c\u6570\u636e\u5168\u90e8\u672a\u901a\u8fc7!skuId\u96c6\u5408\u4e3a\u7a7a[skuIdEc]");
            return false;
        }
        InterfaceCurrentStockQryReqBO interfaceCurrentStockQryReqBO = new InterfaceCurrentStockQryReqBO();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getCityCode())) {
            interfaceCurrentStockQryReqBO.setCity(Long.valueOf(reqBO.getCityCode()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getProvinceCode())) {
            interfaceCurrentStockQryReqBO.setProvince(Long.valueOf(reqBO.getProvinceCode()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getCountyCode())) {
            interfaceCurrentStockQryReqBO.setCounty(Long.valueOf(reqBO.getCountyCode()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getTownCode())) {
            interfaceCurrentStockQryReqBO.setTown(Long.valueOf(reqBO.getTownCode()));
        } else {
            interfaceCurrentStockQryReqBO.setTown(0L);
        }
        interfaceCurrentStockQryReqBO.setSupplierCode(supplierCode);
        interfaceCurrentStockQryReqBO.setSupplierId(supplierId);
        ArrayList<InterfaceSkuNumBO> skuNum = new ArrayList<InterfaceSkuNumBO>();
        skuIdsString.forEach(skuId -> {
            InterfaceSkuNumBO interfaceSkuNumBO = new InterfaceSkuNumBO();
            interfaceSkuNumBO.setNum(new BigDecimal(1));
            interfaceSkuNumBO.setSkuId((String)skuId);
            skuNum.add(interfaceSkuNumBO);
        });
        interfaceCurrentStockQryReqBO.setSkuNum(skuNum);
        InterfaceCurrentStockQryRspBO interfaceCurrentStockQryRspBO = this.interfaceCurrentStockQryService.qryCommdCurrentStock(interfaceCurrentStockQryReqBO);
        if (!interfaceCurrentStockQryRspBO.isSuccess()) {
            throw new ZTBusinessException("[interfaceCurrentStockQryService]\u4e1a\u52a1\u8c03\u7528\u5931\u8d25!");
        }
        List<InterfaceCommdStockBO> commdStockInfo = interfaceCurrentStockQryRspBO.getCommdStockInfo();
        if (CollectionUtils.isEmpty(commdStockInfo)) {
            log.warn("\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a[commdStockInfo]");
            throw new ZTBusinessException("[interfaceCurrentStockQryService]\u4e1a\u52a1\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38!");
        }
        commdStockInfo.forEach(interfaceCommdStockBO -> {
            if (interfaceCommdStockBO.getStockStateId() == 34) {
                skuIdsString.remove(interfaceCommdStockBO.getSkuId());
            }
        });
        InterfaceSkuStateReqBO interfaceSkuStateReqBO = new InterfaceSkuStateReqBO();
        interfaceSkuStateReqBO.setExtSkuIds(skuIdsString);
        interfaceSkuStateReqBO.setSupplierCode(supplierCode);
        interfaceSkuStateReqBO.setSupplierId(supplierId);
        InterfaceSkuStateRsp interfaceSkuStateRsp = this.interfaceQrySkuStateService.qrySkuStatus(interfaceSkuStateReqBO);
        if (!"0000".equals(interfaceSkuStateRsp.getRespCode())) {
            throw new ZTBusinessException("[interfaceQrySkuStateService]\u4e1a\u52a1\u8c03\u7528\u5931\u8d25!");
        }
        List<InterfaceSkuStateRspBo> skuStates = interfaceSkuStateRsp.getSkuStates();
        if (CollectionUtils.isEmpty(skuStates)) {
            log.warn("\u5355\u54c1\u72b6\u6001\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a[skuStates]");
            throw new ZTBusinessException("[interfaceQrySkuStateService]\u4e1a\u52a1\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38!");
        }
        skuStates.forEach(interfaceSkuStateRspBo -> {
            if (interfaceSkuStateRspBo.getState() != 1) {
                skuIdsString.remove(interfaceSkuStateRspBo.getSku());
            }
        });
        if (skuIdsString.size() > 0) {
            return true;
        }
        return false;
    }

    private void validition(UccStdSkuCanSaleCheckAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getStdSkuIds())) {
            throw new ZTBusinessException("\u5165\u53c2\u5c5e\u6027\u6807\u51c6\u5355\u54c1ID[stdSkuIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

