/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.commodity.mall.ability.api.UccBatchCurrentPriceQryAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallSalesVolumeAbilityService;
import com.tydic.commodity.mall.ability.api.UccStdSkuDetailQryAbilityService;
import com.tydic.commodity.mall.ability.bo.SkuInfoImageBo;
import com.tydic.commodity.mall.ability.bo.UccBatchCurrentPriceQryAbilityBo;
import com.tydic.commodity.mall.ability.bo.UccBatchCurrentPriceQryAbilityReqBo;
import com.tydic.commodity.mall.ability.bo.UccBatchCurrentPriceQryAbilityRspBo;
import com.tydic.commodity.mall.ability.bo.UccMallJdPriceBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallNotJdPriceBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallQrySalesVolumeBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySalesVolumeReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySalesVolumeRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySalesVolumeRspDetailBO;
import com.tydic.commodity.mall.ability.bo.UccSkuSpecPropsBo;
import com.tydic.commodity.mall.ability.bo.UccStdSkuDetailQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccStdSkuDetailQryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccStdSkuDetailQryBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccDicDictionaryMapper;
import com.tydic.commodity.mall.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.mall.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityLabelMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallSaleNumMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPicMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.dao.UccSkuSpecMapper;
import com.tydic.commodity.mall.dao.UccStdSkuDetailMapper;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccMallEMdmCatalogPo;
import com.tydic.commodity.mall.po.UccMallEMdmMaterialPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.po.UccSkuStandardRelation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccStdSkuDetailQryAbilityService"})
public class UccStdSkuDetailQryAbilityServiceImpl
implements UccStdSkuDetailQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStdSkuDetailQryAbilityServiceImpl.class);
    @Autowired
    private UccStdSkuDetailMapper uccStdSkuDetailMapper;
    @Autowired
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    @Autowired
    private UccMallSaleNumMapper uccMallSaleNumMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccMallSkuPicMapper uccMallSkuPicMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccMallCommodityLabelMapper uccMallCommodityLabelMapper;
    @Autowired
    private UccMallSalesVolumeAbilityService uccMallSalesVolumeAbilityService;
    @Autowired
    private UccBatchCurrentPriceQryAbilityService uccBatchCurrentPriceQryAbilityService;
    @Value(value="${mock_call_out_elc_interface:false}")
    private boolean mockCallOutElcInterface;

    @PostMapping(value={"qryStdSkuDetail"})
    public UccStdSkuDetailQryAbilityRspBO qryStdSkuDetail(@RequestBody UccStdSkuDetailQryAbilityReqBO reqBO) {
        List<SkuInfoImageBo> skuInfoImageBos1;
        UccCommodityTypePo uccCommodityTypePo;
        UccStdSkuDetailQryAbilityRspBO rspBO = new UccStdSkuDetailQryAbilityRspBO();
        UccStdSkuDetailQryBO uccStdSkuDetailQryBO = new UccStdSkuDetailQryBO();
        uccStdSkuDetailQryBO.setStdSkuId(reqBO.getStdSkuId());
        if (reqBO.getStdSkuId() == null || reqBO == null) {
            rspBO.setRespCode("RSP_CODE_DAO_ERROR");
            rspBO.setRespDesc("\u5165\u53c2\u5fc5\u586b\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List<UccSkuStandardRelation> skuStandardRelations = this.uccStdSkuDetailMapper.getSkuIdByStdSkuId(reqBO.getStdSkuId());
        if (skuStandardRelations.size() == 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u5230\u5185\u5bb9");
            return rspBO;
        }
        List<Long> skuIds = skuStandardRelations.stream().map(UccSkuStandardRelation::getSkuId).collect(Collectors.toList());
        List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qeryBatchSkus(skuIds);
        if (ObjectUtil.isNotEmpty(uccSkuPos)) {
            this.editTotalSaleNum(uccStdSkuDetailQryBO, uccSkuPos);
            this.editPrice(uccStdSkuDetailQryBO, uccSkuPos);
        }
        this.editCommodityPoolLabelName(reqBO.getSkuPoolIds(), uccStdSkuDetailQryBO);
        UccSkuPo uccSkuPo = this.uccMallSkuMapper.qrySkuBySkuId(reqBO.getStdSkuId());
        if (!StringUtils.isEmpty((Object)uccSkuPo)) {
            String skuStatusTitle = this.uccDicDictionaryMapper.selectDictionByPCode(uccSkuPo.getSkuStatus());
            uccStdSkuDetailQryBO.setStdSkuName(uccSkuPo.getSkuName());
            uccStdSkuDetailQryBO.setStdSkuCode(uccSkuPo.getSkuCode());
            uccStdSkuDetailQryBO.setStdSkuStatus(uccSkuPo.getSkuStatus().toString());
            uccStdSkuDetailQryBO.setStdSkuStatusDesc(skuStatusTitle);
            uccStdSkuDetailQryBO.setBrandId(uccSkuPo.getBrandId());
            uccStdSkuDetailQryBO.setBrandName(uccSkuPo.getBrandName());
            uccStdSkuDetailQryBO.setCommodityTypeId(uccSkuPo.getCommodityId());
        }
        if (!StringUtils.isEmpty((Object)uccSkuPo.getCommodityTypeId()) && !StringUtils.isEmpty((Object)(uccCommodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(uccSkuPo.getCommodityTypeId())))) {
            uccStdSkuDetailQryBO.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
        }
        if (uccSkuPo.getMaterialId() != null) {
            Long materialId = Long.valueOf(uccSkuPo.getMaterialId());
            if (materialId == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u5230\u7269\u6599\u4fe1\u606f");
                return rspBO;
            }
            UccMallEMdmMaterialPo uccMallEMdmMaterialPo = this.uccEMdmMaterialMapper.queryMaterialByMaterialId(materialId);
            UccMallEMdmCatalogPo uccMallEMdmCatalogPo = this.uccEMdmCatalogMapper.queryCatalogByCatalogId(uccMallEMdmMaterialPo.getCatalogId());
            if (uccMallEMdmCatalogPo == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u5230\u7269\u6599\u4fe1\u606f");
                return rspBO;
            }
            uccStdSkuDetailQryBO.setCatalogId(uccMallEMdmCatalogPo.getCatalogId());
            uccStdSkuDetailQryBO.setCatalogName(uccMallEMdmCatalogPo.getCatalogName());
        }
        if ((skuInfoImageBos1 = this.uccMallSkuPicMapper.qeurySkuimageBySkuId(skuIds)) == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u5230\u56fe\u7247\u4fe1\u606f");
            return rspBO;
        }
        uccStdSkuDetailQryBO.setSkuImags(skuInfoImageBos1);
        List<UccSkuSpecPropsBo> uccSkuSpecPropsBos = this.uccSkuSpecMapper.qeurySkuSpecPropsBySkuId(skuIds);
        if (uccSkuSpecPropsBos == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u5230\u5c5e\u6027\u4fe1\u606f");
            return rspBO;
        }
        uccStdSkuDetailQryBO.setSkuSpec(uccSkuSpecPropsBos);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        rspBO.setDetailInfo(uccStdSkuDetailQryBO);
        return rspBO;
    }

    private void editTotalSaleNum(UccStdSkuDetailQryBO uccStdSkuDetailQryBO, List<UccSkuPo> uccSkuPos) {
        BigDecimal totalSaleNum = new BigDecimal(1);
        Map<Long, List<UccSkuPo>> shopIdSkuPoMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        Iterator<Long> iteratorSku = shopIdSkuPoMap.keySet().iterator();
        ArrayList<UccMallQrySalesVolumeBO> qrySalesVolumeBOS = new ArrayList<UccMallQrySalesVolumeBO>();
        while (iteratorSku.hasNext()) {
            Long supplierShopId = iteratorSku.next();
            UccMallQrySalesVolumeBO uccMallQrySalesVolumeBO = new UccMallQrySalesVolumeBO();
            uccMallQrySalesVolumeBO.setSupplierShopId(supplierShopId);
            List groupSkuId = shopIdSkuPoMap.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            uccMallQrySalesVolumeBO.setSkuIds(groupSkuId);
            qrySalesVolumeBOS.add(uccMallQrySalesVolumeBO);
        }
        UccMallQrySalesVolumeReqBO uccMallQrySalesVolumeReqBO = new UccMallQrySalesVolumeReqBO();
        uccMallQrySalesVolumeReqBO.setQrySalesVolumeBOS(qrySalesVolumeBOS);
        UccMallQrySalesVolumeRspBO uccMallQrySalesVolumeRspBO = this.uccMallSalesVolumeAbilityService.querySalesVolume(uccMallQrySalesVolumeReqBO);
        if (UccMallConstantsEnums.SUCCESS.code().equals(uccMallQrySalesVolumeRspBO.getRespCode())) {
            List rspDetailBOS = uccMallQrySalesVolumeRspBO.getRspDetailBOS();
            List collect = rspDetailBOS.stream().map(UccMallQrySalesVolumeRspDetailBO::getSkuSale).collect(Collectors.toList());
            for (Map longBigDecimalMap : collect) {
                Collection values = longBigDecimalMap.values();
                for (BigDecimal saleNum : values) {
                    totalSaleNum = totalSaleNum.add(saleNum);
                }
            }
            totalSaleNum = totalSaleNum.subtract(new BigDecimal(1));
            uccStdSkuDetailQryBO.setTotalSaleNum(Long.valueOf(totalSaleNum.longValue()));
        }
    }

    private void editPrice(UccStdSkuDetailQryBO uccStdSkuDetailQryBO, List<UccSkuPo> uccSkuPos) {
        ArrayList<BigDecimal> marketPrice = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> salePrice = new ArrayList<BigDecimal>();
        if (!this.mockCallOutElcInterface) {
            ArrayList<UccBatchCurrentPriceQryAbilityBo> skuInfo = new ArrayList<UccBatchCurrentPriceQryAbilityBo>();
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                UccBatchCurrentPriceQryAbilityBo uccBatchCurrentPriceQryAbilityBo = new UccBatchCurrentPriceQryAbilityBo();
                uccBatchCurrentPriceQryAbilityBo.setSkuId(uccSkuPo.getSkuId());
                uccBatchCurrentPriceQryAbilityBo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                skuInfo.add(uccBatchCurrentPriceQryAbilityBo);
            }
            UccBatchCurrentPriceQryAbilityReqBo uccBatchCurrentPriceQryAbilityReqBo = new UccBatchCurrentPriceQryAbilityReqBo();
            uccBatchCurrentPriceQryAbilityReqBo.setSkuInfo(skuInfo);
            UccBatchCurrentPriceQryAbilityRspBo uccBatchCurrentPriceQryAbilityRspBo = this.uccBatchCurrentPriceQryAbilityService.dealPrice(uccBatchCurrentPriceQryAbilityReqBo);
            if (UccMallConstantsEnums.SUCCESS.code().equals(uccBatchCurrentPriceQryAbilityRspBo.getRespCode())) {
                if (ObjectUtil.isNotEmpty((Object)uccBatchCurrentPriceQryAbilityRspBo.getCommdPriceInfo().getJdPriceInfos())) {
                    for (UccMallJdPriceBO_busi jdPriceBoBusi : uccBatchCurrentPriceQryAbilityRspBo.getCommdPriceInfo().getJdPriceInfos()) {
                        marketPrice.add(jdPriceBoBusi.getMarketPrice());
                        salePrice.add(jdPriceBoBusi.getNewSalePrice());
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)uccBatchCurrentPriceQryAbilityRspBo.getCommdPriceInfo().getNotJdPriceInfo())) {
                    for (UccMallNotJdPriceBO_busi notJdPriceBoBusi : uccBatchCurrentPriceQryAbilityRspBo.getCommdPriceInfo().getNotJdPriceInfo()) {
                        marketPrice.add(notJdPriceBoBusi.getMarketPrice());
                        salePrice.add(notJdPriceBoBusi.getNewSalePrice());
                    }
                }
            }
        } else {
            Map<Long, List<UccSkuPo>> collect = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long supplierShopId : collect.keySet()) {
                List<UccSkuPo> uccSkuPos1 = collect.get(supplierShopId);
                List<Long> collect1 = uccSkuPos1.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                List<UccSkuPricePo> uccSkuPricePos = this.uccMallSkuPriceMapper.batchQryPriBySkuIds(collect1, supplierShopId);
                for (UccSkuPricePo uccSkuPricePo : uccSkuPricePos) {
                    marketPrice.add(new BigDecimal(uccSkuPricePo.getMarketPrice()));
                    salePrice.add(new BigDecimal(uccSkuPricePo.getSalePrice()));
                }
            }
        }
        if (!CollectionUtils.isEmpty(marketPrice)) {
            if (marketPrice.size() == 1) {
                uccStdSkuDetailQryBO.setMinMarketPrice((BigDecimal)marketPrice.get(0));
                uccStdSkuDetailQryBO.setMaxMarketPrice((BigDecimal)marketPrice.get(0));
            } else {
                BigDecimal minMarketPrice = (BigDecimal)marketPrice.get(0);
                BigDecimal maxMarketPrice = (BigDecimal)marketPrice.get(0);
                for (int i = 0; i < marketPrice.size(); ++i) {
                    if (minMarketPrice.compareTo((BigDecimal)marketPrice.get(i)) == 1) {
                        minMarketPrice = (BigDecimal)marketPrice.get(i);
                    }
                    if (maxMarketPrice.compareTo((BigDecimal)marketPrice.get(i)) != -1) continue;
                    maxMarketPrice = (BigDecimal)marketPrice.get(i);
                }
                uccStdSkuDetailQryBO.setMinMarketPrice(minMarketPrice);
                uccStdSkuDetailQryBO.setMaxMarketPrice(maxMarketPrice);
            }
        }
        if (!CollectionUtils.isEmpty(salePrice)) {
            if (salePrice.size() == 1) {
                uccStdSkuDetailQryBO.setMinSalePrice((BigDecimal)salePrice.get(0));
                uccStdSkuDetailQryBO.setMaxSalePrice((BigDecimal)salePrice.get(0));
            } else {
                BigDecimal minSalePrice = (BigDecimal)salePrice.get(0);
                BigDecimal maxSalePrice = (BigDecimal)salePrice.get(0);
                for (int i = 0; i < marketPrice.size(); ++i) {
                    if (minSalePrice.compareTo((BigDecimal)salePrice.get(i)) == 1) {
                        minSalePrice = (BigDecimal)salePrice.get(i);
                    }
                    if (maxSalePrice.compareTo((BigDecimal)salePrice.get(i)) != -1) continue;
                    maxSalePrice = (BigDecimal)salePrice.get(i);
                }
                uccStdSkuDetailQryBO.setMinSalePrice(minSalePrice);
                uccStdSkuDetailQryBO.setMaxSalePrice(maxSalePrice);
            }
        }
    }

    private void editCommodityPoolLabelName(List<String> skuPoolIds, UccStdSkuDetailQryBO uccStdSkuDetailQryBO) {
        ArrayList<String> poolLabelNames = new ArrayList<String>();
        for (String skuPoolId : skuPoolIds) {
            Long poolId = Long.valueOf(skuPoolId);
            String LabelName = this.uccMallCommodityLabelMapper.queryLabelName(poolId);
            if (!StringUtils.isEmpty((Object)LabelName)) {
                poolLabelNames.add(LabelName);
                continue;
            }
            log.warn("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u6c60ID\u4e3a" + skuPoolId + "\u7684\u5546\u54c1\u6c60\u6807\u7b7e\u4fe1\u606f");
        }
        uccStdSkuDetailQryBO.setSkuPoolNames(poolLabelNames);
    }
}

